/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.voicemessages.client.screen;

import de.maxhenkel.voicechat.api.opus.OpusEncoder;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7919;
import net.minecraft.class_8666;
import org.jetbrains.annotations.Nullable;
import ru.dimaskama.voicemessages.VoiceMessages;
import ru.dimaskama.voicemessages.VoiceMessagesMod;
import ru.dimaskama.voicemessages.VoiceMessagesModService;
import ru.dimaskama.voicemessages.VoiceMessagesPlugin;
import ru.dimaskama.voicemessages.client.Playback;
import ru.dimaskama.voicemessages.client.PlaybackManager;
import ru.dimaskama.voicemessages.client.PlaybackPlayer;
import ru.dimaskama.voicemessages.client.screen.OverlayScreen;
import ru.dimaskama.voicemessages.client.screen.RecordVoiceMessageScreen;
import ru.dimaskama.voicemessages.networking.VoiceMessageChunkC2S;
import ru.dimaskama.voicemessages.networking.VoiceMessageEndC2S;

public class VoiceMessageConfirmScreen
extends OverlayScreen {
    private static final class_8666 SEND_SPRITES = new class_8666(VoiceMessagesMod.id("send"), VoiceMessagesMod.id("send_hovered"));
    private final int leftX;
    private final int fromBottomY;
    private final Playback playback;
    private final String target;
    @Nullable
    private final class_2561 targetText;
    private int targetTextX;
    private int targetTextY;
    private PlaybackPlayer playbackPlayer;

    public VoiceMessageConfirmScreen(class_437 parent, int leftX, int fromBottomY, List<short[]> audio, String target) {
        super((class_2561)class_2561.method_43471((String)"voicemessages.confirm"), parent);
        this.leftX = leftX;
        this.fromBottomY = fromBottomY;
        this.playback = new Playback(audio);
        this.target = target;
        this.targetText = VoiceMessageConfirmScreen.getScreenTargetText(target);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int bottomY = this.field_22790 - this.fromBottomY;
        if (this.playbackPlayer == null) {
            this.playbackPlayer = new PlaybackPlayer(PlaybackManager.MAIN, this.playback, -5592406);
            this.playbackPlayer.setRectangle(this.leftX + 1, bottomY - 15, 260, 15);
        }
        class_344 sendButton = (class_344)this.method_37063((class_364)new class_344(this.leftX + 265, bottomY - 15, 14, 14, SEND_SPRITES, button -> {
            this.send();
            this.method_25419();
        }));
        sendButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"voicemessages.send")));
        class_344 cancelButton = (class_344)this.method_37063((class_364)new class_344(this.leftX + 281, bottomY - 15, 14, 14, RecordVoiceMessageScreen.CANCEL_SPRITES, button -> this.method_25419()));
        cancelButton.method_47400(class_7919.method_47407((class_2561)class_5244.field_24335));
        this.targetTextX = this.leftX + 300;
        this.targetTextY = bottomY - 12;
    }

    private void send() {
        List<short[]> audio = this.playback.getAudio();
        OpusEncoder encoder = VoiceMessagesPlugin.getClientOpusEncoder();
        encoder.resetState();
        VoiceMessagesModService service = VoiceMessagesMod.getService();
        for (VoiceMessageChunkC2S chunk : VoiceMessageChunkC2S.split(VoiceMessagesPlugin.encodeList(encoder, audio))) {
            service.sendToServer(chunk);
        }
        service.sendToServer(new VoiceMessageEndC2S(this.target));
        VoiceMessages.getLogger().info("Sent voice message (" + 1000 * audio.size() / 50 + "ms)");
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
    }

    public boolean method_25421() {
        return false;
    }

    @Override
    protected void actualRender(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 150.0f);
        super.actualRender(guiGraphics, mouseX, mouseY, delta);
        this.playbackPlayer.render(guiGraphics);
        if (this.targetText != null) {
            guiGraphics.method_27535(this.field_22793, this.targetText, this.targetTextX, this.targetTextY, -1);
        }
        guiGraphics.method_51448().method_22909();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 257 || keyCode == 335) {
            this.send();
            this.method_25419();
            return true;
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.playbackPlayer.mouseClicked((int)mouseX, (int)mouseY, button)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public void method_25432() {
        super.method_25432();
        PlaybackManager.MAIN.stopPlaying();
        PlaybackManager.MAIN.remove(this.playback);
    }

    public static class_2561 getTargetText(String target) {
        String key = "voicemessages.target." + target;
        return class_2561.method_43470((String)(class_1074.method_4663((String)key) ? class_1074.method_4662((String)key, (Object[])new Object[0]) : target));
    }

    @Nullable
    public static class_2561 getScreenTargetText(String target) {
        return "all".equals(target) ? null : class_2561.method_43469((String)"voicemessages.to", (Object[])new Object[]{VoiceMessageConfirmScreen.getTargetText(target)});
    }
}

