/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.voicemessages.neoforge;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.permission.PermissionAPI;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContext;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContextKey;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;
import net.neoforged.neoforge.server.permission.nodes.PermissionTypes;
import ru.dimaskama.voicemessages.VoiceMessagesMod;
import ru.dimaskama.voicemessages.VoiceMessagesModService;
import ru.dimaskama.voicemessages.neoforge.client.NeoForgeVoiceRecordThread;

@Mod(value="voicemessages")
public final class VoiceMessagesNeoForge {
    public static final PermissionNode<Boolean> VOICE_MESSAGE_SEND_PERMISSION = new PermissionNode("voicemessages", "send", PermissionTypes.BOOLEAN, (player, uuid, contexts) -> true, new PermissionDynamicContextKey[0]);
    public static final PermissionNode<Boolean> VOICE_MESSAGE_SEND_ALL_PERMISSION = new PermissionNode("voicemessages", "send.all", PermissionTypes.BOOLEAN, (player, uuid, contexts) -> true, new PermissionDynamicContextKey[0]);
    public static final PermissionNode<Boolean> VOICE_MESSAGE_SEND_TEAM_PERMISSION = new PermissionNode("voicemessages", "send.team", PermissionTypes.BOOLEAN, (player, uuid, contexts) -> true, new PermissionDynamicContextKey[0]);
    public static final PermissionNode<Boolean> VOICE_MESSAGE_SEND_PLAYERS_PERMISSION = new PermissionNode("voicemessages", "send.players", PermissionTypes.BOOLEAN, (player, uuid, contexts) -> true, new PermissionDynamicContextKey[0]);

    public VoiceMessagesNeoForge() {
        VoiceMessagesMod.init(ModLoadingContext.get().getActiveContainer().getModInfo().getVersion().toString(), new VoiceMessagesModService(this){

            @Override
            public boolean isModLoaded(String modId) {
                return ModList.get().isLoaded(modId);
            }

            @Override
            public void sendToServer(CustomPacketPayload payload) {
                PacketDistributor.sendToServer((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }

            @Override
            public boolean canSendToServer(ResourceLocation payloadId) {
                return Minecraft.getInstance().getConnection().hasChannel(payloadId);
            }

            @Override
            public void sendToPlayer(ServerPlayer player, CustomPacketPayload payload) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }

            @Override
            public VoiceMessagesModService.VoiceRecordThread createVoiceRecordThread(Predicate<short[]> frameConsumer, Consumer<IOException> onMicError) {
                return new NeoForgeVoiceRecordThread(frameConsumer, onMicError);
            }

            @Override
            public boolean hasVoiceMessageSendPermission(ServerPlayer player) {
                return (Boolean)PermissionAPI.getPermission((ServerPlayer)player, VOICE_MESSAGE_SEND_PERMISSION, (PermissionDynamicContext[])new PermissionDynamicContext[0]);
            }

            @Override
            public boolean hasVoiceMessageSendAllPermission(ServerPlayer player) {
                return (Boolean)PermissionAPI.getPermission((ServerPlayer)player, VOICE_MESSAGE_SEND_ALL_PERMISSION, (PermissionDynamicContext[])new PermissionDynamicContext[0]);
            }

            @Override
            public boolean hasVoiceMessageSendTeamPermission(ServerPlayer player) {
                return (Boolean)PermissionAPI.getPermission((ServerPlayer)player, VOICE_MESSAGE_SEND_TEAM_PERMISSION, (PermissionDynamicContext[])new PermissionDynamicContext[0]);
            }

            @Override
            public boolean hasVoiceMessageSendPlayersPermission(ServerPlayer player) {
                return (Boolean)PermissionAPI.getPermission((ServerPlayer)player, VOICE_MESSAGE_SEND_PLAYERS_PERMISSION, (PermissionDynamicContext[])new PermissionDynamicContext[0]);
            }
        });
    }
}

