/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.voicemessages.client.render;

import it.unimi.dsi.fastutil.floats.FloatList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import ru.dimaskama.voicemessages.client.Playback;

public final class PlaybackRenderer {
    public static void renderPlayback(GuiGraphics guiGraphics, int x, int y, int width, int height, int alpha, Playback playback) {
        FloatList audioLevels = playback.getAudioLevels();
        PlaybackRenderer.renderPlayback(guiGraphics, x, y, width, height, alpha, playback.getProgress(), audioLevels.size(), audioLevels);
    }

    public static void renderPlayback(GuiGraphics guiGraphics, int x, int y, int width, int height, int alpha, float progress, int frameCount, FloatList audioLevels) {
        int audioLevelsSize = audioLevels.size();
        for (int i = 0; i < width; ++i) {
            int h;
            boolean recorded;
            boolean isOdd = (i & 1) != 0;
            float p = (float)i / (float)width;
            boolean passed = progress > 0.0f && p <= progress;
            float pAdj = p * (float)frameCount;
            boolean bl = recorded = pAdj < (float)audioLevelsSize;
            if (recorded) {
                int floor = Mth.floor((float)pAdj);
                int ceil = Mth.ceil((float)pAdj);
                h = Mth.lerpInt((float)Mth.lerp((float)(pAdj - (float)floor), (float)audioLevels.getFloat(floor), (float)(ceil < audioLevelsSize ? audioLevels.getFloat(ceil) : 0.0f)), (int)1, (int)height);
            } else {
                h = 1;
            }
            int xx = x + i;
            int yy = y + (height - h >> 1);
            if (!recorded && isOdd) continue;
            guiGraphics.fill(xx, yy, xx + 1, yy + h, ARGB.color((int)alpha, (int)(isOdd ? (passed ? -3355444 : -7829368) : (passed ? -1 : -5592406))));
        }
    }
}

