/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.voicemessages;

import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.dimaskama.voicemessages.VoiceMessages;
import ru.dimaskama.voicemessages.VoiceMessagesModService;
import ru.dimaskama.voicemessages.logger.AbstractLogger;

public final class VoiceMessagesMod {
    private static String modVersion;
    private static VoiceMessagesModService service;
    private static boolean active;

    public static void init(String modVersion, VoiceMessagesModService service) {
        VoiceMessagesMod.service = service;
        active = service.isModLoaded("voicechat");
        final Logger logger = LoggerFactory.getLogger((String)"VoiceMessages");
        VoiceMessagesMod.modVersion = modVersion;
        VoiceMessages.init(VoiceMessages.getVersionFromModVersion(modVersion), new AbstractLogger(){

            @Override
            public void info(String message) {
                logger.info(message);
            }

            @Override
            public void info(String message, Exception e) {
                logger.info(message, (Throwable)e);
            }

            @Override
            public void warn(String message) {
                logger.warn(message);
            }

            @Override
            public void warn(String message, Exception e) {
                logger.warn(message, (Throwable)e);
            }

            @Override
            public void error(String message) {
                logger.error(message);
            }

            @Override
            public void error(String message, Exception e) {
                logger.error(message, (Throwable)e);
            }
        });
    }

    public static boolean isActive() {
        return active;
    }

    public static String getModVersion() {
        return modVersion;
    }

    public static VoiceMessagesModService getService() {
        return service;
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"voicemessages", (String)path);
    }
}

