/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.voicemessages.client.screen;

import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import it.unimi.dsi.fastutil.floats.FloatLists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import ru.dimaskama.voicemessages.VoiceMessages;
import ru.dimaskama.voicemessages.VoiceMessagesMod;
import ru.dimaskama.voicemessages.VoiceMessagesModService;
import ru.dimaskama.voicemessages.client.Playback;
import ru.dimaskama.voicemessages.client.PlaybackManager;
import ru.dimaskama.voicemessages.client.PlaybackPlayer;
import ru.dimaskama.voicemessages.client.networking.VoiceMessagesClientNetworking;
import ru.dimaskama.voicemessages.client.render.PlaybackRenderer;
import ru.dimaskama.voicemessages.client.screen.OverlayScreen;
import ru.dimaskama.voicemessages.client.screen.VoiceMessageConfirmScreen;

public class RecordVoiceMessageScreen
extends OverlayScreen {
    public static final WidgetSprites CANCEL_SPRITES = new WidgetSprites(VoiceMessagesMod.id("cancel"), VoiceMessagesMod.id("cancel_hovered"));
    private static final WidgetSprites DONE_SPRITES = new WidgetSprites(VoiceMessagesMod.id("done"), VoiceMessagesMod.id("done_hovered"));
    private final int leftX;
    private final int fromBottomY;
    private final String target;
    @Nullable
    private final Component targetText;
    private volatile boolean recorded;
    private List<short[]> recordedFrames = new ArrayList<short[]>();
    private FloatList audioLevels = new FloatArrayList();
    private VoiceMessagesModService.VoiceRecordThread recordThread;
    private Exception microphoneException;
    private ImageButton doneButton;
    private ImageButton cancelButton;

    public RecordVoiceMessageScreen(Screen parent, int leftX, int fromBottomY, String target) {
        super((Component)Component.translatable((String)"voicemessages.recording"), parent);
        this.leftX = leftX;
        this.fromBottomY = fromBottomY;
        this.target = target;
        this.targetText = VoiceMessageConfirmScreen.getScreenTargetText(target);
    }

    @Override
    protected void init() {
        super.init();
        PlaybackManager.MAIN.stopPlaying();
        if (!this.recorded && this.recordThread == null) {
            this.recordThread = VoiceMessagesMod.getService().createVoiceRecordThread(this::appendFrame, e -> {
                this.microphoneException = e;
            });
            this.recordThread.startVoiceRecord();
        }
        this.doneButton = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(14, 14, DONE_SPRITES, button -> {
            this.stopRecording();
            if (this.recorded) {
                this.onClose();
            }
        }, CommonComponents.EMPTY));
        this.doneButton.setTooltip(Tooltip.create((Component)CommonComponents.GUI_DONE));
        this.cancelButton = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(14, 14, CANCEL_SPRITES, button -> this.minecraft.setScreen(this.parent), CommonComponents.EMPTY));
        this.cancelButton.setTooltip(Tooltip.create((Component)CommonComponents.GUI_CANCEL));
    }

    private boolean appendFrame(short[] frame) {
        this.recordedFrames.add(frame);
        this.audioLevels.add(Playback.calculateAudioLevel(frame));
        if (this.recordedFrames.size() < VoiceMessagesClientNetworking.getMaxVoiceMessageFrames()) {
            return true;
        }
        this.recordThread = null;
        this.onStoppedRecording();
        return false;
    }

    private void stopRecording() {
        if (this.recordThread != null) {
            this.recordThread.stopVoiceRecord();
            this.recordThread = null;
            this.onStoppedRecording();
        }
    }

    private void onStoppedRecording() {
        this.recordedFrames = Collections.unmodifiableList(this.recordedFrames);
        this.audioLevels = FloatLists.unmodifiable((FloatList)this.audioLevels);
        this.recorded = true;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.microphoneException != null) {
            VoiceMessages.getLogger().warn("Microphone error", this.microphoneException);
            this.minecraft.player.displayClientMessage((Component)Component.translatable((String)"voicemessages.microphone_error", (Object[])new Object[]{this.microphoneException.getLocalizedMessage()}).withStyle(ChatFormatting.RED), true);
            this.minecraft.setScreen(null);
        } else if (this.recorded) {
            this.onClose();
        }
    }

    @Override
    public void onClose() {
        if (this.recordedFrames.isEmpty()) {
            super.onClose();
        } else {
            this.minecraft.setScreen((Screen)new VoiceMessageConfirmScreen(this.parent, this.leftX, this.fromBottomY, this.recordedFrames, this.target));
        }
    }

    @Override
    public void removed() {
        this.stopRecording();
        super.removed();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 257 || keyCode == 335) {
            this.onClose();
            return true;
        }
        return false;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
    }

    @Override
    protected void actualRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 150.0f);
        int bottomY = this.height - this.fromBottomY;
        guiGraphics.fill(this.leftX - 1, bottomY - 16, this.leftX + 243, bottomY + 1, -1);
        guiGraphics.fill(this.leftX, bottomY - 15, this.leftX + 242, bottomY, -43691);
        int maxFrames = VoiceMessagesClientNetworking.getMaxVoiceMessageFrames();
        float recordProgress = (float)this.recordedFrames.size() / (float)maxFrames;
        PlaybackRenderer.renderPlayback(guiGraphics, this.leftX + 1, bottomY - 15, 240, 15, 255, recordProgress, maxFrames, this.audioLevels);
        int maxDuration = VoiceMessagesClientNetworking.getMaxVoiceMessageDurationMs();
        String timeStr = PlaybackPlayer.formatTime((int)(recordProgress * (float)maxDuration)) + "/" + PlaybackPlayer.formatTime(maxDuration);
        guiGraphics.drawString(this.font, timeStr, this.leftX + 247, bottomY - 12, -1);
        int timeStrWidth = this.font.width(timeStr);
        this.doneButton.setPosition(this.leftX + 247 + timeStrWidth + 5, bottomY - 15);
        this.cancelButton.setPosition(this.leftX + 247 + timeStrWidth + 21, bottomY - 15);
        if (this.targetText != null) {
            guiGraphics.drawString(this.font, this.targetText, this.leftX + 247 + timeStrWidth + 40, bottomY - 12, -1);
        }
        super.actualRender(guiGraphics, mouseX, mouseY, delta);
        guiGraphics.pose().popPose();
    }
}

