/*
 * Decompiled with CFR 0.152.
 */
package ru.dimaskama.voicemessages.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.function.Supplier;
import java.util.stream.Stream;
import ru.dimaskama.voicemessages.VoiceMessages;

public class JsonConfig<D> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final transient String path;
    private final Codec<D> codec;
    private final Supplier<D> defaultSupplier;
    private D data;

    public JsonConfig(String path, Codec<D> codec, Supplier<D> defaultSupplier) {
        this.path = path;
        this.codec = codec;
        this.defaultSupplier = defaultSupplier;
    }

    public String getPath() {
        return this.path;
    }

    public D getData() {
        if (this.data == null) {
            this.reset();
        }
        return this.data;
    }

    public void setData(D data) {
        this.data = data;
    }

    public void loadOrCreate() {
        File file = new File(this.getPath());
        if (!file.exists()) {
            File parent = file.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                VoiceMessages.getLogger().warn("Can't create config: " + file.getAbsolutePath());
                return;
            }
            try {
                this.saveWithoutCatch();
            }
            catch (IOException e) {
                VoiceMessages.getLogger().warn("Exception occurred while writing new config. ", e);
            }
        } else {
            this.load(file);
        }
    }

    private void load(File file) {
        try (FileReader f = new FileReader(file);){
            this.deserialize(JsonParser.parseReader((Reader)f));
        }
        catch (Exception e) {
            VoiceMessages.getLogger().warn("Exception occurred while reading config. ", e);
        }
    }

    protected void deserialize(JsonElement element) {
        this.data = ((Pair)this.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).getOrThrow()).getFirst();
    }

    public void save() {
        this.save(true);
    }

    public void save(boolean log) {
        try {
            this.saveWithoutCatch();
            if (log) {
                VoiceMessages.getLogger().info("Config saved: " + this.getPath());
            }
        }
        catch (IOException e) {
            VoiceMessages.getLogger().warn("Exception occurred while saving config. ", e);
        }
    }

    public void saveWithoutCatch() throws IOException {
        JsonElement json = this.serialize();
        try (FileWriter w = new FileWriter(this.getPath());){
            GSON.toJson(json, (Appendable)w);
        }
    }

    protected JsonElement serialize() {
        return (JsonElement)this.codec.encode(this.getData(), (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).getOrThrow();
    }

    public void reset() {
        this.data = this.defaultSupplier.get();
    }

    public static <T> MapCodec<T> defaultedField(Codec<T> codec, final String fieldName, final Supplier<T> defaultSupplier) {
        final MapCodec delegate = codec.fieldOf(fieldName);
        return new MapCodec<T>(){

            public <T1> Stream<T1> keys(DynamicOps<T1> ops) {
                return delegate.keys(ops);
            }

            public <T1> DataResult<T> decode(DynamicOps<T1> ops, MapLike<T1> input) {
                if (input.get(fieldName) != null) {
                    return delegate.decode(ops, input);
                }
                return DataResult.success(defaultSupplier.get());
            }

            public <T1> RecordBuilder<T1> encode(T input, DynamicOps<T1> ops, RecordBuilder<T1> prefix) {
                return delegate.encode(input, ops, prefix);
            }

            public String toString() {
                return "Defaulted[" + String.valueOf(delegate) + "]";
            }
        };
    }
}

