/*
 * Decompiled with CFR 0.152.
 */
package net.mjramon.appliances;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.mjramon.appliances.ConfigCommon;
import net.mjramon.appliances.registry.ModBlockEntityTypes;
import net.mjramon.appliances.registry.ModBlocks;
import net.mjramon.appliances.registry.ModCommands;
import net.mjramon.appliances.registry.ModEntities;
import net.mjramon.appliances.registry.ModItemTags;
import net.mjramon.appliances.registry.ModItems;
import net.mjramon.appliances.registry.ModMenus;
import net.mjramon.appliances.registry.ModMessages;
import net.mjramon.appliances.registry.ModSounds;
import net.mjramon.appliances.registry.ModTabs;
import net.mjramon.appliances.registry.data.ModFlammableBlocks;
import net.mjramon.appliances.screen.freezer.ModFreezerScreen;
import org.slf4j.Logger;

@Mod(value="appliances")
public class Appliances {
    public static final String MOD_ID = "appliances";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final boolean DEBUG = true;

    public Appliances(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::commonSetup);
        ModItems.init(modEventBus);
        ModBlocks.init(modEventBus);
        ModBlockEntityTypes.init(modEventBus);
        ModEntities.register(modEventBus);
        ModMenus.init(modEventBus);
        ModTabs.init(modEventBus);
        ModSounds.init(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(this::onRegisterCommands);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigCommon.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        ModMessages.register();
        ModItemTags.register();
        event.enqueueWork(ModFlammableBlocks::init);
    }

    private void onRegisterCommands(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @Mod.EventBusSubscriber(modid="appliances", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenus.FREEZER.get()), ModFreezerScreen::new);
        }
    }
}

