/*
 * Decompiled with CFR 0.152.
 */
package net.mjramon.appliances;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.mjramon.appliances.registry.ModItemTags;

@Mod.EventBusSubscriber(modid="appliances", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigCommon {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    private static final Machines MACHINES;
    private static final Devices DEVICES;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        CACHE.update();
    }

    @SubscribeEvent
    static void onReload(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == SPEC) {
            CACHE.update();
        }
    }

    static {
        MACHINES = new Machines();
        DEVICES = new Devices();
        SPEC = BUILDER.build();
    }

    public static class CACHE {
        public static void update() {
            MACHINES.FREEZER.ENERGY_ENABLED = (Boolean)Machines.Freezer.ENERGY_ENABLED.get();
            MACHINES.FREEZER.ENERGY.CONSUMPTION_RATE = (Integer)Machines.Freezer.EnergySettings.CONSUMPTION_RATE.get();
            MACHINES.FREEZER.ENERGY.MAX_CAPACITY = (Integer)Machines.Freezer.EnergySettings.MAX_CAPACITY.get();
            MACHINES.FREEZER.ENERGY.MAX_TRANSFER = (Integer)Machines.Freezer.EnergySettings.MAX_TRANSFER.get();
            MACHINES.FREEZER.INVENTORY.ROW_COUNT = (Integer)Machines.Freezer.InventorySettings.ROW_COUNT.get();
            MACHINES.FREEZER.INVENTORY.BLACKLIST_ENABLED = (Boolean)Machines.Freezer.InventorySettings.BLACKLIST_ENABLED.get();
            MACHINES.FREEZER.INVENTORY.WHITELIST_ENABLED = (Boolean)Machines.Freezer.InventorySettings.WHITELIST_ENABLED.get();
            MACHINES.FREEZER.INVENTORY.EDIBLES_ONLY = (Boolean)Machines.Freezer.InventorySettings.EDIBLES_ONLY.get();
            MACHINES.FREEZER.INVENTORY.MEAT_ONLY = (Boolean)Machines.Freezer.InventorySettings.MEAT_ONLY.get();
            MACHINES.FREEZER.SOUNDS.OPEN_CLOSE_ENABLED = (Boolean)Machines.Freezer.SoundSettings.OPEN_CLOSE_ENABLED.get();
            MACHINES.FREEZER.SOUNDS.START_STOP_ENABLED = (Boolean)Machines.Freezer.SoundSettings.START_STOP_ENABLED.get();
            MACHINES.FREEZER.SOUNDS.PROCESSING_ENABLED = (Boolean)Machines.Freezer.SoundSettings.PROCESSING_ENABLED.get();
            DEVICES.LANDMINE.GRACE_PERIOD = (Integer)Devices.Landmine.GRACE_PERIOD.get();
            DEVICES.LANDMINE.ADDITIONAL_PROXIMITY_RADIUS = (Double)Devices.Landmine.ADDITIONAL_PROXIMITY_RADIUS.get();
            DEVICES.LANDMINE.WARNING_SOUND_ENABLED = (Boolean)Devices.Landmine.WARNING_SOUND_ENABLED.get();
            DEVICES.LANDMINE.EMIT_LIGHT_ENABLED = (Boolean)Devices.Landmine.EMIT_LIGHT_ENABLED.get();
            DEVICES.LANDMINE.BLINK_INTERVAL = (Integer)Devices.Landmine.BLINK_INTERVAL.get();
            DEVICES.LANDMINE.DETONATION_DELAY = (Integer)Devices.Landmine.DETONATION_DELAY.get();
            DEVICES.LANDMINE.REDSTONE_TRIGGER_ENABLED = (Boolean)Devices.Landmine.REDSTONE_TRIGGER_ENABLED.get();
            DEVICES.LANDMINE.EXPLOSION_RADIUS = ((Double)Devices.Landmine.EXPLOSION_RADIUS.get()).floatValue();
            DEVICES.LANDMINE.DESTROY_BLOCKS_ENABLED = (Boolean)Devices.Landmine.DESTROY_BLOCKS_ENABLED.get();
            DEVICES.LANDMINE.EXPLODE_ON_LANDING_ENABLED = (Boolean)Devices.Landmine.EXPLODE_ON_LANDING_ENABLED.get();
            DEVICES.LANDMINE.PRODUCE_FIRE_ENABLED = (Boolean)Devices.Landmine.PRODUCE_FIRE_ENABLED.get();
        }

        public static class MACHINES {

            public static class FREEZER {
                public static boolean ENERGY_ENABLED;

                public static class SOUNDS {
                    public static boolean OPEN_CLOSE_ENABLED;
                    public static boolean START_STOP_ENABLED;
                    public static boolean PROCESSING_ENABLED;
                }

                public static class INVENTORY {
                    public static int ROW_COUNT;
                    public static boolean BLACKLIST_ENABLED;
                    public static boolean WHITELIST_ENABLED;
                    public static boolean EDIBLES_ONLY;
                    public static boolean MEAT_ONLY;
                }

                public static class ENERGY {
                    public static int CONSUMPTION_RATE;
                    public static int MAX_CAPACITY;
                    public static int MAX_TRANSFER;
                }
            }
        }

        public static class DEVICES {

            public static class LANDMINE {
                public static int GRACE_PERIOD;
                public static double ADDITIONAL_PROXIMITY_RADIUS;
                public static boolean WARNING_SOUND_ENABLED;
                public static boolean EMIT_LIGHT_ENABLED;
                public static int BLINK_INTERVAL;
                public static int DETONATION_DELAY;
                public static boolean REDSTONE_TRIGGER_ENABLED;
                public static float EXPLOSION_RADIUS;
                public static boolean DESTROY_BLOCKS_ENABLED;
                public static boolean EXPLODE_ON_LANDING_ENABLED;
                public static boolean PRODUCE_FIRE_ENABLED;
            }
        }
    }

    private static class Machines {
        private static Freezer FREEZER;

        private Machines() {
            BUILDER.comment("Machines Settings").push("Machines");
            FREEZER = new Freezer();
            BUILDER.pop();
        }

        private static class Freezer {
            private static ForgeConfigSpec.BooleanValue ENERGY_ENABLED;
            private static EnergySettings ENERGY;
            private static InventorySettings INVENTORY;
            private static SoundSettings SOUNDS;

            private Freezer() {
                BUILDER.comment("Freezer Settings").push("Freezer");
                ENERGY_ENABLED = BUILDER.comment("Use energy system for this machine").define("energyEnabled", true);
                ENERGY = new EnergySettings();
                INVENTORY = new InventorySettings();
                SOUNDS = new SoundSettings();
                BUILDER.pop();
            }

            private static class EnergySettings {
                private static ForgeConfigSpec.IntValue CONSUMPTION_RATE;
                private static ForgeConfigSpec.IntValue MAX_CAPACITY;
                private static ForgeConfigSpec.IntValue MAX_TRANSFER;

                private EnergySettings() {
                    BUILDER.comment("Freezer Energy Settings").push("Energy");
                    CONSUMPTION_RATE = BUILDER.comment("Energy consumed per tick").defineInRange("consumptionRate", 1, 0, Integer.MAX_VALUE);
                    MAX_CAPACITY = BUILDER.comment("Maximum energy storage capacity").defineInRange("maxCapacity", 100000, 0, Integer.MAX_VALUE);
                    MAX_TRANSFER = BUILDER.comment("Maximum energy transfer per tick").defineInRange("maxTransfer", 256, 0, Integer.MAX_VALUE);
                    BUILDER.pop();
                }
            }

            private static class InventorySettings {
                private static ForgeConfigSpec.IntValue ROW_COUNT;
                private static ForgeConfigSpec.BooleanValue BLACKLIST_ENABLED;
                private static ForgeConfigSpec.BooleanValue WHITELIST_ENABLED;
                private static ForgeConfigSpec.BooleanValue EDIBLES_ONLY;
                private static ForgeConfigSpec.BooleanValue MEAT_ONLY;

                private InventorySettings() {
                    BUILDER.comment("Freezer Inventory Settings").push("Inventory");
                    ROW_COUNT = BUILDER.comment("How many inventory rows this machine has").defineInRange("rowCount", 3, 1, 9);
                    BLACKLIST_ENABLED = BUILDER.comment("Enable item blacklist tag (" + ModItemTags.FREEZER_BLACKLIST.f_203868_() + "). Has priority over whitelist").define("blacklistEnabled", false);
                    WHITELIST_ENABLED = BUILDER.comment("Enable item whitelist tag (" + ModItemTags.FREEZER_WHITELIST.f_203868_() + "). If enabled, allows only listed items").define("whitelistEnabled", false);
                    EDIBLES_ONLY = BUILDER.comment("Allow only edibles. Whitelist and blacklist have priority over this setting").define("ediblesOnly", false);
                    MEAT_ONLY = BUILDER.comment("Allow only meat. 'ediblesOnly' has to be enabled.").define("meatOnly", false);
                    BUILDER.pop();
                }
            }

            private static class SoundSettings {
                private static ForgeConfigSpec.BooleanValue OPEN_CLOSE_ENABLED;
                private static ForgeConfigSpec.BooleanValue START_STOP_ENABLED;
                private static ForgeConfigSpec.BooleanValue PROCESSING_ENABLED;

                private SoundSettings() {
                    BUILDER.comment("Freezer Sound Settings").push("Sounds");
                    OPEN_CLOSE_ENABLED = BUILDER.comment("Enable open/close inventory sounds").define("openCloseEnabled", true);
                    START_STOP_ENABLED = BUILDER.comment("Enable start/stop sounds").define("startStopEnabled", true);
                    PROCESSING_ENABLED = BUILDER.comment("Enable processing sound (when machine is active)").define("processingEnabled", true);
                    BUILDER.pop();
                }
            }
        }
    }

    private static class Devices {
        private static Landmine LANDMINE;

        private Devices() {
            BUILDER.comment("Devices Settings").push("Devices");
            LANDMINE = new Landmine();
            BUILDER.pop();
        }

        private static class Landmine {
            private static ForgeConfigSpec.IntValue GRACE_PERIOD;
            private static ForgeConfigSpec.DoubleValue ADDITIONAL_PROXIMITY_RADIUS;
            private static ForgeConfigSpec.BooleanValue WARNING_SOUND_ENABLED;
            private static ForgeConfigSpec.BooleanValue EMIT_LIGHT_ENABLED;
            private static ForgeConfigSpec.IntValue BLINK_INTERVAL;
            private static ForgeConfigSpec.IntValue DETONATION_DELAY;
            private static ForgeConfigSpec.BooleanValue REDSTONE_TRIGGER_ENABLED;
            private static ForgeConfigSpec.DoubleValue EXPLOSION_RADIUS;
            private static ForgeConfigSpec.BooleanValue DESTROY_BLOCKS_ENABLED;
            private static ForgeConfigSpec.BooleanValue EXPLODE_ON_LANDING_ENABLED;
            private static ForgeConfigSpec.BooleanValue PRODUCE_FIRE_ENABLED;

            private Landmine() {
                BUILDER.comment("Landmine Settings").push("Landmine");
                GRACE_PERIOD = BUILDER.comment("Amount of ticks before landmine becomes active (not triggered)").defineInRange("gracePeriod", 20, 0, Integer.MAX_VALUE);
                ADDITIONAL_PROXIMITY_RADIUS = BUILDER.comment("Additional proximity radius in blocks").defineInRange("additionalProximityRadius", 0.0, 0.0, 32.0);
                WARNING_SOUND_ENABLED = BUILDER.comment("Enable periodic warning sound").define("warningSoundEnabled", true);
                EMIT_LIGHT_ENABLED = BUILDER.comment("Emit light while blinking and when triggered").define("emitLightEnabled", true);
                BLINK_INTERVAL = BUILDER.comment("Blinking interval duration in ticks").defineInRange("blinkInterval", 20, 0, 200);
                DETONATION_DELAY = BUILDER.comment("Amount of ticks before landmine explodes after being triggered").defineInRange("detonationDelay", 20, 0, Integer.MAX_VALUE);
                REDSTONE_TRIGGER_ENABLED = BUILDER.comment("Enable triggering landmine with redstone signal").define("redstoneTriggerEnabled", true);
                EXPLOSION_RADIUS = BUILDER.comment("Explosion radius. Vanilla TNT is 4.0").defineInRange("explosionRadius", 4.0, 0.0, 32.0);
                DESTROY_BLOCKS_ENABLED = BUILDER.comment("Destroy blocks on explosion. Respects tntExplosionDropDecay game rule").define("destroyBlocksEnabled", true);
                EXPLODE_ON_LANDING_ENABLED = BUILDER.comment("Should landmine explode when it lands after falling?").define("explodeOnLandingEnabled", true);
                PRODUCE_FIRE_ENABLED = BUILDER.comment("Should explosion produce fire?").define("produceFireEnabled", false);
                BUILDER.pop();
            }
        }
    }
}

