/*
 * Decompiled with CFR 0.152.
 */
package net.mjramon.appliances.block;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import net.mjramon.appliances.ConfigCommon;
import net.mjramon.appliances.block.entity.ModFreezerBlockEntity;
import net.mjramon.appliances.registry.ModBlockEntityTypes;
import net.mjramon.appliances.registry.ModProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModFreezerBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty ACTIVE = ModProperties.ACTIVE;
    private static final VoxelShape SHAPE = Shapes.m_83144_();

    public ModFreezerBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.FALSE)).m_61124_((Property)ACTIVE, (Comparable)Boolean.FALSE));
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        return new ModFreezerBlockEntity(pPos, pState);
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState pState) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, OPEN, ACTIVE});
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_())).m_61124_((Property)OPEN, (Comparable)Boolean.FALSE)).m_61124_((Property)ACTIVE, (Comparable)Boolean.FALSE);
    }

    public void m_6810_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pNewState, boolean pMovedByPiston) {
        BlockEntity blockEntity;
        if (pState.m_60734_() != pNewState.m_60734_() && (blockEntity = pLevel.m_7702_(pPos)) instanceof ModFreezerBlockEntity) {
            ModFreezerBlockEntity freezerBlockEntity = (ModFreezerBlockEntity)blockEntity;
            freezerBlockEntity.drops();
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        if (!pLevel.m_5776_()) {
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            if (blockEntity instanceof ModFreezerBlockEntity) {
                ModFreezerBlockEntity freezerBlockEntity = (ModFreezerBlockEntity)blockEntity;
                if (freezerBlockEntity.getItems().getSlots() != ConfigCommon.CACHE.MACHINES.FREEZER.INVENTORY.ROW_COUNT * 9) {
                    serverPlayer.m_240418_((Component)Component.m_237115_((String)"text.appliances.error.inventory_mismatch").m_130940_(ChatFormatting.YELLOW), true);
                } else {
                    NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)freezerBlockEntity, (BlockPos)pPos);
                }
            } else {
                throw new IllegalStateException("Missing container provider.");
            }
        }
        return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
    }

    public void m_213897_(@NotNull BlockState pState, ServerLevel pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        BlockEntity blockentity = pLevel.m_7702_(pPos);
        if (blockentity instanceof ModFreezerBlockEntity) {
            ((ModFreezerBlockEntity)blockentity).recheckOpen();
        }
    }

    public boolean m_7278_(@NotNull BlockState pState) {
        return true;
    }

    public int m_6782_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)pLevel.m_7702_(pPos));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level pLevel, @NotNull BlockState pState, @NotNull BlockEntityType<T> pBlockEntityType) {
        return ModFreezerBlock.m_152132_(pBlockEntityType, ModBlockEntityTypes.FREEZER.get(), ModFreezerBlockEntity::tick);
    }

    @NotNull
    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(@NotNull BlockState pState, @NotNull Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        switch ((Direction)pState.m_61143_((Property)FACING)) {
            default: 
        }
        return SHAPE;
    }
}

