/*
 * Decompiled with CFR 0.152.
 */
package net.mjramon.appliances.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.mjramon.appliances.ConfigCommon;
import net.mjramon.appliances.block.entity.ModLandmineBlockEntity;
import net.mjramon.appliances.entity.ModLandmineFallingBlockEntity;
import net.mjramon.appliances.registry.ModBlockEntityTypes;
import net.mjramon.appliances.registry.ModProperties;
import net.mjramon.appliances.registry.ModSounds;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModLandmineBlock
extends BaseEntityBlock
implements Fallable {
    public static final BooleanProperty ACTIVE = ModProperties.ACTIVE;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final BooleanProperty PRIMED = ModProperties.PRIMED;
    private static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0), (VoxelShape)Block.m_49796_((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)1.5, (double)11.0));

    public ModLandmineBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ACTIVE, (Comparable)Boolean.FALSE)).m_61124_((Property)LIT, (Comparable)Boolean.FALSE)).m_61124_((Property)PRIMED, (Comparable)Boolean.FALSE));
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        return new ModLandmineBlockEntity(pPos, pState);
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState pState) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{ACTIVE, LIT, PRIMED});
    }

    public BlockState m_5573_(@NotNull BlockPlaceContext pContext) {
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ACTIVE, (Comparable)Boolean.FALSE)).m_61124_((Property)LIT, (Comparable)Boolean.FALSE)).m_61124_((Property)PRIMED, (Comparable)Boolean.FALSE);
    }

    public boolean canDropFromExplosion(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return false;
    }

    public void m_7592_(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Explosion pExplosion) {
        if (!pLevel.f_46443_ && pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            BlockState newState = (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true))).m_61124_((Property)PRIMED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false));
            serverLevel.m_46597_(pPos, newState);
            BlockEntity be = serverLevel.m_7702_(pPos);
            if (be instanceof ModLandmineBlockEntity) {
                ModLandmineBlockEntity landmine = (ModLandmineBlockEntity)be;
                landmine.setInstantTrigger();
            }
        }
    }

    public void onCaughtFire(BlockState state, Level level, BlockPos pos, @Nullable Direction direction, @Nullable LivingEntity igniter) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof ModLandmineBlockEntity) {
            ModLandmineBlockEntity landmine = (ModLandmineBlockEntity)blockEntity;
            ModLandmineBlockEntity.explode(pos, (ServerLevel)level, (Entity)igniter);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level pLevel, @NotNull BlockState pState, @NotNull BlockEntityType<T> pBlockEntityType) {
        return ModLandmineBlock.m_152132_(pBlockEntityType, ModBlockEntityTypes.LANDMINE.get(), ModLandmineBlockEntity::tick);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return SHAPE;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return ConfigCommon.CACHE.DEVICES.LANDMINE.EMIT_LIGHT_ENABLED && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? 7 : 0;
    }

    public void m_6807_(@NotNull BlockState pState, Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pOldState, boolean pIsMoving) {
        pLevel.m_186460_(pPos, (Block)this, this.getDelayAfterPlace());
        if (!pLevel.f_46443_ && !pOldState.m_60713_(pState.m_60734_())) {
            pLevel.m_5594_(null, pPos, (SoundEvent)ModSounds.LANDMINE_DEPLOY.get(), SoundSource.BLOCKS, 0.6f, 1.0f + pLevel.m_213780_().m_188501_() * 0.3f);
        }
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState pState, @NotNull Direction pFacing, @NotNull BlockState pFacingState, LevelAccessor pLevel, @NotNull BlockPos pCurrentPos, @NotNull BlockPos pFacingPos) {
        pLevel.m_186460_(pCurrentPos, (Block)this, this.getDelayAfterPlace());
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public void m_213897_(@NotNull BlockState pState, ServerLevel pLevel, BlockPos pPos, @NotNull RandomSource pRandom) {
        if (ModLandmineBlock.isFree(pLevel.m_8055_(pPos.m_7495_())) && pPos.m_123342_() >= pLevel.m_141937_()) {
            ModLandmineFallingBlockEntity fallingBlockEntity = ModLandmineFallingBlockEntity.fall((Level)pLevel, pPos, pState);
            pLevel.m_7471_(pPos, false);
            pLevel.m_7967_((Entity)fallingBlockEntity);
            this.falling(fallingBlockEntity);
        }
    }

    protected void falling(FallingBlockEntity pEntity) {
    }

    protected int getDelayAfterPlace() {
        return 2;
    }

    public static boolean isFree(BlockState pState) {
        return pState.m_60795_() || pState.m_204336_(BlockTags.f_13076_) || pState.m_278721_() || pState.m_247087_();
    }

    public void m_214162_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, RandomSource pRandom) {
        BlockPos blockpos;
        if (pRandom.m_188503_(16) == 0 && ModLandmineBlock.isFree(pLevel.m_8055_(blockpos = pPos.m_7495_()))) {
            ParticleUtils.m_272037_((Level)pLevel, (BlockPos)pPos, (RandomSource)pRandom, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, pState));
        }
    }

    public int getDustColor(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return -16777216;
    }
}

