/*
 * Decompiled with CFR 0.152.
 */
package net.mjramon.appliances.block.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.mjramon.appliances.ConfigCommon;
import net.mjramon.appliances.block.ModFreezerBlock;
import net.mjramon.appliances.client.sound.FreezerHumSound;
import net.mjramon.appliances.core.energy.ModEnergyStorage;
import net.mjramon.appliances.core.item.FreezerSlot;
import net.mjramon.appliances.core.item.FreezerTrackingItemHandler;
import net.mjramon.appliances.network.packet.EnergySyncS2CPacket;
import net.mjramon.appliances.registry.ModBlockEntityTypes;
import net.mjramon.appliances.registry.ModMessages;
import net.mjramon.appliances.registry.ModProperties;
import net.mjramon.appliances.registry.ModSounds;
import net.mjramon.appliances.screen.freezer.ModFreezerMenu;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModFreezerBlockEntity
extends BlockEntity
implements MenuProvider,
WorldlyContainer {
    private static final String INVENTORY_TAG = "inventory";
    private static final String ENERGY_TAG = "energy";
    @OnlyIn(value=Dist.CLIENT)
    @javax.annotation.Nullable
    private FreezerHumSound humSound;
    private final FreezerTrackingItemHandler items = new FreezerTrackingItemHandler(ModFreezerMenu.getContainerSize()){};
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
            if (ConfigCommon.CACHE.MACHINES.FREEZER.SOUNDS.OPEN_CLOSE_ENABLED) {
                ModFreezerBlockEntity.this.playSound(state, (SoundEvent)ModSounds.FREEZER_OPEN.get());
            }
            ModFreezerBlockEntity.this.updateOpenState(state, true);
        }

        protected void m_142289_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
            if (ConfigCommon.CACHE.MACHINES.FREEZER.SOUNDS.OPEN_CLOSE_ENABLED) {
                ModFreezerBlockEntity.this.playSound(state, (SoundEvent)ModSounds.FREEZER_CLOSE.get());
            }
            ModFreezerBlockEntity.this.updateOpenState(state, false);
        }

        protected void m_142148_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, int p_155069_, int p_155070_) {
        }

        protected boolean m_142718_(Player player) {
            if (player.f_36096_ instanceof ModFreezerMenu) {
                Container container = ((ModFreezerMenu)player.f_36096_).getContainer();
                return container == ModFreezerBlockEntity.this;
            }
            return false;
        }
    };
    private LazyOptional<FreezerTrackingItemHandler> lazyItems = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> lazyEnergy = LazyOptional.empty();
    private final LazyOptional<? extends IItemHandler>[] lazySidedHandlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])Direction.values());
    private final ContainerData data;
    private final ModEnergyStorage ENERGY_STORAGE = new ModEnergyStorage(ModFreezerBlockEntity.getEnergyMaxCapacity(), ModFreezerBlockEntity.getEnergyMaxTransfer()){

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            return super.receiveEnergy(maxReceive, simulate);
        }

        @Override
        public int extractEnergy(int maxExtract, boolean simulate) {
            return super.extractEnergy(maxExtract, simulate);
        }

        @Override
        public void onEnergyChanged() {
            ModFreezerBlockEntity.this.m_6596_();
            ModMessages.sendToClients(new EnergySyncS2CPacket(this.energy, ModFreezerBlockEntity.this.m_58899_()));
        }
    };

    public ModFreezerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntityTypes.FREEZER.get(), pPos, pBlockState);
        this.data = new ContainerData(){

            public int m_6413_(int pIndex) {
                switch (pIndex) {
                    default: 
                }
                return 0;
            }

            public void m_8050_(int pIndex, int pValue) {
            }

            public int m_6499_() {
                return 0;
            }
        };
    }

    public static int getEnergyConsumptionRate() {
        return ConfigCommon.CACHE.MACHINES.FREEZER.ENERGY.CONSUMPTION_RATE;
    }

    public static int getEnergyMaxCapacity() {
        return ConfigCommon.CACHE.MACHINES.FREEZER.ENERGY.MAX_CAPACITY;
    }

    public static int getEnergyMaxTransfer() {
        return ConfigCommon.CACHE.MACHINES.FREEZER.ENERGY.MAX_TRANSFER;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (ConfigCommon.CACHE.MACHINES.FREEZER.ENERGY_ENABLED && cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergy.cast();
        }
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER && side != null) {
            return this.lazySidedHandlers[side.ordinal()].cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItems.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItems = LazyOptional.of(() -> this.items);
        if (ConfigCommon.CACHE.MACHINES.FREEZER.ENERGY_ENABLED) {
            this.lazyEnergy = LazyOptional.of(() -> this.ENERGY_STORAGE);
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItems.invalidate();
        if (ConfigCommon.CACHE.MACHINES.FREEZER.ENERGY_ENABLED) {
            this.lazyEnergy.invalidate();
        }
        for (LazyOptional<? extends IItemHandler> handler : this.lazySidedHandlers) {
            handler.invalidate();
        }
    }

    public int m_6643_() {
        return this.items.getSlots();
    }

    public boolean m_7983_() {
        return ModFreezerBlockEntity.isEmpty(this);
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        return this.items.getStackInSlot(slot);
    }

    @NotNull
    public ItemStack m_7407_(int slot, int count) {
        ItemStack stack = this.items.getStackInSlot(slot);
        if (!stack.m_41619_()) {
            ItemStack result = stack.m_41620_(count);
            this.m_6596_();
            return result;
        }
        return ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        ItemStack stack = this.items.getStackInSlot(slot);
        this.items.setStackInSlot(slot, ItemStack.f_41583_);
        return stack;
    }

    public void m_6836_(int slot, @NotNull ItemStack stack) {
        this.items.setStackInSlot(slot, stack);
        this.m_6596_();
    }

    public boolean m_6542_(@NotNull Player player) {
        return true;
    }

    public void m_6211_() {
        for (int i = 0; i < this.items.getSlots(); ++i) {
            this.items.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public void m_5856_(@NotNull Player pPlayer) {
        if (this.m_58904_() != null && !this.f_58859_ && !pPlayer.m_5833_()) {
            this.openersCounter.m_155452_(pPlayer, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(@NotNull Player pPlayer) {
        if (this.m_58904_() != null && !this.f_58859_ && !pPlayer.m_5833_()) {
            this.openersCounter.m_155468_(pPlayer, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void recheckOpen() {
        if (this.m_58904_() != null && !this.f_58859_) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public int @NotNull [] m_7071_(@NotNull Direction pSide) {
        int[] slots = new int[this.items.getSlots()];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = i;
        }
        return slots;
    }

    public boolean m_7155_(int index, @NotNull ItemStack stack, Direction direction) {
        if (FreezerSlot.canInsert(stack)) {
            if (direction == Direction.UP) {
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean m_7157_(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        return direction != Direction.UP;
    }

    protected void m_183515_(@NotNull CompoundTag pTag) {
        pTag.m_128365_(INVENTORY_TAG, (Tag)this.items.serializeNBT());
        pTag.m_128405_(ENERGY_TAG, this.ENERGY_STORAGE.getEnergyStored());
        super.m_183515_(pTag);
    }

    public void m_142466_(@NotNull CompoundTag pTag) {
        super.m_142466_(pTag);
        this.items.deserializeNBT(pTag.m_128469_(INVENTORY_TAG));
        this.ENERGY_STORAGE.setEnergy(pTag.m_128451_(ENERGY_TAG));
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, @NotNull Inventory pPlayerInventory, @NotNull Player pPlayer) {
        ModMessages.sendToClients(new EnergySyncS2CPacket(this.ENERGY_STORAGE.getEnergyStored(), this.m_58899_()));
        return new ModFreezerMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"container.appliances.freezer");
    }

    private static boolean isMaxEnergy(ModFreezerBlockEntity blockEntity) {
        return blockEntity.ENERGY_STORAGE.getEnergyStored() >= blockEntity.ENERGY_STORAGE.getMaxEnergyStored();
    }

    public IEnergyStorage getEnergyStorage() {
        return this.ENERGY_STORAGE;
    }

    public void setEnergyLevel(int energy) {
        this.ENERGY_STORAGE.setEnergy(energy);
    }

    private static boolean hasEnoughEnergy(ModFreezerBlockEntity blockEntity) {
        return blockEntity.ENERGY_STORAGE.getEnergyStored() >= ModFreezerBlockEntity.getEnergyConsumptionRate();
    }

    private static void simulateEnergy(ModFreezerBlockEntity blockEntity) {
        int testMaxReceive = 64;
        blockEntity.ENERGY_STORAGE.receiveEnergy(testMaxReceive, false);
    }

    private static void extractEnergy(ModFreezerBlockEntity blockEntity) {
        blockEntity.ENERGY_STORAGE.extractEnergy(ModFreezerBlockEntity.getEnergyConsumptionRate(), false);
    }

    private void updateOpenState(BlockState pState, boolean pOpen) {
        assert (this.f_58857_ != null);
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)pState.m_61124_((Property)ModFreezerBlock.OPEN, (Comparable)Boolean.valueOf(pOpen)), 3);
    }

    private void playSound(BlockState pState, SoundEvent pSound) {
        Vec3i vec3i = ((Direction)pState.m_61143_((Property)ModFreezerBlock.FACING)).m_122436_();
        double d0 = (double)this.f_58858_.m_123341_() + 0.5 + (double)vec3i.m_123341_() / 2.0;
        double d1 = (double)this.f_58858_.m_123342_() + 0.5 + (double)vec3i.m_123342_() / 2.0;
        double d2 = (double)this.f_58858_.m_123343_() + 0.5 + (double)vec3i.m_123343_() / 2.0;
        assert (this.f_58857_ != null);
        this.f_58857_.m_6263_((Player)null, d0, d1, d2, pSound, SoundSource.BLOCKS, 0.35f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public ItemStackHandler getItems() {
        return this.items;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.items.getSlots());
        for (int i = 0; i < this.items.getSlots(); ++i) {
            inventory.m_6836_(i, this.items.getStackInSlot(i));
        }
        if (this.m_58904_() != null) {
            Containers.m_19002_((Level)this.m_58904_(), (BlockPos)this.f_58858_, (Container)inventory);
        }
    }

    private static boolean isEmpty(ModFreezerBlockEntity blockEntity) {
        for (int i = 0; i < blockEntity.items.getSlots(); ++i) {
            if (blockEntity.items.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public static boolean isRedstoneDisabled(Level level, BlockPos pos) {
        return level.m_276867_(pos);
    }

    public boolean isRedstoneDisabled() {
        if (this.f_58857_ != null) {
            return ModFreezerBlockEntity.isRedstoneDisabled(this.f_58857_, this.m_58899_());
        }
        return true;
    }

    public boolean isActive() {
        return (Boolean)this.m_58900_().m_61143_((Property)ModProperties.ACTIVE);
    }

    public static boolean isFood(ItemStack itemStack) {
        return itemStack.m_41614_();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ModFreezerBlockEntity blockEntity) {
        if (level.m_5776_()) {
            boolean isActive = (Boolean)state.m_61143_((Property)ModFreezerBlock.ACTIVE);
            if (isActive) {
                if (ConfigCommon.CACHE.MACHINES.FREEZER.SOUNDS.PROCESSING_ENABLED && (blockEntity.humSound == null || blockEntity.humSound.m_7801_())) {
                    blockEntity.humSound = new FreezerHumSound(level, pos);
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)blockEntity.humSound);
                }
            } else if (blockEntity.humSound != null && !blockEntity.humSound.m_7801_()) {
                blockEntity.humSound.stopSound();
                blockEntity.humSound = null;
            }
            return;
        }
        boolean redstoneDisabled = ModFreezerBlockEntity.isRedstoneDisabled(level, pos);
        if (redstoneDisabled && !((Boolean)state.m_61143_((Property)ModFreezerBlock.ACTIVE)).booleanValue()) {
            return;
        }
        boolean canOperate = ModFreezerBlockEntity.hasEnoughEnergy(blockEntity) || !ConfigCommon.CACHE.MACHINES.FREEZER.ENERGY_ENABLED;
        boolean wasActive = (Boolean)state.m_61143_((Property)ModProperties.ACTIVE);
        boolean shouldBeActive = !redstoneDisabled && canOperate && !ModFreezerBlockEntity.isEmpty(blockEntity);
        boolean changed = false;
        if (wasActive != shouldBeActive) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)ModFreezerBlock.ACTIVE, (Comparable)Boolean.valueOf(shouldBeActive)), 3);
            if (ConfigCommon.CACHE.MACHINES.FREEZER.SOUNDS.START_STOP_ENABLED) {
                blockEntity.playSound(state, shouldBeActive ? (SoundEvent)ModSounds.FREEZER_START.get() : (SoundEvent)ModSounds.FREEZER_STOP.get());
            }
            changed = true;
        }
        if (shouldBeActive && ConfigCommon.CACHE.MACHINES.FREEZER.ENERGY_ENABLED) {
            int before = blockEntity.getEnergyStorage().getEnergyStored();
            ModFreezerBlockEntity.extractEnergy(blockEntity);
            int after = blockEntity.getEnergyStorage().getEnergyStored();
            if (before != after) {
                changed = true;
            }
        }
        if (changed) {
            ModFreezerBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }
}

