/*
 * Decompiled with CFR 0.152.
 */
package net.mjramon.appliances.block.entity;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.mjramon.appliances.ConfigCommon;
import net.mjramon.appliances.block.ModLandmineBlock;
import net.mjramon.appliances.registry.ModBlockEntityTypes;
import net.mjramon.appliances.registry.ModProperties;
import net.mjramon.appliances.registry.ModSounds;
import org.jetbrains.annotations.NotNull;

public class ModLandmineBlockEntity
extends BlockEntity {
    private static final String TICKS_SINCE_PLACED_TAG = "TicksSincePlaced";
    private static final String TICKS_SINCE_BLINK_TAG = "TicksSinceBlink";
    private static final String IS_ACTIVE_TAG = "IsActive";
    private static final String IS_PRIMED_TAG = "IsPrimed";
    private static final double boundingRadius = 4.0;
    private int ticksSincePlaced = 0;
    private int ticksSinceBlink = 0;
    private int detonationTicks = 0;
    private boolean primedSoundPlayed = false;
    private AABB scanArea;

    public ModLandmineBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntityTypes.LANDMINE.get(), pPos, pBlockState);
    }

    protected void m_183515_(@NotNull CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128405_(TICKS_SINCE_PLACED_TAG, this.ticksSincePlaced);
        pTag.m_128405_(TICKS_SINCE_BLINK_TAG, this.ticksSinceBlink);
        pTag.m_128379_(IS_ACTIVE_TAG, ((Boolean)this.m_58900_().m_61143_((Property)ModProperties.ACTIVE)).booleanValue());
        pTag.m_128379_(IS_PRIMED_TAG, ((Boolean)this.m_58900_().m_61143_((Property)ModProperties.PRIMED)).booleanValue());
    }

    public void m_142466_(@NotNull CompoundTag pTag) {
        super.m_142466_(pTag);
        this.ticksSincePlaced = pTag.m_128451_(TICKS_SINCE_PLACED_TAG);
        this.ticksSinceBlink = pTag.m_128451_(TICKS_SINCE_BLINK_TAG);
        if (this.m_58904_() != null) {
            BlockState newState = (BlockState)((BlockState)this.m_58900_().m_61124_((Property)ModProperties.ACTIVE, (Comparable)Boolean.valueOf(pTag.m_128471_(IS_ACTIVE_TAG)))).m_61124_((Property)ModProperties.PRIMED, (Comparable)Boolean.valueOf(pTag.m_128471_(IS_PRIMED_TAG)));
            this.m_58904_().m_7731_(this.f_58858_, newState, 3);
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ModLandmineBlockEntity blockEntity) {
        if (level.m_5776_()) {
            return;
        }
        if (blockEntity.ticksSincePlaced == 0 && blockEntity.ticksSinceBlink == 0 && ConfigCommon.CACHE.DEVICES.LANDMINE.BLINK_INTERVAL > 0) {
            blockEntity.ticksSinceBlink = level.m_213780_().m_188503_(ConfigCommon.CACHE.DEVICES.LANDMINE.BLINK_INTERVAL);
        }
        if (blockEntity.ticksSincePlaced < ConfigCommon.CACHE.DEVICES.LANDMINE.GRACE_PERIOD) {
            ++blockEntity.ticksSincePlaced;
        } else if (!((Boolean)state.m_61143_((Property)ModProperties.ACTIVE)).booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)ModProperties.ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
            level.m_5594_(null, pos, (SoundEvent)ModSounds.LANDMINE_CLANK.get(), SoundSource.BLOCKS, 0.5f, 1.0f + level.m_213780_().m_188501_() * 0.3f);
        }
        if (!((Boolean)state.m_61143_((Property)ModProperties.ACTIVE)).booleanValue()) {
            return;
        }
        if (((Boolean)state.m_61143_((Property)ModProperties.PRIMED)).booleanValue()) {
            if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 3);
            }
            if (blockEntity.detonationTicks >= ConfigCommon.CACHE.DEVICES.LANDMINE.DETONATION_DELAY) {
                blockEntity.primedSoundPlayed = false;
                blockEntity.detonate(null);
            } else {
                ++blockEntity.detonationTicks;
                if (!blockEntity.primedSoundPlayed) {
                    level.m_5594_(null, pos, (SoundEvent)ModSounds.LANDMINE_RELEASE.get(), SoundSource.BLOCKS, 0.6f, 1.0f + level.m_213780_().m_188501_() * 0.3f);
                    blockEntity.primedSoundPlayed = true;
                }
            }
            return;
        }
        if (ConfigCommon.CACHE.DEVICES.LANDMINE.REDSTONE_TRIGGER_ENABLED && level.m_276867_(pos)) {
            blockEntity.trigger(null);
            return;
        }
        if (ConfigCommon.CACHE.DEVICES.LANDMINE.BLINK_INTERVAL > 0) {
            if (blockEntity.ticksSinceBlink >= ConfigCommon.CACHE.DEVICES.LANDMINE.BLINK_INTERVAL) {
                if (ConfigCommon.CACHE.DEVICES.LANDMINE.WARNING_SOUND_ENABLED) {
                    level.m_5594_(null, pos, (SoundEvent)ModSounds.LANDMINE_BEEP.get(), SoundSource.BLOCKS, 0.35f, 1.0f + level.m_213780_().m_188501_() * 0.35f);
                }
                level.m_7731_(pos, (BlockState)state.m_61122_((Property)BlockStateProperties.f_61443_), 3);
                blockEntity.ticksSinceBlink = 0;
            }
            ++blockEntity.ticksSinceBlink;
        }
        blockEntity.scanArea = new AABB(pos).m_82406_(0.75).m_82386_(0.0, -0.5, 0.0).m_82400_(Math.min(ConfigCommon.CACHE.DEVICES.LANDMINE.ADDITIONAL_PROXIMITY_RADIUS, 32.0));
        List entities = level.m_45976_(LivingEntity.class, blockEntity.scanArea);
        if (!entities.isEmpty()) {
            blockEntity.trigger((Entity)entities.get(0));
        }
    }

    public void trigger(@Nullable Entity triggerEntity) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        BlockState currentState = this.m_58900_();
        if (!((Boolean)currentState.m_61143_((Property)ModProperties.PRIMED)).booleanValue()) {
            this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)ModSounds.LANDMINE_TRIGGER.get(), SoundSource.BLOCKS, 0.4f, 1.0f + this.f_58857_.m_213780_().m_188501_() * 0.3f);
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)currentState.m_61124_((Property)ModProperties.PRIMED, (Comparable)Boolean.valueOf(true)), 3);
            this.detonationTicks = 0;
        }
    }

    private void detonate(@Nullable Entity triggerEntity) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        BlockState state = this.m_58900_();
        if (!(state.m_60734_() instanceof ModLandmineBlock)) {
            return;
        }
        this.f_58857_.m_7471_(this.f_58858_, false);
        ModLandmineBlockEntity.explode(this.f_58858_, (ServerLevel)this.f_58857_, triggerEntity);
    }

    public static void explode(@NotNull BlockPos pPos, @NotNull ServerLevel pLevel, Entity entity) {
        Level.ExplosionInteraction interaction = ConfigCommon.CACHE.DEVICES.LANDMINE.DESTROY_BLOCKS_ENABLED ? Level.ExplosionInteraction.TNT : Level.ExplosionInteraction.NONE;
        float explosionRadius = Math.min(ConfigCommon.CACHE.DEVICES.LANDMINE.EXPLOSION_RADIUS, 32.0f);
        pLevel.m_255391_(entity, (double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, explosionRadius, ConfigCommon.CACHE.DEVICES.LANDMINE.PRODUCE_FIRE_ENABLED, interaction);
        if (!ConfigCommon.CACHE.DEVICES.LANDMINE.DESTROY_BLOCKS_ENABLED) {
            AABB explosionArea = new AABB(pPos).m_82400_((double)explosionRadius);
            for (BlockPos nearbyPos : BlockPos.m_121976_((int)((int)explosionArea.f_82288_), (int)((int)explosionArea.f_82289_), (int)((int)explosionArea.f_82290_), (int)((int)explosionArea.f_82291_), (int)((int)explosionArea.f_82292_), (int)((int)explosionArea.f_82293_))) {
                BlockEntity be;
                BlockState state;
                if (!pLevel.m_46749_(nearbyPos) || !((state = pLevel.m_8055_(nearbyPos)).m_60734_() instanceof ModLandmineBlock) || !((Boolean)state.m_61143_((Property)ModProperties.ACTIVE)).booleanValue() || !((be = pLevel.m_7702_(nearbyPos)) instanceof ModLandmineBlockEntity)) continue;
                ModLandmineBlockEntity nearbyMine = (ModLandmineBlockEntity)be;
                if (((Boolean)state.m_61143_((Property)ModProperties.PRIMED)).booleanValue()) continue;
                nearbyMine.trigger(entity);
            }
        }
    }

    public void setInstantTrigger() {
        this.ticksSincePlaced = ConfigCommon.CACHE.DEVICES.LANDMINE.GRACE_PERIOD;
        this.detonationTicks = 0;
    }
}

