/*
 * Decompiled with CFR 0.152.
 */
package net.mjramon.appliances.registry;

import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.mjramon.appliances.block.ModFreezerBlock;
import net.mjramon.appliances.block.ModLandmineBlock;
import net.mjramon.appliances.registry.ModItems;
import net.mjramon.appliances.registry.ModProperties;
import net.mjramon.appliances.registry.ModTabs;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"appliances");
    public static final RegistryObject<Block> FREEZER = ModBlocks.registerBlockWithoutItem("freezer", () -> new ModFreezerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_).m_60955_().m_60953_(ModBlocks.freezerBlockEmission())));
    public static final RegistryObject<Block> LANDMINE = ModBlocks.registerBlockWithoutItem("landmine", () -> new ModLandmineBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283856_).m_60918_(SoundType.f_154663_).m_60913_(5.0f, 0.0f).m_60955_().m_60910_().m_60966_()));

    public static <T extends Block> RegistryObject<T> registerBlockWithoutItem(String name, Supplier<? extends T> block) {
        return BLOCKS.register(name, block);
    }

    public static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block, Supplier<CreativeModeTab> tab) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerSimpleBlockItem(name, toReturn, tab);
        return toReturn;
    }

    private static <T extends Block> void registerSimpleBlockItem(String name, RegistryObject<T> block, Supplier<CreativeModeTab> tab) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        ModTabs.add(tab, block);
    }

    private static ToIntFunction<BlockState> freezerBlockEmission() {
        return state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_) != false && (Boolean)state.m_61143_((Property)ModProperties.ACTIVE) != false ? 7 : 0;
    }

    public static void init(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

