/*
 * Decompiled with CFR 0.152.
 */
package net.mjramon.appliances.screen.freezer;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.mjramon.appliances.ConfigCommon;
import net.mjramon.appliances.block.entity.ModFreezerBlockEntity;
import net.mjramon.appliances.core.item.FreezerSlot;
import net.mjramon.appliances.registry.ModBlocks;
import net.mjramon.appliances.registry.ModMenus;
import net.mjramon.appliances.screen.freezer.ModFreezerScreen;
import org.jetbrains.annotations.NotNull;

public class ModFreezerMenu
extends AbstractContainerMenu {
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int INVENTORY_FIRST_SLOT_INDEX = 36;
    public static final int CONTAINER_COLUMN_COUNT = 9;
    public final ModFreezerBlockEntity freezerBlockEntity;
    private final Level level;
    private final ContainerData data;

    public ModFreezerMenu(int pContainerId, Inventory inventory, FriendlyByteBuf extraData) {
        this(pContainerId, inventory, inventory.f_35978_.m_9236_().m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(ModFreezerMenu.getContainerSize()));
    }

    public ModFreezerMenu(int pContainerId, Inventory inventory, BlockEntity blockEntity, ContainerData data) {
        super((MenuType)ModMenus.FREEZER.get(), pContainerId);
        ModFreezerMenu.m_38869_((Container)inventory, (int)ModFreezerMenu.getContainerSize());
        this.freezerBlockEntity = (ModFreezerBlockEntity)blockEntity;
        this.level = inventory.f_35978_.m_9236_();
        this.freezerBlockEntity.m_5856_(inventory.f_35978_);
        this.data = data;
        this.addContainerSlots();
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
        this.m_38884_(data);
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player pPlayer, int pIndex) {
        ItemStack finalStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack fromStack = slot.m_7993_();
            finalStack = fromStack.m_41777_();
            if (pIndex < ModFreezerMenu.getContainerSize() ? !this.m_38903_(fromStack, ModFreezerMenu.getContainerSize(), ModFreezerMenu.getTotalSlotCount(), false) : !this.m_38903_(fromStack, 0, ModFreezerMenu.getContainerSize(), false)) {
                return ItemStack.f_41583_;
            }
            if (fromStack.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return finalStack;
    }

    public boolean m_6875_(@NotNull Player pPlayer) {
        return ModFreezerMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.freezerBlockEntity.m_58899_()), (Player)pPlayer, (Block)((Block)ModBlocks.FREEZER.get()));
    }

    public void m_6877_(@NotNull Player pPlayer) {
        super.m_6877_(pPlayer);
        this.freezerBlockEntity.m_5785_(pPlayer);
    }

    public static int getContainerRowCount() {
        return ConfigCommon.CACHE.MACHINES.FREEZER.INVENTORY.ROW_COUNT;
    }

    public static int getContainerSize() {
        return ModFreezerMenu.getContainerRowCount() * 9;
    }

    public static int getTotalSlotCount() {
        return ModFreezerMenu.getContainerSize() + 36;
    }

    public ModFreezerBlockEntity getBlockEntity() {
        return this.freezerBlockEntity;
    }

    public Container getContainer() {
        return this.freezerBlockEntity;
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        int offsetY = ModFreezerScreen.getWindowHeight() - 24;
        for (int slot = 0; slot < 9; ++slot) {
            this.m_38897_(new Slot((Container)playerInventory, slot, 8 + slot * 18, offsetY));
        }
    }

    private void addPlayerInventory(Inventory playerInventory) {
        int offsetY = ModFreezerScreen.getWindowHeight() - 82;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, offsetY + row * 18));
            }
        }
    }

    private void addContainerSlots() {
        int offsetY = 18;
        this.freezerBlockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
            for (int row = 0; row < ModFreezerMenu.getContainerRowCount(); ++row) {
                for (int col = 0; col < 9; ++col) {
                    this.m_38897_((Slot)new FreezerSlot((IItemHandler)iItemHandler, col + row * 9, 8 + col * 18, offsetY + row * 18));
                }
            }
        });
    }
}

