/*
 * Decompiled with CFR 0.152.
 */
package net.mjramon.appliances.screen.freezer;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.mjramon.appliances.ConfigCommon;
import net.mjramon.appliances.block.entity.ModFreezerBlockEntity;
import net.mjramon.appliances.screen.freezer.ModFreezerMenu;
import org.jetbrains.annotations.NotNull;

public class ModFreezerScreen
extends AbstractContainerScreen<ModFreezerMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"appliances", (String)"textures/gui/freezer.png");
    private static final int WINDOW_WIDTH = 176;
    private static final int HEADER_HEIGHT = 17;
    private static final int CONTAINER_ROW_HEIGHT = 18;
    private static final int ENERGY_BG_HEIGHT = 14;
    private static final int PLAYER_INVENTORY_HEIGHT = 99;
    public static final int SLOT_SIZE = 18;
    public static final int OFFSET_X = 8;

    public ModFreezerScreen(ModFreezerMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 176;
        this.f_97727_ = ModFreezerScreen.getWindowHeight();
        this.f_97731_ = this.f_97727_ - 99 + 6;
    }

    protected void m_7856_() {
        super.m_7856_();
    }

    public void m_88315_(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(pGuiGraphics);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.m_280072_(pGuiGraphics, pMouseX, pMouseY);
    }

    protected void m_7286_(@NotNull GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.renderHeader(pGuiGraphics, x, y);
        this.renderContainerRows(pGuiGraphics, x, y);
        if (ConfigCommon.CACHE.MACHINES.FREEZER.ENERGY_ENABLED) {
            this.renderEnergyBackground(pGuiGraphics, x, y);
        }
        this.renderPlayerInventory(pGuiGraphics, x, y);
        if (ConfigCommon.CACHE.MACHINES.FREEZER.ENERGY_ENABLED) {
            this.renderEnergyBar(pGuiGraphics, x, y);
        }
    }

    protected void m_280003_(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        if (ConfigCommon.CACHE.MACHINES.FREEZER.ENERGY_ENABLED) {
            ModFreezerBlockEntity freezerBlockEntity = ((ModFreezerMenu)this.f_97732_).freezerBlockEntity;
            ArrayList<FormattedCharSequence> tooltips = new ArrayList<FormattedCharSequence>();
            if (this.m_6774_(8, 17 + ModFreezerScreen.getContainerHeight() + 4, 160, 8, pMouseX, pMouseY)) {
                if (freezerBlockEntity.isActive()) {
                    tooltips.add(Component.m_237115_((String)"text.appliances.active").m_130940_(ChatFormatting.DARK_GREEN).m_7532_());
                } else {
                    tooltips.add(Component.m_237115_((String)"text.appliances.inactive").m_130940_(ChatFormatting.DARK_RED).m_7532_());
                }
                if (freezerBlockEntity.isRedstoneDisabled()) {
                    tooltips.add(Component.m_237115_((String)"text.appliances.disabled_by_redstone").m_130940_(ChatFormatting.RED).m_7532_());
                }
            }
            freezerBlockEntity.getCapability(ForgeCapabilities.ENERGY).ifPresent(handler -> {
                int energyStored = handler.getEnergyStored();
                int maxEnergy = handler.getMaxEnergyStored();
                if (this.m_6774_(8, 17 + ModFreezerScreen.getContainerHeight() + 4, 160, 8, pMouseX, pMouseY)) {
                    tooltips.add(Component.m_237110_((String)"text.appliances.energy.storage", (Object[])new Object[]{energyStored, maxEnergy}).m_130940_(ChatFormatting.GRAY).m_7532_());
                    tooltips.add(Component.m_237110_((String)"text.appliances.energy.rate", (Object[])new Object[]{ModFreezerBlockEntity.getEnergyConsumptionRate()}).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
                    tooltips.add(Component.m_237110_((String)"text.appliances.energy.max_transfer", (Object[])new Object[]{ModFreezerBlockEntity.getEnergyMaxTransfer()}).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
                }
            });
            pGuiGraphics.m_280245_(this.f_96547_, tooltips, pMouseX - this.getGuiLeft(), pMouseY - this.getGuiTop());
        }
        super.m_280003_(pGuiGraphics, pMouseX, pMouseY);
    }

    public static int getContainerRowCount() {
        return ModFreezerMenu.getContainerRowCount();
    }

    public static int getContainerHeight() {
        return ModFreezerScreen.getContainerRowCount() * 18;
    }

    public static int getDynamicEnergyBgHeight() {
        return ConfigCommon.CACHE.MACHINES.FREEZER.ENERGY_ENABLED ? 14 : 0;
    }

    public static int getWindowHeight() {
        return 17 + ModFreezerScreen.getContainerHeight() + ModFreezerScreen.getDynamicEnergyBgHeight() + 99;
    }

    private void renderHeader(GuiGraphics pGuiGraphics, int x, int y) {
        pGuiGraphics.m_280218_(TEXTURE, x, y, 0, 0, 176, 17);
    }

    private void renderContainerRows(GuiGraphics pGuiGraphics, int x, int y) {
        for (int row = 0; row < ModFreezerScreen.getContainerRowCount(); ++row) {
            pGuiGraphics.m_280218_(TEXTURE, x, y + 17 + row * 18, 0, 17, 176, 18);
        }
    }

    private void renderEnergyBackground(GuiGraphics pGuiGraphics, int x, int y) {
        pGuiGraphics.m_280218_(TEXTURE, x, y + 17 + ModFreezerScreen.getContainerHeight(), 0, 35, 176, ModFreezerScreen.getDynamicEnergyBgHeight());
    }

    private void renderEnergyBar(GuiGraphics pGuiGraphics, int x, int y) {
        ((ModFreezerMenu)this.f_97732_).freezerBlockEntity.getCapability(ForgeCapabilities.ENERGY).ifPresent(handler -> {
            int energyStored = handler.getEnergyStored();
            int maxEnergy = handler.getMaxEnergyStored();
            if (maxEnergy > 0 && energyStored > 0) {
                int energyBarWidth = 162;
                int scaledWidth = (int)((float)energyStored / (float)maxEnergy * (float)energyBarWidth);
                pGuiGraphics.m_280218_(TEXTURE, x + 8 - 1, y + 17 + ModFreezerScreen.getContainerHeight() + 4, 0, 184, scaledWidth, 10);
            }
        });
    }

    private void renderPlayerInventory(GuiGraphics pGuiGraphics, int x, int y) {
        pGuiGraphics.m_280218_(TEXTURE, x, y + ModFreezerScreen.getWindowHeight() - 99, 0, 49, 176, 99);
    }
}

