/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.discs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.config.Config;
import su.plo.config.ConfigField;
import su.plo.config.provider.ConfigurationProvider;
import su.plo.config.provider.toml.TomlConfiguration;
import su.plo.slib.api.server.McServerLib;
import su.plo.voice.api.server.PlasmoVoiceServer;
import su.plo.voice.api.server.language.ServerLanguages;
import su.plo.voice.libs.kotlin.Metadata;
import su.plo.voice.libs.kotlin.collections.CollectionsKt;
import su.plo.voice.libs.kotlin.enums.EnumEntries;
import su.plo.voice.libs.kotlin.enums.EnumEntriesKt;
import su.plo.voice.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import su.plo.voice.libs.kotlin.jvm.internal.Intrinsics;
import su.plo.voice.libs.kotlin.jvm.internal.SourceDebugExtension;

@Config
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u0000 ;2\u00020\u0001:\b:;<=>?@AB\u0005\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0006\"\u0004\b\u0013\u0010\bR\u001e\u0010\u0014\u001a\u00020\u00158\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u00020\u001b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u00020\u001f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0018\u0010\"\u001a\u0004\u0018\u00010#8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0016\u0010&\u001a\u00020'8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0016\u0010*\u001a\u00020+8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0016\u0010.\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u0006R\u001e\u00100\u001a\u0002018\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u0016\u00106\u001a\u0002078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109\u00a8\u0006B"}, d2={"Lsu/plo/voice/discs/AddonConfig;", "", "()V", "addGlintToCustomDiscs", "", "getAddGlintToCustomDiscs", "()Z", "setAddGlintToCustomDiscs", "(Z)V", "burnLoreMethod", "Lsu/plo/voice/discs/AddonConfig$LoreMethod;", "getBurnLoreMethod", "()Lsu/plo/voice/discs/AddonConfig$LoreMethod;", "burnableTag", "Lsu/plo/voice/discs/AddonConfig$BurnableTag;", "getBurnableTag", "()Lsu/plo/voice/discs/AddonConfig$BurnableTag;", "debug", "getDebug", "setDebug", "defaultSourceLineVolume", "", "getDefaultSourceLineVolume", "()D", "setDefaultSourceLineVolume", "(D)V", "distance", "Lsu/plo/voice/discs/AddonConfig$DistanceConfig;", "getDistance", "()Lsu/plo/voice/discs/AddonConfig$DistanceConfig;", "goatHorn", "Lsu/plo/voice/discs/AddonConfig$GoatHornConfig;", "getGoatHorn", "()Lsu/plo/voice/discs/AddonConfig$GoatHornConfig;", "httpProxy", "", "getHttpProxy", "()Ljava/lang/String;", "httpSource", "Lsu/plo/voice/discs/AddonConfig$HttpSourceConfig;", "getHttpSource", "()Lsu/plo/voice/discs/AddonConfig$HttpSourceConfig;", "localSource", "Lsu/plo/voice/discs/AddonConfig$LocalSourceConfig;", "getLocalSource", "()Lsu/plo/voice/discs/AddonConfig$LocalSourceConfig;", "monoSources", "getMonoSources", "sourceLineWeight", "", "getSourceLineWeight", "()I", "setSourceLineWeight", "(I)V", "youtubeSource", "Lsu/plo/voice/discs/AddonConfig$YouTubeSourceConfig;", "getYoutubeSource", "()Lsu/plo/voice/discs/AddonConfig$YouTubeSourceConfig;", "BurnableTag", "Companion", "DistanceConfig", "GoatHornConfig", "HttpSourceConfig", "LocalSourceConfig", "LoreMethod", "YouTubeSourceConfig", "core"})
public final class AddonConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @ConfigField
    private int sourceLineWeight = 10;
    @ConfigField(comment="\n            Enables debug logging (such as track start/end location and cause).\n            Also enabled automatically if Plasmo Voice debug is enabled.\n        ")
    private boolean debug;
    @ConfigField(comment="\n            The default volume. Volume is configured on the client side\n            and can be adjusted via the mod settings.\n        ")
    private double defaultSourceLineVolume = 0.5;
    @ConfigField(comment="\n            Add enchantment glint to custom discs.\n        ")
    private boolean addGlintToCustomDiscs;
    @ConfigField(comment="\n            The method for creating/removing a lore on burning/erasing the discs:\n            \n            DISABLE \u2014 Disables any lore manipulations on burn/erase.\n            REPLACE \u2014 Replaces the whole lore with a string containing the song name on burn, and removes the lore completely on erase.\n            APPEND \u2014 Adds a new line to the end of the lore on burn, and removes the last line on erase.\n            \n            Default is REPLACE.\n        ")
    @NotNull
    private final LoreMethod burnLoreMethod = LoreMethod.REPLACE;
    @ConfigField(comment="\n            Uses mono sources to play tracks.\n            Quality is worse, but they will now have panning.\n            \n            Conversion happens on client side, so there is no server overhead.\n        ")
    private final boolean monoSources;
    @ConfigField(comment="\n            HTTP/HTTPS proxy. Valid formats:\n            http://user:password@ip:port\n            https://user:password@ip:port\n        ", nullComment="http_proxy = \"http://user:password@ip:port\"")
    @Nullable
    private final String httpProxy;
    @ConfigField
    @NotNull
    private final GoatHornConfig goatHorn = new GoatHornConfig();
    @ConfigField
    @NotNull
    private final DistanceConfig distance = new DistanceConfig();
    @ConfigField
    @NotNull
    private final HttpSourceConfig httpSource = new HttpSourceConfig();
    @ConfigField
    @NotNull
    private final YouTubeSourceConfig youtubeSource = new YouTubeSourceConfig();
    @ConfigField
    @NotNull
    private final LocalSourceConfig localSource = new LocalSourceConfig();
    @ConfigField
    @NotNull
    private final BurnableTag burnableTag = new BurnableTag();
    private static final ConfigurationProvider toml = (ConfigurationProvider)ConfigurationProvider.getProvider(TomlConfiguration.class);

    public final int getSourceLineWeight() {
        return this.sourceLineWeight;
    }

    public final void setSourceLineWeight(int n) {
        this.sourceLineWeight = n;
    }

    public final boolean getDebug() {
        return this.debug;
    }

    public final void setDebug(boolean bl) {
        this.debug = bl;
    }

    public final double getDefaultSourceLineVolume() {
        return this.defaultSourceLineVolume;
    }

    public final void setDefaultSourceLineVolume(double d) {
        this.defaultSourceLineVolume = d;
    }

    public final boolean getAddGlintToCustomDiscs() {
        return this.addGlintToCustomDiscs;
    }

    public final void setAddGlintToCustomDiscs(boolean bl) {
        this.addGlintToCustomDiscs = bl;
    }

    @NotNull
    public final LoreMethod getBurnLoreMethod() {
        return this.burnLoreMethod;
    }

    public final boolean getMonoSources() {
        return this.monoSources;
    }

    @Nullable
    public final String getHttpProxy() {
        return this.httpProxy;
    }

    @NotNull
    public final GoatHornConfig getGoatHorn() {
        return this.goatHorn;
    }

    @NotNull
    public final DistanceConfig getDistance() {
        return this.distance;
    }

    @NotNull
    public final HttpSourceConfig getHttpSource() {
        return this.httpSource;
    }

    @NotNull
    public final YouTubeSourceConfig getYoutubeSource() {
        return this.youtubeSource;
    }

    @NotNull
    public final LocalSourceConfig getLocalSource() {
        return this.localSource;
    }

    @NotNull
    public final BurnableTag getBurnableTag() {
        return this.burnableTag;
    }

    @Config
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001e\u0010\u0012\u001a\u00020\u00138\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u00020\u00138\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lsu/plo/voice/discs/AddonConfig$BurnableTag;", "", "()V", "defaultRecipeCost", "", "getDefaultRecipeCost", "()I", "setDefaultRecipeCost", "(I)V", "defaultRecipeItem", "", "getDefaultRecipeItem", "()Ljava/lang/String;", "setDefaultRecipeItem", "(Ljava/lang/String;)V", "defaultRecipeLore", "getDefaultRecipeLore", "setDefaultRecipeLore", "enableDefaultRecipe", "", "getEnableDefaultRecipe", "()Z", "setEnableDefaultRecipe", "(Z)V", "requireBurnableTag", "getRequireBurnableTag", "setRequireBurnableTag", "core"})
    public static final class BurnableTag {
        @ConfigField(comment="\n                With this option you can only burn discs that have a special NBT\n                tag. You can use this to add a custom way of getting burnable\n                discs, like buying for in-game currency, or crafting.\n            ")
        private boolean requireBurnableTag;
        @ConfigField(comment="\n                Enable a recipe for burnable discs. It's a shapeless craft.\n                By default you need a disc + 4 diamonds to get a burnable disc.\n                You can configure recipe item and cost. \n            ")
        private boolean enableDefaultRecipe;
        @ConfigField
        @NotNull
        private String defaultRecipeItem = "minecraft:diamond";
        @ConfigField
        private int defaultRecipeCost = 4;
        @ConfigField(comment="\n                A lore that will be added to a burnable disc crafted with the\n                default recipe.\n            ")
        @NotNull
        private String defaultRecipeLore = "Burnable";

        public final boolean getRequireBurnableTag() {
            return this.requireBurnableTag;
        }

        public final void setRequireBurnableTag(boolean bl) {
            this.requireBurnableTag = bl;
        }

        public final boolean getEnableDefaultRecipe() {
            return this.enableDefaultRecipe;
        }

        public final void setEnableDefaultRecipe(boolean bl) {
            this.enableDefaultRecipe = bl;
        }

        @NotNull
        public final String getDefaultRecipeItem() {
            return this.defaultRecipeItem;
        }

        public final void setDefaultRecipeItem(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.defaultRecipeItem = string;
        }

        public final int getDefaultRecipeCost() {
            return this.defaultRecipeCost;
        }

        public final void setDefaultRecipeCost(int n) {
            this.defaultRecipeCost = n;
        }

        @NotNull
        public final String getDefaultRecipeLore() {
            return this.defaultRecipeLore;
        }

        public final void setDefaultRecipeLore(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.defaultRecipeLore = string;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lsu/plo/voice/discs/AddonConfig$Companion;", "", "()V", "toml", "Lsu/plo/config/provider/ConfigurationProvider;", "su.plo.voice.libs.kotlin.jvm.PlatformType", "getAddonFolder", "Ljava/io/File;", "minecraftServer", "Lsu/plo/slib/api/server/McServerLib;", "getLanguageResource", "Ljava/io/InputStream;", "resourcePath", "", "loadConfig", "Lsu/plo/voice/discs/AddonConfig;", "server", "Lsu/plo/voice/api/server/PlasmoVoiceServer;", "core"})
    @SourceDebugExtension(value={"SMAP\nAddonConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddonConfig.kt\nsu/plo/voice/discs/AddonConfig$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,344:1\n1#2:345\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AddonConfig loadConfig(@NotNull PlasmoVoiceServer server) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            McServerLib mcServerLib = server.getMinecraftServer();
            Intrinsics.checkNotNullExpressionValue((Object)mcServerLib, (String)"getMinecraftServer(...)");
            File addonFolder = this.getAddonFolder(mcServerLib);
            ServerLanguages serverLanguages = server.getLanguages();
            URL uRL = URI.create("https://github.com/plasmoapp/plasmo-voice-crowdin/archive/refs/heads/addons.zip").toURL();
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
            serverLanguages.register(uRL, "server/discs.toml", Companion::loadConfig$lambda$0, new File(addonFolder, "languages"));
            File configFile = new File(addonFolder, "discs.toml");
            Object object = toml.load(AddonConfig.class, configFile, false);
            AddonConfig it = (AddonConfig)object;
            boolean bl = false;
            toml.save(AddonConfig.class, (Object)it, configFile);
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            return (AddonConfig)object2;
        }

        private final InputStream getLanguageResource(String resourcePath) throws IOException {
            ClassLoader classLoader = this.getClass().getClassLoader();
            String string = "discs/%s";
            Object[] objectArray = new Object[]{resourcePath};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return classLoader.getResourceAsStream(string2);
        }

        private final File getAddonFolder(McServerLib minecraftServer) {
            return new File(minecraftServer.getConfigsFolder(), "pv-addon-discs");
        }

        private static final InputStream loadConfig$lambda$0(String resourcePath) {
            Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
            InputStream inputStream = Companion.getLanguageResource(resourcePath);
            if (inputStream == null) {
                throw new Exception("Can't load language resource");
            }
            return inputStream;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Config
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\n\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\r\"\u0004\b\u0017\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lsu/plo/voice/discs/AddonConfig$DistanceConfig;", "", "()V", "beaconLikeDistanceList", "", "", "getBeaconLikeDistanceList", "()Ljava/util/List;", "setBeaconLikeDistanceList", "(Ljava/util/List;)V", "enableBeaconLikeDistance", "", "getEnableBeaconLikeDistance", "()Z", "setEnableBeaconLikeDistance", "(Z)V", "jukeboxDistance", "getJukeboxDistance", "()S", "setJukeboxDistance", "(S)V", "visualizeDistance", "getVisualizeDistance", "setVisualizeDistance", "core"})
    public static final class DistanceConfig {
        @ConfigField(comment="\n                Visualizes the distance to the player who inserted a custom disc into the jukebox.\n                Visualization will be seen only by players with \"Visualize Voice Distance\" enabled.\n            ")
        private boolean visualizeDistance = true;
        @ConfigField(comment="\n                Distance if 'enable_beacon_like_distance_amplification' is set\n                to false.\n            ")
        private short jukeboxDistance = (short)65;
        @ConfigField(path="enable_beacon_like_distance_amplification", comment="\n                With this option enabled you can build a beacon-like pyramid\n                under a jukebox to change the distance of the sound.\n            ")
        private boolean enableBeaconLikeDistance;
        @ConfigField(path="beacon_like_distances", comment="\n                The first element is the distance without any pyramid layers.\n                You can add as much layers as you want. Even more or less\n                than the vanilla beacon, but at least one layer is required.  \n            ")
        @NotNull
        private List<Short> beaconLikeDistanceList;

        public DistanceConfig() {
            Object[] objectArray = new Short[]{(short)12, (short)24, (short)32, (short)48, (short)64};
            this.beaconLikeDistanceList = CollectionsKt.listOf((Object[])objectArray);
        }

        public final boolean getVisualizeDistance() {
            return this.visualizeDistance;
        }

        public final void setVisualizeDistance(boolean bl) {
            this.visualizeDistance = bl;
        }

        public final short getJukeboxDistance() {
            return this.jukeboxDistance;
        }

        public final void setJukeboxDistance(short s) {
            this.jukeboxDistance = s;
        }

        public final boolean getEnableBeaconLikeDistance() {
            return this.enableBeaconLikeDistance;
        }

        public final void setEnableBeaconLikeDistance(boolean bl) {
            this.enableBeaconLikeDistance = bl;
        }

        @NotNull
        public final List<Short> getBeaconLikeDistanceList() {
            return this.beaconLikeDistanceList;
        }

        public final void setBeaconLikeDistanceList(@NotNull List<Short> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.beaconLikeDistanceList = list;
        }
    }

    @Config
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u00020\b8\u0006X\u0087D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u00020\f8\u0006X\u0087D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u00020\b8\u0006X\u0087D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\n\u00a8\u0006\u0011"}, d2={"Lsu/plo/voice/discs/AddonConfig$GoatHornConfig;", "", "()V", "distance", "", "getDistance", "()S", "enabled", "", "getEnabled", "()Z", "maxDurationSeconds", "", "getMaxDurationSeconds", "()I", "visualizeDistance", "getVisualizeDistance", "core"})
    public static final class GoatHornConfig {
        @ConfigField(comment="\n                Enable goat horns.\n                Allows burning audio onto the goat horn using /disc burn.\n                When a custom goat horn is used, the audio will be loaded and attached to the player.\n                Use /disc cancel to stop the goat horn audio from playing.\n            ")
        private final boolean enabled;
        @ConfigField(comment="\n                Visualizes the distance to the player who used a custom goat horn.\n                Visualization will be seen only by players with \"Visualize Voice Distance\" enabled.\n            ")
        private final boolean visualizeDistance;
        @ConfigField(comment="\n                Goat horn distance.\n            ")
        private final short distance = (short)15;
        @ConfigField(comment="\n                Goat horn maximum audio duration in seconds.\n                Set to 0 to disable duration limit.\n            ")
        private final int maxDurationSeconds;

        public GoatHornConfig() {
            this.visualizeDistance = true;
            this.maxDurationSeconds = 200;
        }

        public final boolean getEnabled() {
            return this.enabled;
        }

        public final boolean getVisualizeDistance() {
            return this.visualizeDistance;
        }

        public final short getDistance() {
            return this.distance;
        }

        public final int getMaxDurationSeconds() {
            return this.maxDurationSeconds;
        }
    }

    @Config
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00020\t8\u0006X\u0087D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lsu/plo/voice/discs/AddonConfig$HttpSourceConfig;", "", "()V", "whitelist", "", "", "getWhitelist", "()Ljava/util/List;", "whitelistEnabled", "", "getWhitelistEnabled", "()Z", "core"})
    public static final class HttpSourceConfig {
        @ConfigField(comment="\n                Only allow links from trusted sources. You can disable this if\n                the server IP is public and leaking it is not a problem.\n            ")
        private final boolean whitelistEnabled;
        @ConfigField
        @NotNull
        private final List<String> whitelist;

        public HttpSourceConfig() {
            this.whitelistEnabled = true;
            Object[] objectArray = new String[]{"dropbox.com", "dropboxusercontent.com"};
            this.whitelist = CollectionsKt.listOf((Object[])objectArray);
        }

        public final boolean getWhitelistEnabled() {
            return this.whitelistEnabled;
        }

        @NotNull
        public final List<String> getWhitelist() {
            return this.whitelist;
        }
    }

    @Config
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u00020\b8\u0006X\u0087D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lsu/plo/voice/discs/AddonConfig$LocalSourceConfig;", "", "()V", "enabled", "", "getEnabled", "()Z", "path", "", "getPath", "()Ljava/lang/String;", "core"})
    public static final class LocalSourceConfig {
        @ConfigField(comment="\n                Enable local source. Local source allows to load audio files from specified \"path\" folder.\n                \n                Example format:\n                file://test.mp3\n                local://test.mp3\n            ")
        private final boolean enabled;
        @ConfigField(comment="\n            Path used as a root to resolve audio files.\n            If path is empty, \"local\" folder inside addon's plugin folder will be used (\"plugins/pv-addon-discs/local\").\n        ")
        @NotNull
        private final String path;

        public LocalSourceConfig() {
            this.path = "";
        }

        public final boolean getEnabled() {
            return this.enabled;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lsu/plo/voice/discs/AddonConfig$LoreMethod;", "", "(Ljava/lang/String;I)V", "DISABLE", "REPLACE", "APPEND", "core"})
    public static final class LoreMethod
    extends Enum<LoreMethod> {
        public static final /* enum */ LoreMethod DISABLE = new LoreMethod();
        public static final /* enum */ LoreMethod REPLACE = new LoreMethod();
        public static final /* enum */ LoreMethod APPEND = new LoreMethod();
        private static final /* synthetic */ LoreMethod[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LoreMethod[] values() {
            return (LoreMethod[])$VALUES.clone();
        }

        public static LoreMethod valueOf(String value) {
            return Enum.valueOf(LoreMethod.class, value);
        }

        @NotNull
        public static EnumEntries<LoreMethod> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = loreMethodArray = new LoreMethod[]{LoreMethod.DISABLE, LoreMethod.REPLACE, LoreMethod.APPEND};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Config
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u0004\u0018\u00010\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\u0004\u0018\u00010\r8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u00020\u00118\u0006X\u0087D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lsu/plo/voice/discs/AddonConfig$YouTubeSourceConfig;", "", "()V", "clients", "", "", "getClients", "()Ljava/util/List;", "poToken", "Lsu/plo/voice/discs/AddonConfig$YouTubeSourceConfig$PoToken;", "getPoToken", "()Lsu/plo/voice/discs/AddonConfig$YouTubeSourceConfig$PoToken;", "remoteCipher", "Lsu/plo/voice/discs/AddonConfig$YouTubeSourceConfig$RemoteCipher;", "getRemoteCipher", "()Lsu/plo/voice/discs/AddonConfig$YouTubeSourceConfig$RemoteCipher;", "useOauth2", "", "getUseOauth2", "()Z", "PoToken", "RemoteCipher", "core"})
    public static final class YouTubeSourceConfig {
        @ConfigField(comment="\n                If you see a error like \"Sign in to confirm you're not a bot\",\n                you can try using YouTube oauth2 authorization.\n\n                On the first start with authorization enabled,\n                you will see \"OAUTH INTEGRATION\" in your console.\n                Follow the instructions in this prompt.\n                If you do everything right, you will see \"Token retrieved successfully\" in your console.\n                You only need to do this once;\n                the token will be stored in \"pv-addon-discs/.youtube-token\" after successful authorization.\n            ")
        private final boolean useOauth2;
        @ConfigField(comment="\n                https://github.com/lavalink-devs/youtube-source?tab=readme-ov-file#using-a-potoken\n               \n                You don't need to specify a poToken if using oauth2, and vice versa.\n                If poToken is specified, oauth2 will be disabled.\n            ", nullComment="\n                [youtube_source.po_token]\n                token = \"paste your po_token here\"\n                visitor_data = \"paste your visitor_data here\"\n            ")
        @Nullable
        private final PoToken poToken;
        @ConfigField(comment="\n                https://github.com/lavalink-devs/youtube-source?tab=readme-ov-file#using-a-remote-cipher-server\n            ", nullComment="\n                [youtube_source.remote_cipher]\n                url = \"http://localhost:8001\"\n                password = \"your_secret_password\"\n            ")
        @Nullable
        private final RemoteCipher remoteCipher;
        @ConfigField(comment="\n                You can check available clients here: https://github.com/lavalink-devs/youtube-source?tab=readme-ov-file#available-clients\n            ", nullComment="\n                clients = [\"MUSIC\", \"ANDROID_VR\", \"WEB\", \"WEBEMBEDDED\", \"TVHTML5EMBEDDED\"]\n            ")
        @Nullable
        private final List<String> clients;

        public final boolean getUseOauth2() {
            return this.useOauth2;
        }

        @Nullable
        public final PoToken getPoToken() {
            return this.poToken;
        }

        @Nullable
        public final RemoteCipher getRemoteCipher() {
            return this.remoteCipher;
        }

        @Nullable
        public final List<String> getClients() {
            return this.clients;
        }

        @Config
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lsu/plo/voice/discs/AddonConfig$YouTubeSourceConfig$PoToken;", "", "()V", "token", "", "getToken", "()Ljava/lang/String;", "visitorData", "getVisitorData", "core"})
        public static final class PoToken {
            @ConfigField
            @NotNull
            private final String token;
            @ConfigField
            @NotNull
            private final String visitorData;

            public PoToken() {
                this.token = "";
                this.visitorData = "";
            }

            @NotNull
            public final String getToken() {
                return this.token;
            }

            @NotNull
            public final String getVisitorData() {
                return this.visitorData;
            }
        }

        @Config
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lsu/plo/voice/discs/AddonConfig$YouTubeSourceConfig$RemoteCipher;", "", "()V", "password", "", "getPassword", "()Ljava/lang/String;", "url", "getUrl", "core"})
        public static final class RemoteCipher {
            @ConfigField
            @NotNull
            private final String url;
            @ConfigField
            @NotNull
            private final String password;

            public RemoteCipher() {
                this.url = "";
                this.password = "";
            }

            @NotNull
            public final String getUrl() {
                return this.url;
            }

            @NotNull
            public final String getPassword() {
                return this.password;
            }
        }
    }
}

