/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.discs.libraries.net.fabricmc.mappingio;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jetbrains.annotations.Nullable;
import su.plo.voice.discs.libraries.net.fabricmc.mappingio.MappingVisitor;
import su.plo.voice.discs.libraries.net.fabricmc.mappingio.format.MappingFormat;
import su.plo.voice.discs.libraries.net.fabricmc.mappingio.format.enigma.EnigmaDirWriter;
import su.plo.voice.discs.libraries.net.fabricmc.mappingio.format.enigma.EnigmaFileWriter;
import su.plo.voice.discs.libraries.net.fabricmc.mappingio.format.proguard.ProGuardFileWriter;
import su.plo.voice.discs.libraries.net.fabricmc.mappingio.format.srg.SrgFileWriter;
import su.plo.voice.discs.libraries.net.fabricmc.mappingio.format.tiny.Tiny1FileWriter;
import su.plo.voice.discs.libraries.net.fabricmc.mappingio.format.tiny.Tiny2FileWriter;

public interface MappingWriter
extends Closeable,
MappingVisitor {
    @Nullable
    public static MappingWriter create(Path file, MappingFormat format) throws IOException {
        if (format.hasSingleFile()) {
            return MappingWriter.create(Files.newBufferedWriter(file, new OpenOption[0]), format);
        }
        switch (format) {
            case ENIGMA_DIR: {
                return new EnigmaDirWriter(file, true);
            }
        }
        return null;
    }

    @Nullable
    public static MappingWriter create(Writer writer, MappingFormat format) throws IOException {
        if (!format.hasSingleFile()) {
            throw new IllegalArgumentException("format " + (Object)((Object)format) + " is not applicable to a single writer");
        }
        switch (format) {
            case TINY_FILE: {
                return new Tiny1FileWriter(writer);
            }
            case TINY_2_FILE: {
                return new Tiny2FileWriter(writer, false);
            }
            case ENIGMA_FILE: {
                return new EnigmaFileWriter(writer);
            }
            case SRG_FILE: {
                return new SrgFileWriter(writer, false);
            }
            case XSRG_FILE: {
                return new SrgFileWriter(writer, true);
            }
            case PROGUARD_FILE: {
                return new ProGuardFileWriter(writer);
            }
        }
        return null;
    }

    @Override
    default public boolean visitEnd() throws IOException {
        this.close();
        return true;
    }
}

