/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.discs.libraries.net.fabricmc.mappingio.adapter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import su.plo.voice.discs.libraries.net.fabricmc.mappingio.MappingVisitor;
import su.plo.voice.discs.libraries.net.fabricmc.mappingio.adapter.ForwardingMappingVisitor;

public final class MappingNsRenamer
extends ForwardingMappingVisitor {
    private final Map<String, String> nameMap;

    public MappingNsRenamer(MappingVisitor next2, Map<String, String> nameMap) {
        super(next2);
        Objects.requireNonNull(nameMap, "null name map");
        this.nameMap = nameMap;
    }

    @Override
    public void visitNamespaces(String srcNamespace, List<String> dstNamespaces) throws IOException {
        String newSrcNamespace = this.nameMap.getOrDefault(srcNamespace, srcNamespace);
        ArrayList<String> newDstNamespaces = new ArrayList<String>(dstNamespaces.size());
        for (String ns : dstNamespaces) {
            newDstNamespaces.add(this.nameMap.getOrDefault(ns, ns));
        }
        super.visitNamespaces(newSrcNamespace, newDstNamespaces);
    }
}

