/*
 * Decompiled with CFR 0.152.
 */
package kite2459.forceload;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public final class ForceLoadConfig {
    public int maxChunks = 4096;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ForceLoadConfig loadOrCreate(Path path) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                ForceLoadConfig c = new ForceLoadConfig();
                ForceLoadConfig.save(path, c);
                return c;
            }
            try (BufferedReader r = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
                ForceLoadConfig c = (ForceLoadConfig)GSON.fromJson((Reader)r, ForceLoadConfig.class);
                ForceLoadConfig forceLoadConfig = ForceLoadConfig.sanitize(c != null ? c : new ForceLoadConfig());
                return forceLoadConfig;
            }
        }
        catch (Exception e) {
            return new ForceLoadConfig();
        }
    }

    public static void save(Path path, ForceLoadConfig cfg) {
        try (BufferedWriter w = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            GSON.toJson((Object)cfg, (Appendable)w);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static ForceLoadConfig sanitize(ForceLoadConfig c) {
        if (c.maxChunks < 1) {
            c.maxChunks = 1;
        }
        if (c.maxChunks > 1000000) {
            c.maxChunks = 1000000;
        }
        return c;
    }
}

