/*
 * Decompiled with CFR 0.152.
 */
package org.ryvione.javalert;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.ryvione.javalert.beacon.TriggerConfigPacket;
import org.ryvione.javalert.config.Config;
import org.ryvione.javalert.network.AlertPacket;
import org.ryvione.javalert.registry.ModRegistry;

@Mod(value="javalert")
public class Javalert {
    public static final String MODID = "javalert";
    private static final String PROTOCOL_VERSION = "1";
    private static final String DEFAULT_PRIMARY_BUTTON = "OK";
    public static final SimpleChannel NETWORK = NetworkRegistry.newSimpleChannel((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"javalert", (String)"main"), () -> "1", "1"::equals, "1"::equals);

    public Javalert() {
        System.out.println("JavAlert loaded");
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModRegistry.init(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.SPEC);
        int packetId = 0;
        NETWORK.messageBuilder(AlertPacket.class, packetId++, NetworkDirection.PLAY_TO_CLIENT).encoder(AlertPacket::encode).decoder(AlertPacket::decode).consumerMainThread(AlertPacket::handle).add();
        NETWORK.messageBuilder(TriggerConfigPacket.class, packetId++, NetworkDirection.PLAY_TO_SERVER).encoder(TriggerConfigPacket::encode).decoder(TriggerConfigPacket::decode).consumerMainThread(TriggerConfigPacket::handle).add();
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"alert").requires(source -> source.m_6761_(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"simple").then(Commands.m_82129_((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            try {
                Collection targets = EntityArgument.m_91477_((CommandContext)context, (String)"player");
                String message = StringArgumentType.getString((CommandContext)context, (String)"message");
                for (ServerPlayer target : targets) {
                    NETWORK.sendTo((Object)new AlertPacket(message, "Minecraft Alert", "warning", true, "messagebox", DEFAULT_PRIMARY_BUTTON, "", "warning", false, "", "", "", "", ""), target.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                }
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a7a[JavaAlert] \u00a7fSimple alert sent to \u00a7b" + targets.size() + " player(s)")), false);
                return targets.isEmpty() ? 0 : 1;
            }
            catch (Exception e) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("\u00a7c[JavaAlert] Error: " + e.getMessage())));
                e.printStackTrace();
                return 0;
            }
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"advanced").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"messagebox").then(Commands.m_82127_((String)"info").then(Commands.m_82129_((String)"title", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> this.sendAdvancedAlert((CommandContext<CommandSourceStack>)context, "messagebox", "info")))))).then(Commands.m_82127_((String)"warning").then(Commands.m_82129_((String)"title", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> this.sendAdvancedAlert((CommandContext<CommandSourceStack>)context, "messagebox", "warning")))))).then(Commands.m_82127_((String)"error").then(Commands.m_82129_((String)"title", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> this.sendAdvancedAlert((CommandContext<CommandSourceStack>)context, "messagebox", "error")))))).then(Commands.m_82127_((String)"question").then(Commands.m_82129_((String)"title", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> this.sendAdvancedAlert((CommandContext<CommandSourceStack>)context, "messagebox", "question"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"notification").then(Commands.m_82127_((String)"info").then(Commands.m_82129_((String)"title", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> this.sendAdvancedAlert((CommandContext<CommandSourceStack>)context, "notification", "info")))))).then(Commands.m_82127_((String)"warning").then(Commands.m_82129_((String)"title", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> this.sendAdvancedAlert((CommandContext<CommandSourceStack>)context, "notification", "warning")))))).then(Commands.m_82127_((String)"error").then(Commands.m_82129_((String)"title", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> this.sendAdvancedAlert((CommandContext<CommandSourceStack>)context, "notification", "error")))))).then(Commands.m_82127_((String)"question").then(Commands.m_82129_((String)"title", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> this.sendAdvancedAlert((CommandContext<CommandSourceStack>)context, "notification", "question")))))))).then(Commands.m_82127_((String)"notification").then(Commands.m_82129_((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            try {
                Collection targets = EntityArgument.m_91477_((CommandContext)context, (String)"player");
                String message = StringArgumentType.getString((CommandContext)context, (String)"message");
                for (ServerPlayer target : targets) {
                    NETWORK.sendTo((Object)new AlertPacket(message, "Minecraft Alert", "info", true, "notification", DEFAULT_PRIMARY_BUTTON, "", "info", false, "", "", "", "", ""), target.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                }
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a7a[JavaAlert] \u00a7fNotification sent to \u00a7b" + targets.size() + " player(s)")), false);
                return targets.isEmpty() ? 0 : 1;
            }
            catch (Exception e) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("\u00a7c[JavaAlert] Error: " + e.getMessage())));
                return 0;
            }
        })))).then(Commands.m_82127_((String)"customscreen").then(Commands.m_82129_((String)"title", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"primaryButton", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"secondaryButton", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> this.sendCustomScreen((CommandContext<CommandSourceStack>)context, true))))).then(Commands.m_82129_((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> this.sendCustomScreen((CommandContext<CommandSourceStack>)context, false))))))));
    }

    private int sendAdvancedAlert(CommandContext<CommandSourceStack> context, String displayType, String iconType) {
        try {
            Collection targets = EntityArgument.m_91477_(context, (String)"player");
            String title = StringArgumentType.getString(context, (String)"title");
            String message = StringArgumentType.getString(context, (String)"message");
            for (ServerPlayer target : targets) {
                NETWORK.sendTo((Object)new AlertPacket(message, title, iconType, true, displayType, DEFAULT_PRIMARY_BUTTON, "", iconType, false, "", "", "", "", ""), target.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a7a[JavaAlert] \u00a7fAdvanced alert [\u00a7e" + displayType.toUpperCase() + "\u00a7f - \u00a7e" + iconType.toUpperCase() + "\u00a7f] sent to \u00a7b" + targets.size() + " player(s)")), false);
            return targets.isEmpty() ? 0 : 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("\u00a7c[JavaAlert] Error: " + e.getMessage())));
            e.printStackTrace();
            return 0;
        }
    }

    private int sendCustomScreen(CommandContext<CommandSourceStack> context, boolean hasSecondary) {
        try {
            Collection targets = EntityArgument.m_91477_(context, (String)"player");
            String title = StringArgumentType.getString(context, (String)"title");
            String message = StringArgumentType.getString(context, (String)"message");
            String primary = StringArgumentType.getString(context, (String)"primaryButton");
            String secondary = hasSecondary ? StringArgumentType.getString(context, (String)"secondaryButton") : "";
            for (ServerPlayer target : targets) {
                NETWORK.sendTo((Object)new AlertPacket(message, title, "info", true, "customscreen", primary, secondary, "info", false, "", "", "", "", ""), target.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a7a[JavaAlert] \u00a7fCustom screen sent to \u00a7b" + targets.size() + " player(s)")), false);
            return targets.isEmpty() ? 0 : 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("\u00a7c[JavaAlert] Error: " + e.getMessage())));
            return 0;
        }
    }
}

