/*
 * Decompiled with CFR 0.152.
 */
package org.ryvione.javalert.beacon;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.NetworkDirection;
import org.ryvione.javalert.Javalert;
import org.ryvione.javalert.network.AlertPacket;
import org.ryvione.javalert.registry.ModRegistry;

public class AlertTriggerBlockEntity
extends BlockEntity {
    private double radius = 10.0;
    private String title = "Alert";
    private String message = "You have triggered an alert!";
    private String displayType = "notification";
    private String iconType = "info";
    private String soundName = "";
    private String primary = "OK";
    private String secondary = "";
    private boolean redstoneEnabled = true;
    private boolean persistent = false;
    private int duration = 5;
    private float volume = 1.0f;
    private String actionType = "dismiss";
    private int cooldown = 0;
    private boolean oneTime = false;
    private String permission = "";
    private final Map<UUID, Long> lastTriggered = new HashMap<UUID, Long>();
    private final Map<UUID, Boolean> oneTimeTriggered = new HashMap<UUID, Boolean>();
    private static final long DEFAULT_COOLDOWN_MS = 5000L;

    public AlertTriggerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.ALERT_TRIGGER_BE.get(), pos, state);
    }

    public void tickServer() {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!this.redstoneEnabled && serverLevel.m_277086_(this.f_58858_) == 0) {
            return;
        }
        long now = System.currentTimeMillis();
        long cooldownMs = (long)this.cooldown * 1000L;
        if (cooldownMs == 0L) {
            cooldownMs = 5000L;
        }
        List players = serverLevel.m_45976_(ServerPlayer.class, this.getAABB());
        for (ServerPlayer player : players) {
            long last;
            UUID uuid = player.m_20148_();
            if (this.oneTime && this.oneTimeTriggered.getOrDefault(uuid, false).booleanValue() || !this.permission.isEmpty() && !player.m_20310_(2) || now - (last = this.lastTriggered.getOrDefault(uuid, 0L).longValue()) < cooldownMs) continue;
            this.lastTriggered.put(uuid, now);
            if (this.oneTime) {
                this.oneTimeTriggered.put(uuid, true);
            }
            Javalert.NETWORK.sendTo((Object)new AlertPacket(this.message, this.title, this.iconType, !this.soundName.isEmpty(), this.displayType, this.primary, this.secondary, this.soundName, false, "", "", "", "", ""), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public void handleRedstone(boolean powered) {
        this.redstoneEnabled = powered;
    }

    private AABB getAABB() {
        double centerX = (double)this.f_58858_.m_123341_() + 0.5;
        double centerY = (double)this.f_58858_.m_123342_() + 0.5;
        double centerZ = (double)this.f_58858_.m_123343_() + 0.5;
        return new AABB(centerX - this.radius, centerY - this.radius, centerZ - this.radius, centerX + this.radius, centerY + this.radius, centerZ + this.radius);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128347_("radius", this.radius);
        tag.m_128359_("title", this.title);
        tag.m_128359_("message", this.message);
        tag.m_128359_("displayType", this.displayType);
        tag.m_128359_("iconType", this.iconType);
        tag.m_128359_("soundName", this.soundName);
        tag.m_128359_("primary", this.primary);
        tag.m_128359_("secondary", this.secondary);
        tag.m_128379_("redstone", this.redstoneEnabled);
        tag.m_128379_("persistent", this.persistent);
        tag.m_128405_("duration", this.duration);
        tag.m_128350_("volume", this.volume);
        tag.m_128359_("actionType", this.actionType);
        tag.m_128405_("cooldown", this.cooldown);
        tag.m_128379_("oneTime", this.oneTime);
        tag.m_128359_("permission", this.permission);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.radius = tag.m_128441_("radius") ? tag.m_128459_("radius") : 10.0;
        this.title = tag.m_128441_("title") ? tag.m_128461_("title") : "Alert";
        this.message = tag.m_128441_("message") ? tag.m_128461_("message") : "You have triggered an alert!";
        this.displayType = tag.m_128441_("displayType") ? tag.m_128461_("displayType") : "notification";
        this.iconType = tag.m_128441_("iconType") ? tag.m_128461_("iconType") : "info";
        this.soundName = tag.m_128441_("soundName") ? tag.m_128461_("soundName") : "";
        this.primary = tag.m_128441_("primary") ? tag.m_128461_("primary") : "OK";
        this.secondary = tag.m_128441_("secondary") ? tag.m_128461_("secondary") : "";
        this.redstoneEnabled = tag.m_128441_("redstone") ? tag.m_128471_("redstone") : true;
        this.persistent = tag.m_128441_("persistent") ? tag.m_128471_("persistent") : false;
        this.duration = tag.m_128441_("duration") ? tag.m_128451_("duration") : 5;
        this.volume = tag.m_128441_("volume") ? tag.m_128457_("volume") : 1.0f;
        this.actionType = tag.m_128441_("actionType") ? tag.m_128461_("actionType") : "dismiss";
        this.cooldown = tag.m_128441_("cooldown") ? tag.m_128451_("cooldown") : 0;
        this.oneTime = tag.m_128441_("oneTime") ? tag.m_128471_("oneTime") : false;
        this.permission = tag.m_128441_("permission") ? tag.m_128461_("permission") : "";
    }

    public void configure(double radius, String title, String message, String displayType, String iconType, String soundName, String primary, String secondary) {
        this.radius = Math.max(1.0, Math.min(radius, 100.0));
        this.title = title;
        this.message = message;
        this.displayType = displayType;
        this.iconType = iconType;
        this.soundName = soundName;
        this.primary = primary;
        this.secondary = secondary;
        this.m_6596_();
    }

    public void configureFull(double radius, String title, String message, String displayType, String iconType, String soundName, String primary, String secondary, boolean persistent, int duration, float volume, String actionType, int cooldown, boolean oneTime, String permission) {
        this.configure(radius, title, message, displayType, iconType, soundName, primary, secondary);
        this.persistent = persistent;
        this.duration = duration;
        this.volume = volume;
        this.actionType = actionType;
        this.cooldown = cooldown;
        this.oneTime = oneTime;
        this.permission = permission;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_46745_(this.f_58858_).m_8092_(true);
        }
    }

    public double getRadius() {
        return this.radius;
    }

    public String getTitle() {
        return this.title;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDisplayType() {
        return this.displayType;
    }

    public String getIconType() {
        return this.iconType;
    }

    public String getSoundName() {
        return this.soundName;
    }

    public String getPrimary() {
        return this.primary;
    }

    public String getSecondary() {
        return this.secondary;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public int getDuration() {
        return this.duration;
    }

    public float getVolume() {
        return this.volume;
    }

    public String getActionType() {
        return this.actionType;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public boolean isOneTime() {
        return this.oneTime;
    }

    public String getPermission() {
        return this.permission;
    }
}

