/*
 * Decompiled with CFR 0.152.
 */
package org.ryvione.javalert.beacon;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(modid="javalert", value={Dist.CLIENT})
public class RadiusPreview {
    private static BlockPos pos;
    private static double radius;
    private static boolean enabled;
    private static boolean visible;

    public static void show(BlockPos p, double r) {
        pos = p;
        radius = r;
        enabled = true;
        visible = true;
    }

    public static void hide() {
        enabled = false;
        visible = false;
    }

    public static void toggle() {
        if (enabled) {
            visible = !visible;
        }
    }

    public static void update(BlockPos p, double r) {
        if (enabled && pos != null && pos.equals((Object)p)) {
            radius = r;
        }
    }

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (!enabled || !visible || pos == null) {
            return;
        }
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        PoseStack pose = event.getPoseStack();
        MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
        pose.m_85836_();
        double r = radius;
        double centerX = (double)pos.m_123341_() + 0.5;
        double centerY = (double)pos.m_123342_() + 0.5;
        double centerZ = (double)pos.m_123343_() + 0.5;
        AABB box = new AABB(centerX - r, centerY - r, centerZ - r, centerX + r, centerY + r, centerZ + r);
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_110504_());
        RadiusPreview.renderBox(pose, consumer, box, 0, 255, 255, 255);
        pose.m_85849_();
        buffer.m_109911_();
    }

    private static void renderBox(PoseStack pose, VertexConsumer consumer, AABB box, int r, int g, int b, int a) {
        double minX = box.f_82288_;
        double minY = box.f_82289_;
        double minZ = box.f_82290_;
        double maxX = box.f_82291_;
        double maxY = box.f_82292_;
        double maxZ = box.f_82293_;
        RadiusPreview.addLine(pose, consumer, minX, minY, minZ, maxX, minY, minZ, r, g, b, a);
        RadiusPreview.addLine(pose, consumer, minX, minY, minZ, minX, minY, maxZ, r, g, b, a);
        RadiusPreview.addLine(pose, consumer, maxX, minY, minZ, maxX, minY, maxZ, r, g, b, a);
        RadiusPreview.addLine(pose, consumer, minX, minY, maxZ, maxX, minY, maxZ, r, g, b, a);
        RadiusPreview.addLine(pose, consumer, minX, maxY, minZ, maxX, maxY, minZ, r, g, b, a);
        RadiusPreview.addLine(pose, consumer, minX, maxY, minZ, minX, maxY, maxZ, r, g, b, a);
        RadiusPreview.addLine(pose, consumer, maxX, maxY, minZ, maxX, maxY, maxZ, r, g, b, a);
        RadiusPreview.addLine(pose, consumer, minX, maxY, maxZ, maxX, maxY, maxZ, r, g, b, a);
        RadiusPreview.addLine(pose, consumer, minX, minY, minZ, minX, maxY, minZ, r, g, b, a);
        RadiusPreview.addLine(pose, consumer, maxX, minY, minZ, maxX, maxY, minZ, r, g, b, a);
        RadiusPreview.addLine(pose, consumer, minX, minY, maxZ, minX, maxY, maxZ, r, g, b, a);
        RadiusPreview.addLine(pose, consumer, maxX, minY, maxZ, maxX, maxY, maxZ, r, g, b, a);
    }

    private static void addLine(PoseStack pose, VertexConsumer consumer, double x1, double y1, double z1, double x2, double y2, double z2, int r, int g, int b, int a) {
        Matrix4f matrix = pose.m_85850_().m_252922_();
        Matrix3f normal = pose.m_85850_().m_252943_();
        consumer.m_252986_(matrix, (float)x1, (float)y1, (float)z1).m_6122_(r, g, b, a).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(matrix, (float)x2, (float)y2, (float)z2).m_6122_(r, g, b, a).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    static {
        enabled = false;
        visible = true;
    }
}

