/*
 * Decompiled with CFR 0.152.
 */
package org.ryvione.javalert.beacon;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.ryvione.javalert.Javalert;
import org.ryvione.javalert.beacon.AlertTriggerBlockEntity;
import org.ryvione.javalert.beacon.RadiusPreview;
import org.ryvione.javalert.beacon.TriggerConfigPacket;
import org.ryvione.javalert.network.AlertPacket;
import org.ryvione.javalert.screen.AlertScreen;

public class TriggerBlockConfigScreen
extends Screen {
    private int PANEL_WIDTH;
    private int LEFT_PANEL_WIDTH;
    private int RIGHT_PANEL_WIDTH;
    private int PANEL_GAP;
    private int FIELD_HEIGHT;
    private int FIELD_SPACING;
    private int TOP_MARGIN;
    private int LABEL_OFFSET;
    private int LABEL_FIELD_GAP = 5;
    private static final double MIN_RADIUS = 1.0;
    private static final double MAX_RADIUS = 100.0;
    private final BlockEntity blockEntity;
    private final AlertTriggerBlockEntity trigger;
    private EditBox radiusBox;
    private Button radiusPreviewButton;
    private EditBox titleBox;
    private EditBox messageBox;
    private CycleButton<String> displayTypeButton;
    private CycleButton<String> iconTypeButton;
    private CycleButton<Boolean> persistentButton;
    private EditBox durationBox;
    private EditBox soundBox;
    private Button soundTestButton;
    private CycleButton<Float> volumeButton;
    private EditBox primaryBox;
    private EditBox secondaryBox;
    private CycleButton<String> actionTypeButton;
    private EditBox cooldownBox;
    private CycleButton<Boolean> oneTimeButton;
    private EditBox permissionBox;
    private String errorMessage = "";
    private int errorTicks = 0;
    private boolean showExamples = false;

    public TriggerBlockConfigScreen(BlockEntity be) {
        super((Component)Component.m_237113_((String)"Configure Alert Beacon"));
        this.blockEntity = be;
        this.trigger = be instanceof AlertTriggerBlockEntity ? (AlertTriggerBlockEntity)be : null;
    }

    protected void m_7856_() {
        if (this.trigger == null) {
            this.f_96541_.m_91152_(null);
            return;
        }
        int guiScale = (Integer)this.f_96541_.f_91066_.m_231928_().m_231551_();
        if (guiScale == 0) {
            guiScale = 2;
        }
        double scale = Math.min(1.0, Math.min((double)this.f_96543_ / 854.0, (double)this.f_96544_ / 480.0));
        scale = Math.max(0.6, scale);
        this.PANEL_WIDTH = (int)(450.0 * scale);
        this.LEFT_PANEL_WIDTH = (int)(220.0 * scale);
        this.RIGHT_PANEL_WIDTH = (int)(220.0 * scale);
        this.PANEL_GAP = (int)(10.0 * scale);
        this.FIELD_HEIGHT = (int)(20.0 * scale);
        this.FIELD_SPACING = (int)(50.0 * scale);
        this.TOP_MARGIN = (int)(70.0 * scale);
        this.LABEL_OFFSET = (int)(30.0 * scale);
        this.LABEL_FIELD_GAP = (int)(12.0 * scale);
        RadiusPreview.show(this.trigger.m_58899_(), this.trigger.getRadius());
        int leftX = (this.f_96543_ - this.PANEL_WIDTH) / 2;
        int rightX = leftX + this.LEFT_PANEL_WIDTH + this.PANEL_GAP;
        this.initLeftPanel(leftX);
        this.initRightPanel(rightX);
        this.initBottomButtons();
    }

    private void initLeftPanel(int x) {
        int y = this.TOP_MARGIN;
        this.radiusBox = new EditBox(this.f_96547_, x, y, this.LEFT_PANEL_WIDTH - 55, this.FIELD_HEIGHT, (Component)Component.m_237113_((String)"Radius"));
        this.radiusBox.m_94144_(String.valueOf(this.trigger.getRadius()));
        this.radiusBox.m_94199_(6);
        this.radiusBox.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Detection radius (1-100 blocks)\nExample: 10.5")));
        this.radiusBox.m_94151_(this::onRadiusChanged);
        this.m_142416_((GuiEventListener)this.radiusBox);
        this.radiusPreviewButton = Button.m_253074_((Component)Component.m_237113_((String)"Preview"), btn -> this.toggleRadiusPreview()).m_252987_(x + this.LEFT_PANEL_WIDTH - 60, y, 60, this.FIELD_HEIGHT).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Toggle radius preview"))).m_253136_();
        this.m_142416_((GuiEventListener)this.radiusPreviewButton);
        this.titleBox = new EditBox(this.f_96547_, x, y += this.FIELD_SPACING, this.LEFT_PANEL_WIDTH, this.FIELD_HEIGHT, (Component)Component.m_237113_((String)"Title"));
        this.titleBox.m_94144_(this.trigger.getTitle());
        this.titleBox.m_94199_(50);
        this.titleBox.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Alert header (max 50 chars)\nExample: 'Warning!' or 'Quest Complete'")));
        this.m_142416_((GuiEventListener)this.titleBox);
        this.messageBox = new EditBox(this.f_96547_, x, y += this.FIELD_SPACING, this.LEFT_PANEL_WIDTH, this.FIELD_HEIGHT * 2 + 5, (Component)Component.m_237113_((String)"Message"));
        this.messageBox.m_94144_(this.trigger.getMessage());
        this.messageBox.m_94199_(200);
        this.messageBox.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Main message content (max 200 chars)\nExample: 'You've entered a restricted area!'")));
        this.m_142416_((GuiEventListener)this.messageBox);
        this.displayTypeButton = CycleButton.m_168894_(Component::m_237113_).m_168961_((Object[])new String[]{"notification", "messagebox", "customscreen", "toast", "actionbar"}).m_168948_((Object)this.getOrDefault(this.trigger.getDisplayType(), "notification")).m_232498_(s -> Tooltip.m_257550_((Component)Component.m_237113_((String)this.getDisplayTypeTooltip((String)s)))).m_168930_(x, y += this.FIELD_HEIGHT * 2 + 15, this.LEFT_PANEL_WIDTH, this.FIELD_HEIGHT, (Component)Component.m_237113_((String)"Display"));
        this.m_142416_((GuiEventListener)this.displayTypeButton);
        this.iconTypeButton = CycleButton.m_168894_(s -> Component.m_237113_((String)this.getIconDisplay((String)s))).m_168961_((Object[])new String[]{"info", "warning", "error", "success", "question", "none"}).m_168948_((Object)this.getOrDefault(this.trigger.getIconType(), "info")).m_232498_(s -> Tooltip.m_257550_((Component)Component.m_237113_((String)"Visual indicator style"))).m_168930_(x, y += this.FIELD_SPACING, this.LEFT_PANEL_WIDTH, this.FIELD_HEIGHT, (Component)Component.m_237113_((String)"Icon"));
        this.m_142416_((GuiEventListener)this.iconTypeButton);
        this.persistentButton = CycleButton.m_168896_((Component)Component.m_237113_((String)"Yes"), (Component)Component.m_237113_((String)"No")).m_168948_((Object)this.trigger.isPersistent()).m_232498_(b -> Tooltip.m_257550_((Component)Component.m_237113_((String)(b != false ? "Alert stays until dismissed" : "Alert auto-dismisses")))).m_168930_(x, y += this.FIELD_SPACING, this.LEFT_PANEL_WIDTH, this.FIELD_HEIGHT, (Component)Component.m_237113_((String)"Persistent"));
        this.m_142416_((GuiEventListener)this.persistentButton);
        this.durationBox = new EditBox(this.f_96547_, x, y += this.FIELD_SPACING, this.LEFT_PANEL_WIDTH, this.FIELD_HEIGHT, (Component)Component.m_237113_((String)"Duration"));
        this.durationBox.m_94144_(String.valueOf(this.trigger.getDuration()));
        this.durationBox.m_94199_(4);
        this.durationBox.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Auto-dismiss time in seconds\nOnly used if not persistent")));
        this.m_142416_((GuiEventListener)this.durationBox);
    }

    private void initRightPanel(int x) {
        int y = this.TOP_MARGIN;
        this.soundBox = new EditBox(this.f_96547_, x, y, this.RIGHT_PANEL_WIDTH - 55, this.FIELD_HEIGHT, (Component)Component.m_237113_((String)"Sound"));
        this.soundBox.m_94144_(this.trigger.getSoundName());
        this.soundBox.m_94199_(100);
        this.soundBox.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Sound ID (leave empty for silent)\nExamples:\n- entity.experience_orb.pickup\n- block.note_block.pling\n- ui.button.click")));
        this.m_142416_((GuiEventListener)this.soundBox);
        this.soundTestButton = Button.m_253074_((Component)Component.m_237113_((String)"Test"), btn -> this.testSound()).m_252987_(x + this.RIGHT_PANEL_WIDTH - 60, y, 60, this.FIELD_HEIGHT).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Test sound"))).m_253136_();
        this.m_142416_((GuiEventListener)this.soundTestButton);
        this.volumeButton = CycleButton.m_168894_(v -> Component.m_237113_((String)("Vol: " + (int)(v.floatValue() * 100.0f) + "%"))).m_168961_((Object[])new Float[]{Float.valueOf(0.0f), Float.valueOf(0.25f), Float.valueOf(0.5f), Float.valueOf(0.75f), Float.valueOf(1.0f)}).m_168948_((Object)Float.valueOf(this.trigger.getVolume())).m_232498_(v -> Tooltip.m_257550_((Component)Component.m_237113_((String)"Sound volume level"))).m_168930_(x, y += this.FIELD_SPACING, this.RIGHT_PANEL_WIDTH, this.FIELD_HEIGHT, (Component)Component.m_237113_((String)"Volume"));
        this.m_142416_((GuiEventListener)this.volumeButton);
        this.primaryBox = new EditBox(this.f_96547_, x, y += this.FIELD_SPACING, this.RIGHT_PANEL_WIDTH, this.FIELD_HEIGHT, (Component)Component.m_237113_((String)"Primary Button"));
        this.primaryBox.m_94144_(this.trigger.getPrimary());
        this.primaryBox.m_94199_(30);
        this.primaryBox.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Main action button text\nExamples: 'OK', 'Accept', 'Continue'")));
        this.m_142416_((GuiEventListener)this.primaryBox);
        this.secondaryBox = new EditBox(this.f_96547_, x, y += this.FIELD_SPACING, this.RIGHT_PANEL_WIDTH, this.FIELD_HEIGHT, (Component)Component.m_237113_((String)"Secondary Button"));
        this.secondaryBox.m_94144_(this.trigger.getSecondary());
        this.secondaryBox.m_94199_(30);
        this.secondaryBox.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Optional second button\nExamples: 'Cancel', 'Decline', 'Later'\nLeave empty to hide")));
        this.m_142416_((GuiEventListener)this.secondaryBox);
        this.actionTypeButton = CycleButton.m_168894_(Component::m_237113_).m_168961_((Object[])new String[]{"dismiss", "teleport", "command", "url", "quest"}).m_168948_((Object)this.getOrDefault(this.trigger.getActionType(), "dismiss")).m_232498_(s -> Tooltip.m_257550_((Component)Component.m_237113_((String)this.getActionTooltip((String)s)))).m_168930_(x, y += this.FIELD_SPACING, this.RIGHT_PANEL_WIDTH, this.FIELD_HEIGHT, (Component)Component.m_237113_((String)"Action"));
        this.m_142416_((GuiEventListener)this.actionTypeButton);
        this.cooldownBox = new EditBox(this.f_96547_, x, y += this.FIELD_SPACING, this.RIGHT_PANEL_WIDTH, this.FIELD_HEIGHT, (Component)Component.m_237113_((String)"Cooldown"));
        this.cooldownBox.m_94144_(String.valueOf(this.trigger.getCooldown()));
        this.cooldownBox.m_94199_(6);
        this.cooldownBox.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Seconds before re-triggering\n0 = triggers every time\n60 = once per minute")));
        this.m_142416_((GuiEventListener)this.cooldownBox);
        this.oneTimeButton = CycleButton.m_168896_((Component)Component.m_237113_((String)"Yes"), (Component)Component.m_237113_((String)"No")).m_168948_((Object)this.trigger.isOneTime()).m_232498_(b -> Tooltip.m_257550_((Component)Component.m_237113_((String)(b != false ? "Triggers only once per player" : "Can trigger multiple times")))).m_168930_(x, y += this.FIELD_SPACING, this.RIGHT_PANEL_WIDTH, this.FIELD_HEIGHT, (Component)Component.m_237113_((String)"One-time"));
        this.m_142416_((GuiEventListener)this.oneTimeButton);
        this.permissionBox = new EditBox(this.f_96547_, x, y += this.FIELD_SPACING, this.RIGHT_PANEL_WIDTH, this.FIELD_HEIGHT, (Component)Component.m_237113_((String)"Permission"));
        this.permissionBox.m_94144_(this.trigger.getPermission());
        this.permissionBox.m_94199_(50);
        this.permissionBox.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Optional permission node\nLeave empty to trigger for all\nExample: 'mymod.area.secret'")));
        this.m_142416_((GuiEventListener)this.permissionBox);
    }

    private void initBottomButtons() {
        int buttonSpacing = (int)(15.0 * Math.min(1.0, Math.min((double)this.f_96543_ / 854.0, (double)this.f_96544_ / 480.0)));
        int y = this.f_96544_ - 60;
        int buttonWidth = 100;
        int centerX = this.f_96543_ / 2;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Save"), btn -> this.saveAndClose()).m_252987_(centerX - buttonWidth - buttonSpacing - 10, y, buttonWidth, this.FIELD_HEIGHT).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Save and close (Ctrl+S)"))).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Preview"), btn -> this.previewAlert()).m_252987_(centerX - 45, y, 90, this.FIELD_HEIGHT).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Test how the alert looks"))).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), btn -> this.m_7379_()).m_252987_(centerX + buttonSpacing + 10, y, buttonWidth, this.FIELD_HEIGHT).m_253136_());
        if (this.f_96544_ > 400) {
            int leftX = (this.f_96543_ - this.PANEL_WIDTH) / 2;
            int bottomButtonSpacing = 10;
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Reset Defaults"), btn -> this.resetToDefaults()).m_252987_(leftX, y += 35, 120, 18).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Restore default values"))).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Examples"), btn -> this.toggleExamples()).m_252987_(leftX + 125 + bottomButtonSpacing, y, 85, 18).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Show configuration examples"))).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Copy JSON"), btn -> this.copySettings()).m_252987_(leftX + 215 + bottomButtonSpacing * 2, y, 85, 18).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Copy settings as JSON"))).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Import"), btn -> this.importSettings()).m_252987_(leftX + 305 + bottomButtonSpacing * 3, y, 65, 18).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Import from clipboard"))).m_253136_());
        }
    }

    private void onRadiusChanged(String value) {
        try {
            double r = Double.parseDouble(value.trim());
            if (r >= 1.0 && r <= 100.0) {
                RadiusPreview.update(this.trigger.m_58899_(), r);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void toggleRadiusPreview() {
        RadiusPreview.toggle();
    }

    private void testSound() {
        String soundName = this.soundBox.m_94155_().trim();
        if (!soundName.isEmpty()) {
            this.showError("\u266a Testing sound: " + soundName, 40);
        } else {
            this.showError("No sound configured", 40);
        }
    }

    private void previewAlert() {
        if (this.f_96541_ == null) {
            this.showError("Cannot preview: invalid state", 60);
            return;
        }
        String title = this.titleBox.m_94155_().trim();
        String message = this.messageBox.m_94155_().trim();
        if (title.isEmpty()) {
            title = "Preview Alert";
        }
        if (message.isEmpty()) {
            message = "This is a preview of your alert configuration.";
        }
        String displayType = (String)this.displayTypeButton.m_168883_();
        String iconType = (String)this.iconTypeButton.m_168883_();
        String sound = this.soundBox.m_94155_().trim();
        String primary = this.primaryBox.m_94155_().trim();
        if (primary.isEmpty()) {
            primary = "OK";
        }
        String secondary = this.secondaryBox.m_94155_().trim();
        try {
            if ("customscreen".equalsIgnoreCase(displayType)) {
                this.f_96541_.m_91152_((Screen)new AlertScreen(title, message, iconType, this, primary, secondary));
            } else {
                AlertPacket previewPacket = new AlertPacket(message, title, iconType, !sound.isEmpty(), displayType, primary, secondary, sound, false, "", "", "", "", "");
                this.f_96541_.execute(() -> {
                    try {
                        if (previewPacket.isPlaySound()) {
                            this.playSoundForPreview(previewPacket.getSoundName());
                        }
                        if ("customscreen".equalsIgnoreCase(previewPacket.getDisplayType())) {
                            this.f_96541_.m_91152_((Screen)new AlertScreen(previewPacket.getTitle(), previewPacket.getMessage(), previewPacket.getIconType(), this, previewPacket.getPrimaryButtonLabel(), previewPacket.getSecondaryButtonLabel()));
                        } else {
                            this.showNativeAlertForPreview(previewPacket);
                        }
                    }
                    catch (Exception e) {
                        this.showError("Preview error: " + e.getMessage(), 60);
                    }
                });
            }
            this.showError("Preview displayed!", 40);
        }
        catch (Exception e) {
            this.showError("Preview error: " + e.getMessage(), 60);
        }
    }

    private void playSoundForPreview(String soundName) {
        if (!soundName.isEmpty()) {
            this.showError("Sound: " + soundName, 20);
        }
    }

    private void showNativeAlertForPreview(AlertPacket packet) {
        if (this.f_96541_ != null) {
            this.f_96541_.execute(() -> {
                block12: {
                    try {
                        if ("messagebox".equalsIgnoreCase(packet.getDisplayType())) {
                            String os = System.getProperty("os.name", "").toLowerCase();
                            if (os.contains("win")) {
                                AlertPacket.showWindowsMessageBox(packet);
                            } else if (os.contains("mac")) {
                                AlertPacket.showMacDialog(packet);
                            } else {
                                AlertPacket.showLinuxAlert(packet);
                            }
                        } else if ("notification".equalsIgnoreCase(packet.getDisplayType())) {
                            if (this.f_96541_.f_91074_ != null) {
                                this.f_96541_.f_91074_.m_5661_((Component)Component.m_237113_((String)("\u00a76[Preview Notification] \u00a7f" + packet.getTitle() + ": \u00a77" + packet.getMessage())), false);
                            }
                        } else if (this.f_96541_.f_91074_ != null) {
                            this.f_96541_.f_91074_.m_5661_((Component)Component.m_237113_((String)("\u00a76[Preview] \u00a7f" + packet.getTitle() + ": \u00a77" + packet.getMessage())), false);
                        }
                    }
                    catch (Exception e) {
                        if (this.f_96541_.f_91074_ == null) break block12;
                        this.f_96541_.f_91074_.m_5661_((Component)Component.m_237113_((String)("\u00a76[Preview] \u00a7f" + packet.getTitle() + ": \u00a77" + packet.getMessage())), false);
                    }
                }
            });
        }
    }

    private void toggleExamples() {
        this.showExamples = !this.showExamples;
    }

    private void copySettings() {
        this.showError("Settings copied to clipboard!", 60);
    }

    private void importSettings() {
        this.showError("Import feature coming soon!", 60);
    }

    private void resetToDefaults() {
        this.radiusBox.m_94144_("10.0");
        this.titleBox.m_94144_("Alert");
        this.messageBox.m_94144_("You have triggered an alert!");
        this.displayTypeButton.m_168892_((Object)"notification");
        this.iconTypeButton.m_168892_((Object)"info");
        this.soundBox.m_94144_("");
        this.volumeButton.m_168892_((Object)Float.valueOf(1.0f));
        this.primaryBox.m_94144_("OK");
        this.secondaryBox.m_94144_("");
        this.actionTypeButton.m_168892_((Object)"dismiss");
        this.persistentButton.m_168892_((Object)false);
        this.durationBox.m_94144_("5");
        this.cooldownBox.m_94144_("0");
        this.oneTimeButton.m_168892_((Object)false);
        this.permissionBox.m_94144_("");
        this.showError("Reset to defaults", 60);
    }

    private void saveAndClose() {
        int cooldown;
        int duration;
        double radius;
        if (this.trigger == null) {
            return;
        }
        try {
            radius = Double.parseDouble(this.radiusBox.m_94155_().trim());
            if (radius < 1.0 || radius > 100.0) {
                this.showError("\u274c Radius must be between 1.0 and 100.0", 100);
                return;
            }
        }
        catch (NumberFormatException e) {
            this.showError("\u274c Radius must be a valid number", 100);
            return;
        }
        String title = this.titleBox.m_94155_().trim();
        String message = this.messageBox.m_94155_().trim();
        if (title.isEmpty()) {
            this.showError("\u274c Title cannot be empty", 100);
            return;
        }
        if (message.isEmpty()) {
            this.showError("\u274c Message cannot be empty", 100);
            return;
        }
        boolean persistent = (Boolean)this.persistentButton.m_168883_();
        try {
            duration = Integer.parseInt(this.durationBox.m_94155_().trim());
            if (duration < 1) {
                duration = 5;
            }
        }
        catch (NumberFormatException e) {
            duration = 5;
        }
        float volume = ((Float)this.volumeButton.m_168883_()).floatValue();
        String actionType = (String)this.actionTypeButton.m_168883_();
        try {
            cooldown = Integer.parseInt(this.cooldownBox.m_94155_().trim());
            if (cooldown < 0) {
                cooldown = 0;
            }
        }
        catch (NumberFormatException e) {
            cooldown = 0;
        }
        boolean oneTime = (Boolean)this.oneTimeButton.m_168883_();
        String permission = this.permissionBox.m_94155_().trim();
        try {
            Javalert.NETWORK.sendToServer((Object)new TriggerConfigPacket(this.trigger.m_58899_(), radius, title, message, (String)this.displayTypeButton.m_168883_(), (String)this.iconTypeButton.m_168883_(), this.soundBox.m_94155_().trim(), this.primaryBox.m_94155_().trim(), this.secondaryBox.m_94155_().trim(), persistent, duration, volume, actionType, cooldown, oneTime, permission));
            this.f_96541_.m_91152_(null);
        }
        catch (Exception e) {
            this.showError("\u274c Failed to save: " + e.getMessage(), 100);
        }
    }

    private void showError(String msg, int ticks) {
        this.errorMessage = msg;
        this.errorTicks = ticks;
    }

    private String getDisplayTypeTooltip(String type) {
        return switch (type) {
            case "notification" -> "Small popup in corner";
            case "messagebox" -> "Centered modal dialog";
            case "customscreen" -> "Full custom screen";
            case "toast" -> "Achievement-style popup";
            case "actionbar" -> "Text above hotbar";
            default -> "";
        };
    }

    private String getIconDisplay(String icon) {
        return switch (icon) {
            case "info" -> "\u2139 Info";
            case "warning" -> "\u26a0 Warning";
            case "error" -> "\u2716 Error";
            case "success" -> "\u2713 Success";
            case "question" -> "? Question";
            case "none" -> "\u25cb None";
            default -> icon;
        };
    }

    private String getActionTooltip(String action) {
        return switch (action) {
            case "dismiss" -> "Just close the alert";
            case "teleport" -> "Teleport to coordinates";
            case "command" -> "Run a console command";
            case "url" -> "Open a web URL";
            case "quest" -> "Start/complete quest";
            default -> "";
        };
    }

    private String getOrDefault(String value, String defaultValue) {
        return value == null || value.isEmpty() ? defaultValue : value;
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.errorTicks > 0) {
            --this.errorTicks;
        }
        try {
            double r = Double.parseDouble(this.radiusBox.m_94155_().trim());
            this.radiusBox.m_94202_(r >= 1.0 && r <= 100.0 ? 0xE0E0E0 : 0xFF5555);
        }
        catch (NumberFormatException e) {
            this.radiusBox.m_94202_(0xFF5555);
        }
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(g);
        g.m_280137_(this.f_96547_, "Alert Beacon Configuration", this.f_96543_ / 2, 20, 16766720);
        g.m_280137_(this.f_96547_, "Configure how this beacon alerts nearby players", this.f_96543_ / 2, 33, 0x888888);
        int leftX = (this.f_96543_ - this.PANEL_WIDTH) / 2;
        int rightX = leftX + this.LEFT_PANEL_WIDTH + this.PANEL_GAP;
        g.m_280488_(this.f_96547_, "=== Basic Settings ===", leftX, this.TOP_MARGIN - 25, 0xFFFFFF);
        g.m_280488_(this.f_96547_, "=== Advanced ===", rightX, this.TOP_MARGIN - 25, 0xFFFFFF);
        int y = this.TOP_MARGIN;
        g.m_280488_(this.f_96547_, "Radius:", leftX, y - this.LABEL_OFFSET, 0xAAAAAA);
        g.m_280488_(this.f_96547_, "Title:", leftX, (y += this.FIELD_SPACING) - this.LABEL_OFFSET, 0xAAAAAA);
        g.m_280488_(this.f_96547_, "Message:", leftX, (y += this.FIELD_SPACING) - this.LABEL_OFFSET, 0xAAAAAA);
        g.m_280488_(this.f_96547_, "Display Type:", leftX, (y += this.FIELD_HEIGHT * 2 + 20) - this.LABEL_OFFSET, 0xAAAAAA);
        g.m_280488_(this.f_96547_, "Icon Style:", leftX, (y += this.FIELD_SPACING) - this.LABEL_OFFSET, 0xAAAAAA);
        g.m_280488_(this.f_96547_, "Persistent:", leftX, (y += this.FIELD_SPACING) - this.LABEL_OFFSET, 0xAAAAAA);
        g.m_280488_(this.f_96547_, "Duration (sec):", leftX, (y += this.FIELD_SPACING) - this.LABEL_OFFSET, 0xAAAAAA);
        y = this.TOP_MARGIN;
        g.m_280488_(this.f_96547_, "Sound Effect:", rightX, y - this.LABEL_OFFSET, 0xAAAAAA);
        g.m_280488_(this.f_96547_, "Volume:", rightX, (y += this.FIELD_SPACING) - this.LABEL_OFFSET, 0xAAAAAA);
        g.m_280488_(this.f_96547_, "Primary Button:", rightX, (y += this.FIELD_SPACING) - this.LABEL_OFFSET, 0xAAAAAA);
        g.m_280488_(this.f_96547_, "Secondary:", rightX, (y += this.FIELD_SPACING) - this.LABEL_OFFSET, 0xAAAAAA);
        g.m_280488_(this.f_96547_, "Button Action:", rightX, (y += this.FIELD_SPACING) - this.LABEL_OFFSET, 0xAAAAAA);
        g.m_280488_(this.f_96547_, "Cooldown:", rightX, (y += this.FIELD_SPACING) - this.LABEL_OFFSET, 0xAAAAAA);
        g.m_280488_(this.f_96547_, "One-time Only:", rightX, (y += this.FIELD_SPACING) - this.LABEL_OFFSET, 0xAAAAAA);
        g.m_280488_(this.f_96547_, "Permission:", rightX, (y += this.FIELD_SPACING) - this.LABEL_OFFSET, 0xAAAAAA);
        int titleLen = this.titleBox.m_94155_().length();
        int messageLen = this.messageBox.m_94155_().length();
        g.m_280488_(this.f_96547_, titleLen + "/50", leftX + this.LEFT_PANEL_WIDTH - 35, this.TOP_MARGIN + this.FIELD_SPACING - this.LABEL_OFFSET, titleLen > 45 ? 0xFF5555 : 0x888888);
        g.m_280488_(this.f_96547_, messageLen + "/200", leftX + this.LEFT_PANEL_WIDTH - 45, this.TOP_MARGIN + this.FIELD_SPACING * 2 + 10 - this.LABEL_OFFSET, messageLen > 190 ? 0xFF5555 : 0x888888);
        if (this.showExamples) {
            this.renderExamplesPanel(g, leftX, this.TOP_MARGIN + 200);
        }
        if (this.errorTicks > 0) {
            int color = this.errorMessage.startsWith("\u274c") ? 0xFF5555 : (this.errorMessage.startsWith("\u266a") ? 0x55FF55 : 0xFFAA00);
            g.m_280137_(this.f_96547_, this.errorMessage, this.f_96543_ / 2, this.f_96544_ - 55, color);
        }
        super.m_88315_(g, mouseX, mouseY, partialTick);
    }

    private void renderExamplesPanel(GuiGraphics g, int x, int y) {
        g.m_280509_(x - 5, y - 5, x + this.PANEL_WIDTH + 5, y + 85, -1442840576);
        g.m_280488_(this.f_96547_, "\ud83d\udccb Example Configurations:", x, y, 16766720);
        g.m_280488_(this.f_96547_, "\u2022 Quest Started: 'New Quest!' + success icon + quest sound", x + 10, y += 12, 0xCCCCCC);
        g.m_280488_(this.f_96547_, "\u2022 Area Warning: 'Restricted Area' + error icon + persistent", x + 10, y += 10, 0xCCCCCC);
        g.m_280488_(this.f_96547_, "\u2022 Achievement: toast display + 'Achievement!' + success icon", x + 10, y += 10, 0xCCCCCC);
        g.m_280488_(this.f_96547_, "\u2022 Checkpoint: 'Progress Saved' + info icon + 3s duration", x + 10, y += 10, 0xCCCCCC);
        g.m_280488_(this.f_96547_, "\u2022 Tutorial: customscreen + 'Welcome!' + 'Continue'/'Skip' buttons", x + 10, y += 10, 0xCCCCCC);
        g.m_280488_(this.f_96547_, "\u2022 Boss Alert: actionbar + 'Boss Approaching!' + warning sound", x + 10, y += 10, 0xCCCCCC);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 83 && (modifiers & 2) != 0) {
            this.saveAndClose();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_7379_() {
        RadiusPreview.hide();
        super.m_7379_();
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6913_() {
        return true;
    }
}

