/*
 * Decompiled with CFR 0.152.
 */
package org.ryvione.javalert.beacon;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import org.ryvione.javalert.beacon.AlertTriggerBlockEntity;

public class TriggerConfigPacket {
    private final BlockPos pos;
    private final double radius;
    private final String title;
    private final String message;
    private final String displayType;
    private final String iconType;
    private final String sound;
    private final String primary;
    private final String secondary;
    private final boolean persistent;
    private final int duration;
    private final float volume;
    private final String actionType;
    private final int cooldown;
    private final boolean oneTime;
    private final String permission;

    public TriggerConfigPacket(BlockPos pos, double radius, String title, String message, String displayType, String iconType, String sound, String primary, String secondary) {
        this(pos, radius, title, message, displayType, iconType, sound, primary, secondary, false, 5, 1.0f, "dismiss", 0, false, "");
    }

    public TriggerConfigPacket(BlockPos pos, double radius, String title, String message, String displayType, String iconType, String sound, String primary, String secondary, boolean persistent, int duration, float volume, String actionType, int cooldown, boolean oneTime, String permission) {
        this.pos = pos;
        this.radius = radius;
        this.title = title;
        this.message = message;
        this.displayType = displayType;
        this.iconType = iconType;
        this.sound = sound;
        this.primary = primary;
        this.secondary = secondary;
        this.persistent = persistent;
        this.duration = duration;
        this.volume = volume;
        this.actionType = actionType;
        this.cooldown = cooldown;
        this.oneTime = oneTime;
        this.permission = permission;
    }

    public static void encode(TriggerConfigPacket pkt, FriendlyByteBuf buf) {
        buf.m_130064_(pkt.pos);
        buf.writeDouble(pkt.radius);
        buf.m_130070_(pkt.title);
        buf.m_130070_(pkt.message);
        buf.m_130070_(pkt.displayType);
        buf.m_130070_(pkt.iconType);
        buf.m_130070_(pkt.sound);
        buf.m_130070_(pkt.primary);
        buf.m_130070_(pkt.secondary);
        buf.writeBoolean(pkt.persistent);
        buf.writeInt(pkt.duration);
        buf.writeFloat(pkt.volume);
        buf.m_130070_(pkt.actionType);
        buf.writeInt(pkt.cooldown);
        buf.writeBoolean(pkt.oneTime);
        buf.m_130070_(pkt.permission);
    }

    public static TriggerConfigPacket decode(FriendlyByteBuf buf) {
        return new TriggerConfigPacket(buf.m_130135_(), buf.readDouble(), buf.m_130277_(), buf.m_130277_(), buf.m_130277_(), buf.m_130277_(), buf.m_130277_(), buf.m_130277_(), buf.m_130277_(), buf.readBoolean(), buf.readInt(), buf.readFloat(), buf.m_130277_(), buf.readInt(), buf.readBoolean(), buf.m_130277_());
    }

    public static void handle(TriggerConfigPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            Level level = player.m_9236_();
            BlockEntity patt3613$temp = level.m_7702_(pkt.pos);
            if (patt3613$temp instanceof AlertTriggerBlockEntity) {
                AlertTriggerBlockEntity trigger = (AlertTriggerBlockEntity)patt3613$temp;
                trigger.configureFull(pkt.radius, pkt.title, pkt.message, pkt.displayType, pkt.iconType, pkt.sound, pkt.primary, pkt.secondary, pkt.persistent, pkt.duration, pkt.volume, pkt.actionType, pkt.cooldown, pkt.oneTime, pkt.permission);
                level.m_7260_(pkt.pos, trigger.m_58900_(), trigger.m_58900_(), 3);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

