/*
 * Decompiled with CFR 0.152.
 */
package org.ryvione.javalert.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.ryvione.javalert.screen.ConsentScreen;
import org.ryvione.javalert.screen.DisclaimerScreen;
import org.ryvione.javalert.screen.JavAlertConfigScreen;
import org.ryvione.javalert.util.ConsentManager;

@Mod.EventBusSubscriber(modid="javalert", value={Dist.CLIENT})
public class ClientInit {
    private static boolean disclaimerShown = false;
    private static boolean consentPrompted = false;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null) {
            return;
        }
        if (!disclaimerShown && mc.f_91080_ instanceof TitleScreen && !ConsentManager.hasSeenDisclaimer()) {
            disclaimerShown = true;
            mc.m_91152_((Screen)new DisclaimerScreen(mc.f_91080_));
            return;
        }
        if (!consentPrompted && mc.f_91080_ instanceof TitleScreen && !ConsentManager.isAllowed()) {
            consentPrompted = true;
            mc.m_91152_((Screen)new ConsentScreen(mc.f_91080_));
        }
    }

    @SubscribeEvent
    public static void onScreenInit(ScreenEvent.Init.Post event) {
        if (event.getScreen() instanceof TitleScreen) {
            TitleScreen titleScreen = (TitleScreen)event.getScreen();
            int singleplayerButtonX = titleScreen.f_96543_ / 2 - 100;
            int singleplayerButtonY = titleScreen.f_96544_ / 4 + 48;
            int iconSize = 16;
            int iconX = singleplayerButtonX - iconSize - 5;
            int iconY = singleplayerButtonY - 1;
            ResourceLocation logoTexture = ResourceLocation.fromNamespaceAndPath((String)"javalert", (String)"textures/gui/logo.png");
            ImageButton configIconButton = new ImageButton(iconX, iconY, iconSize, iconSize, 0, 0, iconSize, logoTexture, iconSize, iconSize * 2, button -> Minecraft.m_91087_().m_91152_((Screen)new JavAlertConfigScreen((Screen)titleScreen)), (Component)Component.m_237113_((String)"JavAlert Config"));
            configIconButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"JavAlert Config")));
            event.addListener((GuiEventListener)configIconButton);
        }
    }

    @SubscribeEvent
    public static void onLogout(ClientPlayerNetworkEvent.LoggingOut event) {
        consentPrompted = false;
    }
}

