/*
 * Decompiled with CFR 0.152.
 */
package org.ryvione.javalert.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="javalert", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.BooleanValue ENABLE_EXPERIMENTAL = BUILDER.comment("Enable experimental features (may be unstable)").define("enableExperimental", false);
    private static final ForgeConfigSpec.BooleanValue ENABLE_ALPHA = BUILDER.comment("Enable ALPHA features (highly experimental, use at your own risk)").define("enableAlpha", false);
    private static final ForgeConfigSpec.BooleanValue ENABLE_ALERT_BEACON = BUILDER.comment("Enable Alert Beacon block (ALPHA feature - requires enableAlpha to be true)").define("enableAlertBeacon", false);
    public static final ForgeConfigSpec SPEC = BUILDER.build();
    public static boolean enableExperimental = false;
    public static boolean enableAlpha = false;
    public static boolean enableAlertBeacon = false;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        enableExperimental = (Boolean)ENABLE_EXPERIMENTAL.get();
        enableAlpha = (Boolean)ENABLE_ALPHA.get();
        enableAlertBeacon = (Boolean)ENABLE_ALERT_BEACON.get() != false && enableAlpha;
    }

    public static void setEnableExperimental(boolean value) {
        ENABLE_EXPERIMENTAL.set((Object)value);
        enableExperimental = value;
    }

    public static void setEnableAlpha(boolean value) {
        ENABLE_ALPHA.set((Object)value);
        enableAlpha = value;
        if (!value) {
            Config.setEnableAlertBeacon(false);
        }
    }

    public static void setEnableAlertBeacon(boolean value) {
        if (value && !enableAlpha) {
            return;
        }
        ENABLE_ALERT_BEACON.set((Object)value);
        enableAlertBeacon = value;
    }

    public static void save() {
        SPEC.save();
    }
}

