/*
 * Decompiled with CFR 0.152.
 */
package org.ryvione.javalert.network;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.function.Supplier;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.ryvione.javalert.screen.AlertScreen;

public class AlertPacket {
    private final String message;
    private final String title;
    private final String iconType;
    private final boolean playSound;
    private final String displayType;
    private final String primaryButtonLabel;
    private final String secondaryButtonLabel;
    private final String soundName;
    private final boolean createFile;
    private final String fileLocationKey;
    private final String fileName;
    private final String fileContents;
    private final String fileCreator;
    private final String fileDateIso;

    public AlertPacket(String message, String title, String iconType, boolean playSound, String displayType, String primaryButtonLabel, String secondaryButtonLabel, String soundName, boolean createFile, String fileLocationKey, String fileName, String fileContents, String fileCreator, String fileDateIso) {
        this.message = message;
        this.title = title;
        this.iconType = iconType;
        this.playSound = playSound;
        this.displayType = displayType;
        this.primaryButtonLabel = primaryButtonLabel;
        this.secondaryButtonLabel = secondaryButtonLabel;
        this.soundName = soundName;
        this.createFile = createFile;
        this.fileLocationKey = fileLocationKey;
        this.fileName = fileName;
        this.fileContents = fileContents;
        this.fileCreator = fileCreator;
        this.fileDateIso = fileDateIso;
    }

    public String getMessage() {
        return this.message;
    }

    public String getTitle() {
        return this.title;
    }

    public String getIconType() {
        return this.iconType;
    }

    public boolean isPlaySound() {
        return this.playSound;
    }

    public String getDisplayType() {
        return this.displayType;
    }

    public String getPrimaryButtonLabel() {
        return this.primaryButtonLabel;
    }

    public String getSecondaryButtonLabel() {
        return this.secondaryButtonLabel;
    }

    public String getSoundName() {
        return this.soundName;
    }

    public static void encode(AlertPacket packet, FriendlyByteBuf buf) {
        buf.m_130070_(AlertPacket.nullToEmpty(packet.message));
        buf.m_130070_(AlertPacket.nullToEmpty(packet.title));
        buf.m_130070_(AlertPacket.nullToEmpty(packet.iconType));
        buf.writeBoolean(packet.playSound);
        buf.m_130070_(AlertPacket.nullToEmpty(packet.displayType));
        buf.m_130070_(AlertPacket.nullToEmpty(packet.primaryButtonLabel));
        buf.m_130070_(AlertPacket.nullToEmpty(packet.secondaryButtonLabel));
        buf.m_130070_(AlertPacket.nullToEmpty(packet.soundName));
        buf.writeBoolean(packet.createFile);
        buf.m_130070_(AlertPacket.nullToEmpty(packet.fileLocationKey));
        buf.m_130070_(AlertPacket.nullToEmpty(packet.fileName));
        buf.m_130070_(AlertPacket.nullToEmpty(packet.fileContents));
        buf.m_130070_(AlertPacket.nullToEmpty(packet.fileCreator));
        buf.m_130070_(AlertPacket.nullToEmpty(packet.fileDateIso));
    }

    public static AlertPacket decode(FriendlyByteBuf buf) {
        return new AlertPacket(buf.m_130277_(), buf.m_130277_(), buf.m_130277_(), buf.readBoolean(), buf.m_130277_(), buf.m_130277_(), buf.m_130277_(), buf.m_130277_(), buf.readBoolean(), buf.m_130277_(), buf.m_130277_(), buf.m_130277_(), buf.m_130277_(), buf.m_130277_());
    }

    public static void handle(AlertPacket packet, Supplier<NetworkEvent.Context> ctx) {
        Minecraft mc = Minecraft.m_91087_();
        mc.execute(() -> {
            try {
                if (packet.playSound) {
                    AlertPacket.playSoundForClient(packet.soundName);
                }
                if ("customscreen".equalsIgnoreCase(packet.displayType)) {
                    mc.m_91152_((Screen)new AlertScreen(packet.title, packet.message, packet.iconType, mc.f_91080_, packet.primaryButtonLabel, packet.secondaryButtonLabel));
                } else {
                    AlertPacket.showNativeAlert(packet);
                }
            }
            catch (Exception e) {
                System.err.println("Error displaying alert: " + e.getMessage());
                e.printStackTrace();
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static void playSoundForClient(String soundName) {
        String os = System.getProperty("os.name").toLowerCase();
        String safeSound = soundName == null || soundName.isBlank() ? "default" : soundName.toLowerCase();
        try {
            if (os.contains("win")) {
                AlertPacket.playWindowsSound(safeSound);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (os.contains("mac")) {
                AlertPacket.playMacSound(safeSound);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            AlertPacket.playLinuxSound(safeSound);
            return;
        }
        catch (Exception exception) {
            try {
                Toolkit.getDefaultToolkit().beep();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return;
        }
    }

    private static void playWindowsSound(String soundName) {
        String psSound = switch (soundName) {
            case "error", "hand" -> "[System.Media.SystemSounds]::Hand.Play()";
            case "exclamation", "warning" -> "[System.Media.SystemSounds]::Exclamation.Play()";
            case "question" -> "[System.Media.SystemSounds]::Question.Play()";
            case "asterisk", "info" -> "[System.Media.SystemSounds]::Asterisk.Play()";
            default -> "[System.Media.SystemSounds]::Beep.Play()";
        };
        try {
            ProcessBuilder pb = new ProcessBuilder("powershell.exe", "-NoProfile", "-WindowStyle", "Hidden", "-Command", psSound);
            pb.start();
        }
        catch (IOException ignored) {
            try {
                Toolkit.getDefaultToolkit().beep();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void playMacSound(String soundName) throws Exception {
        String tone = switch (soundName) {
            case "error" -> "Basso";
            case "warning" -> "Submarine";
            case "info" -> "Glass";
            case "funk" -> "Funk";
            default -> "Ping";
        };
        new ProcessBuilder("afplay", "/System/Library/Sounds/" + tone + ".aiff").start();
    }

    private static void playLinuxSound(String soundName) throws Exception {
        String event = switch (soundName) {
            case "error" -> "dialog-error";
            case "warning" -> "dialog-warning";
            case "info" -> "dialog-information";
            case "question" -> "dialog-question";
            default -> "bell";
        };
        try {
            new ProcessBuilder("canberra-gtk-play", "-i", event).start();
            return;
        }
        catch (Exception exception) {
            try {
                new ProcessBuilder("paplay", "/usr/share/sounds/freedesktop/stereo/" + event + ".oga").start();
                return;
            }
            catch (Exception exception2) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
        }
    }

    private static void showNativeAlert(AlertPacket packet) {
        new Thread(() -> {
            try {
                String osName = System.getProperty("os.name").toLowerCase();
                if (osName.contains("win")) {
                    if ("notification".equals(packet.displayType)) {
                        AlertPacket.showWindowsNotification(packet);
                    } else {
                        AlertPacket.showWindowsMessageBox(packet);
                    }
                } else if (osName.contains("mac")) {
                    if ("notification".equals(packet.displayType)) {
                        AlertPacket.showMacAlert(packet);
                    } else {
                        AlertPacket.showMacDialog(packet);
                    }
                } else if ("notification".equals(packet.displayType)) {
                    AlertPacket.showLinuxNotification(packet);
                } else {
                    AlertPacket.showLinuxAlert(packet);
                }
            }
            catch (Exception e) {
                System.err.println("Native alert error: " + e.getMessage());
                e.printStackTrace();
                System.out.println("\n" + "=".repeat(50));
                System.out.println("\u26a0\ufe0f  " + packet.title);
                System.out.println(packet.message);
                System.out.println("=".repeat(50) + "\n");
            }
        }, "JavaAlert-Native").start();
    }

    private static void showWindowsNotification(AlertPacket packet) {
        try {
            String iconEmoji = AlertPacket.getEmojiForIcon(packet.iconType);
            File tempScript = File.createTempFile("mc_notif_", ".vbs");
            tempScript.deleteOnExit();
            String psCommand = String.format("$null = [Windows.UI.Notifications.ToastNotificationManager, Windows.UI.Notifications, ContentType = WindowsRuntime]; $null = [Windows.Data.Xml.Dom.XmlDocument, Windows.Data.Xml.Dom.XmlDocument, ContentType = WindowsRuntime]; $xml = New-Object Windows.Data.Xml.Dom.XmlDocument; $toastXml = @'<toast><visual><binding template=\"ToastGeneric\"><text>%s %s</text><text>%s</text></binding></visual><audio src=\"ms-winsoundevent:Notification.Default\"/></toast>'@; $xml.LoadXml($toastXml); $toast = [Windows.UI.Notifications.ToastNotification]::new($xml); $toast.Tag = 'Minecraft'; $notifier = [Windows.UI.Notifications.ToastNotificationManager]::CreateToastNotifier('Minecraft'); $notifier.Show($toast);", iconEmoji, AlertPacket.escapePowerShell(packet.title), AlertPacket.escapePowerShell(packet.message));
            String vbsScript = String.format("Set objShell = CreateObject(\"WScript.Shell\")\nobjShell.Run \"powershell.exe -NoProfile -WindowStyle Hidden -ExecutionPolicy Bypass -Command \"\"%s\"\"\", 0, False", psCommand.replace("\"", "\"\""));
            FileWriter writer = new FileWriter(tempScript);
            writer.write(vbsScript);
            writer.close();
            ProcessBuilder pb = new ProcessBuilder("wscript.exe", "//nologo", tempScript.getAbsolutePath());
            Process process = pb.start();
            new Thread(() -> {
                try {
                    Thread.sleep(3000L);
                    tempScript.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).start();
        }
        catch (Exception e) {
            System.err.println("Windows notification error: " + e.getMessage());
            e.printStackTrace();
            AlertPacket.showWindowsMessageBox(packet);
        }
    }

    public static void showWindowsMessageBox(AlertPacket packet) {
        try {
            boolean isHeadless = GraphicsEnvironment.isHeadless();
            if (isHeadless) {
                AlertPacket.showWindowsMessageBoxVBS(packet);
                return;
            }
            try {
                new Thread(() -> {
                    try {
                        SwingUtilities.invokeAndWait(() -> {
                            try {
                                if (GraphicsEnvironment.isHeadless()) {
                                    AlertPacket.showWindowsMessageBoxVBS(packet);
                                    return;
                                }
                                int messageType = 1;
                                switch (packet.iconType.toLowerCase()) {
                                    case "error": {
                                        messageType = 0;
                                        break;
                                    }
                                    case "warning": {
                                        messageType = 2;
                                        break;
                                    }
                                    case "question": {
                                        messageType = 3;
                                        break;
                                    }
                                    case "info": {
                                        messageType = 1;
                                    }
                                }
                                JOptionPane.showMessageDialog(null, packet.message, packet.title, messageType);
                            }
                            catch (HeadlessException e) {
                                AlertPacket.showWindowsMessageBoxVBS(packet);
                            }
                            catch (Exception e) {
                                System.err.println("Windows MessageBox error: " + e.getMessage());
                                AlertPacket.showWindowsMessageBoxVBS(packet);
                            }
                        });
                    }
                    catch (Exception e) {
                        AlertPacket.showWindowsMessageBoxVBS(packet);
                    }
                }).start();
            }
            catch (HeadlessException e) {
                AlertPacket.showWindowsMessageBoxVBS(packet);
            }
            catch (Exception e) {
                System.err.println("Windows MessageBox error: " + e.getMessage());
                AlertPacket.showWindowsMessageBoxVBS(packet);
            }
        }
        catch (Exception e) {
            System.err.println("Windows MessageBox error: " + e.getMessage());
            AlertPacket.showWindowsMessageBoxVBS(packet);
        }
    }

    private static void showWindowsMessageBoxVBS(AlertPacket packet) {
        try {
            File tempScript = File.createTempFile("mc_msgbox_", ".vbs");
            tempScript.deleteOnExit();
            int iconValue = AlertPacket.getVBSIconValue(packet.iconType);
            String vbsScript = String.format("MsgBox \"%s\", %d, \"%s\"", AlertPacket.escapeVBS(packet.message), iconValue, AlertPacket.escapeVBS(packet.title));
            FileWriter writer = new FileWriter(tempScript);
            writer.write(vbsScript);
            writer.close();
            ProcessBuilder pb = new ProcessBuilder("wscript.exe", "//nologo", tempScript.getAbsolutePath());
            pb.start();
            new Thread(() -> {
                try {
                    Thread.sleep(3000L);
                    tempScript.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).start();
        }
        catch (Exception e) {
            System.err.println("Windows VBS MessageBox error: " + e.getMessage());
        }
    }

    private static void showMacAlert(AlertPacket packet) {
        try {
            String script = String.format("display notification \"%s\" with title \"%s\"", AlertPacket.escapeShell(packet.message), AlertPacket.escapeShell(packet.title));
            ProcessBuilder pb = new ProcessBuilder("osascript", "-e", script);
            pb.start();
        }
        catch (Exception e) {
            System.err.println("macOS notification error: " + e.getMessage());
        }
    }

    public static void showMacDialog(AlertPacket packet) {
        try {
            boolean isHeadless = GraphicsEnvironment.isHeadless();
            if (isHeadless) {
                String script = String.format("display dialog \"%s\" with title \"%s\" buttons {\"OK\"} default button 1", AlertPacket.escapeShell(packet.message), AlertPacket.escapeShell(packet.title));
                new ProcessBuilder("osascript", "-e", script).start();
                return;
            }
            try {
                new Thread(() -> {
                    try {
                        SwingUtilities.invokeAndWait(() -> {
                            try {
                                if (GraphicsEnvironment.isHeadless()) {
                                    String script = String.format("display dialog \"%s\" with title \"%s\" buttons {\"OK\"} default button 1", AlertPacket.escapeShell(packet.message), AlertPacket.escapeShell(packet.title));
                                    new ProcessBuilder("osascript", "-e", script).start();
                                    return;
                                }
                                int messageType = 1;
                                switch (packet.iconType.toLowerCase()) {
                                    case "error": {
                                        messageType = 0;
                                        break;
                                    }
                                    case "warning": {
                                        messageType = 2;
                                        break;
                                    }
                                    case "question": {
                                        messageType = 3;
                                        break;
                                    }
                                    case "info": {
                                        messageType = 1;
                                    }
                                }
                                JOptionPane.showMessageDialog(null, packet.message, packet.title, messageType);
                            }
                            catch (HeadlessException e) {
                                try {
                                    String script = String.format("display dialog \"%s\" with title \"%s\" buttons {\"OK\"} default button 1", AlertPacket.escapeShell(packet.message), AlertPacket.escapeShell(packet.title));
                                    new ProcessBuilder("osascript", "-e", script).start();
                                }
                                catch (Exception ex) {
                                    System.err.println("macOS dialog fallback error: " + ex.getMessage());
                                }
                            }
                            catch (Exception e) {
                                System.err.println("macOS dialog error: " + e.getMessage());
                            }
                        });
                    }
                    catch (Exception e) {
                        try {
                            String script = String.format("display dialog \"%s\" with title \"%s\" buttons {\"OK\"} default button 1", AlertPacket.escapeShell(packet.message), AlertPacket.escapeShell(packet.title));
                            new ProcessBuilder("osascript", "-e", script).start();
                        }
                        catch (Exception ex) {
                            System.err.println("macOS dialog fallback error: " + ex.getMessage());
                        }
                    }
                }).start();
            }
            catch (HeadlessException e) {
                String script = String.format("display dialog \"%s\" with title \"%s\" buttons {\"OK\"} default button 1", AlertPacket.escapeShell(packet.message), AlertPacket.escapeShell(packet.title));
                new ProcessBuilder("osascript", "-e", script).start();
            }
            catch (Exception e) {
                System.err.println("macOS dialog error: " + e.getMessage());
            }
        }
        catch (Exception e) {
            System.err.println("macOS dialog error: " + e.getMessage());
        }
    }

    private static void showLinuxNotification(AlertPacket packet) {
        try {
            String iconType = "dialog-warning";
            switch (packet.iconType.toLowerCase()) {
                case "info": {
                    iconType = "dialog-information";
                    break;
                }
                case "error": {
                    iconType = "dialog-error";
                    break;
                }
                case "question": {
                    iconType = "dialog-question";
                }
            }
            ProcessBuilder pb = new ProcessBuilder("notify-send", "-i", iconType, packet.title, packet.message);
            pb.start();
        }
        catch (Exception e) {
            System.err.println("Linux notification error: " + e.getMessage());
        }
    }

    public static void showLinuxAlert(AlertPacket packet) {
        try {
            String display = System.getenv("DISPLAY");
            boolean isHeadless = GraphicsEnvironment.isHeadless();
            if (isHeadless || display == null || display.isEmpty()) {
                AlertPacket.showLinuxAlertZenity(packet);
                return;
            }
            try {
                new Thread(() -> {
                    try {
                        SwingUtilities.invokeAndWait(() -> {
                            try {
                                if (GraphicsEnvironment.isHeadless()) {
                                    AlertPacket.showLinuxAlertZenity(packet);
                                    return;
                                }
                                int messageType = 1;
                                switch (packet.iconType.toLowerCase()) {
                                    case "error": {
                                        messageType = 0;
                                        break;
                                    }
                                    case "warning": {
                                        messageType = 2;
                                        break;
                                    }
                                    case "question": {
                                        messageType = 3;
                                        break;
                                    }
                                    case "info": {
                                        messageType = 1;
                                    }
                                }
                                JOptionPane.showMessageDialog(null, packet.message, packet.title, messageType);
                            }
                            catch (HeadlessException e) {
                                AlertPacket.showLinuxAlertZenity(packet);
                            }
                            catch (Exception e) {
                                System.err.println("Linux JOptionPane error: " + e.getMessage());
                                AlertPacket.showLinuxAlertZenity(packet);
                            }
                        });
                    }
                    catch (Exception e) {
                        AlertPacket.showLinuxAlertZenity(packet);
                    }
                }).start();
            }
            catch (HeadlessException e) {
                AlertPacket.showLinuxAlertZenity(packet);
            }
            catch (Exception e) {
                AlertPacket.showLinuxAlertZenity(packet);
            }
        }
        catch (Exception e) {
            System.err.println("Linux dialog error: " + e.getMessage());
            AlertPacket.showLinuxAlertZenity(packet);
        }
    }

    private static void showLinuxAlertZenity(AlertPacket packet) {
        try {
            String zenityIcon = "--warning";
            switch (packet.iconType.toLowerCase()) {
                case "info": {
                    zenityIcon = "--info";
                    break;
                }
                case "error": {
                    zenityIcon = "--error";
                    break;
                }
                case "question": {
                    zenityIcon = "--question";
                }
            }
            ProcessBuilder pb = new ProcessBuilder("zenity", zenityIcon, "--title=" + packet.title, "--text=" + packet.message, "--no-wrap");
            pb.start();
        }
        catch (Exception e) {
            try {
                String kdialogType = "msgbox";
                switch (packet.iconType.toLowerCase()) {
                    case "error": {
                        kdialogType = "error";
                        break;
                    }
                    case "warning": {
                        kdialogType = "sorry";
                        break;
                    }
                    case "question": {
                        kdialogType = "yesno";
                    }
                }
                ProcessBuilder pb = new ProcessBuilder("kdialog", "--" + kdialogType, packet.message, "--title", packet.title);
                pb.start();
            }
            catch (Exception ex) {
                System.err.println("Linux dialog fallback error: " + ex.getMessage());
            }
        }
    }

    private static int getVBSIconValue(String iconType) {
        switch (iconType.toLowerCase()) {
            case "info": {
                return 64;
            }
            case "warning": {
                return 48;
            }
            case "error": {
                return 16;
            }
            case "question": {
                return 32;
            }
        }
        return 48;
    }

    private static String getEmojiForIcon(String iconType) {
        switch (iconType.toLowerCase()) {
            case "info": {
                return "\u2139\ufe0f";
            }
            case "warning": {
                return "\u26a0\ufe0f";
            }
            case "error": {
                return "\u274c";
            }
            case "question": {
                return "\u2753";
            }
        }
        return "\u26a0\ufe0f";
    }

    private static String escapeVBS(String str) {
        return str.replace("\"", "\"\"").replace("\n", " ").replace("\r", "");
    }

    private static String escapePowerShell(String str) {
        return str.replace("'", "''").replace("`", "``").replace("$", "`$").replace("\n", " ").replace("\r", "");
    }

    private static String escapeShell(String str) {
        return str.replace("\"", "\\\"").replace("$", "\\$").replace("`", "\\`");
    }

    private static String nullToEmpty(String value) {
        return value == null ? "" : value;
    }
}

