/*
 * Decompiled with CFR 0.152.
 */
package org.ryvione.javalert.registry;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.ryvione.javalert.beacon.AlertTriggerBlock;
import org.ryvione.javalert.beacon.AlertTriggerBlockEntity;
import org.ryvione.javalert.config.Config;

public class ModRegistry {
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"javalert");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"javalert");
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"javalert");
    public static final RegistryObject<Block> ALERT_TRIGGER_BLOCK = BLOCKS.register("alert_trigger_block", () -> new AlertTriggerBlock(BlockBehaviour.Properties.m_284310_().m_60978_(1.5f)));
    public static final RegistryObject<Item> ALERT_TRIGGER_ITEM = ITEMS.register("alert_trigger_block", () -> new BlockItem((Block)ALERT_TRIGGER_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<BlockEntityType<AlertTriggerBlockEntity>> ALERT_TRIGGER_BE = BLOCK_ENTITIES.register("alert_trigger_block_entity", () -> BlockEntityType.Builder.m_155273_(AlertTriggerBlockEntity::new, (Block[])new Block[]{(Block)ALERT_TRIGGER_BLOCK.get()}).m_58966_(null));

    public static void init(IEventBus bus) {
        BLOCKS.register(bus);
        ITEMS.register(bus);
        BLOCK_ENTITIES.register(bus);
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"javalert", (String)path);
    }

    @Mod.EventBusSubscriber(modid="javalert", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class TooltipHandler {
        @SubscribeEvent
        public static void onItemTooltip(ItemTooltipEvent event) {
            ItemStack stack = event.getItemStack();
            if (stack.m_41720_() == ALERT_TRIGGER_ITEM.get()) {
                event.getToolTip().add(Component.m_237113_((String)"\u00a7c\u00a7l\u26a0 VERY EARLY ALPHA - MANY BUGS! \u26a0"));
                event.getToolTip().add(Component.m_237113_((String)"\u00a77Triggers custom alerts when players enter the detection radius."));
                event.getToolTip().add(Component.m_237113_((String)"\u00a77Right-click to configure settings like radius, message, display type, and more."));
                event.getToolTip().add(Component.m_237113_((String)"\u00a7cExpect bugs, crashes, and broken features!"));
            }
        }
    }

    @Mod.EventBusSubscriber(modid="javalert", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class CreativeTabs {
        @SubscribeEvent
        public static void onBuildCreativeTab(BuildCreativeModeTabContentsEvent event) {
            if (event.getTabKey() == CreativeModeTabs.f_256791_ && Config.enableAlertBeacon) {
                event.m_246326_((ItemLike)ALERT_TRIGGER_ITEM.get());
            }
        }
    }
}

