/*
 * Decompiled with CFR 0.152.
 */
package org.ryvione.javalert.screen;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class AlertScreen
extends Screen {
    private final String message;
    private final String alertType;
    private final Screen previousScreen;
    private final String primaryButtonLabel;
    private final String secondaryButtonLabel;
    private static final int COLOR_INFO = 3447003;
    private static final int COLOR_WARNING = 15965202;
    private static final int COLOR_ERROR = 15158332;
    private static final int COLOR_QUESTION = 10181046;
    private static final int COLOR_PLAIN = 9807270;

    public AlertScreen(String title, String message, String alertType, Screen previousScreen, String primaryButtonLabel, String secondaryButtonLabel) {
        super((Component)Component.m_237113_((String)title));
        this.message = message;
        this.alertType = alertType;
        this.previousScreen = previousScreen;
        this.primaryButtonLabel = primaryButtonLabel == null || primaryButtonLabel.isBlank() ? "OK" : primaryButtonLabel;
        this.secondaryButtonLabel = secondaryButtonLabel;
    }

    protected void m_7856_() {
        super.m_7856_();
        int buttonY = this.f_96544_ - 50;
        int buttonWidth = 100;
        int buttonSpacing = 10;
        if (this.secondaryButtonLabel != null && !this.secondaryButtonLabel.isBlank()) {
            int totalWidth = buttonWidth * 2 + buttonSpacing;
            int startX = (this.f_96543_ - totalWidth) / 2;
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)this.secondaryButtonLabel), button -> this.m_7379_()).m_252987_(startX, buttonY, buttonWidth, 20).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)this.primaryButtonLabel), button -> this.m_7379_()).m_252987_(startX + buttonWidth + buttonSpacing, buttonY, buttonWidth, 20).m_253136_());
        } else {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)this.primaryButtonLabel), button -> this.m_7379_()).m_252987_(this.f_96543_ / 2 - buttonWidth / 2, buttonY, buttonWidth, 20).m_253136_());
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, -872415232);
        int color = this.getColorForType();
        int boxWidth = Math.min(400, this.f_96543_ - 40);
        int boxHeight = 160;
        int boxX = (this.f_96543_ - boxWidth) / 2;
        int boxY = (this.f_96544_ - boxHeight) / 2;
        graphics.m_280509_(boxX, boxY, boxX + boxWidth, boxY + boxHeight, -13877680);
        graphics.m_280509_(boxX, boxY, boxX + boxWidth, boxY + 5, color | 0xFF000000);
        graphics.m_280509_(boxX, boxY, boxX + boxWidth, boxY + 2, -16777216);
        graphics.m_280509_(boxX, boxY + boxHeight - 2, boxX + boxWidth, boxY + boxHeight, -16777216);
        graphics.m_280509_(boxX, boxY, boxX + 2, boxY + boxHeight, -16777216);
        graphics.m_280509_(boxX + boxWidth - 2, boxY, boxX + boxWidth, boxY + boxHeight, -16777216);
        String icon = this.getIconForType();
        String titleWithIcon = icon + " " + this.f_96539_.getString();
        graphics.m_280137_(this.f_96547_, titleWithIcon, this.f_96543_ / 2, boxY + 15, -1);
        int messageY = boxY + 40;
        int maxWidth = boxWidth - 20;
        String[] words = this.message.split(" ");
        StringBuilder currentLine = new StringBuilder();
        int lineCount = 0;
        for (String word : words) {
            String testLine;
            String string = testLine = currentLine.length() == 0 ? word : String.valueOf(currentLine) + " " + word;
            if (this.f_96547_.m_92895_(testLine) <= maxWidth) {
                currentLine = new StringBuilder(testLine);
                continue;
            }
            graphics.m_280137_(this.f_96547_, currentLine.toString(), this.f_96543_ / 2, messageY + lineCount * 12, -1249039);
            currentLine = new StringBuilder(word);
            if (++lineCount >= 6) break;
        }
        if (currentLine.length() > 0) {
            graphics.m_280137_(this.f_96547_, currentLine.toString(), this.f_96543_ / 2, messageY + lineCount * 12, -1249039);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.previousScreen);
        }
    }

    public boolean m_7043_() {
        return true;
    }

    public boolean m_6913_() {
        return true;
    }

    private int getColorForType() {
        switch (this.alertType.toLowerCase()) {
            case "info": {
                return 3447003;
            }
            case "warning": {
                return 15965202;
            }
            case "error": {
                return 15158332;
            }
            case "question": {
                return 10181046;
            }
            case "plain": {
                return 9807270;
            }
        }
        return 15965202;
    }

    private String getIconForType() {
        switch (this.alertType.toLowerCase()) {
            case "info": {
                return "\u2139";
            }
            case "warning": {
                return "\u26a0";
            }
            case "error": {
                return "\u274c";
            }
            case "question": {
                return "\u2753";
            }
            case "plain": {
                return "\ud83d\udccb";
            }
        }
        return "\u26a0";
    }
}

