/*
 * Decompiled with CFR 0.152.
 */
package org.ryvione.javalert.screen;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fml.loading.FMLPaths;
import org.ryvione.javalert.config.Config;
import org.ryvione.javalert.util.ConsentManager;

public class JavAlertConfigScreen
extends Screen {
    private final Screen back;
    private Button experimentalButton;
    private Button alphaButton;
    private Button alertBeaconButton;

    public JavAlertConfigScreen(Screen back) {
        super((Component)Component.m_237113_((String)"JavAlert Config"));
        this.back = back;
    }

    protected void m_7856_() {
        int centerX = this.f_96543_ / 2;
        int startY = this.f_96544_ / 2 - 60;
        int buttonWidth = 200;
        int buttonHeight = 20;
        int spacing = 25;
        this.experimentalButton = Button.m_253074_((Component)Component.m_237113_((String)("Experimental Features: " + (Config.enableExperimental ? "ON" : "OFF"))), btn -> {
            Config.setEnableExperimental(!Config.enableExperimental);
            this.updateButtons();
        }).m_252987_(centerX - buttonWidth / 2, startY, buttonWidth, buttonHeight).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Enable experimental features that may be unstable"))).m_253136_();
        this.m_142416_((GuiEventListener)this.experimentalButton);
        this.alphaButton = Button.m_253074_((Component)Component.m_237113_((String)("ALPHA Features: " + (Config.enableAlpha ? "ON" : "OFF"))), btn -> {
            Config.setEnableAlpha(!Config.enableAlpha);
            this.updateButtons();
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing, buttonWidth, buttonHeight).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Enable ALPHA features (highly experimental, use at your own risk)"))).m_253136_();
        this.m_142416_((GuiEventListener)this.alphaButton);
        this.alertBeaconButton = Button.m_253074_((Component)Component.m_237113_((String)("Alert Beacon: " + (Config.enableAlertBeacon ? "ON" : "OFF"))), btn -> {
            Config.setEnableAlertBeacon(!Config.enableAlertBeacon);
            this.updateButtons();
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 2, buttonWidth, buttonHeight).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"\u00a7c\u26a0 VERY EARLY ALPHA - MANY BUGS! \u26a0\n\u00a77Enable Alert Beacon block\n\u00a77(ALPHA feature - requires ALPHA features to be enabled)\n\u00a7cUse at your own risk - expect bugs!"))).m_253136_();
        this.m_142416_((GuiEventListener)this.alertBeaconButton);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Save and Close"), btn -> {
            Config.save();
            this.m_7379_();
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 4, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), btn -> this.m_7379_()).m_252987_(centerX - buttonWidth / 2, startY + spacing * 5, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u00a7cReset Mod (All Settings)"), btn -> {
            Config.setEnableExperimental(false);
            Config.setEnableAlpha(false);
            Config.setEnableAlertBeacon(false);
            Config.save();
            try {
                Path configDir = FMLPaths.CONFIGDIR.get();
                Path configFile = configDir.resolve("javalert-client.toml");
                if (Files.exists(configFile, new LinkOption[0])) {
                    Files.delete(configFile);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ConsentManager.resetAll();
            if (this.f_96541_ != null) {
                if (this.f_96541_.f_91074_ != null) {
                    this.f_96541_.f_91074_.m_5661_((Component)Component.m_237113_((String)"\u00a7a[JavAlert] Mod reset! Restart Minecraft to see disclaimer again."), false);
                } else {
                    this.f_96541_.m_91152_(null);
                }
            }
            this.updateButtons();
        }).m_252987_(centerX - buttonWidth / 2, startY + spacing * 6, buttonWidth, buttonHeight).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"\u00a7cWARNING: This will reset ALL mod settings!\n\u00a77- Config toggles\n\u00a77- Config file (javalert-client.toml)\n\u00a77- Consent settings\n\u00a77- Disclaimer status\n\u00a77You'll need to restart Minecraft."))).m_253136_());
        this.updateButtons();
    }

    private void updateButtons() {
        this.experimentalButton.m_93666_((Component)Component.m_237113_((String)("Experimental Features: " + (Config.enableExperimental ? "ON" : "OFF"))));
        this.alphaButton.m_93666_((Component)Component.m_237113_((String)("ALPHA Features: " + (Config.enableAlpha ? "ON" : "OFF"))));
        this.alertBeaconButton.m_93666_((Component)Component.m_237113_((String)("Alert Beacon: " + (Config.enableAlertBeacon ? "ON" : "OFF"))));
        this.alertBeaconButton.f_93623_ = Config.enableAlpha;
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(g);
        g.m_280137_(this.f_96547_, "JavAlert Configuration", this.f_96543_ / 2, 40, 0xFFFFFF);
        g.m_280137_(this.f_96547_, "\u00a7c\u26a0 WARNING: ALPHA features are VERY EARLY ALPHA \u26a0", this.f_96543_ / 2, 60, 0xFF5555);
        g.m_280137_(this.f_96547_, "\u00a7cThere are MANY BUGS - Use at your own risk!", this.f_96543_ / 2, 72, 0xFF5555);
        g.m_280137_(this.f_96547_, "\u00a77Alert Beacon is in VERY EARLY development", this.f_96543_ / 2, 84, 0xAAAAAA);
        super.m_88315_(g, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.back);
        }
    }
}

