/*
 * Decompiled with CFR 0.152.
 */
package org.ryvione.javalert.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraftforge.fml.loading.FMLPaths;

public class ConsentManager {
    private static boolean loaded = false;
    private static boolean allowed = false;
    private static boolean disclaimerShown = false;

    private static Path consentFile() {
        return FMLPaths.CONFIGDIR.get().resolve("javalert_consent.txt");
    }

    private static Path disclaimerFile() {
        return FMLPaths.CONFIGDIR.get().resolve("javalert_disclaimer.txt");
    }

    public static boolean isAllowed() {
        ConsentManager.ensureLoaded();
        return allowed;
    }

    public static boolean hasSeenDisclaimer() {
        ConsentManager.ensureLoaded();
        return disclaimerShown;
    }

    public static void allow() {
        allowed = true;
        ConsentManager.persist(true);
    }

    public static void deny() {
        allowed = false;
        ConsentManager.persist(false);
    }

    public static void setDisclaimerShown() {
        disclaimerShown = true;
        try {
            Files.writeString(ConsentManager.disclaimerFile(), (CharSequence)"shown", new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void ensureLoaded() {
        if (loaded) {
            return;
        }
        loaded = true;
        try {
            Path disPath;
            Path path = ConsentManager.consentFile();
            if (Files.exists(path, new LinkOption[0])) {
                String v = Files.readString(path).trim();
                allowed = "allow".equalsIgnoreCase(v);
            }
            if (Files.exists(disPath = ConsentManager.disclaimerFile(), new LinkOption[0])) {
                disclaimerShown = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void persist(boolean value) {
        try {
            Files.writeString(ConsentManager.consentFile(), (CharSequence)(value ? "allow" : "deny"), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void resetAll() {
        allowed = false;
        disclaimerShown = false;
        loaded = false;
        try {
            Path disclaimerPath;
            Path consentPath = ConsentManager.consentFile();
            if (Files.exists(consentPath, new LinkOption[0])) {
                Files.delete(consentPath);
            }
            if (Files.exists(disclaimerPath = ConsentManager.disclaimerFile(), new LinkOption[0])) {
                Files.delete(disclaimerPath);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

