/*
 * Decompiled with CFR 0.152.
 */
package org.ryvione.javalert.util;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class DirectoryDetector {
    private static final String[] DESKTOP_NAMES = new String[]{"Desktop", "Bureau", "Escritorio", "Schreibtisch", "\u0420\u0430\u0431\u043e\u0447\u0438\u0439 \u0441\u0442\u043e\u043b", "\u30c7\u30b9\u30af\u30c8\u30c3\u30d7", "\u684c\u9762"};
    private static final String[] DOCUMENTS_NAMES = new String[]{"Documents", "Documents", "Documentos", "Dokumente", "\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b", "\u30c9\u30ad\u30e5\u30e1\u30f3\u30c8", "\u6587\u6863", "\u6587\u66f8"};
    private static final String[] DOWNLOADS_NAMES = new String[]{"Downloads", "T\u00e9l\u00e9chargements", "Descargas", "Downloads", "\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0438", "\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9", "\u4e0b\u8f7d", "\u4e0b\u8f09"};

    public static List<DetectedLocation> detectAvailableLocations() {
        Path downloads;
        Path documents;
        ArrayList<DetectedLocation> locations = new ArrayList<DetectedLocation>();
        String home = System.getProperty("user.home");
        if (home == null) {
            return locations;
        }
        Path homePath = Paths.get(home, new String[0]);
        if (!Files.exists(homePath, new LinkOption[0])) {
            return locations;
        }
        Path desktop = DirectoryDetector.detectDirectory(homePath, DESKTOP_NAMES);
        if (desktop != null && Files.exists(desktop, new LinkOption[0])) {
            locations.add(new DetectedLocation("desktop", desktop, desktop.getFileName().toString()));
        }
        if ((documents = DirectoryDetector.detectDirectory(homePath, DOCUMENTS_NAMES)) != null && Files.exists(documents, new LinkOption[0])) {
            locations.add(new DetectedLocation("documents", documents, documents.getFileName().toString()));
        }
        if ((downloads = DirectoryDetector.detectDirectory(homePath, DOWNLOADS_NAMES)) != null && Files.exists(downloads, new LinkOption[0])) {
            locations.add(new DetectedLocation("downloads", downloads, downloads.getFileName().toString()));
        }
        if (locations.isEmpty()) {
            locations.add(new DetectedLocation("home", homePath, homePath.getFileName() == null ? "home" : homePath.getFileName().toString()));
        }
        return locations;
    }

    private static Path detectDirectory(Path home, String[] names) {
        Path xdg = home.resolve(".config/user-dirs.dirs");
        if (Files.exists(xdg, new LinkOption[0])) {
            try {
                List<String> lines = Files.readAllLines(xdg);
                Iterator iterator = lines.iterator();
                while (iterator.hasNext()) {
                    Path p;
                    String line = (String)iterator.next();
                    if ((line = line.trim()).startsWith("XDG_DESKTOP_DIR") && DirectoryDetector.matches(names, "desktop") && (p = DirectoryDetector.parseXdgPath(line, home)) != null) {
                        return p;
                    }
                    if (line.startsWith("XDG_DOCUMENTS_DIR") && DirectoryDetector.matches(names, "documents") && (p = DirectoryDetector.parseXdgPath(line, home)) != null) {
                        return p;
                    }
                    if (!line.startsWith("XDG_DOWNLOAD_DIR") || !DirectoryDetector.matches(names, "downloads") || (p = DirectoryDetector.parseXdgPath(line, home)) == null) continue;
                    return p;
                }
            }
            catch (Exception lines) {
                // empty catch block
            }
        }
        for (String name : names) {
            Path candidate = home.resolve(name);
            if (!Files.exists(candidate, new LinkOption[0]) || !Files.isDirectory(candidate, new LinkOption[0])) continue;
            return candidate;
        }
        try {
            File[] files = home.toFile().listFiles();
            if (files != null) {
                for (File f : files) {
                    if (!f.isDirectory()) continue;
                    String dirName = f.getName().toLowerCase(Locale.ROOT);
                    for (String name : names) {
                        if (!dirName.equals(name.toLowerCase(Locale.ROOT))) continue;
                        return f.toPath();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static boolean matches(String[] names, String key) {
        for (String n : names) {
            if (!n.equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    private static Path parseXdgPath(String line, Path home) {
        try {
            int eq = line.indexOf(61);
            if (eq == -1) {
                return null;
            }
            String val = line.substring(eq + 1).trim().replace("\"", "");
            Path p = Paths.get(val = val.replace("$HOME", home.toString()), new String[0]);
            if (Files.exists(p, new LinkOption[0]) && Files.isDirectory(p, new LinkOption[0])) {
                return p;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Path resolveLocation(String key) {
        String home = System.getProperty("user.home");
        if (home == null) {
            return null;
        }
        Path homePath = Paths.get(home, new String[0]);
        List<DetectedLocation> detected = DirectoryDetector.detectAvailableLocations();
        for (DetectedLocation loc : detected) {
            if (!loc.key.equalsIgnoreCase(key)) continue;
            return loc.path;
        }
        return switch (key.toLowerCase(Locale.ROOT)) {
            case "desktop" -> homePath.resolve("Desktop");
            case "documents" -> homePath.resolve("Documents");
            case "downloads" -> homePath.resolve("Downloads");
            default -> null;
        };
    }

    public static class DetectedLocation {
        public final String key;
        public final Path path;
        public final String displayName;

        public DetectedLocation(String key, Path path, String displayName) {
            this.key = key;
            this.path = path;
            this.displayName = displayName;
        }
    }
}

