/*
 * Decompiled with CFR 0.152.
 */
package games.polarbearbytes.slimenomore.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_4284;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;

public class SlimeChunksState
extends class_18 {
    public static String ID = "slime_no_more_state";
    private HashMap<class_1923, Boolean> slimeChunkStates = new HashMap();
    public static final Codec<class_1923> CHUNK_POS_CODEC = Codec.STRING.xmap(str -> {
        String[] parts = str.split(",", 2);
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid ChunkPos: " + str);
        }
        return new class_1923(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
    }, chunkPos -> chunkPos.field_9181 + "," + chunkPos.field_9180);
    public static final Codec<SlimeChunksState> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap(CHUNK_POS_CODEC, (Codec)Codec.BOOL).fieldOf("chunkstates").forGetter(SlimeChunksState::getRawMap)).apply((Applicative)instance, SlimeChunksState::new));
    public static final class_18.class_8645<SlimeChunksState> TYPE = new class_18.class_8645(SlimeChunksState::new, SlimeChunksState::create, class_4284.field_19213);

    private static SlimeChunksState create(class_2487 nbtCompound, class_7225.class_7874 wrapperLookup) {
        return (SlimeChunksState)((Object)CODEC.parse((DynamicOps)class_2509.field_11560, (Object)nbtCompound).getOrThrow());
    }

    public SlimeChunksState() {
    }

    public class_2487 method_75(class_2487 nbt, class_7225.class_7874 registryLookup) {
        DataResult result = CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this);
        return (class_2487)result.getOrThrow(error -> {
            throw new RuntimeException("Failed to encode: " + error);
        });
    }

    public SlimeChunksState(Map<class_1923, Boolean> slimeChunkStates) {
        this.slimeChunkStates = new HashMap();
        this.slimeChunkStates.putAll(slimeChunkStates);
    }

    public static SlimeChunksState get(MinecraftServer server) {
        return (SlimeChunksState)server.method_30002().method_17983().method_17924(TYPE, ID);
    }

    private Map<class_1923, Boolean> getRawMap() {
        return this.slimeChunkStates;
    }

    public Boolean toggleChunkState(class_1923 chunkPosition) {
        Boolean result = this.slimeChunkStates.compute(chunkPosition, (position, enabled) -> {
            if (enabled == null) {
                return false;
            }
            return null;
        });
        this.method_80();
        return result;
    }

    public boolean getChunkState(class_1923 chunkPosition) {
        return this.slimeChunkStates.getOrDefault(chunkPosition, true);
    }
}

