/*
 * Decompiled with CFR 0.152.
 */
package games.polarbearbytes.slimenomore.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_4284;
import net.minecraft.server.MinecraftServer;

public class SlimeChunksState
extends class_18 {
    private HashMap<class_1923, Boolean> slimeChunkStates = new HashMap();
    public static final Codec<class_1923> CHUNK_POS_CODEC = Codec.STRING.xmap(str -> {
        String[] parts = str.split(",", 2);
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid ChunkPos: " + str);
        }
        return new class_1923(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
    }, chunkPos -> chunkPos.field_9181 + "," + chunkPos.field_9180);
    public static final Codec<SlimeChunksState> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap(CHUNK_POS_CODEC, (Codec)Codec.BOOL).fieldOf("chunkstates").forGetter(SlimeChunksState::getRawMap)).apply((Applicative)instance, SlimeChunksState::new));
    public static final class_10741<SlimeChunksState> TYPE = new class_10741("slime_no_more_state", SlimeChunksState::new, CODEC, class_4284.field_19213);

    public SlimeChunksState() {
    }

    public SlimeChunksState(Map<class_1923, Boolean> slimeChunkStates) {
        this.slimeChunkStates = new HashMap();
        this.slimeChunkStates.putAll(slimeChunkStates);
    }

    public static SlimeChunksState get(MinecraftServer server) {
        return (SlimeChunksState)server.method_30002().method_17983().method_17924(TYPE);
    }

    private Map<class_1923, Boolean> getRawMap() {
        return this.slimeChunkStates;
    }

    public Boolean toggleChunkState(class_1923 chunkPosition) {
        Boolean result = this.slimeChunkStates.compute(chunkPosition, (position, enabled) -> {
            if (enabled == null) {
                return false;
            }
            return null;
        });
        this.method_80();
        return result;
    }

    public boolean getChunkState(class_1923 chunkPosition) {
        return this.slimeChunkStates.getOrDefault(chunkPosition, true);
    }

    public List<class_1923> getList() {
        ArrayList<class_1923> list = new ArrayList<class_1923>();
        for (Map.Entry<class_1923, Boolean> entry : this.slimeChunkStates.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            list.add(entry.getKey());
        }
        return list;
    }
}

