/*
 * Decompiled with CFR 0.152.
 */
package games.polarbearbytes.slimenomore.render;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.vertex.VertexFormat;
import games.polarbearbytes.slimenomore.SlimeNoMore;
import games.polarbearbytes.slimenomore.SlimeNoMoreClient;
import games.polarbearbytes.slimenomore.config.SlimeNoMoreClientConfig;
import games.polarbearbytes.slimenomore.render.IRenderer;
import games.polarbearbytes.slimenomore.render.RenderContext;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_10799;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4599;
import net.minecraft.class_4604;
import net.minecraft.class_7833;
import net.minecraft.class_9801;
import net.minecraft.class_9909;
import net.minecraft.class_9960;
import net.minecraft.class_9974;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class DisabledSlimeChunkRenderer
implements IRenderer {
    @Nullable
    protected class_2338 lastPosition;
    protected class_243 lastCamera;
    private final RenderContext boxRenderContext;
    private final RenderContext billboardRenderContext;
    private final Color color;
    private final List<class_1923> disabledChunks = new ArrayList<class_1923>();
    private boolean needsUpdated;
    public static final class_2960 BILLBOARD_TEXTURE = class_2960.method_60655((String)"slime-no-more", (String)"noslime.png");
    private class_1044 billboardTexture;
    public static final RenderPipeline boxPipeline = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_60125}).withVertexShader("core/position_color").withFragmentShader("core/position_color").withBlend(BlendFunction.TRANSLUCENT).withVertexFormat(class_290.field_1576, VertexFormat.class_5596.field_27380).withLocation(class_2960.method_60655((String)"slime-no-more", (String)"pipeline")).withDepthBias(-3.0f, -3.0f).withCull(false).withDepthWrite(false).withColorWrite(true).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).build();
    public static final RenderPipeline billboardPipeline = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56864}).withVertexShader("core/position_tex_color").withFragmentShader("core/position_tex_color").withBlend(BlendFunction.TRANSLUCENT).withVertexFormat(class_290.field_1575, VertexFormat.class_5596.field_27382).withSampler("Sampler0").withLocation(class_2960.method_60655((String)"slime-no-more", (String)"pipeline")).withCull(false).withDepthWrite(true).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).build();
    public static final DisabledSlimeChunkRenderer INSTANCE = new DisabledSlimeChunkRenderer(new ArrayList<class_1923>(), new Color(200, 0, 0, 128));

    private DisabledSlimeChunkRenderer(List<class_1923> disabledChunks, Color color) {
        assert (class_310.method_1551().field_1687 != null);
        this.color = color;
        this.boxRenderContext = new RenderContext(() -> "slime-no-more/DisabledChunks_TriangleStrip", boxPipeline);
        this.billboardRenderContext = new RenderContext(() -> "slime-no-more/DisabledChunks_Billboards", billboardPipeline);
        this.setDisabledChunks(disabledChunks);
    }

    public void setDisabledChunks(List<class_1923> disabledChunks) {
        this.disabledChunks.clear();
        this.disabledChunks.addAll(disabledChunks);
        this.needsUpdated = true;
    }

    @Override
    public void render(class_276 framebuffer, Matrix4f positionMatrix, Matrix4f projectionMatrix, class_310 client, class_9909 frameGraphBuilder, class_9960 fbSet, class_4604 frustum, class_4184 camera, class_4599 buffers, class_3695 profiler) {
        class_1297 cameraEntity = client.method_1560();
        if (cameraEntity == null || client.field_1724 == null) {
            return;
        }
        this.update(camera.method_19326(), cameraEntity, client);
        this.draw(camera.method_19326(), client);
    }

    public void update(class_243 cameraPos, class_1297 entity, class_310 client) {
        if (!this.shouldRender() || !this.shouldUpdate(entity)) {
            return;
        }
        this.lastPosition = class_2338.method_49637((double)Math.floor(entity.method_23317()), (double)Math.floor(entity.method_23318()), (double)Math.floor(entity.method_23321()));
        this.build(cameraPos, client);
        class_1060 textureManager = class_310.method_1551().method_1531();
        this.billboardTexture = textureManager.method_4619(BILLBOARD_TEXTURE);
        this.billboardTexture.method_70950(true);
        this.lastCamera = cameraPos;
    }

    public void draw(class_243 cameraPos, class_310 client) throws RuntimeException {
        SlimeNoMoreClientConfig config = (SlimeNoMoreClientConfig)AutoConfig.getConfigHolder(SlimeNoMoreClientConfig.class).getConfig();
        if (config.renderBox && this.boxRenderContext.isStarted() && this.boxRenderContext.isUploaded()) {
            this.boxRenderContext.draw(null, client, null);
        }
        if (config.renderBillboard && this.billboardRenderContext.isStarted() && this.billboardRenderContext.isUploaded()) {
            this.billboardRenderContext.draw(null, client, this.billboardTexture.method_71659());
        }
    }

    public boolean shouldRender() {
        return SlimeNoMoreClient.renderDisabledDisplay;
    }

    public boolean shouldUpdate(class_1297 entity) {
        if (this.needsUpdated || this.lastPosition == null) {
            return true;
        }
        int ex = (int)Math.floor(entity.method_23317());
        int ez = (int)Math.floor(entity.method_23321());
        int lx = this.lastPosition.method_10263();
        int lz = this.lastPosition.method_10260();
        return Math.abs(lx - ex) > 16 || Math.abs(lz - ez) > 16;
    }

    public void build(class_243 cameraPos, class_310 client) {
        class_287 boxBuilder = this.boxRenderContext.init();
        class_287 billboardBuilder = this.billboardRenderContext.init();
        class_4587 matrices = new class_4587();
        matrices.method_22903();
        for (class_1923 chunkPos : this.disabledChunks) {
            this.buildBox(chunkPos, cameraPos, boxBuilder, client);
            this.buildBillboard(chunkPos, cameraPos, billboardBuilder, client);
        }
        try {
            class_9801 billboardMeshData;
            class_9801 boxMeshData = boxBuilder.method_60794();
            if (boxMeshData != null) {
                this.boxRenderContext.upload(boxMeshData);
                boxMeshData.close();
            }
            if ((billboardMeshData = billboardBuilder.method_60794()) != null) {
                this.billboardRenderContext.upload(billboardMeshData);
                billboardMeshData.close();
            }
        }
        catch (Exception e) {
            SlimeNoMore.LOGGER.error("DisabledSlimeChunkRenderer#build Exception: {}", (Object)e.getMessage());
        }
        matrices.method_22909();
    }

    private void buildBox(class_1923 chunkPos, class_243 cameraPos, class_287 builder, class_310 client) {
        assert (client != null && client.field_1687 != null);
        float minX = chunkPos.field_9181 << 4;
        float minZ = chunkPos.field_9180 << 4;
        float maxX = minX + 16.0f;
        float maxZ = minZ + 16.0f;
        float minY = client.field_1687.method_31607();
        float maxY = client.field_1687.method_31600();
        float x1 = (float)((double)minX - cameraPos.field_1352);
        float y1 = (float)((double)minY - cameraPos.field_1351);
        float z1 = (float)((double)minZ - cameraPos.field_1350);
        float x2 = (float)((double)maxX - cameraPos.field_1352);
        float y2 = (float)((double)maxY - cameraPos.field_1351);
        float z2 = (float)((double)maxZ - cameraPos.field_1350);
        class_9974.method_62294((class_4587)new class_4587(), (class_4588)builder, (float)x1, (float)y1, (float)z1, (float)x2, (float)y2, (float)z2, (float)((float)this.color.getRed() / 255.0f), (float)((float)this.color.getGreen() / 255.0f), (float)((float)this.color.getBlue() / 255.0f), (float)((float)this.color.getAlpha() / 255.0f));
    }

    private void buildBillboard(class_1923 chunkPos, class_243 cameraPos, class_287 builder, class_310 client) {
        assert (client != null && client.field_1687 != null && client.field_1724 != null);
        float minX = chunkPos.field_9181 << 4;
        float minZ = chunkPos.field_9180 << 4;
        float maxX = minX + 16.0f;
        float maxZ = minZ + 16.0f;
        class_4587 billboardMatrices = new class_4587();
        billboardMatrices.method_22904((double)(minX + maxX) / 2.0 - cameraPos.field_1352, client.field_1724.method_23318() + 1.0 - cameraPos.field_1351, (double)(minZ + maxZ) / 2.0 - cameraPos.field_1350);
        float yaw = client.field_1724.method_36454();
        billboardMatrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(-yaw));
        Matrix4f billboardMatrix = billboardMatrices.method_23760().method_23761();
        builder.method_22918(billboardMatrix, -2.0f, 2.0f, 0.0f).method_1336(255, 255, 255, 128).method_22913(0.0f, 0.0f);
        builder.method_22918(billboardMatrix, -2.0f, -2.0f, 0.0f).method_1336(255, 255, 255, 128).method_22913(0.0f, 1.0f);
        builder.method_22918(billboardMatrix, 2.0f, -2.0f, 0.0f).method_1336(255, 255, 255, 128).method_22913(1.0f, 1.0f);
        builder.method_22918(billboardMatrix, 2.0f, 2.0f, 0.0f).method_1336(255, 255, 255, 128).method_22913(1.0f, 0.0f);
    }
}

