/*
 * Decompiled with CFR 0.152.
 */
package games.polarbearbytes.slimenomore.render;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import games.polarbearbytes.slimenomore.SlimeNoMore;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.Supplier;
import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11219;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

@Environment(value=EnvType.CLIENT)
public class RenderContext {
    protected Supplier<String> id;
    protected final RenderPipeline renderPipeline;
    protected class_9799 bufferAllocator;
    protected class_287 bufferBuilder;
    protected GpuBuffer vertexBuffer;
    protected GpuBuffer indexBuffer;
    protected RenderSystem.class_5590 shapeIndexBuffer;
    protected VertexFormat.class_5596 drawMode;
    protected VertexFormat vertexFormat;
    protected int indexCount;
    protected VertexFormat.class_5595 indexType;
    protected boolean started;
    protected boolean uploaded;

    public RenderContext(Supplier<String> id, RenderPipeline renderPipeline) {
        this.id = id;
        SlimeNoMore.LOGGER.warn("RenderPipeline for {}, is NULL? {}", (Object)id.get(), (Object)(renderPipeline == null ? 1 : 0));
        this.renderPipeline = renderPipeline;
        this.started = false;
        this.uploaded = false;
    }

    public class_287 init() {
        this.reset();
        this.drawMode = this.renderPipeline.getVertexFormatMode();
        this.vertexFormat = this.renderPipeline.getVertexFormat();
        this.bufferAllocator = new class_9799(this.vertexFormat.getVertexSize() * 4);
        this.bufferBuilder = new class_287(this.bufferAllocator, this.drawMode, this.vertexFormat);
        this.shapeIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)this.drawMode);
        this.vertexBuffer = null;
        this.indexBuffer = null;
        this.indexCount = -1;
        this.started = true;
        this.uploaded = false;
        return this.bufferBuilder;
    }

    public void upload(class_9801 meshData) {
        if (!RenderSystem.isOnRenderThread() || meshData == null) {
            return;
        }
        int meshDataSize = meshData.method_60818().remaining();
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
        }
        if (this.indexBuffer != null) {
            this.indexBuffer.close();
            this.indexBuffer = null;
        }
        if (this.vertexBuffer == null || this.vertexBuffer.size() < meshDataSize) {
            this.vertexBuffer = RenderSystem.getDevice().createBuffer(() -> String.valueOf(this.id) + "/VertexBuffer", 40, meshDataSize);
        }
        CommandEncoder commandEncoder = RenderSystem.getDevice().createCommandEncoder();
        if (this.vertexBuffer.isClosed()) {
            throw new RuntimeException("Copying Vertex Data to Buffer When Buffer is Closed");
        }
        commandEncoder.writeToBuffer(this.vertexBuffer.slice(), meshData.method_60818());
        this.indexCount = meshData.method_60822().comp_751();
        this.indexType = meshData.method_60822().comp_753();
        this.uploaded = true;
    }

    protected void draw(class_276 framebuffer, class_310 client, GpuTextureView glTextureView) {
        if (!RenderSystem.isOnRenderThread()) {
            return;
        }
        GpuDevice device = RenderSystem.getDevice();
        if (device == null) {
            SlimeNoMore.LOGGER.error("RenderSystem did not return a valid device!");
            return;
        }
        class_276 fb = framebuffer == null ? client.method_1522() : framebuffer;
        GpuTextureView texture1 = fb.method_71639();
        GpuTextureView texture2 = fb.field_1478 ? fb.method_71640() : null;
        GpuBuffer indexBuffer = this.shapeIndexBuffer.method_68274(this.indexCount);
        Vector4f colorMod = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
        Vector3f modelOffset = new Vector3f();
        Matrix4f texMatrix = new Matrix4f();
        GpuBufferSlice bufferSlice = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)colorMod, (Vector3fc)modelOffset, (Matrix4fc)texMatrix, 0.0f);
        try (RenderPass pass = device.createCommandEncoder().createRenderPass(this.id, texture1, OptionalInt.empty(), texture2, OptionalDouble.empty());){
            pass.setPipeline(this.renderPipeline);
            class_11219 scissorState = RenderSystem.getScissorStateForRenderTypeDraws();
            if (scissorState.method_72091()) {
                pass.enableScissor(scissorState.method_72092(), scissorState.method_72093(), scissorState.method_72094(), scissorState.method_72095());
            }
            RenderSystem.bindDefaultUniforms((RenderPass)pass);
            pass.setUniform("DynamicTransforms", bufferSlice);
            if (this.indexBuffer == null) {
                pass.setIndexBuffer(indexBuffer, this.shapeIndexBuffer.method_31924());
            } else {
                pass.setIndexBuffer(this.indexBuffer, this.indexType);
            }
            pass.setVertexBuffer(0, this.vertexBuffer);
            if (glTextureView != null) {
                pass.bindSampler("Sampler0", glTextureView);
            }
            pass.drawIndexed(0, 0, this.indexCount, 1);
        }
    }

    public void reset() {
        if (this.bufferAllocator != null) {
            this.bufferAllocator.close();
            this.bufferAllocator = null;
        }
        if (this.bufferBuilder != null) {
            try {
                class_9801 built = this.bufferBuilder.method_60794();
                if (built != null) {
                    built.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.bufferBuilder = null;
        }
        if (this.shapeIndexBuffer != null) {
            this.shapeIndexBuffer = null;
        }
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
            this.vertexBuffer = null;
        }
        if (this.indexBuffer != null) {
            this.indexBuffer.close();
            this.indexBuffer = null;
        }
    }

    @Generated
    public boolean isStarted() {
        return this.started;
    }

    @Generated
    public boolean isUploaded() {
        return this.uploaded;
    }
}

