/*
 * Decompiled with CFR 0.152.
 */
package net.MCApolloNetwork.ApolloCrux.Bridge.Inventory;

import java.util.ArrayList;
import net.MCApolloNetwork.ApolloCrux.Bridge.Inventory.ContainerCustomChest;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.BridgeUtils;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.ExtendedPlayer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class GlobalChestInventory
extends InventoryBasic {
    public static int INV_SIZE = 27;
    EntityPlayer player = null;
    int tab = -1;
    public static final String nbtTag = "globalChest";
    public static final String inventoryTag = "tab";
    static boolean debug = false;

    public GlobalChestInventory(EntityPlayer player, int tab) {
        super("", false, INV_SIZE);
        this.player = player;
        this.tab = tab;
    }

    public void func_70295_k_() {
        if (!BridgeUtils.isDataLoaded(this.player)) {
            return;
        }
        if (debug) {
            System.out.println("openInventory tab: " + this.tab);
        }
        GlobalChestInventory.loadGlobalChest(this.player, this.tab);
    }

    public void func_70305_f() {
        if (!BridgeUtils.isDataLoaded(this.player)) {
            return;
        }
        if (debug) {
            System.out.println("closeInventory tab: " + this.tab);
        }
        GlobalChestInventory.saveGlobalChest(this.player, this.tab);
    }

    public void loadInventoryFromNBT(NBTTagList nbtTagList) {
        int slot;
        if (debug) {
            System.out.println("loadInventoryFromNBT");
        }
        for (slot = 0; slot < this.func_70302_i_(); ++slot) {
            this.func_70299_a(slot, null);
        }
        for (slot = 0; slot < nbtTagList.func_74745_c(); ++slot) {
            NBTTagCompound nbt = nbtTagList.func_150305_b(slot);
            int slotNum = nbt.func_74771_c("Slot") & 0xFF;
            short damage = nbt.func_74765_d("Damage");
            if (slotNum < 0 || slotNum >= this.func_70302_i_()) continue;
            ItemStack itemStack = ItemStack.func_77949_a((NBTTagCompound)nbt);
            itemStack.func_77964_b((int)damage);
            this.func_70299_a(slotNum, itemStack);
        }
    }

    public NBTTagList saveInventoryToNBT() {
        if (debug) {
            System.out.println("saveInventoryToNBT");
        }
        NBTTagList inventoryData = new NBTTagList();
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            ItemStack itemStack = this.func_70301_a(slot);
            if (itemStack == null) continue;
            int damage = itemStack.func_77960_j();
            if (debug) {
                System.out.println("- slot #" + itemStack + " damage: " + damage);
            }
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a("Slot", (byte)slot);
            nbt.func_74777_a("Damage", (short)damage);
            itemStack.func_77955_b(nbt);
            inventoryData.func_74742_a((NBTBase)nbt);
        }
        return inventoryData;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public static void copyGlobalChest(EntityPlayer player, ExtendedPlayer props) {
        for (int tab = 0; tab < ContainerCustomChest.tabCount; ++tab) {
            GlobalChestInventory globalChest = ExtendedPlayer.get((EntityPlayer)player).globalChestInventories.get(tab);
            GlobalChestInventory sourceChest = props.globalChestInventories.get(tab);
            globalChest.copy(sourceChest);
        }
    }

    public void copy(GlobalChestInventory globalChest) {
        if (debug) {
            System.out.println("copy? " + (Object)((Object)globalChest));
        }
        for (int i = 0; i < globalChest.func_70302_i_(); ++i) {
            ItemStack stack = globalChest.func_70301_a(i);
            this.func_70299_a(i, stack == null ? null : stack.func_77946_l());
        }
        this.func_70296_d();
    }

    public static void saveGlobalChest(EntityPlayer player) {
        GlobalChestInventory.initGlobalChestInventories(player);
        for (int tab = 0; tab < ContainerCustomChest.tabCount; ++tab) {
            GlobalChestInventory.saveGlobalChest(player, tab);
        }
    }

    public static void saveGlobalChest(EntityPlayer player, int tab) {
        if (debug) {
            System.out.println("saveGlobalChest for: " + player.func_70005_c_() + " tab: " + tab);
        }
        ExtendedPlayer extendedPlayer = ExtendedPlayer.get(player);
        if (extendedPlayer.globalChestInventories.size() <= tab) {
            return;
        }
        GlobalChestInventory globalChest = extendedPlayer.globalChestInventories.get(tab);
        NBTTagCompound globalChestData = GlobalChestInventory.getGlobalChest(player);
        if (debug) {
            System.out.println("saveGlobalChest data: \"" + globalChestData.func_74781_a(inventoryTag + tab) + "\"");
        }
        globalChest.writeToNBT(player, globalChestData, tab);
    }

    public void writeToNBT(EntityPlayer player, NBTTagCompound compound, int tab) {
        if (debug) {
            System.out.println("writeToNBT tab: " + tab);
        }
        boolean isEmpty = true;
        NBTTagList itemList = new NBTTagList();
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            ItemStack itemStack = this.func_70301_a(slot);
            if (itemStack == null) continue;
            if (isEmpty) {
                isEmpty = false;
            }
            if (debug) {
                System.out.println("- slot #" + slot + " | stack: " + itemStack);
            }
            NBTTagCompound itemNbt = new NBTTagCompound();
            itemNbt.func_74774_a("Slot", (byte)slot);
            itemStack.func_77955_b(itemNbt);
            if (debug) {
                System.out.println("- itemNbt: " + itemNbt);
            }
            itemList.func_74742_a((NBTBase)itemNbt);
        }
        if (debug) {
            System.out.println("writeToNBT for " + player.func_70005_c_() + " tab #" + tab + (isEmpty ? " isEmpty: " + isEmpty : " to " + itemList));
        }
        compound.func_74782_a(inventoryTag + tab, (NBTBase)itemList);
        player.getEntityData().func_74782_a(nbtTag, (NBTBase)compound);
    }

    public static void loadGlobalChest(EntityPlayer player) {
        if (debug) {
            System.out.println("loadGlobalChest for: " + player);
        }
        GlobalChestInventory.initGlobalChestInventories(player);
        for (int tab = 0; tab < ContainerCustomChest.tabCount; ++tab) {
            GlobalChestInventory.loadGlobalChest(player, tab);
        }
    }

    public static void loadGlobalChest(EntityPlayer player, int tab) {
        if (debug) {
            System.out.println("loadGlobalChest for: " + player.func_70005_c_() + " tab: " + tab);
        }
        GlobalChestInventory.initGlobalChestInventories(player);
        NBTTagCompound globalChestData = GlobalChestInventory.getGlobalChest(player);
        if (debug) {
            System.out.println("loadGlobalChest data: \"" + globalChestData + "\"");
        }
        GlobalChestInventory globalChest = ExtendedPlayer.get((EntityPlayer)player).globalChestInventories.get(tab);
        globalChest.readFromNBT(player, globalChestData, tab);
    }

    public void readFromNBT(EntityPlayer player, NBTTagCompound compound, int tab) {
        NBTTagList itemList = compound.func_150295_c(inventoryTag + tab, (int)compound.func_74732_a());
        if (debug) {
            System.out.println("readFromNBT tab: " + tab + " itemList: " + itemList.func_74745_c());
        }
        for (int i = 0; i < itemList.func_74745_c(); ++i) {
            NBTTagCompound item = itemList.func_150305_b(i);
            byte slot = item.func_74771_c("Slot");
            if (slot < 0 || slot >= this.func_70302_i_()) continue;
            ItemStack itemStack = ItemStack.func_77949_a((NBTTagCompound)item);
            if (debug) {
                System.out.println("- i #" + i + " slot: " + slot + " | stack: " + itemStack);
            }
            if (itemStack == null) continue;
            this.func_70299_a(slot, itemStack);
        }
    }

    public static NBTTagCompound getGlobalChest(EntityPlayer player) {
        NBTTagCompound forgeData = player.getEntityData();
        NBTTagCompound result = forgeData.func_74775_l(nbtTag);
        return result;
    }

    public static void loadGlobalChestData(EntityPlayer player, NBTTagCompound nbtData) {
        if (debug) {
            System.out.println("loadGlobalChestData for: " + player.func_70005_c_());
        }
        GlobalChestInventory.initGlobalChestInventories(player);
        for (int tab = 0; tab < ContainerCustomChest.tabCount; ++tab) {
            ExtendedPlayer extendedPlayer = ExtendedPlayer.get(player);
            GlobalChestInventory globalChest = extendedPlayer.globalChestInventories.get(tab);
            globalChest.readFromNBT(player, nbtData, tab);
            GlobalChestInventory.saveGlobalChest(player, tab);
        }
    }

    public static void initGlobalChestInventories(EntityPlayer player) {
        ArrayList<GlobalChestInventory> globalChestInventories = ExtendedPlayer.get((EntityPlayer)player).globalChestInventories;
        if (!globalChestInventories.isEmpty()) {
            return;
        }
        if (debug) {
            System.out.println("initGlobalChest array was empty for: " + player.func_70005_c_() + " populating...");
        }
        for (int tab = 0; tab < ContainerCustomChest.tabCount; ++tab) {
            GlobalChestInventory globalChestInventory = new GlobalChestInventory(player, tab);
            if (debug) {
                System.out.println("- populating tab #" + tab + " = ");
            }
            globalChestInventories.add(globalChestInventory);
        }
    }
}

