/*
 * Decompiled with CFR 0.152.
 */
package net.MCApolloNetwork.ApolloCrux.Bridge.Items;

import JinRyuu.JRMCore.JRMCoreH;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.MCApolloNetwork.ApolloCrux.Bridge.Items.ApolloItems;
import net.MCApolloNetwork.ApolloCrux.Bridge.Items.ItemRecovery;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.BridgeUtils;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.Methods;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowNockEvent;

public class ItemEdible
extends ItemFood {
    public EdibleType type;
    public int variation;

    public ItemEdible(EdibleType type, Integer variation) {
        super(10, true);
        this.field_77777_bU = 64;
        this.func_77637_a(ApolloItems.tabItems);
        this.func_77848_i();
        this.type = type;
        this.variation = variation;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        String recoveryDesc = "";
        String eventDesc = "";
        int healthAmount = 0;
        int energyAmount = 0;
        int staminaAmount = 0;
        double duration = 0.0;
        ItemRecovery.RecoveryGroup recoveryGroup = ItemRecovery.getRecoveryItemGroup(itemStack);
        int stackSize = ItemRecovery.getStackLimit(itemStack);
        int cooldown = 0;
        switch (this.type) {
            case DINOMEAT: {
                healthAmount = ItemRecovery.DinoMeatAmount;
                energyAmount = ItemRecovery.DinoMeatAmount;
                staminaAmount = ItemRecovery.DinoMeatStamAmount;
                recoveryDesc = "The finest cut of Meat straight from a Paozusaurus.";
                cooldown = ItemRecovery.DinoMeatCooldown;
                break;
            }
            case DNOODLES: {
                healthAmount = ItemRecovery.DivineAmount;
                energyAmount = ItemRecovery.DivineAmount;
                staminaAmount = ItemRecovery.DivineStamAmount;
                eventDesc = EnumChatFormatting.LIGHT_PURPLE + "Obtained from Whis Training Cooking Task";
                recoveryDesc = "Divine Noodles cooked using only the best ingredients.";
                cooldown = ItemRecovery.DivineCooldown;
                break;
            }
        }
        List formatted = fr.func_78271_c("\"" + recoveryDesc + "\"", 200);
        list.addAll(formatted);
        list.add("");
        list.add(EnumChatFormatting.YELLOW + "Recovery Information:");
        if (!BridgeUtils.isDataLoaded()) {
            list.add(EnumChatFormatting.GRAY + "Character Data Loading...");
        } else {
            int[] recoveryAmounts = ItemRecovery.getRecoveryAmount(itemStack);
            double health = recoveryAmounts[0];
            double healthMax = JRMCoreH.maxBody;
            if (health <= 100.0) {
                health = healthMax / 100.0 * health;
            }
            String healthString = ItemRecovery.getRecoveryString(health, healthMax);
            double energy = recoveryAmounts[1];
            double energyMax = JRMCoreH.maxEnergy;
            if (energy <= 100.0) {
                energy = energyMax / 100.0 * energy;
            }
            String energyString = ItemRecovery.getRecoveryString(energy, energyMax);
            double stamina = recoveryAmounts[2];
            double staminaMax = JRMCoreH.maxStamina;
            if (stamina <= 100.0) {
                stamina = staminaMax / 100.0 * stamina;
            }
            String staminaString = ItemRecovery.getRecoveryString(stamina, staminaMax);
            if (healthAmount > 0) {
                list.add(EnumChatFormatting.GRAY + "- Health Recovery: " + EnumChatFormatting.GREEN + Methods.numSep((int)health) + healthString);
            }
            if (energyAmount > 0) {
                list.add(EnumChatFormatting.GRAY + "- Energy Recovery: " + EnumChatFormatting.AQUA + Methods.numSep((int)energy) + energyString);
            }
            if (staminaAmount > 0) {
                list.add(EnumChatFormatting.GRAY + "- Stamina Recovery: " + EnumChatFormatting.GOLD + Methods.numSep((int)stamina) + staminaString);
            }
            if (duration > 0.0) {
                list.add(EnumChatFormatting.GRAY + "- Duration: " + EnumChatFormatting.DARK_GREEN + ("" + duration).replace(".0", "") + " Seconds");
            }
        }
        list.add("");
        if (recoveryGroup != null) {
            String text = recoveryGroup.equals((Object)ItemRecovery.RecoveryGroup.HEALTH) ? EnumChatFormatting.GREEN + "Health" : (recoveryGroup.equals((Object)ItemRecovery.RecoveryGroup.ENERGY) ? EnumChatFormatting.AQUA + "Energy" : (recoveryGroup.equals((Object)ItemRecovery.RecoveryGroup.DURATION) ? EnumChatFormatting.LIGHT_PURPLE + "Duration" : (recoveryGroup.equals((Object)ItemRecovery.RecoveryGroup.EDIBLE) ? EnumChatFormatting.GOLD + "Edible" : (recoveryGroup.equals((Object)ItemRecovery.RecoveryGroup.SPECIAL_EDIBLE) ? EnumChatFormatting.YELLOW + "Speciality Edible" : EnumChatFormatting.YELLOW + "No Group"))));
            list.add(EnumChatFormatting.GRAY + "Recovery Item Group: " + text);
        }
        if (stackSize > 0) {
            list.add(EnumChatFormatting.GRAY + "Stack Size: " + EnumChatFormatting.DARK_AQUA + stackSize + EnumChatFormatting.GRAY + " (Recovery Slot)");
        }
        if (cooldown > 0) {
            list.add(EnumChatFormatting.GRAY + "Cooldown: " + EnumChatFormatting.DARK_AQUA + cooldown + " Seconds");
        }
        list.add(EnumChatFormatting.GRAY + "Usage Time: " + EnumChatFormatting.DARK_AQUA + 1 + " Seconds");
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_77659_a(ItemStack itemStack, World par2World, EntityPlayer par3EntityPlayer) {
        ArrowNockEvent event = new ArrowNockEvent(par3EntityPlayer, itemStack);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return event.result;
        }
        if (par3EntityPlayer.field_71075_bZ.field_75098_d || par3EntityPlayer.field_71071_by.func_146028_b((Item)this)) {
            par3EntityPlayer.func_71008_a(itemStack, this.func_77626_a(itemStack));
        }
        BridgeUtils.addALogMessage(EnumChatFormatting.RED + "Recovery items must be placed in Recovery Item Slots");
        return itemStack;
    }

    public int func_77626_a(ItemStack itemStack) {
        return 1000;
    }

    public static enum EdibleType {
        DINOMEAT,
        DNOODLES;

    }
}

