/*
 * Decompiled with CFR 0.152.
 */
package net.MCApolloNetwork.ApolloCrux.Bridge.Items;

import JinRyuu.JRMCore.JRMCoreH;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.MCApolloNetwork.ApolloCrux.Bridge.Inventory.ContainerCPlayer;
import net.MCApolloNetwork.ApolloCrux.Bridge.Items.ApolloItems;
import net.MCApolloNetwork.ApolloCrux.Bridge.Items.ItemEdible;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.BridgeUtils;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.Methods;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.Packets.BridgePD;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.Variables;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.ClientUtils;
import net.MCApolloNetwork.ApolloCrux.Server.Utilities.ServerUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowNockEvent;

public class ItemRecovery
extends Item {
    public RecoveryType type;
    public int variation;
    public static int[] VitadrinkCooldown = new int[]{5, 6, 7};
    static int[] vitaDrinkAmount = new int[]{5000, 25000, 50000};
    static int[] vitaDrinkStackSize = new int[]{20, 15, 10};
    public static int[] HealadeCooldown = new int[]{5, 6, 7};
    static int[] healadeAmount = new int[]{35, 50, 70};
    static int[] healadeStackSize = new int[]{20, 15, 10};
    public static int[] SupplementsCooldown = new int[]{11, 9, 6};
    static int[] supplementsAmount = new int[]{35, 50, 70};
    static double[] supplementsDuration = new double[]{12.5, 10.0, 7.5};
    static int[] supplementsStackSize = new int[]{20, 15, 10};
    public static int[] KiStimulantCooldown = new int[]{5, 6, 7};
    static int[] kiStimulantAmount = new int[]{5000, 25000, 50000};
    static int[] kiStimulantStackSize = new int[]{20, 15, 10};
    public static int[] FocusCandyCooldown = new int[]{5, 6, 7};
    static int[] focusCandyAmount = new int[]{40, 55, 80};
    static int[] focusCandyStackSize = new int[]{20, 15, 10};
    public static int[] PillsCooldown = new int[]{11, 9, 6};
    static int[] pillsAmount = new int[]{40, 55, 80};
    static double[] pillsDuration = new double[]{12.5, 10.0, 7.5};
    static int[] pillsStackSize = new int[]{20, 15, 10};
    public static int SenzuCooldown = 10;
    public static int SenzuAmount = 100;
    static int SenzuStackSize = 5;
    public static int DinoMeatCooldown = 6;
    public static int DinoMeatAmount = 15;
    public static int DinoMeatStamAmount = 20;
    static int DinoMeatStackSize = 20;
    public static int DivineCooldown = 5;
    public static int DivineAmount = 35;
    public static int DivineStamAmount = 45;
    static int DivineStackSize = 15;
    public static int BeerusFishCooldown = 6;
    public static int BeerusFishAmount = 65;
    static int BeerusFishStackSize = 10;
    public static int SpookCandyCooldown = 7;
    public static int SpookCandyAmount = 45;
    static int SpookCandyStackSize = 20;
    public static int SpookLollipopCooldown = 6;
    public static int SpookLollipopAmount = 55;
    static int SpookLollipopStackSize = 20;
    public static int JollyGingerbreadCooldown = 8;
    public static int JollyGingerbreadAmount = 40;
    static int JollyGingerbreadStackSize = 15;
    public static int JollyCandyCaneCooldown = 8;
    public static int JollyCandyCaneAmount = 40;
    static int JollyCandyCaneStackSize = 15;

    public ItemRecovery(RecoveryType type, Integer variation) {
        this.func_77627_a(true);
        this.field_77777_bU = 64;
        this.func_77637_a(ApolloItems.tabItems);
        this.type = type;
        this.variation = variation;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        String recoveryDesc = "";
        String eventDesc = "";
        int healthAmount = 0;
        int energyAmount = 0;
        int staminaAmount = 0;
        double duration = 0.0;
        RecoveryGroup recoveryGroup = ItemRecovery.getRecoveryItemGroup(itemStack);
        int stackSize = ItemRecovery.getStackLimit(itemStack);
        int cooldown = 0;
        block0 : switch (this.type) {
            case VITADRINK: {
                String[] vitaDrinkDesc = new String[]{"A Drink that recovers your Health. It's a little bitter, but it's good when you need a quick pick-me-up!", "A medium sized Drink that recovers your Health. It's a little bitter, but it's good when you need a quick pick-me-up!", "A large sized Drink that recovers your Health. It's a little bitter, but it's good when you need a quick pick-me-up!"};
                healthAmount = vitaDrinkAmount[this.variation - 1];
                recoveryDesc = vitaDrinkDesc[this.variation - 1];
                cooldown = VitadrinkCooldown[this.variation - 1];
                break;
            }
            case HEALADE: {
                String[] healadeDesc = new String[]{"A Drink with strong Healing Properties. Has an exhilarating taste that'll leave you feeling refreshed in a flash!", "A more potent Drink with strong Healing Properties. Has an exhilarating taste that'll leave you feeling refreshed in a flash!", "The most potent Drink with strong Healing Properties. Has an exhilarating taste that'll leave you feeling refreshed in a flash!"};
                healthAmount = healadeAmount[this.variation - 1];
                recoveryDesc = healadeDesc[this.variation - 1];
                cooldown = HealadeCooldown[this.variation - 1];
                break;
            }
            case SUPPLEMENTS: {
                String[] supplementsDesc = new String[]{"A Supplement that recovers Health gradually. It may take a few but it'll get the job done!", "A more effective Supplement that recovers Health gradually. It may take a few but it'll get the job done!", "The most effective Supplement that recovers Health gradually. It may take a few but it'll get the job done!"};
                healthAmount = supplementsAmount[this.variation - 1];
                recoveryDesc = supplementsDesc[this.variation - 1];
                cooldown = SupplementsCooldown[this.variation - 1];
                duration = supplementsDuration[this.variation - 1];
                break;
            }
            case SENZU: {
                healthAmount = SenzuAmount;
                energyAmount = SenzuAmount;
                staminaAmount = SenzuAmount;
                recoveryDesc = "A Magical Bean that heals any and all wounds. Only Master Korin knows how to grow it.";
                cooldown = SenzuCooldown;
                break;
            }
            case KISTIMULANT: {
                String[] kiStimulantDesc = new String[]{"A Drink that recovers Energy. It may be bitter but it does it's job!", "A medium sized Drink that recovers Energy. It may be bitter but it does it's job!", "A large sized Drink that recovers Energy. It may be bitter but it does it's job!"};
                energyAmount = kiStimulantAmount[this.variation - 1];
                recoveryDesc = kiStimulantDesc[this.variation - 1];
                cooldown = KiStimulantCooldown[this.variation - 1];
                break;
            }
            case FOCUSCANDY: {
                String[] focusCandyDesc = new String[]{"A Candy that provides Energy Recovery. Pop this bad boy to get a quick burst of Energy!", "A more potent Candy that provides Energy Recovery. Pop this bad boy to get a quick burst of Energy!", "The most potent Candy that provides Energy Recovery. Pop this bad boy to get a quick burst of Energy!"};
                energyAmount = focusCandyAmount[this.variation - 1];
                recoveryDesc = focusCandyDesc[this.variation - 1];
                cooldown = FocusCandyCooldown[this.variation - 1];
                break;
            }
            case PILLS: {
                String[] pillsDesc = new String[]{"A Pill that recovers Energy gradually. It may take a few but it'll get the job done!", "A more effective Pill that recovers Energy gradually. It may take a few but it'll get the job done!", "The most effective Pill that recovers Energy gradually. It may take a few but it'll get the job done!"};
                energyAmount = pillsAmount[this.variation - 1];
                recoveryDesc = pillsDesc[this.variation - 1];
                cooldown = PillsCooldown[this.variation - 1];
                duration = pillsDuration[this.variation - 1];
                break;
            }
            case EVENT: {
                switch (this.variation) {
                    case 1: {
                        healthAmount = BeerusFishAmount;
                        energyAmount = BeerusFishAmount;
                        recoveryDesc = "A meal fit for the gods";
                        eventDesc = EnumChatFormatting.YELLOW + "Limited Edition " + EnumChatFormatting.LIGHT_PURPLE + "BoG & RoF" + EnumChatFormatting.YELLOW + " Release 2020 / 2021";
                        cooldown = BeerusFishCooldown;
                        break block0;
                    }
                    case 2: {
                        healthAmount = SpookCandyAmount;
                        recoveryDesc = "A sweet treat for these spooky times";
                        eventDesc = EnumChatFormatting.YELLOW + "Limited Edition " + EnumChatFormatting.DARK_RED + "SpookFest" + EnumChatFormatting.RED + " Release 2020 - 2023";
                        cooldown = SpookCandyCooldown;
                        break block0;
                    }
                    case 3: {
                        energyAmount = SpookLollipopAmount;
                        recoveryDesc = "A sweet treat for these spooky times";
                        eventDesc = EnumChatFormatting.YELLOW + "Limited Edition " + EnumChatFormatting.DARK_RED + "SpookFest" + EnumChatFormatting.RED + " Release 2020 - 2023";
                        cooldown = SpookLollipopCooldown;
                        break block0;
                    }
                    case 4: {
                        healthAmount = JollyGingerbreadAmount * 2;
                        energyAmount = JollyGingerbreadAmount;
                        recoveryDesc = "Have a Holly Jolly Christmas!";
                        eventDesc = EnumChatFormatting.YELLOW + "Limited Edition " + EnumChatFormatting.DARK_RED + "J" + EnumChatFormatting.WHITE + "o" + EnumChatFormatting.DARK_RED + "l" + EnumChatFormatting.WHITE + "l" + EnumChatFormatting.DARK_RED + "y" + EnumChatFormatting.RED + " Release 2020 - 2022";
                        cooldown = JollyGingerbreadCooldown;
                        break block0;
                    }
                    case 5: {
                        healthAmount = JollyCandyCaneAmount;
                        energyAmount = JollyCandyCaneAmount * 2;
                        recoveryDesc = "Merry Christmas!";
                        eventDesc = EnumChatFormatting.YELLOW + "Limited Edition " + EnumChatFormatting.DARK_RED + "J" + EnumChatFormatting.WHITE + "o" + EnumChatFormatting.DARK_RED + "l" + EnumChatFormatting.WHITE + "l" + EnumChatFormatting.DARK_RED + "y" + EnumChatFormatting.RED + " Release 2020 - 2022";
                        cooldown = JollyCandyCaneCooldown;
                    }
                }
            }
        }
        if (!eventDesc.isEmpty()) {
            list.add(eventDesc);
            list.add("");
        }
        List formatted = fr.func_78271_c("\"" + recoveryDesc + "\"", 200);
        list.addAll(formatted);
        list.add("");
        list.add(EnumChatFormatting.YELLOW + "Recovery Information:");
        if (!BridgeUtils.isDataLoaded()) {
            list.add(EnumChatFormatting.GRAY + "Character Data Loading...");
        } else {
            int[] recoveryAmounts = ItemRecovery.getRecoveryAmount(itemStack);
            double health = recoveryAmounts[0];
            double healthMax = JRMCoreH.maxBody;
            if (health <= 100.0) {
                health = healthMax / 100.0 * health;
            }
            String healthString = ItemRecovery.getRecoveryString(health, healthMax);
            double energy = recoveryAmounts[1];
            double energyMax = JRMCoreH.maxEnergy;
            if (energy <= 100.0) {
                energy = energyMax / 100.0 * energy;
            }
            String energyString = ItemRecovery.getRecoveryString(energy, energyMax);
            double stamina = recoveryAmounts[2];
            double staminaMax = JRMCoreH.maxStamina;
            if (stamina <= 100.0) {
                stamina = staminaMax / 100.0 * stamina;
            }
            String staminaString = ItemRecovery.getRecoveryString(stamina, staminaMax);
            if (healthAmount > 0) {
                list.add(EnumChatFormatting.GRAY + "- Health Recovery: " + EnumChatFormatting.GREEN + Methods.numSep((int)health) + healthString);
            }
            if (energyAmount > 0) {
                list.add(EnumChatFormatting.GRAY + "- Energy Recovery: " + EnumChatFormatting.AQUA + Methods.numSep((int)energy) + energyString);
            }
            if (staminaAmount > 0) {
                list.add(EnumChatFormatting.GRAY + "- Stamina Recovery: " + EnumChatFormatting.GOLD + Methods.numSep((int)stamina) + staminaString);
            }
            if (duration > 0.0) {
                list.add(EnumChatFormatting.GRAY + "- Duration: " + EnumChatFormatting.DARK_GREEN + ("" + duration).replace(".0", "") + " Seconds");
            }
        }
        list.add("");
        if (recoveryGroup != null) {
            String text = recoveryGroup.equals((Object)RecoveryGroup.HEALTH) ? EnumChatFormatting.GREEN + "Health" : (recoveryGroup.equals((Object)RecoveryGroup.ENERGY) ? EnumChatFormatting.AQUA + "Energy" : (recoveryGroup.equals((Object)RecoveryGroup.DURATION) ? EnumChatFormatting.LIGHT_PURPLE + "Duration" : (recoveryGroup.equals((Object)RecoveryGroup.EDIBLE) ? EnumChatFormatting.GOLD + "Edible" : (recoveryGroup.equals((Object)RecoveryGroup.SPECIAL_EDIBLE) ? EnumChatFormatting.YELLOW + "Speciality Edible" : EnumChatFormatting.YELLOW + "No Group"))));
            list.add(EnumChatFormatting.GRAY + "Recovery Item Group: " + text);
        }
        if (stackSize > 0) {
            list.add(EnumChatFormatting.GRAY + "Stack Size: " + EnumChatFormatting.DARK_AQUA + stackSize + EnumChatFormatting.GRAY + " (Recovery Slot)");
        }
        if (cooldown > 0) {
            list.add(EnumChatFormatting.GRAY + "Cooldown: " + EnumChatFormatting.DARK_AQUA + cooldown + " Seconds");
        }
        list.add(EnumChatFormatting.GRAY + "Usage Time: " + EnumChatFormatting.DARK_AQUA + 1 + " Seconds");
    }

    public static String getRecoveryString(double value, double valueMax) {
        double valuePercent = BridgeUtils.round(100.0, Math.min(100.0, value / valueMax * 100.0));
        String valueString = valuePercent + "" + "%";
        if (valueString.endsWith(".0")) {
            valueString = valueString.replace(".0", "");
        }
        return EnumChatFormatting.BLUE + " (" + valueString + ")";
    }

    public static RecoveryGroup getRecoveryItemGroup(ItemStack itemStack) {
        RecoveryGroup recoveryGroup = null;
        if (itemStack == null) {
            return recoveryGroup;
        }
        if (itemStack.func_77973_b() instanceof ItemRecovery) {
            ItemRecovery itemRecovery = (ItemRecovery)itemStack.func_77973_b();
            switch (itemRecovery.type) {
                case VITADRINK: 
                case HEALADE: {
                    recoveryGroup = RecoveryGroup.HEALTH;
                    break;
                }
                case KISTIMULANT: 
                case FOCUSCANDY: {
                    recoveryGroup = RecoveryGroup.ENERGY;
                    break;
                }
                case SUPPLEMENTS: 
                case PILLS: {
                    recoveryGroup = RecoveryGroup.DURATION;
                    break;
                }
                case SENZU: {
                    recoveryGroup = RecoveryGroup.EDIBLE;
                    break;
                }
                case EVENT: {
                    recoveryGroup = RecoveryGroup.SPECIAL_EDIBLE;
                }
            }
        } else if (itemStack.func_77973_b() instanceof ItemEdible) {
            ItemEdible itemEdible = (ItemEdible)itemStack.func_77973_b();
            switch (itemEdible.type) {
                case DINOMEAT: 
                case DNOODLES: {
                    recoveryGroup = RecoveryGroup.EDIBLE;
                }
            }
        }
        return recoveryGroup;
    }

    public static int getRecoveryGroupNumber(RecoveryGroup recoveryGroup) {
        if (recoveryGroup == null) {
            return 0;
        }
        return recoveryGroup.equals((Object)RecoveryGroup.HEALTH) ? 0 : (recoveryGroup.equals((Object)RecoveryGroup.ENERGY) ? 1 : (recoveryGroup.equals((Object)RecoveryGroup.DURATION) ? 2 : (recoveryGroup.equals((Object)RecoveryGroup.EDIBLE) ? 3 : (recoveryGroup.equals((Object)RecoveryGroup.SPECIAL_EDIBLE) ? 4 : 0))));
    }

    public static void recoveryItem(EntityPlayer player, ItemStack itemStack) {
        boolean isDuration;
        int healSingle;
        boolean debug = false;
        NBTTagCompound nbt = player.getEntityData().func_74775_l("PlayerPersisted");
        World world = player.field_70170_p;
        int maxBody = ServerUtils.getMaxHealth((EntityPlayer)player);
        int maxEnergy = ServerUtils.getMaxEnergy((EntityPlayer)player);
        int maxStamina = ServerUtils.getMaxStamina((EntityPlayer)player);
        int curBody = ServerUtils.getCurrentHealth((EntityPlayer)player);
        int curEnergy = ServerUtils.getCurrentEnergy((EntityPlayer)player);
        int healHealth = 0;
        int healEnergy = 0;
        int healStamina = 0;
        String healType = "";
        double duration = 0.0;
        RecoveryType recoveryType = null;
        if (itemStack.func_77973_b() instanceof ItemRecovery) {
            ItemRecovery itemRecovery = (ItemRecovery)itemStack.func_77973_b();
            recoveryType = itemRecovery.type;
            int variation = itemRecovery.variation;
            block0 : switch (itemRecovery.type) {
                case VITADRINK: {
                    healType = "body";
                    healHealth = vitaDrinkAmount[variation - 1];
                    break;
                }
                case HEALADE: {
                    healType = "body";
                    healHealth = maxBody / 100 * healadeAmount[variation - 1];
                    break;
                }
                case SUPPLEMENTS: {
                    healType = "body";
                    healHealth = maxBody / 100 * supplementsAmount[variation - 1];
                    duration = supplementsDuration[variation - 1];
                    world.func_72956_a((Entity)player, "jinryuudragonbc:DBC2.sensu", 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                    break;
                }
                case KISTIMULANT: {
                    healType = "energy";
                    healEnergy = kiStimulantAmount[variation - 1];
                    break;
                }
                case FOCUSCANDY: {
                    healType = "energy";
                    healEnergy = maxEnergy / 100 * focusCandyAmount[variation - 1];
                    world.func_72956_a((Entity)player, "jinryuudragonbc:DBC2.sensu", 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                    break;
                }
                case PILLS: {
                    healType = "energy";
                    healEnergy = maxEnergy / 100 * pillsAmount[variation - 1];
                    duration = pillsDuration[variation - 1];
                    world.func_72956_a((Entity)player, "jinryuudragonbc:DBC2.sensu", 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                    break;
                }
                case SENZU: {
                    healType = "body,energy,stamina";
                    if (variation == 1) {
                        healHealth = maxBody / 100 * SenzuAmount;
                        healEnergy = maxEnergy / 100 * SenzuAmount;
                        healStamina = maxStamina / 100 * SenzuAmount;
                    }
                    world.func_72956_a((Entity)player, "jinryuudragonbc:DBC2.sensu", 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                    break;
                }
                case EVENT: {
                    switch (variation) {
                        case 1: {
                            healType = "body,energy";
                            healHealth = maxBody / 100 * BeerusFishAmount;
                            healEnergy = maxEnergy / 100 * BeerusFishAmount;
                            break block0;
                        }
                        case 2: {
                            healType = "body";
                            healHealth = maxBody / 100 * SpookCandyAmount;
                            break block0;
                        }
                        case 3: {
                            healType = "energy";
                            healEnergy = maxEnergy / 100 * SpookLollipopAmount;
                            break block0;
                        }
                        case 4: {
                            healType = "body,energy";
                            healHealth = maxBody / 100 * JollyGingerbreadAmount;
                            healEnergy = maxEnergy / 100 * JollyGingerbreadAmount;
                            ServerUtils.setEnergyCapped((int)(curEnergy + maxEnergy / 100 * JollyGingerbreadAmount), (EntityPlayer)player);
                            ServerUtils.setHealthCapped((int)(curBody + maxBody / 100 * JollyGingerbreadAmount), (EntityPlayer)player);
                            break block0;
                        }
                        case 5: {
                            healType = "body,energy";
                            healHealth = maxBody / 100 * JollyCandyCaneAmount;
                            healEnergy = maxEnergy / 100 * (JollyCandyCaneAmount * 2);
                        }
                    }
                }
            }
        }
        if (itemStack.func_77973_b() instanceof ItemEdible) {
            ItemEdible itemEdible = (ItemEdible)itemStack.func_77973_b();
            ItemEdible.EdibleType edibleType = itemEdible.type;
            int variation = itemEdible.variation;
            switch (edibleType) {
                case DINOMEAT: {
                    healType = "body,energy,stamina";
                    healHealth = maxBody / 100 * DinoMeatAmount;
                    healEnergy = maxEnergy / 100 * DinoMeatAmount;
                    healStamina = maxStamina / 100 * DinoMeatStamAmount;
                    break;
                }
                case DNOODLES: {
                    healType = "body,energy,stamina";
                    healHealth = maxBody / 100 * DivineAmount;
                    healEnergy = maxEnergy / 100 * DivineAmount;
                    healStamina = maxStamina / 100 * DivineStamAmount;
                }
            }
        }
        int n = healHealth > 0 ? healHealth : (healSingle = healEnergy > 0 ? healEnergy : healStamina);
        if (debug) {
            System.out.println("healType: " + healType);
        }
        if (debug) {
            System.out.println("healHealth: " + healHealth + "_" + healEnergy + "_" + healStamina + " (" + healSingle + ")");
        }
        boolean bl = isDuration = recoveryType == RecoveryType.SUPPLEMENTS || recoveryType == RecoveryType.PILLS;
        if (isDuration) {
            if (debug) {
                System.out.println("duration: " + duration + ";" + healType + ";" + healSingle);
            }
            nbt.func_74778_a("healData", duration + ";" + healType + ";" + healSingle);
        } else {
            nbt.func_74778_a("healData", healType + ";" + healHealth + ":" + healEnergy + ":" + healStamina);
        }
        player.func_70606_j(player.func_110138_aP());
        if (healHealth > 0 || healEnergy > 0 || healStamina > 0) {
            String textHealType;
            String textAmount = EnumChatFormatting.YELLOW + "+" + Methods.numSep(healSingle);
            String string = healType.equals("body") ? EnumChatFormatting.GREEN + "Health" : (healType.equals("energy") ? EnumChatFormatting.AQUA + "Energy" : (textHealType = healType.equals("stamina") ? EnumChatFormatting.GOLD + "Stamina" : ""));
            if (healType.contains(",")) {
                for (int i = 0; i < healType.split(",").length; ++i) {
                    String array = healType.split(",")[i];
                    textAmount = EnumChatFormatting.YELLOW + "+" + Methods.numSep(i == 1 ? healEnergy : (i == 2 ? healStamina : healHealth));
                    textHealType = array.equals("body") ? EnumChatFormatting.GREEN + "Health" : (array.equals("energy") ? EnumChatFormatting.AQUA + "Energy" : (array.equals("stamina") ? EnumChatFormatting.GOLD + "Stamina" : ""));
                    BridgeUtils.addALogMessage(player, textAmount + " " + textHealType + EnumChatFormatting.GRAY + " (" + itemStack.func_82833_r() + EnumChatFormatting.GRAY + ")");
                }
            } else if (isDuration) {
                BridgeUtils.addALogMessage(player, textAmount + " " + textHealType + EnumChatFormatting.BLUE + " Over " + duration + " seconds" + EnumChatFormatting.GRAY + " (" + itemStack.func_82833_r() + EnumChatFormatting.GRAY + ")");
            } else {
                BridgeUtils.addALogMessage(player, textAmount + " " + textHealType + EnumChatFormatting.GRAY + " (" + itemStack.func_82833_r() + EnumChatFormatting.GRAY + ")");
            }
        }
    }

    public static int[] getRecoveryAmount(ItemStack itemStack) {
        int healthAmount = 0;
        int energyAmount = 0;
        int staminaAmount = 0;
        if (itemStack == null) {
            return new int[]{healthAmount, energyAmount, staminaAmount};
        }
        if (itemStack.func_77973_b() instanceof ItemRecovery) {
            ItemRecovery itemRecovery = (ItemRecovery)itemStack.func_77973_b();
            int variation = itemRecovery.variation;
            block0 : switch (itemRecovery.type) {
                case VITADRINK: {
                    healthAmount = vitaDrinkAmount[variation - 1];
                    break;
                }
                case HEALADE: {
                    healthAmount = healadeAmount[variation - 1];
                    break;
                }
                case SUPPLEMENTS: {
                    healthAmount = supplementsAmount[variation - 1];
                    break;
                }
                case KISTIMULANT: {
                    energyAmount = kiStimulantAmount[variation - 1];
                    break;
                }
                case FOCUSCANDY: {
                    energyAmount = focusCandyAmount[variation - 1];
                    break;
                }
                case PILLS: {
                    energyAmount = pillsAmount[variation - 1];
                    break;
                }
                case SENZU: {
                    healthAmount = SenzuAmount;
                    energyAmount = SenzuAmount;
                    staminaAmount = SenzuAmount;
                    break;
                }
                case EVENT: {
                    switch (itemRecovery.variation) {
                        case 1: {
                            healthAmount = BeerusFishAmount;
                            energyAmount = BeerusFishAmount;
                            break block0;
                        }
                        case 2: {
                            healthAmount = SpookCandyAmount;
                            break block0;
                        }
                        case 3: {
                            energyAmount = SpookLollipopAmount;
                            break block0;
                        }
                        case 4: {
                            healthAmount = JollyGingerbreadAmount;
                            energyAmount = JollyGingerbreadAmount;
                            break block0;
                        }
                        case 5: {
                            healthAmount = JollyCandyCaneAmount;
                            energyAmount = JollyCandyCaneAmount * 2;
                        }
                    }
                }
            }
        } else if (itemStack.func_77973_b() instanceof ItemEdible) {
            ItemEdible itemEdible = (ItemEdible)itemStack.func_77973_b();
            switch (itemEdible.type) {
                case DINOMEAT: {
                    healthAmount = DinoMeatAmount;
                    energyAmount = DinoMeatAmount;
                    staminaAmount = DinoMeatStamAmount;
                    break;
                }
                case DNOODLES: {
                    healthAmount = DivineAmount;
                    energyAmount = DivineAmount;
                    staminaAmount = DivineStamAmount;
                }
            }
        }
        return new int[]{healthAmount, energyAmount, staminaAmount};
    }

    public static double getDuration(ItemStack itemStack) {
        double duration = 0.0;
        if (itemStack == null) {
            return duration;
        }
        if (itemStack.func_77973_b() instanceof ItemRecovery) {
            ItemRecovery itemRecovery = (ItemRecovery)itemStack.func_77973_b();
            RecoveryType recoveryType = itemRecovery.type;
            int variation = itemRecovery.variation;
            switch (itemRecovery.type) {
                case SUPPLEMENTS: {
                    duration = supplementsDuration[variation - 1];
                    break;
                }
                case PILLS: {
                    duration = pillsDuration[variation - 1];
                }
            }
        }
        return duration;
    }

    public static int getStackLimit(ItemStack itemStack) {
        int stackSize = 64;
        if (itemStack == null) {
            return stackSize;
        }
        if (itemStack.func_77973_b() instanceof ItemRecovery) {
            ItemRecovery itemRecovery = (ItemRecovery)itemStack.func_77973_b();
            block0 : switch (itemRecovery.type) {
                case VITADRINK: {
                    stackSize = vitaDrinkStackSize[itemRecovery.variation - 1];
                    break;
                }
                case HEALADE: {
                    stackSize = healadeStackSize[itemRecovery.variation - 1];
                    break;
                }
                case SUPPLEMENTS: {
                    stackSize = supplementsStackSize[itemRecovery.variation - 1];
                    break;
                }
                case SENZU: {
                    stackSize = SenzuStackSize;
                    break;
                }
                case FOCUSCANDY: {
                    stackSize = focusCandyStackSize[itemRecovery.variation - 1];
                    break;
                }
                case KISTIMULANT: {
                    stackSize = kiStimulantStackSize[itemRecovery.variation - 1];
                    break;
                }
                case PILLS: {
                    stackSize = pillsStackSize[itemRecovery.variation - 1];
                    break;
                }
                case EVENT: {
                    switch (itemRecovery.variation) {
                        case 1: {
                            stackSize = BeerusFishStackSize;
                            break block0;
                        }
                        case 2: {
                            stackSize = SpookCandyStackSize;
                            break block0;
                        }
                        case 3: {
                            stackSize = SpookLollipopStackSize;
                            break block0;
                        }
                        case 4: {
                            stackSize = JollyGingerbreadStackSize;
                            break block0;
                        }
                        case 5: {
                            stackSize = JollyCandyCaneStackSize;
                        }
                    }
                }
            }
        } else if (itemStack.func_77973_b() instanceof ItemEdible) {
            ItemEdible itemEdible = (ItemEdible)itemStack.func_77973_b();
            switch (itemEdible.type) {
                case DINOMEAT: {
                    stackSize = DinoMeatStackSize;
                    break;
                }
                case DNOODLES: {
                    stackSize = DivineStackSize;
                }
            }
        }
        return stackSize;
    }

    public static int getCooldown(ItemStack itemStack) {
        int cooldown = 5;
        if (itemStack == null) {
            return cooldown;
        }
        if (itemStack.func_77973_b() instanceof ItemRecovery) {
            ItemRecovery itemRecovery = (ItemRecovery)itemStack.func_77973_b();
            block0 : switch (itemRecovery.type) {
                case VITADRINK: {
                    cooldown = VitadrinkCooldown[itemRecovery.variation - 1];
                    break;
                }
                case HEALADE: {
                    cooldown = HealadeCooldown[itemRecovery.variation - 1];
                    break;
                }
                case SUPPLEMENTS: {
                    cooldown = SupplementsCooldown[itemRecovery.variation - 1];
                    break;
                }
                case KISTIMULANT: {
                    cooldown = KiStimulantCooldown[itemRecovery.variation - 1];
                    break;
                }
                case FOCUSCANDY: {
                    cooldown = FocusCandyCooldown[itemRecovery.variation - 1];
                    break;
                }
                case PILLS: {
                    cooldown = PillsCooldown[itemRecovery.variation - 1];
                    break;
                }
                case SENZU: {
                    cooldown = SenzuCooldown;
                    break;
                }
                case EVENT: {
                    switch (itemRecovery.variation) {
                        case 1: {
                            cooldown = BeerusFishCooldown;
                            break block0;
                        }
                        case 2: {
                            cooldown = SpookCandyCooldown;
                            break block0;
                        }
                        case 3: {
                            cooldown = SpookLollipopCooldown;
                            break block0;
                        }
                        case 4: {
                            cooldown = JollyGingerbreadCooldown;
                            break block0;
                        }
                        case 5: {
                            cooldown = JollyCandyCaneCooldown;
                        }
                    }
                }
            }
        } else if (itemStack.func_77973_b() instanceof ItemEdible) {
            ItemEdible itemEdible = (ItemEdible)itemStack.func_77973_b();
            switch (itemEdible.type) {
                case DINOMEAT: {
                    cooldown = DinoMeatCooldown;
                    break;
                }
                case DNOODLES: {
                    cooldown = DivineCooldown;
                }
            }
        }
        return cooldown;
    }

    public static String getSound(ItemStack itemStack) {
        String sound = "random.eat";
        if (itemStack == null) {
            return sound;
        }
        if (itemStack.func_77973_b() instanceof ItemRecovery) {
            ItemRecovery itemRecovery = (ItemRecovery)itemStack.func_77973_b();
            switch (itemRecovery.type) {
                case VITADRINK: 
                case HEALADE: 
                case KISTIMULANT: {
                    sound = "random.drink";
                    break;
                }
                case SUPPLEMENTS: 
                case SENZU: 
                case FOCUSCANDY: 
                case PILLS: {
                    sound = "random.eat";
                    break;
                }
                case EVENT: {
                    switch (itemRecovery.variation) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            sound = "random.eat";
                        }
                    }
                }
            }
        } else if (itemStack.func_77973_b() instanceof ItemEdible) {
            ItemEdible itemEdible = (ItemEdible)itemStack.func_77973_b();
            switch (itemEdible.type) {
                case DINOMEAT: {
                    sound = "random.eat";
                    break;
                }
                case DNOODLES: {
                    sound = "random.drink";
                }
            }
        }
        return sound;
    }

    public static boolean isSameType(ItemStack sourceStack, ItemStack targetStack, boolean compareVariation) {
        ItemEdible itemEdible;
        ItemRecovery itemRecovery;
        if (sourceStack == null || targetStack == null) {
            return false;
        }
        Enum sourceType = null;
        Enum targetType = null;
        Integer sourceVariation = null;
        Integer targetVaration = null;
        if (sourceStack.func_77973_b() instanceof ItemRecovery) {
            itemRecovery = (ItemRecovery)sourceStack.func_77973_b();
            sourceType = itemRecovery.type;
            sourceVariation = itemRecovery.variation;
        } else if (sourceStack.func_77973_b() instanceof ItemEdible) {
            itemEdible = (ItemEdible)sourceStack.func_77973_b();
            sourceType = itemEdible.type;
            sourceVariation = itemEdible.variation;
        }
        if (targetStack.func_77973_b() instanceof ItemRecovery) {
            itemRecovery = (ItemRecovery)targetStack.func_77973_b();
            targetType = itemRecovery.type;
            targetVaration = itemRecovery.variation;
        } else if (targetStack.func_77973_b() instanceof ItemEdible) {
            itemEdible = (ItemEdible)targetStack.func_77973_b();
            targetType = itemEdible.type;
            targetVaration = itemEdible.variation;
        }
        boolean sameType = sourceType.equals(targetType);
        boolean sameVariation = ((Object)sourceVariation).equals(targetVaration);
        return sameType && (!compareVariation || sameVariation);
    }

    public static boolean isSameGroup(ItemStack sourceStack, ItemStack targetStack) {
        if (sourceStack == null || targetStack == null) {
            return false;
        }
        RecoveryGroup sourceGroup = ItemRecovery.getRecoveryItemGroup(sourceStack);
        RecoveryGroup targetGroup = ItemRecovery.getRecoveryItemGroup(targetStack);
        return sourceGroup != null && ((Object)((Object)sourceGroup)).equals((Object)targetGroup);
    }

    public static Object[] canRecoveryItemMove(EntityPlayer player, List inventory, ItemStack itemStack, int targetSlotNum) {
        boolean debug = false;
        boolean hasItemGroup = false;
        int firstEmptySlot = 0;
        int recoverySlotNum = 0;
        if (!ItemRecovery.isRecoverySlotLocked(player)) {
            for (int recoverySlot = 60; recoverySlot <= 63; ++recoverySlot) {
                boolean moveCheck;
                Slot targetStack = (Slot)inventory.get(recoverySlot);
                Item targetRecovery = targetStack.func_75211_c() != null ? targetStack.func_75211_c().func_77973_b() : null;
                Item itemRecovery = itemStack.func_77973_b();
                boolean isSameType = ItemRecovery.isSameType(itemStack, targetStack.func_75211_c(), false);
                boolean isSameVariation = ItemRecovery.isSameType(itemStack, targetStack.func_75211_c(), true);
                if (debug) {
                    System.out.println("recoverySlot #" + recoverySlot + " | " + (targetStack.func_75211_c() != null ? targetStack.func_75211_c().func_82833_r() : "null") + " vs. " + itemStack.func_82833_r() + " | " + (targetStack != null) + " | " + isSameType);
                }
                if (targetStack == null) continue;
                int targetStackSize = targetStack.func_75211_c() != null ? targetStack.func_75211_c().field_77994_a : 0;
                int targetStackLimit = ContainerCPlayer.getItemStackLimit(targetStack.func_75211_c() != null ? targetStack.func_75211_c() : itemStack, true);
                boolean targetAtLimit = targetStackSize >= targetStackLimit;
                int resultStackSize = targetStackSize + itemStack.field_77994_a;
                boolean stackSizeCheck = resultStackSize <= targetStackLimit;
                boolean bl = moveCheck = targetSlotNum < 60 || recoverySlot == targetSlotNum;
                if (isSameType) {
                    if (debug) {
                        System.out.println("- recovery isSameType | resultStackSize: " + resultStackSize + " <= " + targetStackLimit + " | isSameVariation: " + isSameVariation + " | stackSizeCheck: " + stackSizeCheck + " | moveCheck: " + moveCheck + " (" + recoverySlot + " == " + targetSlotNum + ")");
                    }
                    if (isSameVariation && moveCheck) {
                        if (FMLCommonHandler.instance().getSide().isClient() && ClientUtils.getTimeSince((long)ContainerCPlayer.recoverySuccess) >= 250L && targetAtLimit) {
                            ContainerCPlayer.recoveryErrorStackSize = System.currentTimeMillis();
                            if (debug) {
                                System.out.println(" - Error #1");
                            }
                        }
                        firstEmptySlot = recoverySlotNum = recoverySlot;
                        if (!debug) break;
                        System.out.println("- isSameVariation set #" + recoverySlot);
                        break;
                    }
                    hasItemGroup = true;
                    if (!debug) break;
                    System.out.println("- NOT isSameVariation");
                    break;
                }
                if (targetRecovery != null) continue;
                if (firstEmptySlot == 0 && recoverySlotNum == 0) {
                    firstEmptySlot = recoverySlot;
                }
                if (!debug) continue;
                System.out.println("- other set #" + firstEmptySlot);
            }
        }
        if (debug) {
            System.out.println("hasItemGroup: " + hasItemGroup + " | " + firstEmptySlot + " | " + recoverySlotNum);
        }
        return new Object[]{hasItemGroup, firstEmptySlot, recoverySlotNum};
    }

    public static void setRecoverySlotLocked(EntityPlayerMP player, boolean isLocked) {
        NBTTagCompound forgeData = player.getEntityData();
        if (!isLocked && !forgeData.func_74764_b("recoveryItemsLocked")) {
            return;
        }
        if (isLocked) {
            forgeData.func_74768_a("recoveryItemsLocked", 1);
        } else {
            forgeData.func_82580_o("recoveryItemsLocked");
        }
        BridgePD.sendBridge(player, "recoveryItemsLocked", isLocked ? 1 : 0);
    }

    public static boolean isRecoverySlotLocked(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            NBTTagCompound forgeData = player.getEntityData();
            return forgeData.func_74762_e("recoveryItemsLocked") == 1;
        }
        if (Variables.hasValue("recoveryItemsLocked")) {
            return Variables.getValue("recoveryItemsLocked").floatValue() == 1.0f;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_77659_a(ItemStack itemStack, World par2World, EntityPlayer par3EntityPlayer) {
        ArrowNockEvent event = new ArrowNockEvent(par3EntityPlayer, itemStack);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return event.result;
        }
        if (par3EntityPlayer.field_71075_bZ.field_75098_d || par3EntityPlayer.field_71071_by.func_146028_b((Item)this)) {
            par3EntityPlayer.func_71008_a(itemStack, this.func_77626_a(itemStack));
        }
        BridgeUtils.addALogMessage(EnumChatFormatting.RED + "Recovery items must be placed in Recovery Item Slots");
        return itemStack;
    }

    public static enum RecoveryGroup {
        HEALTH,
        ENERGY,
        DURATION,
        EDIBLE,
        SPECIAL_EDIBLE;

    }

    public static enum RecoveryType {
        VITADRINK,
        KISTIMULANT,
        HEALADE,
        FOCUSCANDY,
        SUPPLEMENTS,
        PILLS,
        SENZU,
        EVENT;

    }
}

