/*
 * Decompiled with CFR 0.152.
 */
package net.MCApolloNetwork.ApolloCrux.Bridge.Utils;

import JinRyuu.JRMCore.JRMCoreH;
import JinRyuu.JRMCore.items.GiTurtleBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.MCApolloNetwork.ApolloCrux.Bridge.Items.ApolloItems;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.ArmorRegistry;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.BridgeUtils;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.ClothingSetup;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.ExtendedPlayer;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.Methods;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.CharacterCreation;
import net.MCApolloNetwork.ApolloCrux.Client.Main;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.ClientKeyHandler;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import noppes.npcs.entity.EntityCustomNpc;

public class ArmorSetup
extends GiTurtleBase {
    public int type = -1;
    public int subType = -1;
    public int armorPiece = -1;
    private int meleeDmg = -1;
    private int defense = -1;
    private int kiPower = -1;
    private int kiDefense = -1;
    public int str;
    public int dex;
    public int wil;
    public int eng;
    private final int rarity = 2;
    private float gearRating = -1.0f;
    private final String fullSetBonus;
    private final String fullSetDesc;
    private String armorType;
    private final int[][] armorLimits = new int[][]{{2, 6, 12, 16, 22, 30}, {0, 0, 1, 1, 2, 3}};
    private final int[] armorStats = new int[]{0, -1, 0, 1, 2, 4};

    public ArmorSetup(ItemArmor.ArmorMaterial par2ArmorMaterial, int par3, int par4, String armornamePrefix, int meleeDmg, int defense, int kiPower, int kiDefense, int gearRating, String fullSetBonus, String fullSetDesc, int str, int dex, int wil, int eng, int type, int subType) {
        super(par2ArmorMaterial, par3, par4, armornamePrefix);
        this.setName(par4, armornamePrefix);
        this.func_77637_a(ApolloItems.tabArmor);
        this.type = type;
        this.str = str + this.armorStats[this.rarity];
        this.dex = dex + this.armorStats[this.rarity];
        this.wil = wil + this.armorStats[this.rarity];
        this.eng = eng + this.armorStats[this.rarity];
        this.meleeDmg = meleeDmg;
        this.defense = defense;
        this.kiPower = kiPower;
        this.kiDefense = kiDefense;
        this.gearRating = gearRating;
        this.fullSetBonus = fullSetBonus;
        this.fullSetDesc = fullSetDesc;
        this.subType = subType;
        this.armorPiece = par4;
        this.setupItemTexture(par4, armornamePrefix);
    }

    public ArmorSetup(ItemArmor.ArmorMaterial par2ArmorMaterial, int par3, int par4, String armornamePrefix, int meleeDmg, int defense, int kiPower, int kiDefense, int gearRating, String fullSetBonus, String fullSetDesc) {
        super(par2ArmorMaterial, par3, par4, armornamePrefix);
        this.setName(par4, armornamePrefix);
        this.func_77637_a(ApolloItems.tabArmor);
        this.meleeDmg = meleeDmg + this.armorStats[this.rarity];
        this.defense = defense + this.armorStats[this.rarity];
        this.kiPower = kiPower + this.armorStats[this.rarity];
        this.kiDefense = kiDefense + this.armorStats[this.rarity];
        this.gearRating = gearRating;
        this.fullSetBonus = fullSetBonus;
        this.fullSetDesc = fullSetDesc;
        this.armorPiece = par4;
        this.setupItemTexture(par4, armornamePrefix);
    }

    public void func_77663_a(ItemStack gear, World world, Entity player, int p_77663_4_, boolean p_77663_5_) {
        NBTTagCompound nbt;
        super.func_77663_a(gear, world, player, p_77663_4_, p_77663_5_);
        int typeID = ArmorRegistry.convertTypeID(0, this.type);
        int subID = ArmorRegistry.convertSubTypeID(0, this.subType);
        int pieceID = this.armorPiece - 1;
        String gearName = ArmorRegistry.gearNames[0][typeID][subID][pieceID];
        boolean forceCreate = false;
        int existingVersion = -1;
        if (gear.func_77942_o()) {
            nbt = gear.func_77978_p();
            existingVersion = nbt.func_74762_e("version");
            boolean bl = forceCreate = !nbt.func_74764_b("armorStats");
        }
        if (gear.func_77942_o() && !forceCreate) {
            nbt = gear.func_77978_p();
            nbt.func_74778_a("armorLimit", this.armorLimits[0][nbt.func_74762_e("rarity")] * nbt.func_74762_e("tier") + "," + this.armorLimits[1][nbt.func_74762_e("rarity")]);
            int armorVersion = nbt.func_74762_e("version");
            if (this.fullSetBonus.contains("Warrior of Conton!")) {
                this.setStats(armorVersion, pieceID);
            }
            if (nbt.func_74764_b("armorStats") && nbt.func_74779_i("armorStats").contains(",") && nbt.func_74779_i("armorStats").split(",").length != 7) {
                nbt.func_74778_a("armorStats", this.meleeDmg + "," + this.defense + "," + this.kiPower + "," + this.kiDefense + "," + 0 + "," + 0 + "," + 0);
            }
            if (nbt.func_74764_b("armorEnhance") && nbt.func_74779_i("armorEnhance").contains(",") && nbt.func_74779_i("armorEnhance").split(",").length != 7) {
                nbt.func_74778_a("armorEnhance", nbt.func_74779_i("armorEnhance") + "," + 0);
            }
            if (nbt.func_74764_b("setBonus") && nbt.func_74779_i("setBonus").contains(",") && nbt.func_74779_i("setBonus").split(",").length != 8) {
                nbt.func_74778_a("setBonus", this.str + "," + this.dex + "," + this.wil + "," + this.eng + "," + 0 + "," + 0 + "," + 0 + "," + this.fullSetBonus);
            }
            String expectedName = gearName + (this.fullSetBonus.contains("Warrior of Conton!") ? EnumChatFormatting.YELLOW + " (" + (armorVersion == 1 ? EnumChatFormatting.AQUA + "Ki" : EnumChatFormatting.RED + "Melee") + EnumChatFormatting.YELLOW + " Version)" : "");
            if (gear != null && gear.func_82837_s() && expectedName != null && !gear.func_82833_r().equals(expectedName)) {
                gear.func_151001_c(expectedName);
            }
            if (nbt.func_74764_b("ench") || nbt.func_74764_b("RepairCost")) {
                nbt.func_82580_o("ench");
                nbt.func_82580_o("RepairCost");
                gear.func_151001_c(expectedName);
                ((EntityPlayer)player).func_146105_b((IChatComponent)new ChatComponentText("" + EnumChatFormatting.RED + "You can't apply enchants to armor!"));
            }
            if (!nbt.func_74764_b("type") || nbt.func_74762_e("type") != this.type) {
                nbt.func_74768_a("type", this.type);
            }
            if (!nbt.func_74764_b("subType") && this.subType != -1 || nbt.func_74762_e("subType") != this.subType) {
                nbt.func_74768_a("subType", this.subType);
            }
        } else {
            nbt = new NBTTagCompound();
            if (this.fullSetBonus.contains("Warrior of Conton!") || existingVersion != -1) {
                int armorVersion = existingVersion != -1 ? existingVersion : (Math.random() >= 0.5 ? 1 : 0);
                nbt.func_74768_a("version", armorVersion);
            }
            nbt.func_74776_a("gearRating", this.gearRating + (float)nbt.func_74762_e("enhanceCount") / 2.0f);
            nbt.func_74778_a("armorStats", this.meleeDmg + "," + this.defense + "," + this.kiPower + "," + this.kiDefense + "," + 0 + "," + 0 + "," + 0);
            nbt.func_74778_a("armorEnhance", "0,0,0,0,0,0,0");
            nbt.func_74778_a("setBonus", this.str + "," + this.dex + "," + this.wil + "," + this.eng + "," + 0 + "," + 0 + "," + 0 + "," + this.fullSetBonus);
            nbt.func_74768_a("enhanceCount", 0);
            nbt.func_74768_a("runeCount", 0);
            nbt.func_74778_a("armorLimit", this.armorLimits[0][2] + "," + this.armorLimits[1][2]);
            nbt.func_74768_a("rarity", 2);
            nbt.func_74768_a("tier", 1);
            nbt.func_74768_a("type", this.type);
            nbt.func_74768_a("subType", this.subType);
        }
        gear.func_77982_d(nbt);
    }

    void setStats(int armorVersion, int pieceID) {
        int[][][] stats = new int[][][]{new int[][]{{4, 3, 2, 2}, {3, 3, 1, 2}, {3, 2, 3, 3}}, new int[][]{{3, 3, 4, 3}, {2, 2, 3, 3}, {1, 2, 3, 2}}};
        this.meleeDmg = stats[armorVersion][pieceID][0];
        this.defense = stats[armorVersion][pieceID][1];
        this.kiPower = stats[armorVersion][pieceID][2];
        this.kiDefense = stats[armorVersion][pieceID][3];
        int[][] fullSet = new int[][]{{1, 2, -2, -1}, {-2, -1, 2, 1}};
        this.str = fullSet[armorVersion][0];
        this.dex = fullSet[armorVersion][1];
        this.wil = fullSet[armorVersion][2];
        this.eng = fullSet[armorVersion][3];
    }

    public static ItemStack setArmorVersion(ItemStack itemStack, int armorVersion) {
        NBTTagCompound nbt = itemStack.func_77942_o() ? itemStack.func_77978_p() : new NBTTagCompound();
        nbt.func_74768_a("version", armorVersion);
        itemStack.func_77982_d(nbt);
        return itemStack;
    }

    public void func_77624_a(ItemStack armor, EntityPlayer player, List list, boolean p_77624_4_) {
        try {
            if (armor.func_77942_o()) {
                boolean holdingShift;
                NBTTagCompound nbt = armor.func_77978_p();
                StringBuilder enhanceLimit = new StringBuilder(EnumChatFormatting.GRAY + "");
                String[] armorStats = nbt.func_74779_i("armorStats").split(",");
                String[] armorEnhance = nbt.func_74779_i("armorEnhance").split(",");
                String[] armorLimit = nbt.func_74779_i("armorLimit").split(",");
                int armorVersion = nbt.func_74762_e("version");
                if (this.fullSetBonus.contains("Warrior of Conton!")) {
                    this.setStats(armorVersion, this.armorPiece - 1);
                }
                float enhanceTotalCount = nbt.func_74760_g("enhanceCount");
                int enhanceAmount = (int)((float)Integer.parseInt(armorLimit[0]) - enhanceTotalCount);
                for (int i = 0; i < enhanceAmount; ++i) {
                    enhanceLimit.append("|");
                }
                boolean inCosmeticSlot = ExtendedPlayer.get((EntityPlayer)player).inventory.func_70301_a(11 + this.armorPiece) == armor;
                boolean isOwner = !nbt.func_74764_b("owner") || nbt.func_74779_i("owner").equals(Main.mc.field_71439_g.func_70005_c_());
                boolean bl = holdingShift = ClientKeyHandler.isKeyPressed((int)42) || ClientKeyHandler.isKeyPressed((int)54);
                if (inCosmeticSlot && !holdingShift) {
                    list.add("");
                    list.add(EnumChatFormatting.RED + "This piece of gear is equipped in the cosmetic slot");
                    list.add(EnumChatFormatting.GRAY + "All stat benefits from this piece are disabled");
                    list.add(EnumChatFormatting.YELLOW + "Hold the (Shift) Key to see Stats");
                } else if (!isOwner && !holdingShift) {
                    list.add("");
                    list.add(EnumChatFormatting.RED + "This piece of gear is not yours!");
                    list.add(EnumChatFormatting.GRAY + "All stat benefits from this piece are disabled");
                    list.add(EnumChatFormatting.YELLOW + "Hold the (Shift) Key to see Stats");
                } else {
                    list.add("");
                    list.add(EnumChatFormatting.GOLD + "Armor Stats: ");
                    String[] stat = new String[]{"Melee DMG", "Defense", "Ki Power", "Ki Defense", "Health", "Stamina", "Max Ki"};
                    int[] value = new int[]{this.meleeDmg, this.defense, this.kiPower, this.kiDefense};
                    EnumChatFormatting[] armorColor = new EnumChatFormatting[]{EnumChatFormatting.DARK_RED, EnumChatFormatting.BLUE, EnumChatFormatting.AQUA, EnumChatFormatting.GREEN, EnumChatFormatting.DARK_GREEN, EnumChatFormatting.YELLOW, EnumChatFormatting.DARK_BLUE};
                    EnumChatFormatting[] armorColor2 = new EnumChatFormatting[]{EnumChatFormatting.GRAY, EnumChatFormatting.GOLD};
                    for (int i = 0; i < armorStats.length; ++i) {
                        if (i >= 4 && (i < 4 || armorStats[i].equalsIgnoreCase("") || armorEnhance[i].equalsIgnoreCase("") || Integer.parseInt(armorStats[i]) == 0)) continue;
                        float statCount = value[i];
                        float enhanceCount = Integer.parseInt(armorEnhance[i]);
                        list.add(armorColor2[i < 4 ? 0 : 1] + stat[i] + ": " + this.getPointsInStat(armorColor[i], (int)statCount) + this.getPointsInStat(EnumChatFormatting.DARK_PURPLE, (int)enhanceCount) + enhanceLimit + " " + EnumChatFormatting.GRAY + "[" + armorColor[i] + Math.round(statCount) + EnumChatFormatting.GRAY + "]" + (enhanceCount != 0.0f ? " " + EnumChatFormatting.GRAY + "[" + EnumChatFormatting.DARK_PURPLE + "+" + Math.round(enhanceCount) + EnumChatFormatting.GRAY + "]" : "") + " " + EnumChatFormatting.GRAY + BridgeUtils.convertDecimalToPercent(1.0f + statCount * Methods.gearStatFactor + enhanceCount * Methods.gearEnhanceFactor + enhanceTotalCount * Methods.gearEnhanceTotalFactor));
                    }
                    list.add(EnumChatFormatting.GRAY + "Each enhance into a stat provides a " + EnumChatFormatting.DARK_PURPLE + BridgeUtils.convertDecimalToPercent(1.0f + Methods.gearStatFactor) + EnumChatFormatting.GRAY + " increase ");
                    list.add(EnumChatFormatting.GRAY + "along with " + EnumChatFormatting.DARK_PURPLE + BridgeUtils.convertDecimalToPercent(1.0f + Methods.gearEnhanceTotalFactor) + EnumChatFormatting.GRAY + " into other stats.");
                    if (enhanceAmount > 0) {
                        list.add(EnumChatFormatting.DARK_PURPLE + "Enhancements Remaining: " + enhanceAmount + (nbt.func_74764_b("enhanceRate") ? (nbt.func_74769_h("enhanceRate") != 100.0 ? EnumChatFormatting.GRAY + " at " + (nbt.func_74769_h("enhanceRate") >= 90.0 ? EnumChatFormatting.AQUA : (nbt.func_74769_h("enhanceRate") >= 75.0 ? EnumChatFormatting.GREEN : (nbt.func_74769_h("enhanceRate") >= 55.0 ? EnumChatFormatting.GOLD : (nbt.func_74769_h("enhanceRate") >= 30.0 ? EnumChatFormatting.RED : (nbt.func_74769_h("enhanceRate") >= 5.0 ? EnumChatFormatting.DARK_RED : ""))))) + "" + nbt.func_74769_h("enhanceRate") + "% Chance" : "") : EnumChatFormatting.GRAY + " at " + EnumChatFormatting.GOLD + "100% Chance"));
                    }
                    list.add("");
                    list.add(EnumChatFormatting.GREEN + "Full Set Bonus: " + this.fullSetBonus + (this.fullSetBonus.contains("Warrior of Conton!") ? EnumChatFormatting.YELLOW + " (" + (armorVersion == 1 ? EnumChatFormatting.AQUA + "Ki" : EnumChatFormatting.RED + "Melee") + EnumChatFormatting.YELLOW + " Version)" : ""));
                    list.add(EnumChatFormatting.GRAY + this.fullSetDesc);
                    list.add("" + (this.str > 0 ? EnumChatFormatting.AQUA : (this.str == 0 ? EnumChatFormatting.GRAY : EnumChatFormatting.RED)) + "STR: " + (this.str > 0 ? "+" : "") + this.str + "%");
                    list.add("" + (this.dex > 0 ? EnumChatFormatting.AQUA : (this.dex == 0 ? EnumChatFormatting.GRAY : EnumChatFormatting.RED)) + "DEX: " + (this.dex > 0 ? "+" : "") + this.dex + "%");
                    list.add("" + (this.wil > 0 ? EnumChatFormatting.AQUA : (this.wil == 0 ? EnumChatFormatting.GRAY : EnumChatFormatting.RED)) + "WIL: " + (this.wil > 0 ? "+" : "") + this.wil + "%");
                    list.add("" + (this.eng > 0 ? EnumChatFormatting.AQUA : (this.eng == 0 ? EnumChatFormatting.GRAY : EnumChatFormatting.RED)) + "ENG: " + (this.eng > 0 ? "+" : "") + this.eng + "%");
                }
                list.add("");
                if (nbt.func_74764_b("owner")) {
                    list.add(EnumChatFormatting.GREEN + "Owner: " + nbt.func_74779_i("owner"));
                }
                list.add(ArmorRegistry.getGearType(this.type, this.subType, "Armor"));
                if (nbt.func_74764_b("rarity")) {
                    switch (nbt.func_74762_e("rarity")) {
                        case 0: 
                        case 1: {
                            list.add(EnumChatFormatting.GRAY + "" + EnumChatFormatting.BOLD + "Common " + this.armorType);
                            break;
                        }
                        case 2: {
                            list.add(EnumChatFormatting.GREEN + "" + EnumChatFormatting.BOLD + "Uncommon " + this.armorType);
                            break;
                        }
                        case 3: {
                            list.add(EnumChatFormatting.BLUE + "" + EnumChatFormatting.BOLD + "Rare " + this.armorType);
                            break;
                        }
                        case 4: {
                            list.add(EnumChatFormatting.LIGHT_PURPLE + "" + EnumChatFormatting.BOLD + "Mythic " + this.armorType);
                            break;
                        }
                        case 5: {
                            list.add(EnumChatFormatting.GOLD + "" + EnumChatFormatting.BOLD + "Legendary " + this.armorType);
                            break;
                        }
                        case 6: {
                            list.add(EnumChatFormatting.LIGHT_PURPLE + "" + EnumChatFormatting.BOLD + "Special " + this.armorType);
                        }
                    }
                }
            } else {
                list.add(ArmorRegistry.getGearType(this.type, this.subType, "Armor"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setupItemTexture(int type, String armorName) {
        if (!armorName.contains("coat")) {
            String typeString = "chest";
            switch (type) {
                case 0: {
                    typeString = "hat";
                    break;
                }
                case 1: {
                    typeString = "chest";
                    break;
                }
                case 2: {
                    typeString = "legs";
                    break;
                }
                case 3: {
                    typeString = "boots";
                }
            }
            this.func_111206_d(ArmorRegistry.getItemTexturePath(armorName, typeString, this.type));
        }
    }

    private void setName(int type, String armorName) {
        if (!armorName.contains("coat")) {
            String typeString = "chest";
            switch (type) {
                case 0: {
                    typeString = "hat";
                    this.armorType = "Hat";
                    break;
                }
                case 1: {
                    typeString = "chest";
                    this.armorType = "Chestpiece";
                    break;
                }
                case 2: {
                    typeString = "legs";
                    this.armorType = "Pants";
                    break;
                }
                case 3: {
                    typeString = "boots";
                    this.armorType = "Boots";
                }
            }
            this.func_77655_b(armorName + "_" + typeString);
        } else {
            this.func_77655_b(armorName);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister IconRegister) {
        this.field_77791_bV = IconRegister.func_94245_a("dbapollo:armor/" + ArmorRegistry.getGearSubTexturePath(this.type) + this.func_77658_a().replaceAll("item.", ""));
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return this.getArmorTexture(stack, entity, slot, type, false);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type, boolean canRender) {
        boolean cosmeticEnabled;
        int slotConversion;
        boolean debug = false;
        if (!(entity instanceof EntityCustomNpc) && !canRender) {
            if (debug) {
                System.out.println("visual nuh uh #1");
            }
            return "dbapollo:textures/armor/visual_disabled.png";
        }
        String[] d2 = JRMCoreH.data((String)entity.func_70005_c_(), (int)2, (String)"0;0;0;0;0;0;0;0;0").split(";");
        String[] d4 = JRMCoreH.data((String)entity.func_70005_c_(), (int)4, (String)"0;0;0;0;0;0;0;0;0").split(";");
        String[] cosmetic = d4[3].split(",");
        String cosmeticItems = d4[4];
        String[] d13 = JRMCoreH.data((String)entity.func_70005_c_(), (int)13, (String)"0;0;0;0;0;0;0;0;0").split(";");
        String[] d18 = JRMCoreH.data((String)entity.func_70005_c_(), (int)18, (String)"0;0;0;0;0;0;0;0;0").split(";");
        int st = Integer.parseInt(d2[0]);
        int rc = Integer.parseInt(d2[2]);
        boolean isFused = Methods.isFused(d18[2]);
        boolean primal = Methods.isInPrimalForm(rc, st) && !isFused;
        boolean primalMode = Methods.isInPrimalMode(rc, st);
        String texture = this.na;
        String[] armorTypes = new String[]{"boots", "legs", "chest", "hat"};
        int n = slot == 0 ? 3 : (slot == 1 ? 2 : (slotConversion = slot == 2 ? 1 : 0));
        boolean bl = !(cosmetic.length != 5 || !cosmetic[0].contains("1") || primalMode && Methods.cosmeticsCheck(d13, 5, true)) ? (slotConversion == 0 && cosmetic[1].contains("1") ? true : (!(slotConversion != 1 || !cosmetic[2].contains("1") || primal && Methods.cosmeticsCheck(d13, 5, true)) ? true : (slotConversion == 2 && cosmetic[3].contains("1") ? true : slotConversion == 3 && cosmetic[4].contains("1")))) : (cosmeticEnabled = false);
        if (cosmeticEnabled && !entity.func_82150_aj() && !isFused && !CharacterCreation.isOpen) {
            if (debug) {
                System.out.println("armor: " + stack.func_77977_a() + " slot: " + slot + " armorType: " + armorTypes[slot]);
            }
            Item cosmeticItem = null;
            if (entity instanceof EntityPlayer && cosmeticItems != null) {
                cosmeticItem = Item.func_150899_d((int)Integer.parseInt(cosmeticItems.split(",")[slotConversion]));
            }
            if (debug) {
                System.out.println("next... stack: " + stack + " | armorType: " + armorTypes[slot]);
            }
            if (cosmeticItem != null) {
                if (debug) {
                    System.out.println("cosmeticItem is " + cosmeticItem.func_77658_a());
                }
                if ((cosmeticItem instanceof ArmorSetup || cosmeticItem instanceof ClothingSetup) && cosmeticItem.func_77658_a().contains(armorTypes[slot])) {
                    String first = cosmeticItem.func_77658_a().split("item.")[1];
                    texture = first.split("_").length > 2 ? first.split("_")[0] + "_" + first.split("_")[1] : first.split("_")[first.split("_").length - 2];
                    if (debug) {
                        System.out.println("cosmetic texture: " + texture);
                    }
                    return ArmorRegistry.getGearTexturePath(texture, slot);
                }
            } else if (stack.func_77977_a().contains(armorTypes[slot])) {
                if (debug) {
                    System.out.println("armor texture: " + texture);
                }
                return ArmorRegistry.getGearTexturePath(texture, slot, this.type);
            }
        } else if (entity instanceof EntityCustomNpc) {
            return ArmorRegistry.getGearTexturePath(texture, slot, this.type);
        }
        if (debug) {
            System.out.println("visual nuh uh #2");
        }
        return "dbapollo:textures/armor/visual_disabled.png";
    }

    public String getPointsInStat(EnumChatFormatting color, int stat) {
        StringBuilder bar = new StringBuilder(color + "");
        for (int i = 0; i < stat; ++i) {
            bar.append("|");
        }
        return bar.toString();
    }
}

