/*
 * Decompiled with CFR 0.152.
 */
package net.MCApolloNetwork.ApolloCrux.Bridge.Utils;

import JinRyuu.JRMCore.JRMCoreH;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.MCApolloNetwork.ApolloCrux.Bridge.Main;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.Methods;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.Packets.BridgePD;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.Variables;
import net.MCApolloNetwork.ApolloCrux.Client.Events.ClientHandler;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.ClientUtils;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.InfoHandler;
import net.MCApolloNetwork.ApolloCrux.Server.MySql.SqlDriver;
import net.MCApolloNetwork.ApolloCrux.Server.Utilities.FormTechs.FormUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public class BridgeUtils {
    public static final String[] statTags = new String[]{"jrmcStrI", "jrmcDexI", "jrmcCnsI", "jrmcWilI", "jrmcIntI", "jrmcCncI"};
    public static final String[] statTagsR = new String[]{"jrmcStrR", "jrmcDexR", "jrmcCnsR", "jrmcWilR", "jrmcIntR", "jrmcCncR"};
    public static final int statCap = 100000;
    public static final double TPupgradeCost = 0.12;
    public static final int TPminUpgradeCost = 16;
    public static final int TPmaxUpgradeCost = 1000000000;
    public static final int startingTP = 500;
    public static final String[] statNames = new String[]{EnumChatFormatting.RED + "STR", EnumChatFormatting.DARK_GREEN + "DEX", EnumChatFormatting.GOLD + "CON", EnumChatFormatting.AQUA + "WIL", EnumChatFormatting.DARK_AQUA + "ENG", EnumChatFormatting.BLUE + "SPI"};
    public static final int[] statColors = new int[]{0xFF5555, 43520, 0xFFAA00, 0x55FFFF, 43690, 0x5555FF};
    public static final String[][] techniques = new String[][]{{"kk1", "kk2", "kk3", "kk4", "kk5", "kk6"}, {"fusion1"}};
    public static final String[] techniqueList = new String[]{"kk", "fusion"};
    public static final String[] forms = new String[]{"25,26,27,10,35", "17,18,19,11,35", "17,18,19,11,35", "28,29,30,12,35", "22,23,24,13,35", "40,41,42,14,35", "45,46,47,15,35"};
    public static final String formsList = "10,25,26,27, 11,17,18,19, 12,28,29,30, 13,22,23,24, 14,40,41,42, 15,45,46,47, 35";
    public static final String racialList = "90,25,26,27, 91,17,18,19, 92,28,29,30, 93,22,23,24, 94,40,41,42, 95,45,46,47";
    public static int[] formCount = new int[]{6, 6, 6, 6, 6, 6};
    public static final float[][] humanRaceStats = new float[][]{{2.9f, 2.7f, 3.1f}, {4.4f, 3.6f, 4.0f}, {20.0f, 22.0f, 24.0f}, {3.55f, 3.15f, 3.85f}, {5.8f, 6.3f, 5.3f}, {4.0f, 4.2f, 3.8f}, {40.0f, 44.0f, 36.0f}, {1.0f, 1.1f, 1.1f}, {1.05f, 1.0f, 0.95f}};
    public static final float[][] saiyanRaceStats = new float[][]{{3.0f, 2.8f, 3.3f}, {4.4f, 3.6f, 3.9f}, {21.0f, 23.0f, 25.0f}, {3.5f, 3.1f, 3.8f}, {6.1f, 6.5f, 5.6f}, {3.9f, 4.2f, 3.7f}, {40.0f, 44.0f, 36.0f}, {1.15f, 1.2f, 1.2f}, {0.9f, 0.85f, 0.8f}};
    public static final float[][] halfSaiyanRaceStats = new float[][]{{2.8f, 2.6f, 3.1f}, {4.5f, 3.7f, 4.0f}, {22.0f, 24.0f, 26.0f}, {3.6f, 3.2f, 3.9f}, {6.3f, 6.7f, 5.8f}, {4.1f, 4.2f, 3.9f}, {41.0f, 45.0f, 37.0f}, {1.05f, 1.1f, 1.1f}, {1.0f, 0.9f, 0.85f}};
    public static final float[][] namekianRaceStats = new float[][]{{2.7f, 2.5f, 2.9f}, {4.3f, 3.5f, 3.8f}, {24.0f, 25.0f, 27.0f}, {3.4f, 2.9f, 3.7f}, {6.8f, 7.3f, 6.3f}, {4.3f, 4.5f, 4.1f}, {48.0f, 52.0f, 44.0f}, {1.05f, 1.1f, 1.1f}, {0.95f, 0.9f, 0.85f}};
    public static final float[][] arcosianRaceStats = new float[][]{{2.8f, 2.6f, 3.1f}, {4.5f, 3.8f, 4.0f}, {23.0f, 24.0f, 25.0f}, {3.4f, 3.0f, 3.7f}, {6.5f, 6.9f, 6.1f}, {4.0f, 4.2f, 3.8f}, {43.0f, 47.0f, 41.0f}, {1.15f, 1.25f, 1.2f}, {1.15f, 1.1f, 1.05f}};
    public static final float[][] majinRaceStats = new float[][]{{2.8f, 2.6f, 3.0f}, {4.6f, 3.9f, 4.2f}, {25.0f, 26.0f, 28.0f}, {3.6f, 3.2f, 3.9f}, {5.9f, 6.4f, 5.4f}, {4.2f, 4.4f, 3.5f}, {41.0f, 45.0f, 37.0f}, {1.15f, 1.2f, 1.2f}, {1.1f, 1.0f, 0.95f}};
    public static final int[][] startingStats = new int[][]{{15, 10, 25, 15, 10, 15, 90}, {5, 5, 15, 30, 15, 20, 90}, {20, 15, 25, 10, 5, 15, 90}};
    public static int[][] raceStates = new int[][]{{0, 10, 1, 2, 3, 4, 5, 6}, {0, 7, 1, 5, 6, 12, 9, 10}, {0, 7, 1, 5, 6, 12, 9, 10}, {0, 10, 1, 2, 3, 4, 5, 6}, {0, 10, 2, 3, 4, 5, 7, 6}, {0, 10, 1, 2, 3, 4, 5, 6}};
    public static final String[] races = new String[]{"Human", "Saiyan", "Half-Saiyan", "Namekian", "Arcosian", "Majin"};
    static String[] PlyrSttngs = new String[]{"K", "R", "D", "G", "Z", "B", "M", "E", "O", "F", "P", "U", "I", "S"};
    public static final String usersWithAccess = "XeroZon,Kat_The_Neko,PreciseRook,MunchkinBoy12,JongaBon";
    public static final String[] raceDescriptions = new String[]{"Humans have the best stamina control of any race, able to outlast others and get back into the fray much sooner then their foes.", "Full Blooded Saiyans are a powerful damage role, what they lack in defense they make up for it with powerful strikes and ki abilities.", "Half Saiyans are a well rounded fighter, able to fit into any role or style with ease.", "Namekians are a powerful ki user race, able to blast foes with devastating ki attacks or fight close up and personal with their bulky nature", "Arcosians are a quick agile class who exert a lot of energy in attempt to finish their foes quickly", "Majins are defensive tanks, able to take heavy hits and outlast their foes until the very end"};
    public static final String[] classDescriptions = new String[]{"Martial Artist is a balanced class, able to handle whatever comes at them in a variety of styles", "Spiritualist is a powerful ki users who prefer to fight just out of reach of their foes", "Warrior is a powerful melee class, unleashing powerful strikes to finish their foes quickly"};
    public static final String[] statisticNames = new String[]{"Strength", "Dexterity", "Constitution", "WillPower", "Energy", "Spirit"};
    public static final String[] statisticDescriptions = new String[]{"Strength, Increases Melee Damage\n\nGreat for Melee Builds", "Dexterity, Increases Defense & Ki Defense (40% Effectiveness)\n\nGreat for Melee Builds", "Constitution, Increases Health and Stamina\n\nGreat for All Stat Builds", "WillPower, Increases Ki Power (Energy Attack Damage)\n\nGreat for Ki Builds", "Energy, Increase Ki Defense\n\nGreat for Ki Builds", "Spirit, Increases Max Ki\n\nGreat for All Stat Builds"};
    public static final String[] outputStatNames = new String[]{"Melee Dmg", "Defense", "Health", "Stamina", "Ki Power", "Max Ki", "Running", "Flying", "", "", "", "", "Ki Defense"};
    public static final float[][] minMaxOutputStats = new float[][]{{2.5f, 3.3f}, {3.5f, 4.6f}, {20.0f, 28.0f}, {2.9f, 3.9f}, {5.3f, 7.3f}, {3.5f, 4.5f}, {36.0f, 52.0f}, {0.15f, 0.45f}};
    public static final String[] tutorialText = new String[]{"Hello and welcome to Dragon Block Apollo! We're going to start you off by creating your character!", "Now that you've created your character, we'll explain the basics of upgrading your stats.", "Stats can be upgraded by clicking the \"+\" button. The \"UC\" can be seen below your stats, this value is how much it costs per stat upgrade. You've been given 500 tp to upgrade some stats, to know what a specific stat does you can hover over the stat in the menu.", "Skills are obtained from Story Quest Completion (Z Story Line) You can hover over each Skill for more details on that Skill!", "Ki Attacks can be created at the cost of TP, you start with a few Ki Attacks depending on the Class you choose!", "Forms can be unlocked mostly from Story Quest Completion, however a few forms have special unlock requirements. You can see these details by hovering over each form entry!", "Techniques are obtained from Story Quest Completion, you can hover over each technique entry for more details!", "TP Boosters can be used to increase the tp gained per tp gem consumed! Pressing each TP Booster Icon will use that booster for the specified time!", "Now it's time for you to start your very own adventure here on Dragon Block Apollo! We'll begin by having you start our Dragon Ball Z Story-Line. Head to \"/warp Quests\" to begin", "", ""};
    public static final String[] tutorialTextHelpMenu = new String[]{"The Help Menu is a menu full of useful information, you should check this to find answers to questions before you ask in chat. If you have any suggestions for us to add more in here, let us know!", "The Useful Commands Menu contains a list of important commands that you may otherwise not know about.", "The List of Tips Menu shows a list of the Tips that you would otherwise see in the bottom right of your screen while playing!"};
    public static int[] techCol = new int[]{0, 0xFFFFFF, 53999, 13801198, 14812441, 328965, 5695066, 16706880, 16625664};
    public static int[] techCol2 = new int[]{0, 0xFFFFFF, 12575487, 0xF7D7FF, 16736618, 328965, 0xA5FFA5, 16775651, 16633177};
    public static int[] techCol3 = new int[]{0, 0x7D7D7D, 2499671, 2559542, 4786450, 197379, 2505498, 3477505, 6170377};
    public static String[] techColName = new String[]{"Default", "White", "Blue", "Purple", "Red", "Black", "Green", "Yellow", "Orange"};
    public static final String[] techDBCTypes = new String[]{"Wave", "Blast", "Disk", "Laser", "Spiral", "BigBlast", "Barrage"};
    public static final float[] kiTypeDamage = new float[]{0.65f, 1.4f, 1.45f, 1.25f, 1.85f, 3.75f, 0.15f};
    public static final float[] kiTypeUsage = new float[]{2.2f, 1.1f, 1.5f, 1.25f, 2.35f, 3.55f, 0.2f};
    public static final float[] kiTypeTPCost = new float[]{0.75f, 0.3f, 0.5f, 0.4f, 0.55f, 0.7f, 0.1f};
    public static final float[] kiTypeSize = new float[]{3.5f, 2.0f, 2.0f, 1.5f, 3.0f, 10.0f, 0.7f};
    public static final float[] kiTypeHitBoxSize = new float[]{0.6f, 0.9f, 0.75f, 0.25f, 0.6f, 0.3f, 0.7f};
    public static final float[] techDBCct = new float[]{5.0f, 2.0f, 2.5f, 1.75f, 3.5f, 7.5f, 0.13f};
    public static final float[] techDBCcd = new float[]{20.0f, 5.0f, 6.0f, 4.5f, 7.0f, 17.0f, 0.4f};
    public static final String[] techDBCSpeed = new String[]{"Slow", "Average", "Fast", "Very Fast"};
    public static final float[] techDBCaddSPCost = new float[]{0.5f, 0.6f, 0.7f, 0.8f};
    public static final byte[] techDBCstatsDefault = new byte[]{0, 0, 0, 0, 0, 0, 0};
    public static final String[] defaultKiAttacks = new String[]{"Ki Blast;1;Server;1;1;100;1;0;0;0;0;1;0;0;0", "Ki Wave;1;Server;0;1;100;0;0;0;0;0;1;5;5;0", "Ki Barrage;1;Server;6;1;100;1;0;0;0;0;1;0;0;0", "Large Ki Blast;1;Server;5;1;100;1;0;0;0;0;1;3;3;0"};
    public static final int[] techBase = new int[]{1, 0, 1, 1, 1, 10, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1};
    public static final int[] techMin = new int[]{1, 0, 1, 0, 0, 10, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1};
    public static final int[] techMax = new int[]{20, 1, 30, 6, 2, 100, 1, 0, 0, 0, 8, 3, 10, 10, 10, 100};
    public static final int[] techUpg = new int[]{0, 0, 0, 1, 1, 10, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1};
    public static Item ItemBlackStarDragonBlock;
    public static Block BlockBlackStarDragonBall;
    public static float formMulti;
    public static float strMulti;
    public static float dexMulti;
    public static float conMulti;
    public static float wilMulti;
    public static float engMulti;
    public static float spiMulti;
    public static float extraMulti;
    public static float formMultiStack;
    public static float strMultiStack;
    public static float dexMultiStack;
    public static float conMultiStack;
    public static float wilMultiStack;
    public static float engMultiStack;
    public static float spiMultiStack;
    public static float formMultiDif;
    public static float strMultiDif;
    public static float dexMultiDif;
    public static float conMultiDif;
    public static float wilMultiDif;
    public static float engMultiDif;
    public static float spiMultiDif;
    public static float formStamUsage;
    public static float formStamRegen;
    public static boolean isServerSide;
    public static final int[][] BPstatWeight;
    public static final float[] movementSpeedBase;
    public static final float[][] movementSpeedRaces;
    static final float[] movementSpeedForms;
    static final float[][] movementSpeedTechs;
    public static final float[] movementSpeedSkills;
    public static final Object[][] buildInfo;
    private static TrustManager[] trustAllCerts;
    private static HostnameVerifier allHostsValid;
    public static final Map<String, Long> performanceTimer;

    public static int getStat(String getType, byte pwr, int stat, int statLv, byte rc, byte cl, float sklLv, EntityPlayer player) {
        boolean debug = false;
        if (debug) {
            System.out.println("getStat ran for Stat: " + stat + " at Level: " + statLv);
        }
        try {
            if (getType.equals("server") && JRMCoreH.getByte((EntityPlayer)player, (String)"jrmcAccept") == 1 && SqlDriver.isSlotLoaded((EntityPlayer)player) || !getType.equals("server") && JRMCoreH.Accepted == 1 && BridgeUtils.isDataLoaded()) {
                float[][] raceStats;
                boolean surgeToggle;
                byte st2;
                float fullSetBonus;
                int armorStat;
                int release;
                int n = sklLv != -2.0f ? (getType.equals("server") ? (int)JRMCoreH.getByte((EntityPlayer)player, (String)"jrmcRelease") : (int)JRMCoreH.curRelease) : (release = 100);
                int n2 = stat == 0 || stat == 6 || stat == 8 ? 0 : (stat == 1 || stat == 9 ? 1 : (stat == 4 ? 2 : (stat == 11 ? 3 : (stat == 2 ? 4 : (stat == 5 ? 5 : (armorStat = stat == 3 ? 6 : 0))))));
                float f = armorStat <= 3 ? (getType.equals("server") && JRMCoreH.getString((EntityPlayer)player, (String)"fullSetBonus").split(",").length == 7 ? Float.parseFloat(JRMCoreH.getString((EntityPlayer)player, (String)"fullSetBonus").split(",")[armorStat]) : Methods.getArmorFullSet(player, armorStat)) : (fullSetBonus = -1.0f);
                float armorBonus = getType.equals("server") ? (JRMCoreH.getString((EntityPlayer)player, (String)"armorStats").split(",").length == 7 ? Float.parseFloat(JRMCoreH.getString((EntityPlayer)player, (String)"armorStats").split(",")[armorStat]) : 1.0f) : Methods.getArmorStats(player, armorStat);
                float skillBoost = BridgeUtils.getSkillBoost(getType, false, pwr, stat, statLv, rc, cl, sklLv, player);
                if (debug) {
                    System.out.println("getStat | stat: " + stat + " at lv: " + statLv + " release: " + release + " | armorStat: " + armorStat + " fullSetBonus: " + fullSetBonus + " armorBonus: " + armorBonus);
                }
                byte by = st2 = getType.equals("server") ? JRMCoreH.getByte((EntityPlayer)player, (String)"jrmcState2") : JRMCoreH.State2;
                boolean raceState = getType.equals("server") ? JRMCoreH.getInt((EntityPlayer)player, (String)"daRaceState") == 1 : Variables.getValue("daRaceState").floatValue() == 1.0f;
                boolean instaKill = getType.equals("server") && player.getEntityData().func_74762_e("instaKill") == 1;
                boolean noDamage = getType.equals("server") && player.getEntityData().func_74762_e("noDamage") == 1;
                boolean bl = surgeToggle = getType.equals("server") ? player.getEntityData().func_74764_b("surgeToggle") : Variables.hasValue("surgeBar");
                float[][] fArray = rc == 0 ? humanRaceStats : (rc == 1 ? saiyanRaceStats : (rc == 2 ? halfSaiyanRaceStats : (rc == 3 ? namekianRaceStats : (rc == 4 ? arcosianRaceStats : (raceStats = rc == 5 ? majinRaceStats : (float[][])null)))));
                if (sklLv != 3.0f) {
                    String[] multiArray = null;
                    String[] multiArrayStack = null;
                    String[] multiArrayDif = null;
                    if (getType.equals("server")) {
                        multiArray = JRMCoreH.getString((EntityPlayer)player, (String)"lastMult").split(",");
                        multiArrayStack = JRMCoreH.getString((EntityPlayer)player, (String)"lastMultStack").split(",");
                        multiArrayDif = JRMCoreH.getString((EntityPlayer)player, (String)"lastMultDif").split(",");
                        extraMulti = JRMCoreH.getFloat((EntityPlayer)player, (String)"lastMultExtra");
                    } else {
                        String[] d10 = JRMCoreH.data((String)player.func_70005_c_(), (int)10, (String)"0;0;0;0;0;0").split(";");
                        if (d10.length >= 6) {
                            if (d10[2].contains(",")) {
                                multiArray = d10[2].split(",");
                            }
                            if (d10[3].contains(",")) {
                                multiArrayStack = d10[3].split(",");
                            }
                            if (d10[4].contains(",")) {
                                multiArrayDif = d10[4].split(",");
                            }
                            extraMulti = Float.parseFloat(d10[5]);
                        }
                    }
                    if (multiArray != null) {
                        formMulti = Float.parseFloat(multiArray[0]);
                        strMulti = Float.parseFloat(multiArray[1]);
                        dexMulti = Float.parseFloat(multiArray[2]);
                        conMulti = Float.parseFloat(multiArray[3]);
                        wilMulti = Float.parseFloat(multiArray[4]);
                        engMulti = Float.parseFloat(multiArray[5]);
                        spiMulti = Float.parseFloat(multiArray[6]);
                    }
                    if (multiArrayDif != null) {
                        formMultiStack = Float.parseFloat(multiArrayStack[0]);
                        strMultiStack = Float.parseFloat(multiArrayStack[1]);
                        dexMultiStack = Float.parseFloat(multiArrayStack[2]);
                        conMultiStack = Float.parseFloat(multiArrayStack[3]);
                        wilMultiStack = Float.parseFloat(multiArrayStack[4]);
                        engMultiStack = Float.parseFloat(multiArrayStack[5]);
                        spiMultiStack = Float.parseFloat(multiArrayStack[6]);
                    }
                    if (multiArrayDif != null) {
                        formMultiDif = Float.parseFloat(multiArrayDif[0]);
                        strMultiDif = Float.parseFloat(multiArrayDif[1]);
                        dexMultiDif = Float.parseFloat(multiArrayDif[2]);
                        conMultiDif = Float.parseFloat(multiArrayDif[3]);
                        wilMultiDif = Float.parseFloat(multiArrayDif[4]);
                        engMultiDif = Float.parseFloat(multiArrayDif[5]);
                        spiMultiDif = Float.parseFloat(multiArrayDif[6]);
                    }
                }
                if (stat == 0) {
                    int meleeDamage = (int)((float)statLv * fullSetBonus * raceStats[0][cl] * BridgeUtils.round(10000.0f, formMulti * strMulti) * skillBoost * armorBonus * (float)release / 100.0f);
                    return instaKill ? Integer.MAX_VALUE : meleeDamage;
                }
                if (stat == 1) {
                    int defense = (int)((float)statLv * fullSetBonus * raceStats[1][cl] * BridgeUtils.round(10000.0f, formMulti * dexMulti) * skillBoost * armorBonus * (float)release / 100.0f);
                    return instaKill || noDamage ? Integer.MAX_VALUE : defense;
                }
                if (stat == 2) {
                    int health = (int)((float)statLv * raceStats[2][cl] * BridgeUtils.round(10000.0f, conMulti) * armorBonus);
                    return health;
                }
                if (stat == 3) {
                    int stamina = (int)((float)statLv * raceStats[3][cl] * BridgeUtils.round(10000.0f, conMulti) * armorBonus);
                    return stamina;
                }
                if (stat == 4) {
                    int kiPower = (int)((float)statLv * fullSetBonus * raceStats[4][cl] * BridgeUtils.round(10000.0f, formMulti * wilMulti) * armorBonus * (float)release / 100.0f);
                    return instaKill ? Integer.MAX_VALUE : kiPower;
                }
                if (stat == 5) {
                    int maxKi = (int)((float)statLv * raceStats[6][cl] * BridgeUtils.round(10000.0f, spiMulti) * skillBoost * armorBonus);
                    return maxKi;
                }
                if (stat == 6) {
                    int staminaUsage = -Math.round((float)statLv * fullSetBonus * raceStats[0][cl] * 0.05f * raceStats[7][cl] * (float)release / 100.0f);
                    return Math.min(staminaUsage, -3);
                }
                if (stat == 7) {
                    if (!getType.equals("server")) {
                        formStamRegen = Math.round(Variables.getValue("lastStamRegen").floatValue());
                    }
                    int staminaRegen = (int)((float)statLv * 0.1f * (raceStats[8][cl] * 0.8f) * 2.0f);
                    return Math.max(staminaRegen, 2);
                }
                if (stat == 8) {
                    int kiFistUsage = -Math.round((float)statLv * fullSetBonus * raceStats[0][cl] * 0.03f * skillBoost * armorBonus * (float)release / 100.0f);
                    return kiFistUsage;
                }
                if (stat == 9) {
                    int kiProtUsage = -Math.round((float)statLv * 0.4f * fullSetBonus * raceStats[1][cl] * 0.03f * BridgeUtils.getSkillBoost(getType, false, pwr, stat, (int)((float)statLv * 0.4f), rc, cl, sklLv, player) * armorBonus * (float)release / 100.0f);
                    return kiProtUsage;
                }
                if (stat == 10) {
                    int kiPower = (int)((float)statLv * raceStats[4][cl]);
                    return kiPower;
                }
                if (stat == 11) {
                    int kiDefense = (int)((float)statLv * fullSetBonus * raceStats[5][cl] * BridgeUtils.round(10000.0f, formMulti * engMulti) * skillBoost * armorBonus * (float)release / 100.0f);
                    return instaKill || noDamage ? Integer.MAX_VALUE : kiDefense;
                }
                if (stat == 13) {
                    int kiPower = (int)((float)statLv * fullSetBonus * raceStats[4][cl] * armorBonus);
                    return kiPower;
                }
                if (stat == 14) {
                    int kiProtUsage = -Math.round((float)statLv * 0.65f * fullSetBonus * raceStats[5][cl] * 0.03f * BridgeUtils.getSkillBoost(getType, false, pwr, stat, (int)((float)statLv * 0.65f), rc, cl, sklLv, player) * armorBonus * (float)release / 100.0f);
                    return kiProtUsage;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 10;
    }

    public static float getSkillBoost(String getType, boolean bypassEnable, byte pwr, int stat, int statLv, byte rc, byte cl, float sklLv, EntityPlayer player) {
        float spi;
        float skillBoost = 1.0f;
        float ratio = 0.0f;
        int skillLv = 0;
        if (stat == 0) {
            float str;
            if (getType.equals("server")) {
                if (!JRMCoreH.PlyrSettingsB((EntityPlayer)player, (int)9) || bypassEnable) {
                    str = JRMCoreH.getInt((EntityPlayer)player, (String)"jrmcStrI");
                    spi = JRMCoreH.getInt((EntityPlayer)player, (String)"jrmcCncI");
                    ratio = Math.min(1.0f, spi / str);
                    skillLv = JRMCoreH.SklLvl((int)12, (String[])Methods.PlyrSkills(player, true));
                }
            } else if (getType.equals("client") && (!JRMCoreH.PlyrSettingsB((int)9) || bypassEnable)) {
                str = JRMCoreH.PlyrAttrbts[0];
                spi = JRMCoreH.PlyrAttrbts[5];
                ratio = Math.min(1.0f, spi / str);
                skillLv = JRMCoreH.SklLvl((int)12);
            }
            skillBoost = (float)(1.0 + (double)skillLv * 0.01 * (double)ratio);
        }
        if (stat == 1 || stat == 11) {
            float dex;
            if (getType.equals("server")) {
                if (!JRMCoreH.PlyrSettingsB((EntityPlayer)player, (int)10) || bypassEnable) {
                    dex = JRMCoreH.getInt((EntityPlayer)player, (String)"jrmcDexI");
                    spi = JRMCoreH.getInt((EntityPlayer)player, (String)"jrmcCncI");
                    ratio = Math.min(1.0f, spi / dex);
                    skillLv = JRMCoreH.SklLvl((int)11, (String[])Methods.PlyrSkills(player, true));
                }
            } else if (getType.equals("client") && (!JRMCoreH.PlyrSettingsB((int)10) || bypassEnable)) {
                dex = JRMCoreH.PlyrAttrbts[1];
                spi = JRMCoreH.PlyrAttrbts[5];
                ratio = Math.min(1.0f, spi / dex);
                skillLv = JRMCoreH.SklLvl((int)11);
            }
            skillBoost = (float)(1.0 + (double)skillLv * 0.01 * (double)ratio);
        }
        if (stat == 5) {
            skillLv = getType.equals("server") ? JRMCoreH.SklLvl((int)13, (String[])Methods.PlyrSkills(player, true)) : JRMCoreH.SklLvl((int)13);
            skillBoost = (float)(1.0 + (double)skillLv * 0.015);
        }
        return skillBoost;
    }

    public static float getSurgeMulti() {
        boolean surgeActive;
        float surgeBar = 1.0f;
        float surgeBoost = 0.15f;
        boolean bl = surgeActive = Variables.hasValue("surgeActive") && Variables.getValue("surgeActive").floatValue() == 1.0f;
        if (Variables.hasValue("surgeBar")) {
            surgeBar = Variables.getValue("surgeBar").floatValue();
        }
        if (Variables.hasValue("surgeBoost")) {
            surgeBoost = Variables.getValue("surgeBoost").floatValue();
        }
        surgeBar = surgeActive ? 2.0f : surgeBar - 1.0f;
        float multi = 1.0f + surgeBoost * surgeBar;
        return multi;
    }

    public static int getBattlePower(String getType, EntityPlayer player) {
        return BridgeUtils.getBattlePower(getType, player, JRMCoreH.curRelease);
    }

    public static int getBattlePower(String getType, EntityPlayer player, int release) {
        if (getType.equals("client") && JRMCoreH.Accepted == 1) {
            int battlePower = 0;
            ArrayList<Integer> battlePowerArray = BridgeUtils.getBattlePowerArray(player, release);
            for (int stat = 0; stat < 6; ++stat) {
                battlePower += battlePowerArray.get(stat).intValue();
            }
            return battlePower;
        }
        return 100;
    }

    public static ArrayList<Integer> getBattlePowerArray(EntityPlayer player, int release) {
        ArrayList<Integer> battlePowerArray = new ArrayList<Integer>();
        byte cls = JRMCoreH.Class;
        for (int stat = 0; stat < 6; ++stat) {
            float fullSetBonus;
            int armorStat = stat == 0 ? 0 : (stat == 1 ? 1 : (stat == 3 ? 2 : (stat == 4 ? 3 : 0)));
            float f = fullSetBonus = armorStat <= 3 ? Methods.getArmorFullSet(player, armorStat) : -1.0f;
            float statMulti = stat == 0 ? strMulti : (stat == 1 ? dexMulti : (stat == 2 ? conMulti : (stat == 3 ? wilMulti : (stat == 4 ? engMulti : (stat == 5 ? spiMulti : 0.0f)))));
            float realMulti = formMulti * statMulti;
            if ((stat == 2 || stat == 5) && strMulti != 1.0f) {
                float avgMulti = (strMulti + dexMulti + wilMulti + engMulti) / 4.0f;
                realMulti = formMulti == 1.0f ? avgMulti : formMulti + avgMulti;
            }
            int statReturn = (int)((float)JRMCoreH.PlyrAttrbts[stat] * fullSetBonus * (float)BPstatWeight[cls][stat] * BridgeUtils.round(10000.0f, realMulti));
            battlePowerArray.add(statReturn / 100 * release);
        }
        return battlePowerArray;
    }

    public static int getKiUtil(EntityPlayer player, int curAtr, int type, int speed, int density, String util) {
        double kiDamage = curAtr;
        if (util.contains("damage")) {
            return (int)(kiDamage * (double)(player.getEntityData().func_74764_b("kiTypeDamage") ? player.getEntityData().func_74760_g("kiTypeDamage") : kiTypeDamage[type]));
        }
        if (util.contains("usage")) {
            double kiUsage = kiDamage * (double)kiTypeUsage[type] * (double)techDBCaddSPCost[speed];
            return (int)kiUsage;
        }
        if (util.contains("tpCost")) {
            double tpUsage = kiDamage * 7.5 * (double)kiTypeTPCost[type] * (double)techDBCaddSPCost[speed];
            return (int)tpUsage;
        }
        return 0;
    }

    public static int getKiUtil(int curAtr, String[] kiSelc, String util) {
        int type = Integer.parseInt(kiSelc[3]);
        int speed = Integer.parseInt(kiSelc[4]);
        double kiDamage = curAtr;
        if (util.contains("damage")) {
            return (int)(kiDamage * (double)kiTypeDamage[type]);
        }
        if (util.contains("usage")) {
            double kiUsage = kiDamage * (double)kiTypeUsage[type] * (double)techDBCaddSPCost[speed];
            return (int)kiUsage;
        }
        if (util.contains("tpCost")) {
            double tpUsage = kiDamage * 7.5 * (double)kiTypeTPCost[type] * (double)techDBCaddSPCost[speed];
            return (int)tpUsage;
        }
        return 0;
    }

    public static float getKiOverCharge(int charge) {
        return charge <= 50 ? (float)charge * 0.02f : (float)(charge - 50) * 0.01f + 1.0f;
    }

    public static int techDBCty(String[] t) {
        return Integer.parseInt(t[3]);
    }

    public static float techDBCct(String[] t, byte[] sts) {
        int ty = Integer.parseInt(t[3]);
        float ct = ty == 6 ? techDBCct[ty] : (float)Integer.parseInt(t[5]) / 50.0f + techDBCct[ty];
        return ct;
    }

    public static float techDBCctWc(String[] t, byte[] sts) {
        return BridgeUtils.techDBCct(t, sts) * 20.0f;
    }

    public static float techDBCcd(String[] t, byte[] sts) {
        int ty = Integer.parseInt(t[3]);
        return ty != 6 && Variables.getValue("KiCDToggle").floatValue() == 1.0f ? 0.0f : techDBCcd[ty];
    }

    public static Float[] getMovementSpeedClient(int speedType) {
        int techStage;
        int form = Methods.getSelectionFromState(JRMCoreH.State, JRMCoreH.Race);
        boolean inAltForm = Variables.getValue("daTMP").floatValue() == 1.0f;
        boolean inRaceState = Variables.getValue("daRaceState").floatValue() == 1.0f;
        String[] d18 = JRMCoreH.dataP((int)18, (String)"0;0;0;0;0;0;0;0;0;0;0;0").split(";");
        boolean isFused = Methods.isFused(d18[2]);
        int tech = JRMCoreH.State2 > 0 ? 0 : (isFused ? 1 : -1);
        int n = techStage = tech == 0 ? JRMCoreH.State2 - 1 : BridgeUtils.getClientSideTechniqueLevel("fusion1") - 1;
        int skillLv = JRMCoreH.SklLvl((int)(speedType == 0 ? 2 : (speedType == 1 ? 3 : (speedType == 2 ? 1 : 2))), (byte)1);
        return BridgeUtils.getMovementSpeed(speedType, JRMCoreH.Race, form, inAltForm, inRaceState, tech, techStage, skillLv);
    }

    public static Float[] getMovementSpeed(int speedType, int rc, int form, boolean inAltForm, boolean inRaceState, int tech, int techStage, int skillLv) {
        float speedTech;
        float speedBase = movementSpeedBase[speedType];
        float speedRace = movementSpeedRaces[0][rc];
        float speedForm = form != -1 ? movementSpeedForms[form - 1] : 0.0f;
        float speedAltForm = inAltForm ? movementSpeedRaces[1][rc] : 0.0f;
        float speedRacialState = inRaceState ? movementSpeedRaces[2][rc] : 0.0f;
        float f = speedTech = tech != -1 && techStage != -1 ? movementSpeedTechs[tech][techStage] : 0.0f;
        if (form == -1 && tech == 0) {
            speedTech *= 1.5f;
        }
        float speedBoost = Variables.hasValue("speedBoost") ? Variables.getValue("speedBoost").floatValue() : 0.0f;
        float speedSkill = movementSpeedSkills[speedType] * (float)skillLv;
        int releaseLv = JRMCoreH.SklLvl((int)5, (byte)1);
        float speedRelease = (float)JRMCoreH.curRelease / (50.0f + (float)(releaseLv * 5));
        speedRelease = Math.max(speedRelease, 0.35f);
        float speedFactor = Variables.getValue("speedFactor").floatValue();
        float speedDynamic = speedType == 1 && ClientHandler.dodge_forwDash_STE ? movementSpeedSkills[4] : 1.0f;
        float speedTurbo = speedType == 0 && ClientHandler.turbo && !ClientHandler.dodge_forwDash_STE ? movementSpeedSkills[3] : 1.0f;
        float stateSpeed = speedForm + speedAltForm + speedRacialState + speedTech + speedBoost;
        float speedResult = (speedBase + speedRace + stateSpeed + speedSkill) * speedRelease * speedFactor * speedTurbo * speedDynamic;
        return new Float[]{Float.valueOf(speedResult), Float.valueOf(speedBase), Float.valueOf(speedRace), Float.valueOf(speedForm), Float.valueOf(speedAltForm), Float.valueOf(speedRacialState), Float.valueOf(speedTech), Float.valueOf(speedBoost), Float.valueOf(speedSkill), Float.valueOf(speedRelease), Float.valueOf(speedFactor), Float.valueOf(speedTurbo), Float.valueOf(speedDynamic)};
    }

    public static String getMovementSpeedDesc(int speedType, Float[] speedArray) {
        String speedName;
        EnumChatFormatting col = EnumChatFormatting.GRAY;
        EnumChatFormatting col2 = EnumChatFormatting.YELLOW;
        String string = speedType == 0 ? "Running Speed" : (speedName = speedType == 1 ? "Flight Speed" : "Jump Height");
        String skillName = speedType == 0 ? "Dash" : (speedType == 1 ? "Flight" : "Jump");
        String speedDesc = (speedArray[3].floatValue() != 0.0f ? col + "Form: " + col2 + BridgeUtils.convertDecimalToPercent(speedArray[3].floatValue() + 1.0f) : "") + (speedArray[4].floatValue() != 0.0f ? col + " + Alt Form: " + col2 + BridgeUtils.convertDecimalToPercent(speedArray[4].floatValue() + 1.0f) : "") + (speedArray[5].floatValue() != 0.0f ? col + " + Racial State: " + col2 + BridgeUtils.convertDecimalToPercent(speedArray[5].floatValue() + 1.0f) : "") + (speedArray[6].floatValue() != 0.0f ? col + " + Tech: " + col2 + BridgeUtils.convertDecimalToPercent(speedArray[6].floatValue() + 1.0f) : "") + (speedArray[7].floatValue() != 0.0f ? col + " + Speed Boost (Test Command): " + col2 + BridgeUtils.convertDecimalToPercent(speedArray[7].floatValue() + 1.0f) : "");
        String desc = col2 + speedName + ":\n" + col + "Base: " + col2 + BridgeUtils.convertDecimalToPercent(speedArray[1].floatValue() + 1.0f) + col + " + Race: " + col2 + BridgeUtils.convertDecimalToPercent(speedArray[2].floatValue() + 1.0f) + "\n" + col + " + (" + col2 + speedDesc + col + (!speedDesc.isEmpty() ? " + " : "") + skillName + " Skill: " + col2 + BridgeUtils.convertDecimalToPercent(speedArray[8].floatValue() + 1.0f) + col + ")\n" + col + " * Power Release: " + col2 + speedArray[9] + col + " * Speed Factor (Action Menu): " + col2 + speedArray[10] + (speedArray[11].floatValue() != 1.0f ? col + " * Turbo Dash: " + col2 + speedArray[11] : "") + (speedArray[12].floatValue() != 1.0f ? col + " * Dynamic Flight: " + col2 + speedArray[12] : "");
        return desc;
    }

    public static String getFormName() {
        return BridgeUtils.getFormName(3, 0, false);
    }

    public static String getFormName(int type) {
        return BridgeUtils.getFormName(type, 0, false);
    }

    public static String getFormName(int type, int formId, boolean alt) {
        return BridgeUtils.getFormName(type, formId, alt ? 2 : 0);
    }

    public static String getFormName(int type, int formId, int formStage) {
        return BridgeUtils.getFormName(type, JRMCoreH.Race, formId, formStage, false, false);
    }

    public static String getFormName(int type, int rc, int formId, boolean altForm, boolean raceState) {
        return BridgeUtils.getFormName(type, rc, formId, 0, altForm, raceState);
    }

    public static String getFormName(int type, int rc, int formId, int formStage, boolean altForm, boolean raceState) {
        return BridgeUtils.getFormName(type, rc, formId, formStage, altForm, raceState, false);
    }

    public static String getFormName(int type, int rc, int formId, int formStage, boolean altForm, boolean raceState, boolean shortHand) {
        return BridgeUtils.getFormName(type, rc, formId, formStage, altForm, false, raceState, shortHand);
    }

    public static String getFormName(int type, int rc, int formId, int formStage, boolean altForm, boolean kaioken, boolean raceState, boolean shortHand) {
        return BridgeUtils.getFormName(type, rc, formId, formStage, altForm, kaioken, raceState, shortHand, JRMCoreH.State, JRMCoreH.State2);
    }

    public static String getFormName(int type, int rc, int formId, int formStage, boolean altForm, boolean kaioken, boolean raceState, boolean shortHand, int st, int st2) {
        boolean debug = false;
        int formSelection = Methods.getSelectionFromState(st, rc);
        if (type >= 3) {
            if (type == 3) {
                formSelection = Math.round(Variables.getValue("formSelected").floatValue());
            } else if (type == 4 || type == 5) {
                formSelection = Methods.getSelectionFromID(formId, rc, formStage == 2);
            }
        }
        raceState = raceState && (formId == 0 || formSelection >= 2 && formSelection <= 4);
        String name = "Base";
        if (rc == 0) {
            String string = formSelection == 1 ? EnumChatFormatting.BLACK + "Human Primal " + EnumChatFormatting.RED + "Mode" : (formSelection == 2 ? EnumChatFormatting.GOLD + (altForm ? "Max Buffed" : "Buffed") : (formSelection == 3 ? EnumChatFormatting.GOLD + "Full Release H" : (formSelection == 4 ? EnumChatFormatting.GOLD + (altForm ? "Super Human " + EnumChatFormatting.YELLOW + "Calm" : "Super " + EnumChatFormatting.BLUE + "Human") : (formSelection == 5 ? EnumChatFormatting.GOLD + "Primal " + EnumChatFormatting.DARK_RED + "Human" : (formSelection == 6 ? EnumChatFormatting.GOLD + "Human " + EnumChatFormatting.RED + "God Form" : (formSelection == 7 ? EnumChatFormatting.RED + (shortHand ? "A" : "Ascended ") + EnumChatFormatting.DARK_RED + "God Form" : (name = name)))))));
            if (raceState) {
                name = EnumChatFormatting.WHITE + "Augmented " + name;
            }
        }
        if (rc == 1) {
            String string = formSelection == 1 ? (altForm ? EnumChatFormatting.YELLOW + "Golden Oozaru" : EnumChatFormatting.GOLD + "Oozaru") : (formSelection == 2 ? EnumChatFormatting.YELLOW + (altForm ? (shortHand ? "FP SSJ" : "Full Power SSJ") : (shortHand ? "SSJ" : "Super Saiyan")) : (formSelection == 3 ? EnumChatFormatting.YELLOW + (altForm ? (shortHand ? "FP SSJ2" : "Full Power SSJ2") : (shortHand ? "SSJ2" : "Super Saiyan 2")) : (formSelection == 4 ? EnumChatFormatting.YELLOW + (shortHand ? "SS3" : "Super Saiyan 3") : (formSelection == 5 ? EnumChatFormatting.RED + (shortHand ? "SS" + EnumChatFormatting.YELLOW + "4" : "Super Saiyan " + EnumChatFormatting.YELLOW + "4") : (formSelection == 6 ? EnumChatFormatting.RED + (shortHand ? "SSG" : "Super Saiyan God") : (formSelection == 7 ? EnumChatFormatting.AQUA + (shortHand ? "SSB" : "Super Saiyan Blue") : (name = name)))))));
            if (raceState) {
                name = EnumChatFormatting.GREEN + "Legendary " + (formSelection == 2 ? EnumChatFormatting.DARK_AQUA + "SSJ Type C" : (formSelection == 3 ? EnumChatFormatting.YELLOW + "SSJ" : (formSelection == 4 ? "SSJ Full Power" : name)));
            }
        }
        if (rc == 2) {
            String string = formSelection == 1 ? (altForm ? EnumChatFormatting.YELLOW + "Golden Oozaru" : EnumChatFormatting.GOLD + "Oozaru") : (formSelection == 2 ? EnumChatFormatting.YELLOW + (altForm ? (shortHand ? "FP " + EnumChatFormatting.YELLOW + "SSJ" : EnumChatFormatting.GOLD + "Full Power " + EnumChatFormatting.YELLOW + "SSJ") : (shortHand ? "SS" + EnumChatFormatting.GOLD + "J" : "Super " + EnumChatFormatting.GOLD + "Saiyan")) : (formSelection == 3 ? EnumChatFormatting.YELLOW + (altForm ? (shortHand ? "FP " + EnumChatFormatting.YELLOW + "SSJ2" : EnumChatFormatting.GOLD + "Full Power " + EnumChatFormatting.YELLOW + "SSJ2") : (shortHand ? "SSJ" + EnumChatFormatting.GOLD + "2" : "Super " + EnumChatFormatting.GOLD + "Saiyan 2")) : (formSelection == 4 ? EnumChatFormatting.YELLOW + (shortHand ? "SS" + EnumChatFormatting.GOLD + "3" : "Super " + EnumChatFormatting.GOLD + "Saiyan 3") : (formSelection == 5 ? EnumChatFormatting.RED + (shortHand ? "SS" + EnumChatFormatting.YELLOW + "4" : "Super " + EnumChatFormatting.GOLD + "Saiyan " + EnumChatFormatting.YELLOW + "4") : (formSelection == 6 ? EnumChatFormatting.RED + (shortHand ? "SS" + EnumChatFormatting.DARK_RED + "G" : "Super Saiyan " + EnumChatFormatting.DARK_RED + "God") : (formSelection == 7 ? EnumChatFormatting.AQUA + (shortHand ? "SSB" : "Super Saiyan " + EnumChatFormatting.BLUE + "Blue") : (name = name)))))));
            if (raceState) {
                name = EnumChatFormatting.GREEN + "Legen" + EnumChatFormatting.DARK_GREEN + "dary " + (formSelection == 2 ? EnumChatFormatting.DARK_AQUA + "SSJ Type C" : (formSelection == 3 ? EnumChatFormatting.YELLOW + "SSJ" : (formSelection == 4 ? "SSJ Full Power" : name)));
            }
        }
        if (rc == 3) {
            String string = formSelection == 1 ? EnumChatFormatting.GREEN + "Namekian Primal " + EnumChatFormatting.GRAY + "Mode" : (formSelection == 2 ? (altForm ? EnumChatFormatting.GREEN + "Condensed " + EnumChatFormatting.DARK_GREEN + "Giant" : EnumChatFormatting.GREEN + "Giant") : (formSelection == 3 ? EnumChatFormatting.GREEN + "Full Release N" : (formSelection == 4 ? EnumChatFormatting.GREEN + (altForm ? "Super Namekian " + EnumChatFormatting.BLUE + "Calm" : "Super " + EnumChatFormatting.GREEN + "Namekian") : (formSelection == 5 ? EnumChatFormatting.GREEN + "Primal " + EnumChatFormatting.RED + "Namekian" : (formSelection == 6 ? EnumChatFormatting.DARK_GREEN + (shortHand ? "God" + EnumChatFormatting.RED + " Form" : "Namekian " + EnumChatFormatting.RED + "God Form") : (formSelection == 7 ? EnumChatFormatting.BLUE + (shortHand ? "A" : "Ascended ") + EnumChatFormatting.DARK_BLUE + "God Form" : (name = name)))))));
            if (raceState) {
                name = EnumChatFormatting.GOLD + "Dragon " + name;
            }
        }
        if (rc == 4 && (formSelection >= 0 && formSelection <= 3 || formSelection >= 4 || type == 3 || formSelection == -1)) {
            String string = formSelection == 1 ? EnumChatFormatting.BLUE + "Arcosian Primal " + EnumChatFormatting.GRAY + "Mode" : (formSelection == 2 ? EnumChatFormatting.DARK_PURPLE + "Second Form" : (formSelection == 3 ? EnumChatFormatting.DARK_PURPLE + (altForm ? "Full Power " + EnumChatFormatting.LIGHT_PURPLE + "Third Form" : "Third Form") : (formSelection == 4 ? EnumChatFormatting.DARK_PURPLE + (altForm ? "Full Power " + EnumChatFormatting.LIGHT_PURPLE + "Final Form" : "Final Form") : (formSelection == 5 ? EnumChatFormatting.BLUE + "Fifth " + EnumChatFormatting.DARK_PURPLE + "Form" : (formSelection == 6 ? EnumChatFormatting.LIGHT_PURPLE + "Arcosian God Form" : (name = formSelection == 7 ? EnumChatFormatting.GOLD + "Golden " + EnumChatFormatting.YELLOW + "Form" : name))))));
            if (raceState) {
                name = EnumChatFormatting.UNDERLINE + (formSelection <= 3 ? EnumChatFormatting.DARK_AQUA + "Meta Core " : EnumChatFormatting.AQUA + "Metal ") + name;
            }
        }
        if (rc == 5) {
            String string = formSelection == 1 ? EnumChatFormatting.LIGHT_PURPLE + "Majin Primal " + EnumChatFormatting.GRAY + "Mode" : (formSelection == 2 ? (altForm ? EnumChatFormatting.RED + "Enraged " : "") + EnumChatFormatting.LIGHT_PURPLE + "Evil Majin" : (formSelection == 3 ? EnumChatFormatting.LIGHT_PURPLE + "Adult Majin" : (formSelection == 4 ? (altForm ? EnumChatFormatting.RED + "Enraged " : "") + EnumChatFormatting.LIGHT_PURPLE + "Super Majin" : (formSelection == 5 ? EnumChatFormatting.LIGHT_PURPLE + "Primal " + EnumChatFormatting.DARK_PURPLE + "Majin" : (formSelection == 6 ? EnumChatFormatting.DARK_PURPLE + "Majin " + EnumChatFormatting.RED + "God Form" : (formSelection == 7 ? EnumChatFormatting.LIGHT_PURPLE + (shortHand ? "A" : "Ascended ") + EnumChatFormatting.DARK_PURPLE + "God Form" : (name = name)))))));
            if (raceState) {
                name = EnumChatFormatting.DARK_AQUA + "" + EnumChatFormatting.BOLD + "" + EnumChatFormatting.UNDERLINE + "Genie " + name;
            }
        }
        if (st2 > 0 && type != 3 && type != 4 && type != 5) {
            int[] kaioStages = new int[]{2, 3, 4, 5, 10, 20};
            name = name + EnumChatFormatting.RED + " x" + kaioStages[st2 - 1];
        }
        if (type == 1 || type == 4) {
            return EnumChatFormatting.func_110646_a((String)name);
        }
        return name;
    }

    public static String getFormSubName(int formSelected) {
        return formSelected == 1 ? "Primal Mode" : (formSelected == 2 ? "Tier 1" : (formSelected == 3 ? "Tier 2" : (formSelected == 4 ? "Tier 3" : (formSelected == 5 ? "Primal" : (formSelected == 6 ? "God" : (formSelected == 7 ? "AGod" : ""))))));
    }

    public static String getTechName(String tech, int techSelected) {
        String name;
        String string = tech.equals("kk") ? "x2" : (name = tech.equals("fusion") ? "Fusion" : null);
        if (tech.equals("kk")) {
            name = techSelected == 1 ? "x2" : (techSelected == 2 ? "x3" : (techSelected == 3 ? "x4" : (techSelected == 4 ? "x5" : (techSelected == 5 ? "x10" : (techSelected == 6 ? "x20" : name)))));
        }
        return name;
    }

    public static int getRaceFromID(int formId) {
        int rc = -1;
        if (formId == 25 || formId == 26 || formId == 27 || formId == 10) {
            rc = 0;
        }
        if (formId == 17 || formId == 18 || formId == 19 || formId == 11) {
            rc = 1;
        }
        if (formId == 28 || formId == 29 || formId == 30 || formId == 12) {
            rc = 3;
        }
        if (formId == 22 || formId == 23 || formId == 24 || formId == 13) {
            rc = 4;
        }
        if (formId == 40 || formId == 41 || formId == 42 || formId == 14) {
            rc = 5;
        }
        return rc;
    }

    public static boolean isRaceForm(int rc, int formId) {
        if (formId == 35) {
            return true;
        }
        if (rc == 0 && (formId == 25 || formId == 26 || formId == 27 || formId == 10)) {
            return true;
        }
        if (!(rc != 1 && rc != 2 || formId != 17 && formId != 18 && formId != 19 && formId != 11)) {
            return true;
        }
        if (rc == 3 && (formId == 28 || formId == 29 || formId == 30 || formId == 12)) {
            return true;
        }
        if (rc == 4 && (formId == 22 || formId == 23 || formId == 24 || formId == 13)) {
            return true;
        }
        return rc == 5 && (formId == 40 || formId == 41 || formId == 42 || formId == 14);
    }

    public static String getTechniqueNameID(int tech, int subTech) {
        String TransNms2 = "";
        String[][] techNames = new String[][]{{"x2", "x3", "x4", "x5", "x10", "x20"}, {"Fusion"}};
        TransNms2 = techNames[tech][subTech];
        return TransNms2;
    }

    public static int getMasteryLevel(EntityPlayer player, int form, boolean selected) {
        if (SqlDriver.isSlotLoaded((EntityPlayer)player)) {
            NBTTagCompound nbt = player.getEntityData().func_74775_l("PlayerPersisted");
            String nbtTag = selected ? FormUtil.masteryLvTag : FormUtil.masteryIdTag;
            for (String s : nbt.func_74779_i(nbtTag).split(":")) {
                if (!s.split(",")[0].equals(form + "")) continue;
                return Integer.parseInt(s.split(",")[1]);
            }
        }
        return -1;
    }

    public static int getClientSideMasteryLevel(int formSelected, boolean selected) {
        int formLV = -1;
        int form = Methods.getFormIDFromSelection(formSelected, JRMCoreH.Race);
        return BridgeUtils.getClientSideMasteryLevelID(form, selected);
    }

    public static int getClientSideMasteryLevelID(int formId, boolean selected) {
        int formLV = -1;
        for (int j = 0; j < formsList.split(",").length; ++j) {
            String entry = formsList.split(",")[j].replace(" ", "");
            if (Integer.parseInt(entry) != formId || !InfoHandler.validateMasteryData((String)entry)) continue;
            formLV = selected ? ((Integer)InfoHandler.formMasteryLV.get(entry)).intValue() : ((Integer)InfoHandler.formMastery.get(entry)).intValue();
        }
        return formLV;
    }

    public static int getMasteryExp(EntityPlayer player, int form) {
        NBTTagCompound nbt = player.getEntityData().func_74775_l("PlayerPersisted");
        String nbtTag = "daFormMasteryXP";
        for (String s : nbt.func_74779_i(nbtTag).split(":")) {
            if (!s.split(",")[0].equals(form + "")) continue;
            return Integer.parseInt(s.split(",")[1]);
        }
        return -1;
    }

    public static int getClientSideMasteryExp(int formId) {
        int formXp = -1;
        int form = Methods.getFormIDFromSelection(formId, JRMCoreH.Race);
        for (int j = 0; j < formsList.split(",").length; ++j) {
            String entry = formsList.split(",")[j].replace(" ", "");
            if (Integer.parseInt(entry) != form || !InfoHandler.validateMasteryData((String)entry)) continue;
            formXp = (Integer)InfoHandler.formMasteryEXP.get(entry);
        }
        return formXp;
    }

    public static int getClientSideTechniqueLevel(String techName) {
        int result = 0;
        if (techName.contains("kk")) {
            for (int j = 0; j < techniques[0].length; ++j) {
                String entry = techniques[0][j];
                if (!InfoHandler.validateTechniqueData((String)entry)) continue;
                if (techName.equals("kk")) {
                    if ((Integer)InfoHandler.technique.get(entry) < 1) continue;
                    ++result;
                    continue;
                }
                if (!techName.equalsIgnoreCase(entry)) continue;
                return (Integer)InfoHandler.technique.get(entry);
            }
        } else if (techName.contains("fusion1") && InfoHandler.validateTechniqueData((String)techName)) {
            return (Integer)InfoHandler.technique.get(techName);
        }
        return result;
    }

    public static int getTechniqueLevel(EntityPlayer player, String tech, boolean selected) {
        String nbtTag;
        NBTTagCompound nbt = player.getEntityData().func_74775_l("PlayerPersisted");
        String string = nbtTag = selected ? FormUtil.techniqueLvTag : FormUtil.techniqueIdTag;
        if (tech.equalsIgnoreCase("kk")) {
            int unlocks = 0;
            for (int i = 1; i <= 6; ++i) {
                if (BridgeUtils.getTechniqueLevel(player, tech + i, false) <= 0) continue;
                ++unlocks;
            }
            return unlocks;
        }
        for (String s : nbt.func_74779_i(nbtTag).split(":")) {
            if (!s.split(",")[0].equals(tech + "")) continue;
            return Integer.parseInt(s.split(",")[1]);
        }
        return -1;
    }

    public static int getClientSideRacialStateLevelID(int formId, boolean selected) {
        int formLV = -1;
        for (int j = 0; j < racialList.split(",").length; ++j) {
            String entry = racialList.split(",")[j].replace(" ", "");
            if (Integer.parseInt(entry) != formId || !InfoHandler.validateRacialStateData((String)entry)) continue;
            formLV = selected ? ((Integer)InfoHandler.racialStateLV.get(entry)).intValue() : ((Integer)InfoHandler.racialState.get(entry)).intValue();
        }
        return formLV;
    }

    public static int getRacialStateBaseId(int rc) {
        return rc == 0 ? 90 : (rc == 1 || rc == 2 ? 91 : (rc == 3 ? 92 : (rc == 4 ? 93 : (rc == 5 ? 94 : 0))));
    }

    public static int getLevel() {
        return JRMCoreH.PlyrAttrbts[0] + JRMCoreH.PlyrAttrbts[1] + JRMCoreH.PlyrAttrbts[2] + JRMCoreH.PlyrAttrbts[3] + JRMCoreH.PlyrAttrbts[4] + JRMCoreH.PlyrAttrbts[5];
    }

    public static String getRaceName(int rc, boolean shortHand) {
        if (!shortHand) {
            return rc == 0 ? EnumChatFormatting.YELLOW + "Human" : (rc == 1 ? EnumChatFormatting.GOLD + "Saiyan" : (rc == 2 ? EnumChatFormatting.YELLOW + "Half" + EnumChatFormatting.GRAY + "-" + EnumChatFormatting.GOLD + "Saiyan" : (rc == 3 ? EnumChatFormatting.DARK_GREEN + "Namekian" : (rc == 4 ? EnumChatFormatting.DARK_PURPLE + "Arcosian" : (rc == 5 ? EnumChatFormatting.LIGHT_PURPLE + "Majin" : "Unknown")))));
        }
        return rc == 0 ? "H" : (rc == 1 ? "S" : (rc == 2 ? "HS" : (rc == 3 ? "N" : (rc == 4 ? "A" : (rc == 5 ? "M" : "Unknown")))));
    }

    public static String getClassName(int cls, boolean shortHand) {
        if (!shortHand) {
            return cls == 0 ? EnumChatFormatting.YELLOW + "Martial Artist" : (cls == 1 ? EnumChatFormatting.AQUA + "Spiritualist" : (cls == 2 ? EnumChatFormatting.RED + "Warrior" : "Unknown"));
        }
        return cls == 0 ? "MA" : (cls == 1 ? "SPI" : (cls == 2 ? "WAR" : "Unknown"));
    }

    public static String[] getBuildInfo(int[] stats, int level) {
        int buildNum = 0;
        double strRatio = 0.0;
        double dexRatio = 0.0;
        double conRatio = 0.0;
        double wilRatio = 0.0;
        double engRatio = 0.0;
        double spiRatio = 0.0;
        double minRatio = 0.0;
        double maxRatio = 0.0;
        for (int stat = 0; stat < 6; ++stat) {
            double statRatio = (double)stats[stat] / (double)level;
            if (stat == 0) {
                strRatio = statRatio;
            }
            if (stat == 1) {
                dexRatio = statRatio;
            }
            if (stat == 2) {
                conRatio = statRatio;
            }
            if (stat == 3) {
                wilRatio = statRatio;
            }
            if (stat == 4) {
                engRatio = statRatio;
            }
            if (stat == 5) {
                spiRatio = statRatio;
            }
            minRatio = Math.min(statRatio, minRatio);
            maxRatio = Math.max(statRatio, maxRatio);
        }
        if (maxRatio < 0.2) {
            buildNum = 0;
        }
        if (wilRatio < 0.1 && engRatio < 0.1) {
            int n = dexRatio >= strRatio && dexRatio >= conRatio ? 3 : (conRatio >= strRatio && conRatio >= dexRatio ? 1 : (buildNum = strRatio >= dexRatio || conRatio >= dexRatio ? 2 : 7));
        }
        if (strRatio < 0.1 && dexRatio < 0.1) {
            buildNum = engRatio >= wilRatio && engRatio >= spiRatio ? 6 : (spiRatio >= wilRatio && spiRatio >= engRatio ? 4 : (wilRatio >= engRatio || spiRatio >= engRatio ? 5 : 7));
        }
        String buildName = (String)buildInfo[buildNum][0];
        String buildDesc = (String)buildInfo[buildNum][1];
        return new String[]{buildName, buildDesc};
    }

    public static String getAlignment(int align) {
        return align >= 45 && align <= 55 ? "Neutral" : (align < 45 ? "Evil" : (align > 55 ? "Good" : "Unknown"));
    }

    public static double round(double round, double value) {
        return (double)Math.round(value * round) / round;
    }

    public static float round(float round, float value) {
        return (float)Math.round(value * round) / round;
    }

    public static float roundWhole(float round, float value) {
        return (float)Math.round(value / round) * round;
    }

    public static String convertDecimalToPercent(float decimal) {
        return BridgeUtils.convertDecimalToPercent(decimal, 10000);
    }

    public static String convertDecimalToPercent(float decimal, int roundAmount) {
        String percent = null;
        float value = (float)(Math.round(decimal * (float)roundAmount) - (decimal < 0.0f ? -roundAmount : roundAmount)) / (float)(roundAmount / 100);
        percent = String.valueOf(value);
        if (percent.endsWith(".0")) {
            percent = "" + Math.round(value);
        }
        percent = percent + "%";
        return percent;
    }

    public static void addALogMessage(String message) {
        ClientUtils.addALogMessage((String)message);
    }

    public static void addALogMessage(EntityPlayer player, String message) {
        BridgePD.tellClient((EntityPlayerMP)player, "ALog:" + message);
    }

    public static boolean isDataLoaded(EntityPlayer player) {
        return player instanceof EntityPlayerMP && SqlDriver.isSlotLoaded((EntityPlayer)player) || BridgeUtils.isDataLoaded();
    }

    public static boolean isDataLoaded() {
        return Variables.hasValue("cSlotLoad") && Variables.getValue("cSlotLoad").floatValue() == -1.0f;
    }

    public static String timerBuilder(int seconds) {
        return BridgeUtils.timerBuilder((float)seconds);
    }

    public static String timerBuilder(float seconds) {
        return BridgeUtils.timerBuilder(seconds, 4);
    }

    public static String timerBuilder(float seconds, int level) {
        int wholeSeconds = (int)seconds;
        boolean whole = seconds == (float)wholeSeconds;
        String builder = (whole ? "" + wholeSeconds : Float.valueOf(seconds)) + "s";
        if (seconds >= 60.0f) {
            int minutes = (int)((double)(wholeSeconds / 60));
            int hours = 0;
            int days = 0;
            if (minutes >= 60) {
                hours = (int)((double)(minutes / 60));
                minutes -= hours * 60;
            }
            if (hours >= 24) {
                days = (int)((double)(hours / 24));
                hours -= days * 24;
            }
            wholeSeconds -= (int)((double)(wholeSeconds / 60)) * 60;
            builder = "";
            if (days > 0 && level > 0) {
                builder = builder + days + "d";
            }
            if (hours > 0 && level > 1) {
                builder = builder + (days > 0 ? " " : "") + hours + "h";
            }
            if (minutes > 0 && level > 2) {
                builder = builder + (hours > 0 || hours == 0 && days > 0 ? " " : "") + minutes + "m";
            }
            if (wholeSeconds > 0 && level > 3) {
                builder = builder + (minutes > 0 || minutes == 0 && hours > 0 || hours == 0 && days > 0 ? " " : "") + wholeSeconds + "s";
            }
        }
        return builder;
    }

    public static int upgradeCost(int[] attrbts, int upgradeFactor) {
        int lvl = attrbts[0] + attrbts[1] + attrbts[2] + attrbts[3] + attrbts[4] + attrbts[5];
        return BridgeUtils.upgradeCost(lvl, upgradeFactor);
    }

    public static int upgradeCost(int lvl, int upgradeFactor) {
        int lvlPer = lvl;
        int cost = 0;
        int upgradeAmount = BridgeUtils.upgradeAmount(upgradeFactor);
        for (int i = 0; i < upgradeAmount; ++i) {
            int costPer = BridgeUtils.upgradeCost(lvlPer++);
            cost += costPer;
            if (costPer != 0) continue;
            return 0;
        }
        if (cost == 0 || cost > 1000000000) {
            return 0;
        }
        return cost;
    }

    public static int upgradeCost(int lvl) {
        if (lvl >= 600000) {
            return 0;
        }
        int am = (int)((double)lvl * 0.12);
        int dec = Math.max(140 - lvl, 0);
        int cost = am - dec;
        return cost < 16 ? 16 : Math.min(cost, 1000000000);
    }

    public static int upgradeAmount(int upgradeAmount) {
        return upgradeAmount == 0 ? 1 : (upgradeAmount == 1 ? 10 : (upgradeAmount == 2 ? 100 : (upgradeAmount == 3 ? 1000 : (upgradeAmount == 4 ? 10000 : 1))));
    }

    public static boolean checkStatCap(int[] attrbts) {
        int lvl = attrbts[0] + attrbts[1] + attrbts[2] + attrbts[3] + attrbts[4] + attrbts[5];
        return 600000 <= lvl;
    }

    public static String getStatRank(int stat) {
        if (stat >= 500000) {
            return EnumChatFormatting.AQUA + "[" + EnumChatFormatting.STRIKETHROUGH + "Z" + EnumChatFormatting.YELLOW + "+++" + EnumChatFormatting.AQUA + "]";
        }
        if (stat >= 400000) {
            return EnumChatFormatting.AQUA + "[" + EnumChatFormatting.STRIKETHROUGH + "Z" + EnumChatFormatting.YELLOW + "++" + EnumChatFormatting.AQUA + "]";
        }
        if (stat >= 300000) {
            return EnumChatFormatting.AQUA + "[" + EnumChatFormatting.STRIKETHROUGH + "Z" + EnumChatFormatting.YELLOW + "+" + EnumChatFormatting.AQUA + "]";
        }
        if (stat >= 200000) {
            return EnumChatFormatting.AQUA + "[" + EnumChatFormatting.STRIKETHROUGH + "Z" + EnumChatFormatting.AQUA + "]";
        }
        if (stat >= 100000) {
            return EnumChatFormatting.YELLOW + "[S+++]";
        }
        if (stat >= 87500) {
            return EnumChatFormatting.YELLOW + "[S++]";
        }
        if (stat >= 75000) {
            return EnumChatFormatting.YELLOW + "[S+]";
        }
        if (stat >= 62500) {
            return EnumChatFormatting.YELLOW + "[S]";
        }
        if (stat >= 50000) {
            return EnumChatFormatting.RED + "[A++]";
        }
        if (stat >= 42500) {
            return EnumChatFormatting.RED + "[A+]";
        }
        if (stat >= 35000) {
            return EnumChatFormatting.RED + "[A]";
        }
        if (stat >= 26000) {
            return EnumChatFormatting.GREEN + "[B++]";
        }
        if (stat >= 21000) {
            return EnumChatFormatting.GREEN + "[B+]";
        }
        if (stat >= 16000) {
            return EnumChatFormatting.GREEN + "[B]";
        }
        if (stat >= 10000) {
            return EnumChatFormatting.BLUE + "[C++]";
        }
        if (stat >= 7500) {
            return EnumChatFormatting.BLUE + "[C+]";
        }
        if (stat >= 5000) {
            return EnumChatFormatting.BLUE + "[C]";
        }
        if (stat >= 3000) {
            return EnumChatFormatting.GOLD + "[D++]";
        }
        if (stat >= 2250) {
            return EnumChatFormatting.GOLD + "[D+]";
        }
        if (stat >= 1500) {
            return EnumChatFormatting.GOLD + "[D]";
        }
        if (stat >= 800) {
            return EnumChatFormatting.DARK_PURPLE + "[E++]";
        }
        if (stat >= 550) {
            return EnumChatFormatting.DARK_PURPLE + "[E+]";
        }
        if (stat >= 350) {
            return EnumChatFormatting.DARK_PURPLE + "[E]";
        }
        if (stat >= 125) {
            return EnumChatFormatting.GRAY + "[F++]";
        }
        if (stat >= 50) {
            return EnumChatFormatting.GRAY + "[F+]";
        }
        return EnumChatFormatting.GRAY + "[F]";
    }

    public static void setAttackTimer(EntityPlayer player) {
        NBTTagCompound nbt = player.getEntityData().func_74775_l("PlayerPersisted");
        int epoch = (int)(System.currentTimeMillis() / 1000L);
        nbt.func_74768_a("jrmcAttackTimer", epoch);
    }

    public static void getEventInfoThread() {
        boolean debug = false;
        if (debug) {
            System.out.println("getEventInfoThread");
        }
        try {
            String line;
            boolean testing = true;
            BufferedReader reader = BridgeUtils.readUrl("https://raw.githubusercontent.com/XeroZon/DBApolloFiles/main/eventInfo" + (testing ? "Testing" : "") + ".txt");
            if (debug) {
                System.out.println("getEventInfoThread 2");
            }
            ArrayList<String> data = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                data.add(line);
            }
            DayOfWeek dayOfWeek = LocalDate.now(ZoneId.of("UTC")).getDayOfWeek();
            EnumSet<DayOfWeek> weekend = EnumSet.of(DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
            if (debug) {
                System.out.println("day: " + dayOfWeek + " | " + weekend);
            }
            if (Double.parseDouble((String)data.get(0)) > 1.0) {
                Main.tpMulti = Double.parseDouble((String)data.get(0));
            } else if (weekend.contains(dayOfWeek)) {
                Main.tpMulti = 1.05;
            }
            if (!((String)data.get(1)).equals("none")) {
                Main.eventChallenger = (String)data.get(1);
            }
            if (Double.parseDouble((String)data.get(2)) > 1.0) {
                Main.expMulti = Double.parseDouble((String)data.get(2));
            }
            if (!((String)data.get(3)).equals("none")) {
                Main.eventName = (String)data.get(3);
            }
            if (Double.parseDouble((String)data.get(4)) > 1.0) {
                Main.storeSale = Double.parseDouble((String)data.get(4));
            }
            if (net.MCApolloNetwork.ApolloCrux.Client.Main.spookActive && !Main.eventName.startsWith("Spook")) {
                net.MCApolloNetwork.ApolloCrux.Client.Main.spookActive = false;
            }
        }
        catch (Exception e) {
            if (debug) {
                System.out.println("error loading event data");
            }
            Main.eventFailedToLoad = true;
        }
    }

    public static BufferedReader readUrl(String urlInput) {
        BufferedReader reader = null;
        try {
            URL url = new URL(urlInput);
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            connection.setSSLSocketFactory(BridgeUtils.getInstance("TLS").getSocketFactory());
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return reader;
    }

    private static SSLContext getInstance(String protocol) throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext sc = SSLContext.getInstance(protocol);
        sc.init(null, trustAllCerts, new SecureRandom());
        return sc;
    }

    public static void performanceTest(String systemName, boolean start) {
        BridgeUtils.performanceTest(systemName, 300, start);
    }

    public static void performanceTest(String systemName, int time, boolean start) {
        long curTime = System.currentTimeMillis();
        if (start) {
            performanceTimer.put(systemName, curTime);
        } else if (performanceTimer.containsKey(systemName)) {
            long timer = performanceTimer.getOrDefault(systemName, 0L);
            if (timer != 0L && curTime - timer >= (long)time) {
                System.out.println("!!! Performance Test for system \"" + systemName + "\" took " + (curTime - timer) + " ms");
            }
            performanceTimer.remove(systemName);
        }
    }

    static {
        formMulti = 1.0f;
        strMulti = 1.0f;
        dexMulti = 1.0f;
        conMulti = 1.0f;
        wilMulti = 1.0f;
        engMulti = 1.0f;
        spiMulti = 1.0f;
        extraMulti = 1.0f;
        formMultiStack = 0.0f;
        strMultiStack = 0.0f;
        dexMultiStack = 0.0f;
        conMultiStack = 0.0f;
        wilMultiStack = 0.0f;
        engMultiStack = 0.0f;
        spiMultiStack = 0.0f;
        formMultiDif = 0.0f;
        strMultiDif = 0.0f;
        dexMultiDif = 0.0f;
        conMultiDif = 0.0f;
        wilMultiDif = 0.0f;
        engMultiDif = 0.0f;
        spiMultiDif = 0.0f;
        formStamUsage = 1.0f;
        formStamRegen = 1.0f;
        isServerSide = false;
        BPstatWeight = new int[][]{{10, 9, 7, 9, 8, 7}, {3, 7, 7, 14, 9, 10}, {13, 10, 8, 4, 7, 8}};
        movementSpeedBase = new float[]{0.2f, 0.1f, 0.15f};
        movementSpeedRaces = new float[][]{{0.3f, 0.25f, 0.35f, 0.2f, 0.4f, 0.2f}, {0.0f, 0.15f, 0.05f, 0.0f, 0.2f, 0.1f}, {0.2f, 0.2f, 0.2f, 0.2f, 0.2f, 0.2f}};
        movementSpeedForms = new float[]{-0.25f, 0.3f, 0.45f, 0.55f, 0.9f, 0.7f, 0.8f};
        movementSpeedTechs = new float[][]{{0.1f, 0.15f, 0.2f, 0.25f, 0.3f, 0.35f}, {0.1f, 0.15f, 0.2f, 0.25f, 0.3f, 0.35f, 0.4f}};
        movementSpeedSkills = new float[]{0.055f, 0.25f, 0.075f, 1.3f, 1.5f};
        buildInfo = new Object[][]{{"Balanced", "All Stats are about the same..."}, {"Balanced Brawler", "Con higher than Str & Dex, Stamina helps you keep going"}, {"Offensive Brawler", "Str or Con higher than Dex, you might just always be angry"}, {"Defensive Brawler", "Dex higher than Str & Con, you get defensive when asked about your stats"}, {"Balanced Spiritualist", "Spi Higher than Wil & Eng, you likely don't like form drain"}, {"Offensive Spiritualist", "Wil or Spi higher than Eng, you get shredded by enemy ki attacks"}, {"Defensive Spiritualist", "Eng higher than Wil & Spi, wouldn't want the die to a ki attack"}, {"MEOW", "#8"}};
        trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        performanceTimer = new HashMap<String, Long>();
    }
}

