/*
 * Decompiled with CFR 0.152.
 */
package net.MCApolloNetwork.ApolloCrux.Bridge.Utils;

import JinRyuu.JRMCore.JRMCoreH;
import JinRyuu.JRMCore.items.GiTurtleBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.MCApolloNetwork.ApolloCrux.Bridge.Items.ApolloItems;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.ArmorRegistry;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.ArmorSetup;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.ExtendedPlayer;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.Methods;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.CharacterCreation;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import noppes.npcs.entity.EntityCustomNpc;

public class ClothingSetup
extends GiTurtleBase {
    public int type = -1;
    public int subType = -1;
    public int armorPiece = -1;
    private final int defaultColor = presetColor[15];
    public static final int[] presetColor = new int[]{0x1E1B1B, 11743532, 3887386, 5320730, 2437522, 8073150, 2651799, 0xABABAB, 0x434343, 0xD8A8A8, 4312372, 14602026, 6719955, 12801229, 15435844, 0xF0F0F0};

    public ClothingSetup(ItemArmor.ArmorMaterial par2ArmorMaterial, int par3, int par4, String armornamePrefix, int type, int subType) {
        super(par2ArmorMaterial, par3, par4, armornamePrefix);
        this.setName(par4, armornamePrefix);
        this.func_77637_a(ApolloItems.tabArmor);
        this.type = type;
        this.subType = subType;
        this.armorPiece = par4;
        this.setupItemTexture(par4, armornamePrefix);
    }

    public ClothingSetup(ItemArmor.ArmorMaterial par2ArmorMaterial, int par3, int par4, String armornamePrefix) {
        super(par2ArmorMaterial, par3, par4, armornamePrefix);
        this.setName(par4, armornamePrefix);
        this.func_77637_a(ApolloItems.tabArmor);
        this.type = -1;
        this.armorPiece = par4;
        this.setupItemTexture(par4, armornamePrefix);
    }

    public void func_77663_a(ItemStack gear, World world, Entity player, int p_77663_4_, boolean p_77663_5_) {
        NBTTagCompound nbt;
        super.func_77663_a(gear, world, player, p_77663_4_, p_77663_5_);
        int gearType = this.type < 100 ? 2 : 1;
        int typeID = ArmorRegistry.convertTypeID(gearType, this.type);
        int subID = ArmorRegistry.convertSubTypeID(gearType, this.subType);
        int pieceID = gear.func_77977_a().contains("santa") || gear.func_77977_a().contains("elf") ? this.armorPiece : this.armorPiece - 1;
        String gearName = ArmorRegistry.gearNames[gearType][typeID][subID][pieceID];
        if (!gear.func_82833_r().equals(gearName)) {
            gear.func_151001_c(gearName);
        }
        if (gear.func_77942_o()) {
            nbt = gear.func_77978_p();
            if (!nbt.func_74764_b("type") || nbt.func_74762_e("type") != this.type) {
                nbt.func_74768_a("type", this.type);
            }
            if (!nbt.func_74764_b("subType") && this.subType != -1 || nbt.func_74762_e("subType") != this.subType) {
                nbt.func_74768_a("subType", this.subType);
            }
            if (nbt.func_74764_b("ench") || nbt.func_74764_b("RepairCost")) {
                if (nbt.func_74764_b("ench")) {
                    nbt.func_82580_o("ench");
                }
                if (nbt.func_74764_b("RepairCost")) {
                    nbt.func_82580_o("RepairCost");
                }
                ((EntityPlayer)player).func_146105_b((IChatComponent)new ChatComponentText("" + EnumChatFormatting.RED + "You can't apply enchants to clothing!"));
            }
        } else {
            nbt = new NBTTagCompound();
            nbt.func_74768_a("type", this.type);
            nbt.func_74768_a("subType", this.subType);
        }
        gear.func_77982_d(nbt);
    }

    public void setupItemTexture(int type, String armorName) {
        if (!armorName.contains("coat")) {
            String typeString = "chest";
            switch (type) {
                case 0: {
                    typeString = "hat";
                    break;
                }
                case 1: {
                    typeString = "chest";
                    break;
                }
                case 2: {
                    typeString = "legs";
                    break;
                }
                case 3: {
                    typeString = "boots";
                }
            }
            this.func_111206_d(ArmorRegistry.getItemTexturePath(armorName, typeString, this.type));
        }
    }

    private void setName(int type, String armorName) {
        if (!armorName.contains("coat")) {
            String typeString = "chest";
            switch (type) {
                case 0: {
                    typeString = "hat";
                    break;
                }
                case 1: {
                    typeString = "chest";
                    break;
                }
                case 2: {
                    typeString = "legs";
                    break;
                }
                case 3: {
                    typeString = "boots";
                }
            }
            this.func_77655_b(armorName + "_" + typeString);
        } else {
            this.func_77655_b(armorName);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack clothing, EntityPlayer player, List list, boolean bool) {
        boolean cosmetic;
        boolean bl = cosmetic = ExtendedPlayer.get((EntityPlayer)player).inventory.func_70301_a(11 + this.armorPiece) == clothing;
        if (cosmetic) {
            list.add("");
            list.add(EnumChatFormatting.GRAY + "This piece of gear is equipped in the cosmetic slot");
            list.add("");
        }
        list.add(ArmorRegistry.getGearType(this.type, this.subType, "Clothing"));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister IconRegister) {
        this.field_77791_bV = IconRegister.func_94245_a("dbapollo:armor/" + ArmorRegistry.getGearSubTexturePath(this.type) + this.func_77658_a().replaceAll("item.", ""));
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return this.getArmorTexture(stack, entity, slot, type, false);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type, boolean canRender) {
        boolean cosmeticEnabled;
        int slotConversion;
        boolean debug = false;
        if (!(entity instanceof EntityCustomNpc) && !canRender) {
            return "dbapollo:textures/armor/visual_disabled.png";
        }
        String[] d2 = JRMCoreH.data((String)entity.func_70005_c_(), (int)2, (String)"0;0;0;0;0;0;0;0;0").split(";");
        String[] d4 = JRMCoreH.data((String)entity.func_70005_c_(), (int)4, (String)"0;0;0;0;0;0;0;0;0").split(";");
        String[] cosmetic = d4[3].split(",");
        String cosmeticItems = d4[4];
        String[] d13 = JRMCoreH.data((String)entity.func_70005_c_(), (int)13, (String)"0;0;0;0;0;0;0;0;0").split(";");
        String[] d18 = JRMCoreH.data((String)entity.func_70005_c_(), (int)18, (String)"0;0;0;0;0;0;0;0;0").split(";");
        int st = Integer.parseInt(d2[0]);
        int rc = Integer.parseInt(d2[2]);
        boolean isFused = Methods.isFused(d18[2]);
        boolean primal = Methods.isInPrimalForm(rc, st) && !isFused;
        boolean primalMode = Methods.isInPrimalMode(rc, st);
        String texture = this.na;
        String[] armorTypes = new String[]{"boots", "legs", "chest", "hat"};
        int n = slot == 0 ? 3 : (slot == 1 ? 2 : (slotConversion = slot == 2 ? 1 : 0));
        boolean bl = cosmetic.length == 5 && cosmetic[0].contains("1") && (!primalMode || !Methods.cosmeticsCheck(d13, 5, true) && !CharacterCreation.isOpen) ? (slotConversion == 0 && cosmetic[1].contains("1") ? true : (!(slotConversion != 1 || !cosmetic[2].contains("1") || primal && Methods.cosmeticsCheck(d13, 5, true)) ? true : (slotConversion == 2 && cosmetic[3].contains("1") ? true : slotConversion == 3 && cosmetic[4].contains("1")))) : (cosmeticEnabled = false);
        if (!stack.func_77977_a().contains("color")) {
            if (cosmeticEnabled && !entity.func_82150_aj() && !isFused) {
                Item cosmeticItem = null;
                if (entity instanceof EntityPlayer && cosmeticItems != null) {
                    cosmeticItem = Item.func_150899_d((int)Integer.parseInt(cosmeticItems.split(",")[slotConversion]));
                }
                if (cosmeticItem != null) {
                    if ((cosmeticItem instanceof ArmorSetup || cosmeticItem instanceof ClothingSetup) && cosmeticItem.func_77658_a().contains(armorTypes[slot])) {
                        String first = cosmeticItem.func_77658_a().split("item.")[1];
                        texture = first.split("_").length > 2 ? first.split("_")[0] + "_" + first.split("_")[1] : first.split("_")[first.split("_").length - 2];
                        return ArmorRegistry.getGearTexturePath(texture, slot);
                    }
                } else if (stack.func_77977_a().contains(armorTypes[slot])) {
                    return ArmorRegistry.getGearTexturePath(texture, slot, this.type);
                }
            } else if (entity instanceof EntityCustomNpc) {
                return ArmorRegistry.getGearTexturePath(texture, slot, this.type);
            }
        } else if (stack.func_77977_a().contains("color") && slot == 1) {
            return ArmorRegistry.getGearTexturePath(texture, slot, this.type);
        }
        return "dbapollo:textures/armor/visual_disabled.png";
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack item, int var) {
        return this.func_82814_b(item);
    }

    public boolean func_82816_b_(ItemStack item) {
        if (!item.func_77942_o()) {
            return false;
        }
        if (!item.func_77978_p().func_74764_b("coloration")) {
            return false;
        }
        return item.func_77978_p().func_74775_l("coloration").func_74764_b("color1") && item.func_77978_p().func_74775_l("coloration").func_74764_b("color2") && item.func_77978_p().func_74775_l("coloration").func_74764_b("color3");
    }

    public int getColors(ItemStack item, int dyeStage) {
        NBTTagCompound nbttagcompound = item.func_77978_p();
        if (nbttagcompound == null) {
            return this.defaultColor;
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("coloration");
        if (nbttagcompound1 != null) {
            if (nbttagcompound1.func_74764_b("color" + dyeStage)) {
                return nbttagcompound1.func_74762_e("color" + dyeStage);
            }
            return this.defaultColor;
        }
        return 10511680;
    }

    public void removeColor(ItemStack item, int dyeStage) {
        NBTTagCompound nbttagcompound1;
        NBTTagCompound nbttagcompound = item.func_77978_p();
        if (nbttagcompound != null && (nbttagcompound1 = nbttagcompound.func_74775_l("coloration")).func_74764_b("color" + dyeStage)) {
            nbttagcompound1.func_82580_o("color" + dyeStage);
        }
    }

    public ItemStack setColor(ItemStack item, int colorID, int dyeStage) {
        NBTTagCompound nbttagcompound = item.func_77978_p();
        if (nbttagcompound == null) {
            nbttagcompound = new NBTTagCompound();
            item.func_77982_d(nbttagcompound);
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("coloration");
        if (!nbttagcompound.func_74764_b("coloration")) {
            nbttagcompound.func_74782_a("coloration", (NBTBase)nbttagcompound1);
        }
        nbttagcompound1.func_74768_a("color" + dyeStage, colorID);
        nbttagcompound1.func_74768_a("dyeStage", nbttagcompound1.func_74764_b("dyeStage") ? 1 : (nbttagcompound1.func_74762_e("dyeStage") == 3 ? 1 : nbttagcompound1.func_74762_e("dyeStage") + 1));
        item.func_77982_d(nbttagcompound);
        return item;
    }
}

