/*
 * Decompiled with CFR 0.152.
 */
package net.MCApolloNetwork.ApolloCrux.Bridge.Utils;

import java.util.ArrayList;
import java.util.List;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.Methods;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.ClientUtils;

public class DebugUtils {
    static int perLine = 5;
    static int spacePerEntry = 8;
    static long rateLimit = 500L;
    static long lastDebugTime = 0L;

    public static <T> void print(T toPrint) {
        System.out.println(toPrint);
    }

    public static void printList(List<?> toPrint) {
        DebugUtils.printListReal(new ArrayList(toPrint));
    }

    public static void printListReal(List<?> toPrint) {
        String printText1 = "";
        String printText2 = "";
        for (int entry = 0; entry < toPrint.size(); ++entry) {
            String variableName = "#" + entry + ": ";
            Object entryText = toPrint.get(entry);
            StringBuilder spacing = new StringBuilder();
            if (entryText.toString().length() < spacePerEntry) {
                int spacesToAdd = spacePerEntry - entryText.toString().length();
                for (int space = 0; space < spacesToAdd; ++space) {
                    spacing.append(" ");
                }
            }
            if (entry < perLine) {
                printText1 = Methods.addToExisting(printText1, "" + entryText, spacing + " | ", true);
                continue;
            }
            printText2 = Methods.addToExisting(printText2, "" + entryText, spacing + " | ", true);
        }
        System.out.println("Debug Print:");
        DebugUtils.printLine("#1: " + printText1);
        DebugUtils.printLine("#2: " + printText2);
    }

    public static void printLine(String printText) {
        if (!printText.isEmpty()) {
            System.out.println(printText);
        }
    }

    public static void debugRateLimit(String debug) {
        DebugUtils.debugRateLimit(debug, rateLimit);
    }

    public static void debugRateLimit(String debug, long time) {
        if (ClientUtils.getTimeSince((long)lastDebugTime) < time) {
            return;
        }
        System.out.println(debug);
        lastDebugTime = System.currentTimeMillis();
    }
}

