/*
 * Decompiled with CFR 0.152.
 */
package net.MCApolloNetwork.ApolloCrux.Bridge.Utils;

import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.Methods;

public class FormUtils {
    public static final int oneBilly = 1000000000;
    public static final int[] maxFormLevel = new int[]{6, 10};
    public static final int[] expToLevelGod = new int[]{1000000000, 150, 250, 500, 950, 1050, 1200, 1600, 2000, 2400};
    public static final int[] expToLevelPrimal = new int[]{1000000000, 120, 280, 500, 950, 1050, 1200, 1600, 2000, 2400};
    public static final int[] expToLevel = new int[]{1000000000, 250, 500, 1000, 1750, 2500, 1000000000, 1000000000, 1000000000};
    public static double[] expTransferRates = new double[]{0.05, 0.1, 0.15, 0.2, 0.2};
    public static final int[][] expToLevelKaio = new int[][]{{1000000000, 75, 150, 225}, {1000000000, 150, 225, 300}, {1000000000, 225, 300, 375}, {1000000000, 300, 375, 450}, {1000000000, 375, 450, 525}, {1000000000, 450, 525, 600}};
    public static final int[] timeTillEXPKaio = new int[]{6, 6, 6, 6, 6, 6};
    public static final int[] expToLevelFusion = new int[]{1000000000, 200, 500, 900, 1400, 2000, 2800};
    public static final int[] fusionSuccessRates = new int[]{35, 40, 45, 50, 60, 70, 85};
    public static final int[] expToLevelRacialStates = new int[]{1000000000, 200, 400, 700, 1000};
    public static int whisTrainingQuest = 194;
    public static int primalTrainingQuest = 505;
    public static String whisTrainingQuestString = "sq5-12 (Super Saga)";
    public static String primalTrainingQuestString = "gt2-08 (GT Saga)";
    static final int[][] ascendTimes = new int[][]{{30}, {100, 90, 80, 70, 60, 50}, {120, 105, 90, 80, 70, 60, 55, 50, 45, 40}, {115, 105, 95, 85, 75, 65, 55, 50, 45, 40}, {40, 50, 60, 70, 85, 100}, {120}};

    public static int xpUntilLevelForm(int formLv, int formId) {
        if (FormUtils.getFormMaxLevel(formId) > formLv) {
            return formId == 35 ? expToLevelGod[formLv] : (formId >= 10 && formId <= 15 ? expToLevelPrimal[formLv] : expToLevel[formLv]);
        }
        return 1000000000;
    }

    public static int xpUntilLevelTech(int techLv, String techId) {
        if (techId.contains("kk")) {
            int kaioStage = Integer.parseInt(techId.split("kk")[1]);
            if (FormUtils.getTechMaxLevel(techId) > techLv && kaioStage > 0) {
                return expToLevelKaio[kaioStage - 1][techLv];
            }
        } else if (techId.contains("fusion") && FormUtils.getTechMaxLevel(techId) > techLv) {
            return expToLevelFusion[techLv];
        }
        return 1000000000;
    }

    public static int xpUntilLevelRacialStates(int racialStateLv, int racialStateId) {
        if (racialStateLv > 0 && racialStateLv < FormUtils.getRacialStateMaxLevel(racialStateId)) {
            return expToLevelRacialStates[racialStateLv];
        }
        return 1000000000;
    }

    public static int getFormExpTotal(int formID, int formLV) {
        int expTotal = 0;
        for (int i = 0; i < formLV - 1; ++i) {
            int formXpToLevel = FormUtils.xpUntilLevelForm(i + 1, formID);
            expTotal += formXpToLevel;
        }
        return expTotal;
    }

    public static int getTechExpTotal(String techID, int techLV) {
        int expTotal = 0;
        for (int i = 0; i < techLV - 1; ++i) {
            int techXpToLevel = FormUtils.xpUntilLevelTech(i + 1, techID);
            expTotal += techXpToLevel;
        }
        return expTotal;
    }

    public static int getRacialStateExpTotal(int formID, int formLV) {
        int expTotal = 0;
        for (int i = 0; i < formLV - 1; ++i) {
            int racialStatesXpToLevel = FormUtils.xpUntilLevelRacialStates(i + 1, formID);
            expTotal += racialStatesXpToLevel;
        }
        return expTotal;
    }

    public static int getFormUnlockLevel(int formID, boolean isSecondForm) {
        return FormUtils.getFormUnlockLevel(formID, isSecondForm ? 2 : 0);
    }

    public static int getFormUnlockLevel(int formID, int formStage) {
        return formStage == 2 && formID == 35 ? 6 : (formStage == 1 ? 3 : 1);
    }

    public static int getFormMaxLevel(int formID) {
        return formID == 35 || formID >= 10 && formID <= 15 ? 10 : 6;
    }

    public static int getTechMaxLevel(String techID) {
        return techID.contains("kk") ? 4 : (techID.contains("fusion") ? 7 : -1);
    }

    public static int getRacialStateMaxLevel(int racialStateId) {
        return racialStateId >= 0 && racialStateId <= 5 ? 1 : 5;
    }

    public static int getTransformTime(int rc, int formId, int formLv, boolean stacking, boolean inState) {
        if (formLv < 0) {
            return 100;
        }
        int formTier = Methods.getFormTierByID(formId);
        int entry1 = formTier <= 3 ? 1 : (formTier == 4 ? 2 : (formTier == 5 ? 3 : 1));
        int entry2 = entry1 == 0 ? 0 : formLv - 1;
        int ascendTime = ascendTimes[entry1][entry2];
        int stackTime = ascendTimes[0][0];
        int resultTime = Math.min(120, inState ? stackTime : ascendTime + (stacking ? stackTime : 0));
        return resultTime;
    }

    public static int getAscendTime(String tech, int techStage) {
        int entry1 = tech.equalsIgnoreCase("kk") ? 4 : 5;
        int entry2 = entry1 == 5 ? 0 : techStage - 1;
        return Math.min(120, ascendTimes[entry1][entry2]);
    }
}

