/*
 * Decompiled with CFR 0.152.
 */
package net.MCApolloNetwork.ApolloCrux.Bridge.Utils;

import JinRyuu.JRMCore.JRMCoreH;
import JinRyuu.JRMCore.mod_JRMCore;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.ArmorSetup;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.BridgeUtils;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.FormUtils;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.Packets.BridgePD;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.Variables;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.CharacterCreation;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.HairEditor;
import net.MCApolloNetwork.ApolloCrux.Client.GUI.OnScreen.QuickSelection;
import net.MCApolloNetwork.ApolloCrux.Client.Main;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.CharacterUtils;
import net.MCApolloNetwork.ApolloCrux.Client.Utils.MovieUtils;
import net.MCApolloNetwork.ApolloCrux.Server.Utilities.FormTechs.FusionUtil;
import net.MCApolloNetwork.ApolloCrux.Server.Utilities.Packets.ServerPD;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public class Methods {
    public static float gearStatFactor = 0.0025f;
    public static float gearEnhanceFactor = 0.002f;
    public static float gearEnhanceTotalFactor = 5.0E-4f;
    public static int[] ccSizeInches = new int[]{58, 84};
    public static float[] ccWidthRatio = new float[]{0.3f, 0.3f, 0.3f, 0.3f, 0.3f, 0.4f};
    static float[][][] TransSizes = new float[][][]{new float[][]{{1.0f, 1.0f}, {1.2f, 1.1f}, {1.04f, 1.0f}, {1.06f, 1.0f}, {1.15f, 1.05f}, {1.0f, 0.94f}, {1.12f, 1.07f}, {2.35f, 1.2f}, {1.0f, 1.0f}}, new float[][]{{1.0f, 1.0f}, {1.02f, 1.0f}, {1.04f, 1.0f}, {1.06f, 1.0f}, {1.05f, 1.0f}, {1.0f, 0.92f}, {1.0f, 0.94f}, {2.7f, 1.25f}, {2.7f, 1.25f}}, new float[][]{{1.0f, 1.0f}, {1.03f, 1.0f}, {1.06f, 1.0f}, {1.09f, 1.0f}, {1.08f, 1.0f}, {1.0f, 0.93f}, {1.03f, 0.96f}, {2.6f, 1.25f}, {2.6f, 1.25f}}, new float[][]{{1.0f, 1.0f}, {2.0f, 1.0f}, {1.06f, 0.95f}, {1.09f, 1.0f}, {1.05f, 1.0f}, {1.0f, 0.94f}, {1.08f, 0.97f}, {2.55f, 1.2f}, {1.0f, 1.0f}}, new float[][]{{0.85f, 0.95f}, {1.0f, 1.0f}, {1.45f, 1.05f}, {1.2f, 1.1f}, {1.0f, 1.0f}, {1.3f, 1.13f}, {1.05f, 1.05f}, {1.0f, 0.92f}, {2.15f, 1.2f}}, new float[][]{{1.0f, 1.07f}, {1.0f, 0.87f}, {1.15f, 1.06f}, {1.1f, 1.03f}, {1.05f, 1.0f}, {1.0f, 0.94f}, {0.75f, 0.95f}, {2.2f, 1.2f}, {1.0f, 1.0f}}};

    public static boolean isNumeric(String input) {
        if (input == null) {
            return false;
        }
        try {
            Integer.parseInt(input);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static boolean isFloateric(String input) {
        if (input == null) {
            return false;
        }
        try {
            Float.parseFloat(input);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static int getDecimal(String hex) {
        String digits = "0123456789ABCDEF";
        hex = hex.toUpperCase();
        int val = 0;
        for (int i = 0; i < hex.length(); ++i) {
            char c = hex.charAt(i);
            int d = digits.indexOf(c);
            val = 16 * val + d;
        }
        return val;
    }

    public static boolean isHexDecimal(String input) {
        String regex = "#[0-9A-Fa-f]{6}";
        if (input == null) {
            return false;
        }
        return input.matches(input);
    }

    public static void reincarnateChar(EntityPlayer player) {
        NBTTagCompound nbt = player.getEntityData().func_74775_l("PlayerPersisted");
        nbt.func_74768_a("jrmcRencrnt", 1);
        for (int i = 0; i < 6; ++i) {
            int stat = nbt.func_74762_e(BridgeUtils.statTags[i]);
            nbt.func_74768_a(BridgeUtils.statTagsR[i], stat);
        }
        ServerPD.updateMasteryPackets((EntityPlayerMP)((EntityPlayerMP)player));
        Methods.resetChar(player, true, true);
    }

    public static void resetChar(EntityPlayer player, boolean skillReset, boolean statReset) {
        int j;
        byte pwr = JRMCoreH.getByte((EntityPlayer)player, (String)"jrmcPwrtyp");
        mod_JRMCore.logger.info("Character reset for " + player.func_70005_c_());
        mod_JRMCore.logger.info("Alignment: " + JRMCoreH.getByte((EntityPlayer)player, (String)"jrmcAlign"));
        mod_JRMCore.logger.info("Race: " + BridgeUtils.getRaceName(JRMCoreH.getByte((EntityPlayer)player, (String)"jrmcRace"), false));
        mod_JRMCore.logger.info("Class: " + BridgeUtils.getClassName(JRMCoreH.getByte((EntityPlayer)player, (String)"jrmcClass"), false));
        for (int i = 0; i < JRMCoreH.attrNms[pwr].length; ++i) {
            mod_JRMCore.logger.info(JRMCoreH.attrNms((int)pwr, (int)i) + ": " + JRMCoreH.getInt((EntityPlayer)player, (String)BridgeUtils.statTags[i]));
        }
        String[] PlyrSkills = JRMCoreH.getString((EntityPlayer)player, (String)"jrmcSSlts").split(",");
        for (j = 0; j < PlyrSkills.length; j = (int)((byte)(j + 1))) {
            String skl = PlyrSkills[j];
            if (skl.length() <= 2) continue;
            mod_JRMCore.logger.info("Skill: " + JRMCoreH.SklName((String)skl, (String[])JRMCoreH.vlblSkls, (String[])JRMCoreH.vlblSklsNms) + " lvl: " + (Integer.parseInt(skl.substring(2)) + 1));
        }
        JRMCoreH.setByte((int)67, (EntityPlayer)player, (String)"jrmcAlign");
        JRMCoreH.setByte((int)0, (EntityPlayer)player, (String)"jrmcPwrtyp");
        JRMCoreH.setByte((int)0, (EntityPlayer)player, (String)"jrmcClass");
        for (int stat = 0; stat < BridgeUtils.statTags.length; ++stat) {
            JRMCoreH.setInt((int)1, (EntityPlayer)player, (String)BridgeUtils.statTags[stat]);
        }
        int skillRelease = !skillReset ? 0 : JRMCoreH.SklLvl((int)5, (int)pwr, (String[])PlyrSkills) * 5;
        JRMCoreH.setByte((int)(50 + skillRelease), (EntityPlayer)player, (String)"jrmcRelease");
        JRMCoreH.setByte((int)0, (EntityPlayer)player, (String)"jrmcState");
        JRMCoreH.setByte((int)0, (EntityPlayer)player, (String)"jrmcState2");
        JRMCoreH.setByte((int)0, (EntityPlayer)player, (String)"jrmcSaiRg");
        JRMCoreH.setByte((int)0, (EntityPlayer)player, (String)"jrmcAccept");
        JRMCoreH.setString((String)" ", (EntityPlayer)player, (String)"jrmcStatusEff");
        JRMCoreH.setString((String)" ", (EntityPlayer)player, (String)"jrmcSettings");
        FusionUtil.fusionDisbandSystem((EntityPlayerMP)((EntityPlayerMP)player), (String)"Character Creation", (boolean)true);
        if (!skillReset) {
            JRMCoreH.setString((String)",", (EntityPlayer)player, (String)"jrmcSSlts");
        }
        if (!statReset) {
            for (j = 0; j < JRMCoreH.techNbt.length; j = (int)((byte)(j + 1))) {
                JRMCoreH.setString((String)" ", (EntityPlayer)player, (String)JRMCoreH.techNbt[j]);
            }
            JRMCoreH.setInt((int)0, (EntityPlayer)player, (String)"jrmcTpint");
        }
        JRMCoreH.setInt((int)0, (EntityPlayer)player, (String)"daTMP");
        JRMCoreH.setInt((int)0, (EntityPlayer)player, (String)"daRaceState");
        BridgePD.tellClient((EntityPlayerMP)player, "ccRestart");
        BridgePD.sendBridge((EntityPlayerMP)player, "characterCreation", 1);
    }

    public static int[] PlyrAttrbts(EntityPlayer player, boolean serverSide) {
        if (serverSide) {
            NBTTagCompound nbt = player.getEntityData().func_74775_l("PlayerPersisted");
            int[] PlyrAttrbts = new int[JRMCoreH.PlyrAttrbts.length];
            for (int i = 0; i < JRMCoreH.AttrbtNbt.length; i = (int)((byte)(i + 1))) {
                int result;
                if (nbt.func_74781_a(BridgeUtils.statTags[i]) == null & nbt.func_74781_a(JRMCoreH.AttrbtNbt[i]) != null) {
                    nbt.func_74768_a(BridgeUtils.statTags[i], (int)nbt.func_74765_d(JRMCoreH.AttrbtNbt[i]));
                    nbt.func_82580_o(JRMCoreH.AttrbtNbt[i]);
                } else if (nbt.func_74781_a(BridgeUtils.statTags[i]) == null) {
                    nbt.func_74768_a(BridgeUtils.statTags[i], 1);
                }
                PlyrAttrbts[i] = result = JRMCoreH.etXq4V((int)nbt.func_74762_e(BridgeUtils.statTags[i]));
            }
            return PlyrAttrbts;
        }
        return JRMCoreH.PlyrAttrbts;
    }

    public static String[] PlyrSkills(EntityPlayer player, boolean serverSide) {
        if (serverSide) {
            NBTTagCompound nbt = player.getEntityData().func_74775_l("PlayerPersisted");
            if (nbt.func_74781_a("jrmcSSlts") == null) {
                nbt.func_74778_a("jrmcSSlts", ",");
            }
            return nbt.func_74779_i("jrmcSSlts").split(",");
        }
        return JRMCoreH.PlyrSkills;
    }

    public static int getStat(EntityPlayer player, int statNum) {
        NBTTagCompound nbt = player.getEntityData().func_74775_l("PlayerPersisted");
        return nbt.func_74762_e(BridgeUtils.statTags[statNum]);
    }

    public static boolean isInBaseForm(int rc, int st) {
        return Methods.isInBaseForm(null, rc, st);
    }

    public static boolean isInBaseForm(EntityPlayer player, int rc, int st) {
        boolean arcoBaseForm;
        NBTTagCompound nbt;
        boolean serverSide = player instanceof EntityPlayerMP;
        NBTTagCompound nBTTagCompound = nbt = serverSide ? player.getEntityData().func_74775_l("PlayerPersisted") : null;
        boolean bl = serverSide ? nbt.func_74762_e("arcoBaseForm") == 1 : (arcoBaseForm = Variables.getValue("arcoBaseForm").floatValue() == 1.0f);
        if (rc != 4 && st == 0) {
            return true;
        }
        return rc == 4 && (st == 1 || st >= 2 && st <= 4 && !arcoBaseForm);
    }

    public static boolean isInGodForm(int rc, int st, boolean ascended) {
        if ((rc == 0 || rc == 3) && (!ascended && st == 5 || ascended && st == 6)) {
            return true;
        }
        if ((rc == 1 || rc == 2) && (!ascended && st == 9 || ascended && st == 10)) {
            return true;
        }
        if (rc == 4 && (!ascended && st == 7 || ascended && st == 6)) {
            return true;
        }
        if (rc == 5) {
            return !ascended && st == 5 || ascended && st == 6;
        }
        return false;
    }

    public static boolean doesFormHaveAlt(int formId) {
        boolean hasAlt = false;
        if (formId == 25 || formId == 27) {
            hasAlt = true;
        }
        if (formId == 17 || formId == 18) {
            hasAlt = true;
        }
        if (formId == 28 || formId == 30) {
            hasAlt = true;
        }
        if (formId == 23 || formId == 24) {
            hasAlt = true;
        }
        if (formId == 40 || formId == 42) {
            hasAlt = true;
        }
        return hasAlt;
    }

    public static boolean doesFormHaveAlt(int rc, int state) {
        return Methods.doesFormHaveAlt(Methods.getFormIDFromState(state, rc));
    }

    public static boolean doesFormHaveRaceState(int formId) {
        boolean hasRaceState = false;
        int formTier = Methods.getFormTierByID(formId);
        if (formTier == 0 || formTier == 1 || formTier == 2 || formTier == 3) {
            hasRaceState = true;
        }
        return hasRaceState;
    }

    public static boolean doesFormHaveRaceState(int rc, int st) {
        return Methods.doesFormHaveRaceState(Methods.getFormIDFromState(st, rc));
    }

    public static int getPrimalId(int rc) {
        return rc == 0 ? 10 : (rc == 1 || rc == 2 ? 11 : (rc == 3 ? 12 : (rc == 4 ? 13 : (rc == 5 ? 14 : 10))));
    }

    public static boolean isInPrimalForm(int rc, int st) {
        if ((rc == 0 || rc == 3) && st == 4) {
            return true;
        }
        if ((rc == 1 || rc == 2) && st == 12) {
            return true;
        }
        if (rc == 4 && st == 5) {
            return true;
        }
        if (rc == 5) {
            return st == 4;
        }
        return false;
    }

    public static boolean isInPrimalMode(int rc, int st) {
        if ((rc == 0 || rc == 3 || rc == 4 || rc == 5) && st == 10) {
            return true;
        }
        if (rc == 1 || rc == 2) {
            return st == 7 || st == 8;
        }
        return false;
    }

    public static boolean formHasLightning(int rc, int st, int st2, int stUp, boolean isAscending, boolean arcoBaseForm, boolean altForm, boolean raceState) {
        boolean formUp = !Methods.isInBaseForm(rc, stUp) && isAscending;
        boolean primalMode = Methods.isInPrimalMode(rc, st);
        boolean primalForm = Methods.isInPrimalForm(rc, st);
        boolean primalFormUp = Methods.isInPrimalForm(rc, stUp) && isAscending;
        boolean god = Methods.isInGodForm(rc, st, false);
        boolean godUp = Methods.isInGodForm(rc, stUp, false) && isAscending;
        boolean aGod = Methods.isInGodForm(rc, st, true);
        boolean aGodUp = Methods.isInGodForm(rc, stUp, true) && isAscending;
        return rc == 0 && (st == 2 || stUp == 2 && formUp || primalForm || primalFormUp || aGod || aGodUp && formUp) || (rc == 1 || rc == 2) && ((!altForm || rc == 2) && (st == 5 || stUp == 5 && formUp) || st == 6 && !formUp || stUp == 6 && formUp || primalForm || primalFormUp) || rc == 3 && (st == 2 || stUp == 2 && formUp) || rc == 4 && (st == 3 && altForm && arcoBaseForm || stUp == 3 && altForm && formUp && arcoBaseForm || primalForm || primalFormUp || st == 4 && altForm || aGod || aGodUp && formUp) || rc == 5 && (st == 2 && altForm || st == 3 || stUp == 3 && formUp || primalForm || primalFormUp || aGod || aGodUp && formUp) || st2 >= 5 || raceState && rc != 4;
    }

    public static int getFormTierByID(int formId) {
        int tier = formId == 17 || formId == 22 || formId == 25 || formId == 28 || formId == 40 ? 1 : (formId == 18 || formId == 23 || formId == 26 || formId == 29 || formId == 41 ? 2 : (formId == 19 || formId == 24 || formId == 27 || formId == 30 || formId == 42 ? 3 : (formId == 10 || formId == 11 || formId == 12 || formId == 13 || formId == 14 ? 4 : (formId == 35 ? 5 : 0))));
        return tier;
    }

    public static boolean isInTechnique(int st2) {
        return st2 > 0;
    }

    public static int getSelectionState(int rc, int selection) {
        int stateUp;
        int n = stateUp = rc == 4 ? 1 : 0;
        if (rc == 0 || rc == 3 || rc == 5) {
            int n2 = selection == 1 ? 10 : (selection == 2 ? 1 : (selection == 3 ? 2 : (selection == 4 ? 3 : (selection == 5 ? 4 : (selection == 6 ? 5 : (stateUp = selection == 7 ? 6 : stateUp))))));
        }
        if (rc == 1 || rc == 2) {
            int n3 = selection == 1 ? 7 : (selection == 2 ? 1 : (selection == 3 ? 5 : (selection == 4 ? 6 : (selection == 5 ? 12 : (selection == 6 ? 9 : (stateUp = selection == 7 ? 10 : stateUp))))));
        }
        if (rc == 4) {
            stateUp = selection == 1 ? 10 : (selection == 2 ? 2 : (selection == 3 ? 3 : (selection == 4 ? 4 : (selection == 5 ? 5 : (selection == 6 ? 7 : (selection == 7 ? 6 : stateUp))))));
        }
        return stateUp;
    }

    public static int getStateUp(int rc, int state) {
        return Methods.getStateUp(null, rc, state);
    }

    public static int getStateUp(EntityPlayer player, int rc, int st) {
        int stateUp;
        boolean serverSide = player instanceof EntityPlayerMP;
        NBTTagCompound nbt = serverSide ? player.getEntityData().func_74775_l("PlayerPersisted") : null;
        int n = stateUp = rc == 4 ? 1 : 0;
        if (rc == 0 || rc == 3) {
            int n2 = st == 0 ? 1 : (st == 1 ? 2 : (st == 2 ? 3 : (st == 3 || st == 10 ? 4 : (st == 3 || st == 4 ? 5 : (stateUp = st == 5 ? 6 : stateUp)))));
        }
        if (rc == 1 || rc == 2) {
            int n3 = st == 0 ? 1 : (st == 1 ? 5 : (st == 5 ? 6 : (st == 6 || st == 8 ? 12 : (st == 6 || st == 12 ? 9 : (stateUp = st == 9 ? 10 : stateUp)))));
        }
        if (rc == 4) {
            int n4 = st == 1 ? 2 : (st == 2 ? 3 : (st == 3 ? 4 : (st == 4 || st == 10 ? 5 : (st == 4 || st == 5 ? 7 : (stateUp = st == 7 ? 6 : stateUp)))));
        }
        if (rc == 5) {
            stateUp = st == 0 ? 1 : (st == 1 ? 2 : (st == 2 ? 3 : (st == 3 || st == 10 ? 4 : (st == 3 || st == 4 ? 5 : (st == 5 ? 6 : stateUp)))));
        }
        return stateUp;
    }

    public static int getFormIDFromState(int st, int rc) {
        int form = -1;
        if (rc == 0) {
            int n = st == 1 ? 25 : (st == 2 ? 26 : (st == 3 ? 27 : (st == 4 || st == 10 ? 10 : (form = st == 5 || st == 6 ? 35 : form))));
        }
        if (rc == 1 || rc == 2) {
            int n = st == 1 ? 17 : (st == 5 ? 18 : (st == 6 ? 19 : (st == 12 || st == 7 || st == 8 ? 11 : (form = st == 9 || st == 10 ? 35 : form))));
        }
        if (rc == 3) {
            int n = st == 1 ? 28 : (st == 2 ? 29 : (st == 3 ? 30 : (st == 4 || st == 10 ? 12 : (form = st == 5 || st == 6 ? 35 : form))));
        }
        if (rc == 4) {
            int n = st == 2 ? 22 : (st == 3 ? 23 : (st == 4 ? 24 : (st == 5 || st == 10 ? 13 : (form = st == 7 || st == 6 ? 35 : form))));
        }
        if (rc == 5) {
            form = st == 1 ? 40 : (st == 2 ? 41 : (st == 3 ? 42 : (st == 4 || st == 10 || st == 11 ? 14 : (st == 5 || st == 6 ? 35 : form))));
        }
        return form;
    }

    public static int getFormIDFromSelection(int formSelected, int rc) {
        int form = -1;
        if (formSelected == 6 || formSelected == 7) {
            return 35;
        }
        if (rc == 0) {
            int n = formSelected == 2 ? 25 : (formSelected == 3 ? 26 : (formSelected == 4 ? 27 : (form = formSelected == 1 || formSelected == 5 ? 10 : form)));
        }
        if (rc == 1 || rc == 2) {
            int n = formSelected == 2 ? 17 : (formSelected == 3 ? 18 : (formSelected == 4 ? 19 : (form = formSelected == 1 || formSelected == 5 ? 11 : form)));
        }
        if (rc == 3) {
            int n = formSelected == 2 ? 28 : (formSelected == 3 ? 29 : (formSelected == 4 ? 30 : (form = formSelected == 1 || formSelected == 5 ? 12 : form)));
        }
        if (rc == 4) {
            int n = formSelected == 2 ? 22 : (formSelected == 3 ? 23 : (formSelected == 4 ? 24 : (form = formSelected == 1 || formSelected == 5 ? 13 : form)));
        }
        if (rc == 5) {
            form = formSelected == 2 ? 40 : (formSelected == 3 ? 41 : (formSelected == 4 ? 42 : (formSelected == 1 || formSelected == 5 ? 14 : form)));
        }
        return form;
    }

    public static int getSelectionFromID(int form, int rc, boolean alt) {
        int formSelected = -1;
        if (form == 35) {
            return !alt ? 6 : 7;
        }
        if (rc == 0) {
            int n = form == 10 && !alt ? 1 : (form == 25 ? 2 : (form == 26 ? 3 : (form == 27 ? 4 : (formSelected = form == 10 ? 5 : formSelected))));
        }
        if (rc == 1 || rc == 2) {
            int n = form == 11 && !alt ? 1 : (form == 17 ? 2 : (form == 18 ? 3 : (form == 19 ? 4 : (formSelected = form == 11 ? 5 : formSelected))));
        }
        if (rc == 3) {
            int n = form == 12 && !alt ? 1 : (form == 28 ? 2 : (form == 29 ? 3 : (form == 30 ? 4 : (formSelected = form == 12 ? 5 : formSelected))));
        }
        if (rc == 4) {
            int n = form == 13 && !alt ? 1 : (form == 22 ? 2 : (form == 23 ? 3 : (form == 24 ? 4 : (formSelected = form == 13 ? 5 : formSelected))));
        }
        if (rc == 5) {
            formSelected = form == 14 && !alt ? 1 : (form == 40 ? 2 : (form == 41 ? 3 : (form == 42 ? 4 : (form == 14 ? 5 : formSelected))));
        }
        return formSelected;
    }

    public static int getSelectionFromState(int st, int rc) {
        int formSelected = -1;
        int form = Methods.getFormIDFromState(st, rc);
        boolean primal = Methods.isInPrimalForm(rc, st);
        boolean aGod = Methods.isInGodForm(rc, st, true);
        return Methods.getSelectionFromID(form, rc, primal || aGod);
    }

    public static int getCosmeticToggle(int type) {
        return (int)(Variables.hasValue("cosmetic") ? Variables.getValue("cosmetic" + (type == 0 ? "" : Integer.valueOf(type))).floatValue() : 0.0f);
    }

    public static boolean isArmorActive(EntityPlayer player) {
        NBTTagCompound nbt;
        boolean serverSide = player instanceof EntityPlayerMP;
        NBTTagCompound nBTTagCompound = nbt = serverSide ? player.getEntityData().func_74775_l("PlayerPersisted") : null;
        return serverSide ? nbt.func_74762_e("armorActive") == 1 : Variables.getValue("armorActive").floatValue() == 1.0f;
    }

    public static boolean ownsArmor(EntityPlayer player, int slot) {
        if (player.field_71071_by.func_70440_f(slot) != null && player.field_71071_by.func_70440_f(slot).func_77973_b() instanceof ArmorSetup && player.field_71071_by.func_70440_f(slot).func_77942_o()) {
            NBTTagCompound armorSlot = player.field_71071_by.func_70440_f(slot).func_77978_p();
            return armorSlot.func_74779_i("uuid").equals(player.func_110124_au().toString()) || !armorSlot.func_74764_b("uuid");
        }
        return false;
    }

    public static boolean hasArmor(EntityPlayer player, int type, int armorStat) {
        ArrayList<String> setBonus = new ArrayList<String>();
        if (!Methods.isArmorActive(player)) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            if (!Methods.ownsArmor(player, i)) continue;
            if (type != 2) {
                if (armorStat != -1 && i != armorStat) continue;
                return true;
            }
            setBonus.add(Methods.getArmorFullSetName(player, i, false));
        }
        if (type == 2) {
            return setBonus.size() == 3 && ((String)setBonus.get(0)).equals(setBonus.get(1)) && ((String)setBonus.get(1)).equals(setBonus.get(2)) && ((String)setBonus.get(2)).equals(setBonus.get(0));
        }
        return false;
    }

    public static int getArmorStatNum(int statNum) {
        return statNum == 0 ? 0 : (statNum == 1 ? 1 : (statNum == 3 ? 2 : (statNum == 4 ? 3 : 0)));
    }

    public static int getArmorStatName(int statName) {
        return statName == 0 ? 0 : (statName == 1 ? 1 : (statName == 2 ? 4 : (statName == 3 ? 2 : (statName == 4 ? 3 : (statName == 5 ? 6 : 0)))));
    }

    public static float getGearRating(EntityPlayer player, int type) {
        float armorTotal = 0.0f;
        float armorCache = 0.0f;
        if (!Methods.isArmorActive(player)) {
            return armorTotal;
        }
        for (int i = 0; i < 3; ++i) {
            NBTTagCompound armorSlot;
            if (!Methods.ownsArmor(player, i) || !(armorSlot = player.field_71071_by.func_70440_f(i).func_77978_p()).func_74764_b("gearRating") || !armorSlot.func_74764_b("enhanceCount") || !armorSlot.func_74779_i("uuid").equals(player.func_110124_au().toString()) && armorSlot.func_74764_b("uuid")) continue;
            float enhanceCount = armorSlot.func_74762_e("enhanceCount");
            armorCache = (float)armorSlot.func_74762_e("gearRating") + (enhanceCount != 0.0f ? enhanceCount / 2.0f : 0.0f);
            if (type == i) {
                return armorCache;
            }
            armorTotal += armorCache;
        }
        return armorTotal;
    }

    public static float getArmorStats(EntityPlayer player, int stat) {
        float armorStat = 1.0f;
        if (!Methods.isArmorActive(player) || stat >= 4) {
            return armorStat;
        }
        for (int i = 0; i < 3; ++i) {
            NBTTagCompound armorSlot;
            if (!Methods.ownsArmor(player, i) || (armorSlot = player.field_71071_by.func_70440_f(i).func_77978_p()).func_74779_i("armorStats").split(",").length < stat + 1 || armorSlot.func_74779_i("armorEnhance").split(",").length < stat + 1) continue;
            String armorStats = armorSlot.func_74779_i("armorStats").split(",")[stat];
            String armorStatsE = armorSlot.func_74779_i("armorEnhance").split(",")[stat];
            float statCount = !armorStats.isEmpty() ? Float.parseFloat(armorStats) : 0.0f;
            float enhanceCount = !armorStatsE.isEmpty() ? Float.parseFloat(armorStatsE) : 0.0f;
            float enhanceTotalCount = armorSlot.func_74760_g("enhanceCount");
            armorStat = BridgeUtils.round(1000.0f, armorStat + statCount * gearStatFactor + enhanceCount * gearEnhanceFactor + enhanceTotalCount * gearEnhanceTotalFactor);
        }
        return armorStat;
    }

    public static float getArmorFullSet(EntityPlayer player, int stat) {
        ArrayList<String> setBonus = new ArrayList<String>();
        String[] statBonus = null;
        if (!Methods.isArmorActive(player)) {
            return 1.0f;
        }
        for (int i = 0; i < 3; ++i) {
            NBTTagCompound armorSlot;
            String[] fullSet;
            if (!Methods.ownsArmor(player, i) || (fullSet = (statBonus = (armorSlot = player.field_71071_by.func_70440_f(i).func_77978_p()).func_74779_i("setBonus").split(","))).length != 8) continue;
            setBonus.add(fullSet[7]);
        }
        if (setBonus.size() == 3 && ((String)setBonus.get(0)).equals(setBonus.get(1)) && ((String)setBonus.get(1)).equals(setBonus.get(2)) && ((String)setBonus.get(2)).equals(setBonus.get(0))) {
            return BridgeUtils.round(1000.0f, (float)(Integer.parseInt(statBonus[stat]) + 100) / 100.0f);
        }
        return 1.0f;
    }

    public static String getArmorFullSetName(EntityPlayer player, int slot, boolean ignoreActive) {
        String fullSetBonus = "";
        if (!Methods.isArmorActive(player)) {
            return fullSetBonus;
        }
        if (Methods.ownsArmor(player, slot)) {
            NBTTagCompound armorSlot = player.field_71071_by.func_70440_f(slot).func_77978_p();
            String[] fullSet = armorSlot.func_74779_i("setBonus").split(",");
            if (fullSet.length == 8) {
                fullSetBonus = fullSet[7];
            }
        } else {
            fullSetBonus = "One or more pieces of this armor set is not owned by you!";
        }
        return fullSetBonus;
    }

    public static boolean canUseKaioken(int formID) {
        boolean canKaio;
        boolean bl = canKaio = formID == 26 || formID == 27;
        if (formID == 17 || formID == 19) {
            canKaio = true;
        }
        if (formID == 29 || formID == 30) {
            canKaio = true;
        }
        if (formID == 22 || formID == 24) {
            canKaio = true;
        }
        if (formID == 41 || formID == 42) {
            canKaio = true;
        }
        return canKaio;
    }

    public static boolean canUseKaioken(int rc, int st) {
        return Methods.canUseKaioken(Methods.getFormIDFromState(st, rc));
    }

    public static boolean canUseKaioken(int techSelected, boolean checkLV, boolean sendMessage) {
        int formID = Methods.getFormIDFromState(JRMCoreH.State, JRMCoreH.Race);
        int formSelection = Methods.getSelectionFromID(formID, JRMCoreH.Race, false);
        int formLv = BridgeUtils.getClientSideMasteryLevel(formSelection, false);
        int kaioLV = BridgeUtils.getClientSideTechniqueLevel("kk" + techSelected);
        return Methods.canUseKaioken(formID, formLv, JRMCoreH.State, JRMCoreH.Race, techSelected, kaioLV, checkLV, sendMessage);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canUseKaioken(int formID, int formLV, int state, int rc, int state2, int kaioLV, boolean checkLV, boolean sendMessage) {
        if (formID == -1) {
            return true;
        }
        if (Methods.canUseKaioken(formID)) {
            if (!checkLV) {
                return true;
            }
            if ((state2 == 1 || state2 == 2) && formLV < 2) {
                if (!sendMessage) return false;
                BridgeUtils.addALogMessage(EnumChatFormatting.RED + "This form cannot use KaioKen until form " + EnumChatFormatting.GOLD + "level 2!");
                return false;
            } else if ((state2 == 3 || state2 == 4) && formLV < 3) {
                if (!sendMessage) return false;
                BridgeUtils.addALogMessage(EnumChatFormatting.RED + "This form cannot use KaioKen until form " + EnumChatFormatting.GOLD + "level 3!");
                return false;
            } else if (state2 == 5 && formLV < 4) {
                if (!sendMessage) return false;
                BridgeUtils.addALogMessage(EnumChatFormatting.RED + "This form cannot use KaioKen until form " + EnumChatFormatting.GOLD + "level 4!");
                return false;
            } else {
                if (state2 != 6 || formLV >= 5) return true;
                if (!sendMessage) return false;
                BridgeUtils.addALogMessage(EnumChatFormatting.RED + "This form cannot use KaioKen until form " + EnumChatFormatting.GOLD + "level 5!");
            }
            return false;
        } else if (formID == 35) {
            boolean ascendedGodForm = Methods.isInGodForm(rc, state, true);
            if (ascendedGodForm && formLV >= 9 && kaioLV >= 3 && (state2 == 5 || !checkLV)) {
                return true;
            }
            if (state2 != 5 && ascendedGodForm) {
                if (!sendMessage) return false;
                BridgeUtils.addALogMessage(EnumChatFormatting.RED + "This form can only use KaioKen " + EnumChatFormatting.GOLD + "x10");
                return false;
            } else if (state2 == 5 && kaioLV < 3 && ascendedGodForm) {
                if (!sendMessage) return false;
                BridgeUtils.addALogMessage(EnumChatFormatting.RED + "This form cannot use KaioKen until KaioKen x10 is " + EnumChatFormatting.GOLD + "level 3!");
                return false;
            } else if (formLV < 9 && ascendedGodForm) {
                if (!sendMessage) return false;
                BridgeUtils.addALogMessage(EnumChatFormatting.RED + "This form cannot use KaioKen until form " + EnumChatFormatting.GOLD + "level 9!");
                return false;
            } else {
                if (ascendedGodForm || !sendMessage) return false;
                BridgeUtils.addALogMessage(EnumChatFormatting.RED + "This form cannot use Kaioken!");
            }
            return false;
        } else {
            if (!sendMessage) return false;
            BridgeUtils.addALogMessage(EnumChatFormatting.RED + "This form cannot use KaioKen!");
        }
        return false;
    }

    public static int getFormLvToUseKaioken(int state2) {
        return Methods.getFormLvToUseKaioken(state2, -1);
    }

    public static int getFormLvToUseKaioken(int state2, int formId) {
        if (formId == 35) {
            return 9;
        }
        return state2 == 1 || state2 == 2 ? 2 : (state2 == 3 || state2 == 4 ? 3 : (state2 == 5 ? 4 : (state2 == 6 ? 5 : 0)));
    }

    public static boolean isFused(String fusionData) {
        return fusionData != null && !fusionData.isEmpty() && !fusionData.equals(" ") && fusionData.split(",").length >= 3;
    }

    public static boolean isFusionController(String fusionData, String name) {
        return fusionData.split(",").length >= 3 && name.equalsIgnoreCase(fusionData.split(",")[0]);
    }

    public static int getFusionTimer(String fusionData) {
        return fusionData.split(",").length >= 3 ? Integer.parseInt(fusionData.split(",")[2]) : 0;
    }

    public static int getFusionCooldown(String fusionData) {
        return !fusionData.isEmpty() && !fusionData.equals(" ") && !fusionData.contains(",") ? Integer.parseInt(fusionData) : 0;
    }

    public static float getFusionTimeRate(String fusionData) {
        return fusionData.split(",").length >= 4 ? Float.parseFloat(fusionData.split(",")[3]) : 1.0f;
    }

    public static String getFusionName(EntityPlayer controller, String controllerCharacterName) {
        String[] d18 = JRMCoreH.data((String)controller.func_70005_c_(), (int)18, (String)"0;0;0;0;0;0;0;0;0").split(";");
        String[] fusionArray = d18[2].split(",");
        if (fusionArray.length == 4 && (fusionArray[0].equalsIgnoreCase(controller.func_70005_c_()) || fusionArray[1].equalsIgnoreCase(controller.func_70005_c_()))) {
            String[] d1 = JRMCoreH.data((String)fusionArray[1], (int)1, (String)"0;0;0;0;0;0;0;0;0").split(";");
            String partnerCharacterName = CharacterUtils.getCharacterNameData((String)d1[1]);
            String controllerName = CharacterUtils.hasCharacterName((String)fusionArray[0], (String)controllerCharacterName) ? controllerCharacterName : fusionArray[0];
            String partnerName = CharacterUtils.hasCharacterName((String)fusionArray[1], (String)partnerCharacterName) ? partnerCharacterName : fusionArray[1];
            return Methods.getFusionName(controllerName, partnerName);
        }
        return null;
    }

    public static String getFusionName(String controllerName, String partnerName) {
        return EnumChatFormatting.YELLOW + controllerName.substring(0, controllerName.length() / 2) + EnumChatFormatting.AQUA + partnerName.substring(partnerName.length() / 2);
    }

    public static String getFusionPartnerName(String fusionData, String name) {
        return fusionData.split(",").length >= 3 ? fusionData.split(",")[Methods.isFusionController(fusionData, name) ? 1 : 0] : name;
    }

    public static int getFusionLevelToUse(EntityPlayer player, int rc, int st) {
        boolean inBase = Methods.isInBaseForm(player, rc, st);
        boolean god = Methods.isInGodForm(rc, st, false);
        boolean aGod = Methods.isInGodForm(rc, st, true);
        boolean primalMode = Methods.isInPrimalMode(rc, st);
        boolean primalForm = Methods.isInPrimalForm(rc, st);
        int formTier = Methods.getFormTierByID(Methods.getFormIDFromState(st, rc));
        return inBase ? 1 : (primalMode ? 2 : (god ? 5 : (primalForm || aGod ? 6 : formTier + 1)));
    }

    public static String numSep(int value) {
        return Methods.numSep(value, ',');
    }

    public static String numSep(long c2, char s) {
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance();
        symbols.setGroupingSeparator(s);
        DecimalFormat formatter = new DecimalFormat("###,###.##", symbols);
        return formatter.format(c2);
    }

    public static String numShorter(int value) {
        return Methods.numShorter(value, false);
    }

    public static String numShorter(int value, boolean showDecimals) {
        float curValue = value;
        if (curValue >= 1.0E9f) {
            return (showDecimals ? BridgeUtils.round(100.0f, curValue / 1.0E9f) : (float)(value / 1000000000)) + "b";
        }
        if (curValue >= 1000000.0f) {
            return (showDecimals ? BridgeUtils.round(100.0f, curValue / 1000000.0f) : (float)(value / 1000000)) + "m";
        }
        if (curValue >= 1000.0f && curValue < 1000000.0f) {
            return (showDecimals ? BridgeUtils.round(100.0f, curValue / 1000.0f) : (float)(value / 1000)) + "k";
        }
        return Methods.numSep(value);
    }

    public static String addToExisting(String existing, String addition, String separator, boolean ignoreContains) {
        String newResult = existing;
        if (!existing.contains(addition) || ignoreContains) {
            newResult = newResult.isEmpty() || newResult == null ? addition : newResult + separator + addition;
        }
        return newResult;
    }

    public static String removeFromExisting(String existing, String value, String separator) {
        boolean debug = false;
        String newResult = existing;
        String[] ignoreArray = existing.split(value);
        if (debug) {
            System.out.println("ignoreArray: " + existing + " " + value + " " + separator);
        }
        if (existing.contains(value)) {
            if (ignoreArray.length > 1 && ignoreArray[1].contains(separator)) {
                if (debug) {
                    System.out.println("ignoreArray #1: " + ignoreArray[1].indexOf(separator) + " " + ignoreArray[1].substring(ignoreArray[1].indexOf(separator) + 1));
                }
                newResult = ignoreArray[0] + ignoreArray[1].substring(ignoreArray[1].indexOf(separator) + 1);
            } else {
                newResult = existing.equals(value) ? "" : (existing.startsWith(value) ? ignoreArray[1].substring(separator.length()) : (existing.endsWith(value) ? ignoreArray[0].substring(0, ignoreArray[0].length() - separator.length()) : ignoreArray[0].substring(0, ignoreArray[0].length() - 2)));
            }
        }
        return newResult;
    }

    public static String splitDataFromExisting(String existing, String separator, int split) {
        String newResult = existing;
        if (existing.contains(separator)) {
            newResult = newResult.split(separator)[split];
        }
        return newResult;
    }

    public static String replaceInExisting(String existing, String separator, int split, String input) {
        String newResult = "";
        if (existing.contains(separator)) {
            String[] array = existing.split(separator);
            for (int i = 0; i < array.length; ++i) {
                String addition = i == split ? input : array[i];
                newResult = Methods.addToExisting(newResult, addition, separator, true);
            }
        }
        return newResult;
    }

    public static String getNumberAsString(int number) {
        return (number < 10 ? "00" : (number < 100 ? "0" : "")) + number;
    }

    public static String enumConvert(String input) {
        String[] colorCodes = new String[]{"4", "c", "6", "e", "2", "a", "b", "3", "1", "9", "d", "5", "f", "7", "8", "0", "k", "l", "m", "n", "o", "r"};
        EnumChatFormatting[] enumCodes = new EnumChatFormatting[]{EnumChatFormatting.DARK_RED, EnumChatFormatting.RED, EnumChatFormatting.GOLD, EnumChatFormatting.YELLOW, EnumChatFormatting.DARK_GREEN, EnumChatFormatting.GREEN, EnumChatFormatting.AQUA, EnumChatFormatting.DARK_AQUA, EnumChatFormatting.DARK_BLUE, EnumChatFormatting.BLUE, EnumChatFormatting.LIGHT_PURPLE, EnumChatFormatting.DARK_PURPLE, EnumChatFormatting.WHITE, EnumChatFormatting.GRAY, EnumChatFormatting.DARK_GRAY, EnumChatFormatting.BLACK, EnumChatFormatting.OBFUSCATED, EnumChatFormatting.BOLD, EnumChatFormatting.STRIKETHROUGH, EnumChatFormatting.UNDERLINE, EnumChatFormatting.ITALIC, EnumChatFormatting.RESET};
        for (int i = 0; i < colorCodes.length; ++i) {
            String colorCode = colorCodes[i];
            EnumChatFormatting enumCode = enumCodes[i];
            input = input.replaceAll("&" + colorCode, String.valueOf(enumCode));
        }
        return input;
    }

    public static String convertID(int id, int level) {
        StringBuilder newID = new StringBuilder();
        if (String.valueOf(id).length() <= level) {
            for (int i = 0; i < level; ++i) {
                newID.append("0");
            }
        }
        newID.append(id);
        return newID.toString();
    }

    static float getSizeFromCon(int[] plyrAttrbts, float ccHeight) {
        int conStat = plyrAttrbts[2];
        float sizeRatio = 0.05f + 0.05f * (1.0f - ccHeight);
        return sizeRatio * Math.min((float)conStat, 100000.0f) / 100000.0f;
    }

    static float getSizeFromRelease(float rls, float ccHeight) {
        float sizeRatio = 0.1f + 0.05f * (1.0f - ccHeight);
        return sizeRatio * (rls / 100.0f);
    }

    static float getSizeFromFactor(float sizeFactor, float ccHeight) {
        float sizeRatio = 0.15f + 0.1f * ccHeight;
        return 0.75f + sizeRatio * sizeFactor;
    }

    static float[] getCCSize(int rc) {
        float widthRatio = ccWidthRatio[rc];
        float heightRatio = (float)ccSizeInches[1] / (float)ccSizeInches[0] - 1.0f;
        float intendedMin = 0.82759f;
        return new float[]{widthRatio, heightRatio, intendedMin};
    }

    public static float getFormSize(int rc, int st, int type) {
        int entry;
        int n = rc == 0 || rc == 3 || rc == 5 ? (st == 10 ? 7 : st) : (rc == 1 || rc == 2 ? (st == 5 ? 2 : (st == 6 ? 3 : (st == 12 ? 4 : (st == 9 ? 5 : (st == 10 ? 6 : st))))) : (rc == 4 ? (st == 10 ? 8 : st) : (entry = st)));
        if (entry >= TransSizes[rc].length) {
            entry = rc == 4 ? 1 : 0;
        }
        return TransSizes[rc][entry][type];
    }

    public static float getHeight(EntityPlayer player, int rc, int st, boolean altForm, boolean raceState, boolean condensed) {
        float height = Methods.getFormSize(rc, st, 0);
        String[] d13 = JRMCoreH.data((String)player.func_70005_c_(), (int)13, (String)"0;0;0;0;0;0;0;0;0").split(";");
        boolean god = Methods.isInGodForm(rc, st, false);
        boolean aGod = Methods.isInGodForm(rc, st, true);
        if (rc == 0 && st == 3 && altForm) {
            height *= 0.9f;
        }
        if (rc == 1 || rc == 2) {
            if (rc == 1 && altForm) {
                height *= st == 1 ? 1.03f : (st == 5 ? 1.06f : 1.0f);
            }
            if (rc == 2 && altForm) {
                height *= st == 1 ? 1.06f : (st == 5 ? 1.09f : 1.0f);
            }
            if (raceState) {
                height *= st == 1 ? 1.15f : (st == 5 ? 1.2f : (st == 6 ? 1.25f : 1.0f));
            }
        }
        if (rc == 3) {
            if (st == 1 && altForm) {
                height *= 0.7f;
            }
            if (st == 3 && altForm) {
                height *= 0.93f;
            }
        }
        if (rc == 4) {
            if (st == 1 && condensed) {
                height *= 0.7f;
            }
            if (st == 4 && altForm) {
                height *= 1.15f;
            }
        }
        if (rc == 5) {
            if (altForm) {
                height *= st == 3 ? 1.1f : (st == 2 ? 1.15f : 1.0f);
            }
            if (aGod) {
                float f = height = Methods.cosmeticsCheck(player, d13, 62, false) ? 0.8f : 0.9f;
            }
        }
        if (Methods.isInPrimalMode(rc, st) && condensed) {
            height *= 0.7f;
        }
        return height;
    }

    public static float getWidth(EntityPlayer player, int rc, int st, boolean altForm, boolean raceState, boolean condensed) {
        float width = Methods.getFormSize(rc, st, 1);
        boolean god = Methods.isInGodForm(rc, st, false);
        boolean aGod = Methods.isInGodForm(rc, st, true);
        String[] d13 = JRMCoreH.data((String)player.func_70005_c_(), (int)13, (String)"0;0;0;0;0;0;0;0;0").split(";");
        if (god && !Methods.cosmeticsCheck(player, d13, 7, true)) {
            width = 1.0f;
        }
        if (rc == 1 || rc == 2) {
            if (rc == 2 && altForm) {
                width *= st == 1 ? 1.1f : (st == 5 ? 1.15f : 1.0f);
            }
            if (raceState) {
                width *= st == 1 ? 1.15f : (st == 5 ? 1.2f : (st == 6 ? 1.25f : 1.0f));
            }
        }
        if (rc == 3) {
            // empty if block
        }
        if (rc == 4 && (st == 3 || st == 4) && altForm) {
            width = 1.13f;
        }
        if (rc == 5) {
            if (st == 1 && !Methods.cosmeticsCheck(player, d13, 60, true)) {
                width = 1.0f;
            }
            if (aGod && !Methods.cosmeticsCheck(player, d13, 62, true)) {
                width = 1.0f;
            }
            if (altForm) {
                if (st == 2) {
                    width *= 1.06f;
                }
                if (st == 3) {
                    width *= 0.95f;
                }
            }
        }
        if (Methods.isInPrimalMode(rc, st) && condensed) {
            width *= 0.9f;
        }
        return width;
    }

    public static float[] getPlayerSizeServer(EntityPlayer player) {
        float f1 = 0.75f;
        float f2 = 1.0f;
        float f3 = 1.0f;
        NBTTagCompound nbt = player.getEntityData().func_74775_l("PlayerPersisted");
        int[] PlyrAttrbts = new int[BridgeUtils.statTags.length];
        for (int stat = 0; stat < PlyrAttrbts.length; ++stat) {
            PlyrAttrbts[stat] = nbt.func_74762_e(BridgeUtils.statTags[stat]);
        }
        boolean charCreated = nbt.func_74762_e("jrmcAccept") == 1;
        int rc = nbt.func_74762_e("jrmcRace");
        int st = nbt.func_74762_e("jrmcState");
        int st2 = nbt.func_74762_e("jrmcState2");
        boolean altForm = nbt.func_74762_e("daTMP") == 1;
        boolean raceState = nbt.func_74762_e("daRaceState") == 1;
        boolean condensed = nbt.func_74762_e("condensed") == 1;
        float sizeFactorValue = nbt.func_74760_g("sizeFactor");
        int rls = nbt.func_74762_e("jrmcRelease");
        String characterData = nbt.func_74779_i("characterData");
        String bodyData = characterData.isEmpty() ? "0,0,0.5,0.5" : characterData.split("_")[1];
        String[] bodyDataArray = bodyData.split(",");
        float ccWidth = bodyDataArray.length != 8 ? 0.5f : Float.parseFloat(bodyData.split(",")[3]);
        float ccHeight = bodyDataArray.length != 8 ? 0.5f : Float.parseFloat(bodyData.split(",")[2]);
        boolean noAffect = !charCreated;
        f1 += noAffect ? 0.0f : Methods.getSizeFromCon(JRMCoreH.PlyrAttrbts((EntityPlayer)player), ccHeight) + Methods.getSizeFromRelease(rls, ccHeight);
        f2 = Methods.getWidth(player, rc, st, altForm, raceState, condensed);
        f3 = Methods.getHeight(player, rc, st, altForm, raceState, condensed);
        float[] ccSizes = Methods.getCCSize(rc);
        float widthRatio = ccSizes[0];
        float heightRatio = ccSizes[1];
        float intendedMin = ccSizes[2];
        float sizeFactor = condensed || noAffect ? 1.0f : Methods.getSizeFromFactor(sizeFactorValue, ccHeight);
        float widthFactor = 1.0f - widthRatio / 2.0f + widthRatio * ccWidth;
        float heightFactor = intendedMin + heightRatio * ccHeight;
        f1 *= sizeFactor;
        return new float[]{f1 *= 1.1f, f2 *= widthFactor, f3 *= heightFactor};
    }

    public static float[] getPlayerSizeClient(EntityPlayer player, boolean boundingBox) {
        float ccHeight;
        float ccWidth;
        boolean altForm;
        int st2;
        int st;
        int rc;
        boolean charCreated;
        boolean debug = false;
        float f1 = 0.75f;
        float f2 = 1.0f;
        float f3 = 1.0f;
        String playerName = player.func_70005_c_();
        boolean isPlayerClient = playerName.equalsIgnoreCase(Main.mc.field_71439_g.func_70005_c_());
        String[] d1 = JRMCoreH.data((String)playerName, (int)1, (String)"0;0;0;0;0;0;0;0;0").split(";");
        String[] d2 = JRMCoreH.data((String)playerName, (int)2, (String)"0;0;0;0;0;0;0;0;0").split(";");
        String[] d3 = JRMCoreH.data((String)playerName, (int)3, (String)"0;0;0;0;0;0;0;0;0").split(";");
        String[] d10 = JRMCoreH.data((String)playerName, (int)10, (String)"0;0;0;0;0;0;0;0;0").split(";");
        String[] d12 = JRMCoreH.data((String)playerName, (int)12, (String)"0;0;0;0;0;0;0;0;0;0").split(";");
        String[] d14 = JRMCoreH.data((String)playerName, (int)14, (String)"0;0;0;0;0;0;0;0;0").split(";");
        String[] d18 = JRMCoreH.data((String)playerName, (int)18, (String)"0;0;0;0;0;0;0;0;0").split(";");
        boolean isRaceRender = isPlayerClient && player.getEntityData().func_74764_b("renderOnlyRace") && CharacterCreation.page == 0;
        boolean isBodyRender = isPlayerClient && player.getEntityData().func_74764_b("renderOnlyBody") && CharacterCreation.page == 1 && CharacterCreation.subPage == 2;
        boolean isFaceRender = isPlayerClient && player.getEntityData().func_74764_b("renderOnlyHead") && CharacterCreation.page == 2;
        boolean isHairRender = isPlayerClient && HairEditor.isOpen;
        int visualSelection = player.getEntityData().func_74762_e("visualSelection");
        int visualSelection2 = player.getEntityData().func_74762_e("visualSelection2");
        boolean characterCreation = CharacterCreation.isOpen && (CharacterCreation.page == 0 || CharacterCreation.page == 3) && !HairEditor.isOpen;
        boolean bl = charCreated = Integer.parseInt(d1[4]) >= 1;
        int n = characterCreation ? (isRaceRender ? visualSelection : CharacterCreation.rc) : (rc = Integer.parseInt(d1[0]));
        int n2 = MovieUtils.isMovieActive() ? MovieUtils.st : (st = characterCreation ? CharacterCreation.st : Integer.parseInt(d2[0]));
        int n3 = MovieUtils.isMovieActive() ? MovieUtils.st2 : (st2 = characterCreation && CharacterCreation.formPage == 2 ? CharacterCreation.st2 : Integer.parseInt(d2[1]));
        boolean bl2 = MovieUtils.isMovieActive() ? MovieUtils.altForm : (CharacterCreation.isOpen && isPlayerClient && CharacterCreation.formPage == 1 ? CharacterCreation.altForm : (altForm = Integer.parseInt(d12[3]) == 1));
        boolean raceState = MovieUtils.isMovieActive() ? MovieUtils.raceState : (CharacterCreation.isOpen && isPlayerClient && CharacterCreation.formPage == 3 ? CharacterCreation.raceState : Integer.parseInt(d12[1]) == 1);
        boolean condensed = Integer.parseInt(d12[8]) == 1;
        float sizeFactorValue = Float.parseFloat(d12[9]);
        int rls = Integer.parseInt(d10[0]);
        String characterData = !charCreated && isPlayerClient ? CharacterUtils.getCharacterCreationData() : d1[1];
        String bodyData = characterData.isEmpty() ? "0,0,0.5,0.5" : CharacterUtils.getCharacterBodyData((String)characterData);
        String[] bodyDataArray = bodyData.split(",");
        int preBodySize = CharacterUtils.raceDefaultBodySizes[visualSelection][visualSelection2];
        float f = isFaceRender || bodyDataArray.length != 8 || isHairRender ? 0.5f : (isRaceRender ? CharacterUtils.presetBodySize[preBodySize][1] : (isBodyRender ? CharacterUtils.presetBodySize[visualSelection][1] : (ccWidth = !charCreated && isPlayerClient ? CharacterCreation.widthSlider : CharacterUtils.getSubDataDecimal((String)bodyData, (int)3))));
        float f4 = isFaceRender || bodyDataArray.length != 8 || isHairRender ? 0.5f : (isRaceRender ? CharacterUtils.presetBodySize[preBodySize][0] : (isBodyRender ? CharacterUtils.presetBodySize[visualSelection][0] : (ccHeight = !charCreated && isPlayerClient ? CharacterCreation.heightSlider : CharacterUtils.getSubDataDecimal((String)bodyData, (int)2))));
        if (debug) {
            System.out.println(" - START _ " + charCreated + "_" + isRaceRender + "_" + isBodyRender + "_" + isFaceRender + " | rc: " + rc + " | st: " + st);
        }
        if (debug) {
            System.out.println("sizes #1: " + f1 + "_" + f2 + "_" + f3);
        }
        boolean inForm = !Methods.isInBaseForm(rc, st);
        int formSelected = isPlayerClient ? QuickSelection.formSelected : Integer.parseInt(d3[1]);
        boolean inState = Methods.getSelectionState(rc, formSelected) == st;
        int stUp = Methods.getSelectionState(rc, formSelected);
        byte curRg = isPlayerClient ? JRMCoreH.TransSaiCurRg : Byte.parseByte(d2[3]);
        boolean isAscending = curRg > 0;
        int transformTime = FormUtils.getTransformTime(rc, Methods.getFormIDFromSelection(formSelected, rc), BridgeUtils.getClientSideMasteryLevel(formSelected, false), false, inState);
        float transformRate = (float)curRg / (float)transformTime;
        transformRate = Math.min(1.0f, transformRate);
        int[] quickSelection = QuickSelection.getQuickSelectionValues((EntityPlayer)player);
        int qsPage = quickSelection[0];
        int qsSubPage = quickSelection[1];
        int qsSubSubPage = quickSelection[2];
        boolean ascendFormPage = qsPage == 3;
        boolean ascendIntoForm = ascendFormPage && isAscending && !inForm;
        boolean altFormAscend = ascendFormPage && qsSubPage == 2 && isAscending;
        boolean racialStateAscend = ascendFormPage && qsSubPage == 4 && isAscending;
        boolean noAffect = (!isPlayerClient || (!CharacterUtils.isSelected((int)rc) || visualSelection2 != 0) && CharacterCreation.page != 3) && !charCreated;
        f1 += noAffect ? 0.0f : Methods.getSizeFromCon(JRMCoreH.PlyrAttrbtsC((EntityPlayer)player), ccHeight) + Methods.getSizeFromRelease(rls, ccHeight);
        f2 = noAffect ? 1.0f : Methods.getWidth(player, rc, st, altForm, raceState, condensed);
        float f5 = f3 = noAffect ? 1.0f : Methods.getHeight(player, rc, st, altForm, raceState, condensed);
        if (inForm && ascendFormPage || ascendIntoForm) {
            if (isPlayerClient && MovieUtils.isMovieActive()) {
                transformRate = MovieUtils.blackBarProgress;
            }
            altForm = altFormAscend;
            boolean bl3 = raceState = racialStateAscend || MovieUtils.isMovieActive();
            if (raceState && Methods.isInPrimalMode(rc, stUp)) {
                stUp = rc == 4 ? 1 : 0;
            }
            float newWidth = Methods.getWidth(player, rc, stUp, altForm, raceState, condensed);
            float newHeight = Methods.getHeight(player, rc, stUp, altForm, raceState, condensed);
            f2 += (newWidth - f2) * transformRate;
            f3 += (newHeight - f3) * transformRate;
        }
        if (debug) {
            System.out.println("sizes #2: " + f1 + " (noAffect: " + noAffect + ")_" + f2 + "_" + f3);
        }
        float[] ccSizes = Methods.getCCSize(rc);
        float widthRatio = ccSizes[0];
        float heightRatio = ccSizes[1];
        float intendedMin = ccSizes[2];
        float sizeFactor = condensed || noAffect ? 1.0f : Methods.getSizeFromFactor(sizeFactorValue, ccHeight);
        float widthFactor = 1.0f - widthRatio / 2.0f + widthRatio * ccWidth;
        float heightFactor = intendedMin + heightRatio * ccHeight;
        if (debug) {
            System.out.println("sizeFactor: " + sizeFactor + " (" + noAffect + ") | widthFactor: " + widthFactor + " (" + ccWidth + ") | heightFactor: " + heightFactor + " (" + ccHeight + ")");
        }
        f1 *= sizeFactor;
        f2 *= widthFactor;
        f3 *= heightFactor;
        String fusionData = d18[2];
        if (Methods.isFused(fusionData) && !Methods.isFusionController(fusionData, player.func_70005_c_())) {
            f1 = 0.01f;
            f2 = 0.01f;
            f3 = 0.01f;
        }
        if (debug) {
            System.out.println(" - END sizes #3: " + f1 + "_" + f2 + "_" + f3);
        }
        if (boundingBox) {
            f1 *= 1.1f;
        }
        return new float[]{f1, f2, f3};
    }

    public static void setSize(EntityPlayer player, float width, float height) {
        float f2;
        if (width != player.field_70130_N || height != player.field_70131_O) {
            player.field_70130_N = width;
            player.field_70131_O = height;
            player.field_70121_D.field_72336_d = player.field_70121_D.field_72340_a + (double)player.field_70130_N;
            player.field_70121_D.field_72337_e = player.field_70121_D.field_72338_b + (double)player.field_70131_O;
            player.field_70121_D.field_72334_f = player.field_70121_D.field_72339_c + (double)player.field_70130_N;
        }
        player.field_70168_am = (double)(f2 = width % 2.0f) < 0.375 ? Entity.EnumEntitySize.SIZE_1 : ((double)f2 < 0.75 ? Entity.EnumEntitySize.SIZE_2 : ((double)f2 < 1.0 ? Entity.EnumEntitySize.SIZE_3 : ((double)f2 < 1.375 ? Entity.EnumEntitySize.SIZE_4 : ((double)f2 < 1.75 ? Entity.EnumEntitySize.SIZE_5 : Entity.EnumEntitySize.SIZE_6))));
    }

    public static Object[][] getStates(EntityPlayer player, int rc, int st, int st2) {
        boolean racialStateAscend;
        boolean altForm;
        boolean inForm;
        String playerName = player.func_70005_c_();
        boolean isPlayerClient = playerName.equalsIgnoreCase(Main.mc.field_71439_g.func_70005_c_());
        String[] d2 = JRMCoreH.data((String)playerName, (int)2, (String)"0;0;0;0;0;0;0;0;0").split(";");
        String[] d3 = JRMCoreH.data((String)playerName, (int)3, (String)"0;0;0;0;0;0;0;0;0").split(";");
        String[] d12 = JRMCoreH.data((String)playerName, (int)12, (String)"0;0;0;0;0;0;0;0;0").split(";");
        String[] d18 = JRMCoreH.data((String)playerName, (int)18, (String)"0;0;0;0;0;0;0;0;0").split(";");
        int formSelected = isPlayerClient ? QuickSelection.formSelected : Integer.parseInt(d3[1]);
        int kaioSelected = isPlayerClient ? QuickSelection.kaioSelected : Integer.parseInt(d3[2]);
        boolean inState = Methods.getSelectionState(rc, formSelected) == st;
        int stUp = Methods.getSelectionState(rc, formSelected);
        byte curRg = isPlayerClient ? JRMCoreH.TransSaiCurRg : Byte.parseByte(d2[3]);
        boolean isAscending = curRg > 0;
        int transformTime = FormUtils.getTransformTime(rc, Methods.getFormIDFromSelection(formSelected, rc), BridgeUtils.getClientSideMasteryLevel(formSelected, false), false, inState);
        double transformRate = (double)curRg / (double)transformTime;
        transformRate = Math.min(1.0, transformRate);
        boolean bl = inForm = !Methods.isInBaseForm(rc, st);
        boolean bl2 = MovieUtils.isMovieActive() ? MovieUtils.altForm : ((CharacterCreation.isOpen || HairEditor.isOpen) && isPlayerClient && CharacterCreation.formPage == 1 && CharacterUtils.isSelected((int)rc) ? CharacterCreation.altForm : (altForm = Integer.parseInt(d12[3]) == 1));
        boolean raceState = MovieUtils.isMovieActive() ? MovieUtils.raceState : ((CharacterCreation.isOpen || HairEditor.isOpen) && isPlayerClient && CharacterCreation.formPage == 3 && CharacterUtils.isSelected((int)rc) ? CharacterCreation.raceState : Integer.parseInt(d12[1]) == 1);
        boolean isFused = Methods.isFused(d18[2]);
        int[] quickSelection = QuickSelection.getQuickSelectionValues((EntityPlayer)player);
        int qsPage = quickSelection[0];
        int qsSubPage = quickSelection[1];
        int qsSubSubPage = quickSelection[2];
        boolean ascendFormPage = qsPage == 3;
        boolean ascendIntoForm = ascendFormPage && isAscending && !inForm;
        boolean altFormAscend = ascendFormPage && qsSubPage == 2 && isAscending;
        boolean ascendKaio = qsPage == 4 && qsSubPage == 1 && isAscending;
        boolean ascendFusion = qsPage == 4 && qsSubPage == 2;
        boolean kaioStackAscend = (qsSubPage == 3 && qsSubSubPage == 1 || inForm && qsPage == 4 && qsSubPage == 1) && isAscending;
        boolean bl3 = racialStateAscend = ascendFormPage && qsSubPage == 4 && isAscending;
        if (ascendIntoForm) {
            altForm = altFormAscend;
            boolean bl4 = raceState = racialStateAscend || MovieUtils.isMovieActive();
            if (raceState && Methods.isInPrimalMode(rc, stUp)) {
                stUp = rc == 4 ? 1 : 0;
            }
        }
        st2 = ascendKaio || kaioStackAscend ? kaioSelected : st2;
        boolean primalMode = Methods.isInPrimalMode(rc, st);
        boolean primalModeUp = Methods.isInPrimalMode(rc, stUp) && ascendIntoForm;
        boolean primalForm = Methods.isInPrimalForm(rc, st);
        boolean primalFormUp = Methods.isInPrimalForm(rc, stUp) && ascendIntoForm;
        boolean god = Methods.isInGodForm(rc, st, false);
        boolean godUp = Methods.isInGodForm(rc, stUp, false) && ascendIntoForm;
        boolean aGod = Methods.isInGodForm(rc, st, true);
        boolean aGodUp = Methods.isInGodForm(rc, stUp, true) && ascendIntoForm;
        Object[][] statesData = new Object[][]{{rc, st, st2, (int)curRg}, {inForm, ascendIntoForm, isAscending, altForm, raceState, isFused}, {primalMode, primalModeUp, primalForm, primalFormUp, god, godUp, aGod, aGodUp}, {transformRate}};
        return statesData;
    }

    public static int getStatesLayer1(Object[][] statesData, int entry) {
        return (Integer)statesData[0][entry];
    }

    public static boolean getStatesLayer2(Object[][] statesData, int entry) {
        return (Boolean)statesData[1][entry];
    }

    public static boolean getStatesLayer3(Object[][] statesData, int entry) {
        return (Boolean)statesData[2][entry];
    }

    public static double getStatesLayer4(Object[][] statesData, int entry) {
        return (Double)statesData[3][entry];
    }

    public static void PlyrSettingsSet(EntityPlayer player, int ps, int pi) {
        if (pi == -1) {
            Methods.PlyrSettingsRem(player, ps);
        } else {
            NBTTagCompound nbt = player.getEntityData().func_74775_l("PlayerPersisted");
            String jrmcSettings = nbt.func_74779_i("jrmcSettings").trim();
            String result = jrmcSettings + BridgeUtils.PlyrSttngs[ps] + pi;
            for (int i = 0; i < jrmcSettings.length() / 2; ++i) {
                String c = Methods.stringAt(jrmcSettings, i * 2);
                if (!c.equals(BridgeUtils.PlyrSttngs[ps])) continue;
                String x = Methods.stringAt(jrmcSettings, i * 2 + 1);
                result = jrmcSettings.replaceAll(c + x, c + pi);
                break;
            }
            nbt.func_74778_a("jrmcSettings", result);
        }
    }

    public static void PlyrSettingsRem(EntityPlayer player, int ps) {
        NBTTagCompound nbt = player.getEntityData().func_74775_l("PlayerPersisted");
        String jrmcSettings = nbt.func_74779_i("jrmcSettings").trim();
        for (int i = 0; i < jrmcSettings.length() / 2; ++i) {
            String c = Methods.stringAt(jrmcSettings, i * 2);
            if (!c.equals(BridgeUtils.PlyrSttngs[ps])) continue;
            String x = Methods.stringAt(jrmcSettings, i * 2 + 1);
            nbt.func_74778_a("jrmcSettings", jrmcSettings.replaceAll(c + x, ""));
            break;
        }
    }

    public static String stringAt(String s1, int s2) {
        return s1.charAt(s2) + "";
    }

    public static boolean cosmeticsCheck(String[] dataArray, int cosmeticID, boolean defaultOn) {
        return Methods.cosmeticsCheck(null, dataArray, cosmeticID, defaultOn);
    }

    public static boolean cosmeticsCheck(EntityPlayer player, String[] dataArray, int cosmeticID, boolean defaultOn) {
        if (dataArray != null && dataArray.length > 3) {
            return Methods.cosmeticsCheck(player, dataArray[3], cosmeticID, defaultOn);
        }
        return defaultOn;
    }

    public static boolean cosmeticsCheck(EntityPlayer player, String cosmeticData, int cosmeticID, boolean defaultOn) {
        boolean canDebug;
        String cosmeticID00 = Methods.getNumberAsString(cosmeticID);
        boolean debug = false;
        String debugID = "001";
        boolean bl = canDebug = debug && (debugID.equals("000") || debugID.equalsIgnoreCase(cosmeticID00));
        if (canDebug) {
            System.out.println("cosmeticData: " + cosmeticData);
        }
        if (cosmeticData.equals("\"\"")) {
            return false;
        }
        boolean serverSide = player instanceof EntityPlayerMP;
        if (!serverSide && CharacterCreation.isOpen) {
            return defaultOn;
        }
        String[] cosmeticTags = null;
        cosmeticTags = cosmeticData.contains(",") ? cosmeticData.split(",") : new String[]{cosmeticData};
        boolean ifNotPresent = defaultOn && !cosmeticData.contains(cosmeticID00);
        for (String cosmeticTag : cosmeticTags) {
            boolean tagOn = cosmeticTag.equals(cosmeticID00 + "-on");
            if (canDebug) {
                System.out.println("input: " + cosmeticID00 + " | cur loop Check: " + cosmeticTag + " | defaultOn: " + defaultOn + " | tagOn: " + tagOn + " | on: " + cosmeticTag.equals(cosmeticID00 + "-off"));
            }
            if (!tagOn && !ifNotPresent) continue;
            if (canDebug) {
                System.out.println(" can show cosmetic because: tagOn: " + tagOn + " | ifNotPresent: " + ifNotPresent);
            }
            return true;
        }
        return false;
    }

    public static String getDateFormatted() {
        ZonedDateTime date = Instant.now().atZone(ZoneOffset.UTC);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM/dd/yyyy");
        String dateFormatted = date.format(formatter);
        return dateFormatted;
    }
}

