/*
 * Decompiled with CFR 0.152.
 */
package net.MCApolloNetwork.ApolloCrux.Bridge.Utils.Render;

import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.Render.RenderHelpException;
import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GLContext;

public class OpenGlRenderHelper {
    public boolean hasPushed = false;
    public boolean hasPushedl2 = false;
    public boolean hasPushedAA = false;
    private final int lightmapTex;
    private final int defaultmapTex;
    public final boolean contextMultiText;
    boolean debug = false;

    public OpenGlRenderHelper() {
        ContextCapabilities contextcapabilities = GLContext.getCapabilities();
        this.contextMultiText = contextcapabilities.GL_ARB_multitexture && !contextcapabilities.OpenGL13;
        this.defaultmapTex = 33984;
        this.lightmapTex = 33985;
    }

    private void setActiveTex(int texid) {
        if (this.contextMultiText) {
            ARBMultitexture.glActiveTextureARB((int)texid);
        } else {
            GL13.glActiveTexture((int)texid);
        }
    }

    private void pushl2() {
        GL11.glPushMatrix();
        this.hasPushedl2 = true;
    }

    private void popl2() {
        GL11.glPopMatrix();
        this.hasPushedl2 = false;
    }

    private void push() {
        GL11.glPushMatrix();
        this.hasPushed = true;
    }

    private void pop() {
        GL11.glPopMatrix();
        this.hasPushed = false;
    }

    private void pushAA() {
        GL11.glPushMatrix();
        this.hasPushedAA = true;
    }

    private void popAA() {
        GL11.glPopMatrix();
        this.hasPushedAA = false;
    }

    public void startAntiAlias() throws RenderHelpException {
        if (this.debug) {
            System.out.println("1. startAntiAlias");
        }
        if (this.hasPushedAA) {
            throw new RenderHelpException("Already pushed AA matrix!");
        }
        GL11.glPushMatrix();
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glDisable((int)2896);
        this.pushAA();
        GL11.glDisable((int)2848);
        GL11.glDisable((int)3042);
    }

    public void stopAntiAlias() throws RenderHelpException {
        if (this.debug) {
            System.out.println("2. stopAntiAlias");
        }
        if (!this.hasPushedAA) {
            throw new RenderHelpException("Needs to push AA matrix first!");
        }
        this.popAA();
        GL11.glPopAttrib();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public void enableBlendTransparency() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.15f);
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
    }

    public void disableBlendTransparency() {
        GL11.glDisable((int)3042);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glDepthMask((boolean)true);
    }

    public void enableBlendFunc() throws RenderHelpException {
        if (this.debug) {
            System.out.println("1. enableBlendFunc");
        }
        if (this.hasPushed) {
            throw new RenderHelpException("Already pushed matrix!");
        }
        this.push();
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
    }

    public void disableBlendFunc() throws RenderHelpException {
        if (this.debug) {
            System.out.println("2. disableBlendFunc");
        }
        if (!this.hasPushed) {
            throw new RenderHelpException("Needs to push matrix first!");
        }
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        this.pop();
        GL11.glDepthMask((boolean)true);
    }

    public void disableLightMap() throws RenderHelpException {
        if (this.debug) {
            System.out.println("2. disableLightMap");
        }
        if (this.hasPushedl2) {
            throw new RenderHelpException("Already pushed l2 matrix!");
        }
        this.pushl2();
        this.setActiveTex(this.lightmapTex);
        GL11.glDisable((int)3553);
        this.setActiveTex(this.defaultmapTex);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
    }

    public void enableLightMap() throws RenderHelpException {
        if (this.debug) {
            System.out.println("1. enableLightMap");
        }
        if (!this.hasPushedl2) {
            throw new RenderHelpException("Needs to push l2 matrix first!");
        }
        this.popl2();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2884);
    }
}

