/*
 * Decompiled with CFR 0.152.
 */
package net.MCApolloNetwork.ApolloCrux.Bridge.Utils;

import net.MCApolloNetwork.ApolloCrux.Bridge.Items.ItemEdible;
import net.MCApolloNetwork.ApolloCrux.Bridge.Items.ItemRecovery;
import net.MCApolloNetwork.ApolloCrux.Bridge.Utils.Methods;
import net.MCApolloNetwork.ApolloCrux.Server.MySql.SqlDriver;
import net.MCApolloNetwork.ApolloCrux.Server.Utilities.ServerUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class StatisticsUtils {
    public static final String[][] statistics = new String[][]{{"quests", "dMissions", "punchMachine", "challengers", "whisTrain", "primalTrain", "tpBooster", "smithYes", "smithNo", "fusionYes", "fusionNo", "enhanceYes", "enhanceNo", "cSwitch", "party", "helpMenu", "clientSettings", "statMenu", "wild", "spawn", "socialLinks", "reincarnate", "respec", "class", "reset", "inventory", "globalChest", "trashBin", "setCharacter", "setInstance", "setTitles", "setRanks", "setCosmetics", "tpGem1", "tpGem2", "tpGem3", "tpGem4", "tpGem5", "tpGem6", "tpGem7", "zSoul1", "zSoul2", "zSoul3", "kShard", "kPiece", "kRising", "crate1", "crate2", "crate3", "crate4", "crate5", "crate6", "crate7", "crate8", "crate9", "rec1", "rec2", "rec3", "rec4", "rec5", "rec6", "rec7", "rec8", "rec9", "rec10", "rec11", "rec12", "rec13", "rec14", "kiCreate", "kiCreate0", "kiCreate1", "kiCreate2", "kiCreate3", "kiCreate4", "kiCreate5", "kiCreate6", "titSet", "titUnl", "tpb"}, {"questsSQ", "questsGT", "questsMQ", "questsPQ", "questsChal"}, {"cReaction", "giftBox", "vote", "event1", "event2", "event3", "event4", "event5", "jolly", "jolly2", "jolly3", "valentine", "easter", "anv", "spook23_1", "spook23_2", "spook23_3", "spook23_4", "spook23_5", "spook24_1", "spook24_2", "spook24_3", "spook24_4", "spook24_5", "spook25_1", "spook25_2", "spook25_3", "spook25_4", "spook25_5", "jolly23_1", "jolly23_2", "jolly23_3", "jolly23_4", "jollyO23_1", "jollyO23_2", "jollyO23_3", "jollyO23_4"}};
    public static final Object[][] subValues = new Object[][]{{"crate", 4}, {"tpb", 6}};

    public static void setStatistic(EntityPlayer player, boolean firstTime, String type, int value) {
        StatisticsUtils.setStatistic(player, firstTime, type, value, 0);
    }

    public static void setStatistic(EntityPlayer player, boolean firstTime, String type, int value, int subValue) {
        StatisticsUtils.setStatistic(player, firstTime ? 1 : 0, type, value, subValue);
    }

    public static void setStatistic(EntityPlayer player, int dataType, String type, int value, int subValue) {
        boolean debug = false;
        ServerUtils.performanceTest((String)("setStatistic_" + player.func_70005_c_() + "_" + type), (int)100, (boolean)true);
        NBTTagCompound forgeData = player.getEntityData();
        NBTTagCompound Statistics = forgeData.func_74775_l("Statistics");
        NBTTagCompound FirstTime = Statistics.func_74775_l("FirstTime");
        if (debug) {
            System.out.println("setStatistic: dataType: " + dataType + " type: " + type + " value: " + value);
        }
        for (int i = 0; i < statistics[dataType].length; ++i) {
            if (!type.equalsIgnoreCase(statistics[dataType][i])) continue;
            if (debug) {
                System.out.println(type + " == " + statistics[dataType][i]);
            }
            if (dataType == 0) {
                String subSet = "";
                for (Object[] objects : subValues) {
                    String statistic = (String)objects[0];
                    int count = (Integer)objects[1];
                    if (!type.equals(statistic)) continue;
                    for (int sub = 0; sub < count; ++sub) {
                        subSet = Methods.addToExisting(subSet, "0", ";", true);
                    }
                }
                if (!subSet.isEmpty()) {
                    int existing = 0;
                    if (Statistics.func_74764_b(type)) {
                        subSet = Statistics.func_74779_i(type);
                        existing = Integer.parseInt(Methods.splitDataFromExisting(subSet, ";", subValue));
                    }
                    subSet = Methods.replaceInExisting(subSet, ";", subValue, "" + (existing + value));
                    Statistics.func_74778_a(type, subSet);
                } else if (Statistics.func_74764_b(type)) {
                    Statistics.func_74768_a(type, Statistics.func_74762_e(type) + value);
                } else {
                    Statistics.func_74768_a(type, value);
                }
                forgeData.func_74782_a("Statistics", (NBTBase)Statistics);
                continue;
            }
            if (dataType == 1) {
                FirstTime.func_74768_a(type, value);
                forgeData.func_74782_a("Statistics", (NBTBase)Statistics);
                Statistics.func_74782_a("FirstTime", (NBTBase)FirstTime);
                continue;
            }
            if (dataType != 2) continue;
            SqlDriver.setAccountStatistic((EntityPlayer)player, (String)type, (int)(type.equalsIgnoreCase("valentine") || type.equalsIgnoreCase("easter") ? value : 1));
        }
        ServerUtils.performanceTest((String)("setStatistic_" + player.func_70005_c_() + "_" + type), (int)100, (boolean)false);
    }

    public static String setAccountStatistic(String data, String statistic, int value) {
        if (!data.contains(statistic)) {
            data = Methods.addToExisting(data, statistic + ":" + value, ",", false);
        } else {
            int existingValue = 0;
            String existing = data.split(statistic + ":")[1];
            existingValue = existing.contains(",") && Methods.isNumeric(existing.split(",")[0]) ? Integer.parseInt(existing.split(",")[0]) : Integer.parseInt(existing);
            data = data.replace(statistic + ":" + existingValue, statistic + ":" + (existingValue + (statistic.equalsIgnoreCase("valentine") || statistic.equalsIgnoreCase("easter") ? value : 1)));
        }
        return data;
    }

    public static int getStatistic(EntityPlayer player, boolean firstTime, String type) {
        return StatisticsUtils.getStatistic(player, firstTime ? 1 : 0, type);
    }

    public static int getStatistic(EntityPlayer player, int dataType, String type) {
        String data;
        NBTTagCompound nbt = player.getEntityData();
        NBTTagCompound statistics = nbt.func_74775_l("Statistics");
        int value = 0;
        if (dataType < 2) {
            for (int i = 0; i < StatisticsUtils.statistics[dataType].length; ++i) {
                if (!type.equalsIgnoreCase(StatisticsUtils.statistics[dataType][i])) continue;
                if (dataType == 1) {
                    statistics = nbt.func_74775_l("Statistics").func_74775_l("FirstTime");
                }
                value = statistics.func_74762_e(type);
            }
        } else if (dataType == 2 && (data = SqlDriver.getAccountData((EntityPlayer)player, (String)"statistics")).contains(type)) {
            String result = data.split(type + ":")[1];
            if (result.contains(",")) {
                result = result.split(",")[0];
            }
            return Integer.parseInt(result);
        }
        return value;
    }

    public static String getStatisticBulk(EntityPlayer player, int dataType, String type, int min, int max) {
        String data;
        String result = "";
        if (dataType == 2 && (data = SqlDriver.getAccountData((EntityPlayer)player, (String)"statistics")).contains(type)) {
            String resultBulk = "";
            for (int i = min; i <= max; ++i) {
                if (data.contains(type + i + ":")) {
                    String resultPer = data.split(type + i + ":")[1];
                    if (resultPer.contains(",")) {
                        resultPer = resultPer.split(",")[0];
                    }
                    resultBulk = Methods.addToExisting(resultBulk, i + ":" + resultPer, ",", false);
                    continue;
                }
                resultBulk = Methods.addToExisting(resultBulk, i + ":" + 0, ",", false);
            }
            return resultBulk;
        }
        return result;
    }

    public static int getRecoveryItemStatistic(ItemStack itemStack) {
        int recoveryId = -1;
        if (itemStack.func_77973_b() instanceof ItemRecovery) {
            ItemRecovery itemRecovery = (ItemRecovery)itemStack.func_77973_b();
            block0 : switch (itemRecovery.type) {
                case VITADRINK: {
                    recoveryId = 1;
                    break;
                }
                case HEALADE: {
                    recoveryId = 2;
                    break;
                }
                case SUPPLEMENTS: {
                    recoveryId = 3;
                    break;
                }
                case KISTIMULANT: {
                    recoveryId = 4;
                    break;
                }
                case FOCUSCANDY: {
                    recoveryId = 5;
                    break;
                }
                case PILLS: {
                    recoveryId = 6;
                    break;
                }
                case SENZU: {
                    recoveryId = 8;
                    break;
                }
                case EVENT: {
                    switch (itemRecovery.variation) {
                        case 1: {
                            recoveryId = 10;
                            break block0;
                        }
                        case 2: {
                            recoveryId = 11;
                            break block0;
                        }
                        case 3: {
                            recoveryId = 12;
                            break block0;
                        }
                        case 4: {
                            recoveryId = 13;
                            break block0;
                        }
                        case 5: {
                            recoveryId = 14;
                        }
                    }
                }
            }
        }
        if (itemStack.func_77973_b() instanceof ItemEdible) {
            ItemEdible itemEdible = (ItemEdible)itemStack.func_77973_b();
            switch (itemEdible.type) {
                case DINOMEAT: {
                    recoveryId = 7;
                    break;
                }
                case DNOODLES: {
                    recoveryId = 9;
                }
            }
        }
        return recoveryId;
    }
}

