/*
 * Decompiled with CFR 0.152.
 */
package net.atired.executiveorders.enemies.blockentity;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import net.atired.executiveorders.blocks.SuspiciousBedrockBlock;
import net.atired.executiveorders.enemies.custom.JauntEntity;
import net.atired.executiveorders.init.EOBlockEntityInit;
import net.atired.executiveorders.init.EOBlocksInit;
import net.atired.executiveorders.init.EOEntityTypeInit;
import net.atired.executiveorders.init.EOItemsInit;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class BrushableBedrockEntity
extends class_2586 {
    public static final class_1792[] ITEMS = new class_1792[]{class_1802.field_27063, EOBlocksInit.BEDROCK_LEAVES.method_8389(), class_1802.field_8882, class_1802.field_8118, class_1802.field_8060, EOItemsInit.DIGGERSHARK, EOItemsInit.RIPPERSHARK, EOItemsInit.NIGHTMARE_FUEL, class_1802.field_8542};
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String LOOT_TABLE_NBT_KEY = "LootTable";
    private static final String LOOT_TABLE_SEED_NBT_KEY = "LootTableSeed";
    private static final String HIT_DIRECTION_NBT_KEY = "hit_direction";
    private static final String ITEM_NBT_KEY = "item";
    private static final int field_42806 = 10;
    private static final int field_42807 = 40;
    private static final int field_42808 = 10;
    private int brushesCount;
    private long nextDustTime;
    private long nextBrushTime;
    private class_1799 item = class_1799.field_8037;
    @Nullable
    private class_2350 hitDirection;
    @Nullable
    private class_5321<class_52> lootTable;
    private long lootTableSeed;

    public BrushableBedrockEntity(class_2338 pos, class_2680 state) {
        super(EOBlockEntityInit.BRUSHABLE_BLOCK_BEDROCK, pos, state);
    }

    public boolean brush(long worldTime, class_1657 player, class_2350 hitDirection) {
        if (this.hitDirection == null) {
            this.hitDirection = hitDirection;
        }
        this.nextDustTime = worldTime + 40L;
        if (worldTime >= this.nextBrushTime && this.field_11863 instanceof class_3218) {
            this.nextBrushTime = worldTime + 10L;
            this.generateItem(player);
            int i = this.getDustedLevel();
            if (++this.brushesCount >= 10) {
                this.finishBrushing(player);
                return true;
            }
            this.field_11863.method_39279(this.method_11016(), this.method_11010().method_26204(), 2);
            int j = this.getDustedLevel();
            if (i != j) {
                class_2680 blockState = this.method_11010();
                class_2680 blockState2 = (class_2680)((class_2680)blockState.method_11657((class_2769)class_2741.field_42836, (Comparable)Integer.valueOf(j))).method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(j > 1));
                this.field_11863.method_8652(this.method_11016(), blockState2, 3);
            }
            return false;
        }
        return false;
    }

    public void generateItem(class_1657 player) {
        if (this.field_11863 != null && !this.field_11863.method_8608() && this.field_11863.method_8503() != null && this.item.method_7960()) {
            this.item = new class_1799((class_1935)ITEMS[player.method_59922().method_43048(ITEMS.length)]);
        }
    }

    private void finishBrushing(class_1657 player) {
        for (int i = 0; i < 5; ++i) {
            class_243 vec3d = this.field_11867.method_61082().method_1031(Math.random() / 2.0 - 0.25, 1.1, Math.random() / 2.0 - 0.25);
            this.field_11863.method_8406((class_2394)class_2398.field_11214, vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, Math.random() / 4.0 - 0.25, 0.2, Math.random() / 4.0 - 0.25);
            this.field_11863.method_8406((class_2394)class_2398.field_23190, vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, Math.random() / 4.0 - 0.25, 0.4, Math.random() / 4.0 - 0.25);
        }
        if (this.field_11863 != null && this.field_11863.method_8503() != null) {
            class_2248 block2;
            this.spawnItem(player);
            class_2680 blockState = this.method_11010();
            this.field_11863.method_20290(3008, this.method_11016(), class_2248.method_9507((class_2680)blockState));
            class_2248 class_22482 = this.method_11010().method_26204();
            if (class_22482 instanceof SuspiciousBedrockBlock) {
                SuspiciousBedrockBlock brushableBlock = (SuspiciousBedrockBlock)class_22482;
                block2 = brushableBlock.getBaseBlock();
            } else {
                block2 = class_2246.field_10124;
            }
            this.field_11863.method_8652(this.field_11867, block2.method_9564(), 3);
        }
    }

    private void spawnItem(class_1657 player) {
        if (this.field_11863 != null && this.field_11863.method_8503() != null) {
            this.generateItem(player);
            class_2350 direction = Objects.requireNonNullElse(this.hitDirection, class_2350.field_11036);
            if (this.item.method_7909() == class_1802.field_8542) {
                JauntEntity jauntEntity = new JauntEntity(EOEntityTypeInit.JAUNT, this.field_11863);
                class_243 vec3d = this.field_11867.method_61082().method_1031(0.0, 1.1, 0.0);
                jauntEntity.method_23327(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
                jauntEntity.method_18799(new class_243(0.0, 0.0, 0.0).method_43206(direction, 0.7));
                this.field_11863.method_8649((class_1297)jauntEntity);
                this.item = class_1799.field_8037;
            } else if (!this.item.method_7960()) {
                double d = class_1299.field_6052.method_17685();
                double e = 1.0 - d;
                double f = d / 2.0;
                class_243 vec3d = this.field_11867.method_61082().method_1031(-0.5, 0.5, -0.5).method_43206(direction, 0.8);
                double g = vec3d.method_10216() + 0.5 * e + f;
                double h = vec3d.method_10214() + (double)(class_1299.field_6052.method_17686() / 2.0f);
                double i = vec3d.method_10215() + 0.5 * e + f;
                class_1542 itemEntity = new class_1542(this.field_11863, g, h, i, this.item.method_7971(this.field_11863.field_9229.method_43048(21) + 10));
                itemEntity.method_18799(new class_243(0.0, 0.0, 0.0).method_43206(direction, 0.3));
                this.field_11863.method_8649((class_1297)itemEntity);
                this.item = class_1799.field_8037;
            }
        }
    }

    public void scheduledTick() {
        if (this.field_11863 != null) {
            if (this.brushesCount != 0 && this.field_11863.method_8510() >= this.nextDustTime) {
                int i = this.getDustedLevel();
                this.brushesCount = Math.max(0, this.brushesCount - 2);
                int j = this.getDustedLevel();
                if (i != j) {
                    this.field_11863.method_8652(this.method_11016(), (class_2680)((class_2680)this.method_11010().method_11657((class_2769)class_2741.field_42836, (Comparable)Integer.valueOf(j))).method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(j > 1)), 3);
                }
                int k = 4;
                this.nextDustTime = this.field_11863.method_8510() + 4L;
            }
            if (this.brushesCount == 0) {
                this.hitDirection = null;
                this.nextDustTime = 0L;
                this.nextBrushTime = 0L;
            } else {
                this.field_11863.method_39279(this.method_11016(), this.method_11010().method_26204(), 2);
            }
        }
    }

    private boolean readLootTableFromNbt(class_2487 nbt) {
        if (nbt.method_10573(LOOT_TABLE_NBT_KEY, 8)) {
            this.lootTable = class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2960.method_60654((String)nbt.method_10558(LOOT_TABLE_NBT_KEY)));
            this.lootTableSeed = nbt.method_10537(LOOT_TABLE_SEED_NBT_KEY);
            return true;
        }
        return false;
    }

    private boolean writeLootTableToNbt(class_2487 nbt) {
        if (this.lootTable == null) {
            return false;
        }
        nbt.method_10582(LOOT_TABLE_NBT_KEY, this.lootTable.method_29177().toString());
        if (this.lootTableSeed != 0L) {
            nbt.method_10544(LOOT_TABLE_SEED_NBT_KEY, this.lootTableSeed);
        }
        return true;
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbtCompound = super.method_16887(registryLookup);
        if (this.hitDirection != null) {
            nbtCompound.method_10569(HIT_DIRECTION_NBT_KEY, this.hitDirection.ordinal());
        }
        if (!this.item.method_7960()) {
            nbtCompound.method_10566(ITEM_NBT_KEY, this.item.method_57358(registryLookup));
        }
        return nbtCompound;
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.item = !this.readLootTableFromNbt(nbt) && nbt.method_10545(ITEM_NBT_KEY) ? class_1799.method_57360((class_7225.class_7874)registryLookup, (class_2520)nbt.method_10562(ITEM_NBT_KEY)).orElse(class_1799.field_8037) : class_1799.field_8037;
        if (nbt.method_10545(HIT_DIRECTION_NBT_KEY)) {
            this.hitDirection = class_2350.values()[nbt.method_10550(HIT_DIRECTION_NBT_KEY)];
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        if (!this.writeLootTableToNbt(nbt) && !this.item.method_7960()) {
            nbt.method_10566(ITEM_NBT_KEY, this.item.method_57358(registryLookup));
        }
    }

    public void setLootTable(class_5321<class_52> lootTable, long seed) {
        this.lootTable = lootTable;
        this.lootTableSeed = seed;
    }

    private int getDustedLevel() {
        if (this.brushesCount == 0) {
            return 0;
        }
        if (this.brushesCount < 3) {
            return 1;
        }
        return this.brushesCount < 6 ? 2 : 3;
    }

    @Nullable
    public class_2350 getHitDirection() {
        return this.hitDirection;
    }

    public class_1799 getItem() {
        return this.item;
    }
}

