/*
 * Decompiled with CFR 0.152.
 */
package net.atired.executiveorders.enemies.blockentity;

import java.util.Optional;
import net.atired.executiveorders.blocks.VitricCampfireBlock;
import net.atired.executiveorders.init.EOBlockEntityInit;
import net.atired.executiveorders.init.EODataComponentTypeInit;
import net.atired.executiveorders.init.EOParticlesInit;
import net.atired.executiveorders.recipe.VitrifiedRecipe;
import net.minecraft.class_1262;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3829;
import net.minecraft.class_3922;
import net.minecraft.class_3956;
import net.minecraft.class_4174;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9288;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import org.jetbrains.annotations.Nullable;

public class VitricCampfireBlockEntity
extends class_2586
implements class_3829 {
    private static final int field_31330 = 2;
    private static final int field_31331 = 4;
    private final class_2371<class_1799> itemsBeingCooked = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
    private final int[] cookingTimes = new int[4];
    private final int[] cookingTotalTimes = new int[4];
    private final class_1863.class_7266<class_9696, VitrifiedRecipe> matchGetter = class_1863.method_42302((class_3956)VitrifiedRecipe.Type.INSTANCE);

    public VitricCampfireBlockEntity(class_2338 pos, class_2680 state) {
        super(EOBlockEntityInit.VITRIC_CAMPFIRE_ENTITY_TYPE, pos, state);
    }

    public static void litServerTick(class_1937 world, class_2338 pos, class_2680 state, VitricCampfireBlockEntity campfire) {
        boolean bl = false;
        for (int i = 0; i < campfire.itemsBeingCooked.size(); ++i) {
            class_4174 foodComponent;
            class_1799 itemStack = (class_1799)campfire.itemsBeingCooked.get(i);
            if (itemStack.method_7960()) continue;
            bl = true;
            int n = i;
            campfire.cookingTimes[n] = campfire.cookingTimes[n] + 1;
            if (campfire.cookingTimes[i] < campfire.cookingTotalTimes[i]) continue;
            class_9696 singleStackRecipeInput = new class_9696(itemStack);
            Optional recipe = world.method_8433().method_8132((class_3956)VitrifiedRecipe.Type.INSTANCE, (class_9695)singleStackRecipeInput, world);
            class_1799 itemStack2 = itemStack;
            if (recipe.isPresent()) {
                itemStack2 = itemStack.method_60503((class_1935)((VitrifiedRecipe)((class_8786)recipe.get()).comp_1933()).method_8110(null).method_7909());
            }
            if ((foodComponent = (class_4174)itemStack.method_57824(class_9334.field_50075)) != null && itemStack.method_57824(EODataComponentTypeInit.VITRIC) == null) {
                class_4174 foodComponentNew = new class_4174((int)Math.ceil((double)foodComponent.comp_2491() / 1.5), foodComponent.comp_2492() / 1.5f, foodComponent.comp_2493(), foodComponent.comp_2494() / 2.0f, foodComponent.comp_2794(), foodComponent.comp_2495());
                itemStack.method_57379(class_9334.field_50075, (Object)foodComponentNew);
                itemStack.method_57379(EODataComponentTypeInit.VITRIC, (Object)1);
            }
            if (!itemStack2.method_45435(world.method_45162())) continue;
            class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)itemStack2);
            campfire.itemsBeingCooked.set(i, (Object)class_1799.field_8037);
            world.method_8413(pos, state, state, 3);
            world.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43287((class_2680)state));
        }
        if (bl) {
            VitricCampfireBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
        }
    }

    public static void unlitServerTick(class_1937 world, class_2338 pos, class_2680 state, VitricCampfireBlockEntity campfire) {
        boolean bl = false;
        for (int i = 0; i < campfire.itemsBeingCooked.size(); ++i) {
            if (campfire.cookingTimes[i] <= 0) continue;
            bl = true;
            campfire.cookingTimes[i] = class_3532.method_15340((int)(campfire.cookingTimes[i] - 2), (int)0, (int)campfire.cookingTotalTimes[i]);
        }
        if (bl) {
            VitricCampfireBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
        }
    }

    public static void clientTick(class_1937 world, class_2338 pos, class_2680 state, VitricCampfireBlockEntity campfire) {
        int i;
        class_5819 random = world.field_9229;
        if (random.method_43057() < 0.3f) {
            for (i = 0; i < random.method_43048(2) + 2; ++i) {
                VitricCampfireBlock.spawnSmokeParticle(world, pos, (Boolean)state.method_11654((class_2769)class_3922.field_17353), false);
            }
        }
        i = ((class_2350)state.method_11654((class_2769)class_3922.field_17564)).method_10161();
        for (int j = 0; j < campfire.itemsBeingCooked.size(); ++j) {
            if (((class_1799)campfire.itemsBeingCooked.get(j)).method_7960() || !(random.method_43057() < 0.2f)) continue;
            class_2350 direction = class_2350.method_10139((int)Math.floorMod(j + i, 4));
            float f = 0.3125f;
            double d = (double)pos.method_10263() + 0.5 - (double)((float)direction.method_10148() * 0.3125f) + (double)((float)direction.method_10170().method_10148() * 0.3125f);
            double e = (double)pos.method_10264() + 0.5;
            double g = (double)pos.method_10260() + 0.5 - (double)((float)direction.method_10165() * 0.3125f) + (double)((float)direction.method_10170().method_10165() * 0.3125f);
            for (int k = 0; k < 4; ++k) {
                world.method_8406((class_2394)EOParticlesInit.SMALL_VOID_PARTICLE, d, e, g, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    public class_2371<class_1799> getItemsBeingCooked() {
        return this.itemsBeingCooked;
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        int[] is;
        super.method_11014(nbt, registryLookup);
        this.itemsBeingCooked.clear();
        class_1262.method_5429((class_2487)nbt, this.itemsBeingCooked, (class_7225.class_7874)registryLookup);
        if (nbt.method_10573("CookingTimes", 11)) {
            is = nbt.method_10561("CookingTimes");
            System.arraycopy(is, 0, this.cookingTimes, 0, Math.min(this.cookingTotalTimes.length, is.length));
        }
        if (nbt.method_10573("CookingTotalTimes", 11)) {
            is = nbt.method_10561("CookingTotalTimes");
            System.arraycopy(is, 0, this.cookingTotalTimes, 0, Math.min(this.cookingTotalTimes.length, is.length));
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5427((class_2487)nbt, this.itemsBeingCooked, (boolean)true, (class_7225.class_7874)registryLookup);
        nbt.method_10539("CookingTimes", this.cookingTimes);
        nbt.method_10539("CookingTotalTimes", this.cookingTotalTimes);
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbtCompound = new class_2487();
        class_1262.method_5427((class_2487)nbtCompound, this.itemsBeingCooked, (boolean)true, (class_7225.class_7874)registryLookup);
        return nbtCompound;
    }

    public Optional<class_8786<VitrifiedRecipe>> getRecipeFor(class_1799 stack) {
        return this.itemsBeingCooked.stream().noneMatch(class_1799::method_7960) ? Optional.empty() : this.matchGetter.method_42303((class_9695)new class_9696(stack), this.field_11863);
    }

    public boolean addItem(@Nullable class_1309 user, class_1799 stack, int cookTime) {
        for (int i = 0; i < this.itemsBeingCooked.size(); ++i) {
            class_1799 itemStack = (class_1799)this.itemsBeingCooked.get(i);
            if (!itemStack.method_7960()) continue;
            this.cookingTotalTimes[i] = cookTime;
            this.cookingTimes[i] = 0;
            this.itemsBeingCooked.set(i, (Object)stack.method_60504(1, user));
            this.field_11863.method_43276((class_6880)class_5712.field_28733, this.method_11016(), class_5712.class_7397.method_43286((class_1297)user, (class_2680)this.method_11010()));
            this.updateListeners();
            return true;
        }
        return false;
    }

    private void updateListeners() {
        this.method_5431();
        this.method_10997().method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
    }

    public void method_5448() {
        this.itemsBeingCooked.clear();
    }

    public void spawnItemsBeingCooked() {
        if (this.field_11863 != null) {
            this.updateListeners();
        }
    }

    protected void method_57568(class_2586.class_9473 components) {
        super.method_57568(components);
        ((class_9288)components.method_58695(class_9334.field_49622, (Object)class_9288.field_49334)).method_57492(this.getItemsBeingCooked());
    }

    protected void method_57567(class_9323.class_9324 componentMapBuilder) {
        super.method_57567(componentMapBuilder);
        componentMapBuilder.method_57840(class_9334.field_49622, (Object)class_9288.method_57493(this.getItemsBeingCooked()));
    }

    public void method_57569(class_2487 nbt) {
        nbt.method_10551("Items");
    }
}

