/*
 * Decompiled with CFR 0.152.
 */
package net.atired.executiveorders.mixins;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.floats.FloatArraySet;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import java.util.List;
import java.util.Map;
import net.atired.executiveorders.accessors.LivingEntityAccessor;
import net.atired.executiveorders.init.EOMobEffectsInit;
import net.atired.executiveorders.init.EOParticlesInit;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2784;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_6880;
import net.minecraft.class_7134;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297
implements LivingEntityAccessor {
    @Shadow
    @Nullable
    private class_1282 field_6276;
    private int thunderedtime;
    private int executetime;
    private class_243 oldvel = class_243.field_1353;
    private boolean bouncy = false;
    private boolean noclipped = false;
    private boolean doomed = false;

    @Shadow
    public abstract float method_6032();

    @Shadow
    protected abstract void method_6119();

    @Shadow
    public abstract boolean method_5643(class_1282 var1, float var2);

    @Shadow
    public abstract int method_6096();

    @Shadow
    protected abstract void method_5623(double var1, boolean var3, class_2680 var4, class_2338 var5);

    @Shadow
    protected abstract float method_56077(float var1);

    @Shadow
    protected abstract void method_5693(class_2945.class_9222 var1);

    @Shadow
    public abstract boolean method_6128();

    @Shadow
    public abstract Map<class_6880<class_1291>, class_1293> method_6088();

    @Shadow
    public abstract boolean method_36608();

    @Shadow
    public abstract boolean method_45324(class_1799 var1, class_1799 var2);

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(at={@At(value="HEAD")}, method={"tick()V"})
    private void tickheadmix(CallbackInfo info) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657) {
            class_1657 gamer = (class_1657)livingEntityMixin;
            if (this.isStruckDown()) {
                gamer.method_23669();
            }
        }
        this.oldvel = this.method_18798();
    }

    @ModifyArgs(method={"Lnet/minecraft/entity/LivingEntity;baseTick()V"}, at=@At(ordinal=0, value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"))
    private void lotsohurt(Args args) {
        if (((class_1309)this).method_6059(EOMobEffectsInit.PHASING_EFFECT)) {
            if (args.get(0) != this.method_48923().method_48822()) {
                ((class_1309)this).method_6016(EOMobEffectsInit.PHASING_EFFECT);
            } else {
                args.set(1, (Object)Float.valueOf(0.0f));
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick()V"})
    private void tickmix(CallbackInfo info) {
        LivingEntityMixin accessor;
        LivingEntityMixin vec3;
        if ((this.method_6128() || this.method_18798().method_1033() > 3.0) && this.method_19538().method_1033() > 9100.0 && this.method_37908().method_40134().method_40230().isPresent() && this.method_37908().method_40134().method_40230().get() == class_7134.field_37668) {
            if (this.getThunderedTime() < 100) {
                this.setThunderedTime(this.getThunderedTime() + 1);
                if (this.getThunderedTime() == 100) {
                    this.setstruckDown(true);
                    this.setThunderedTime(60);
                    LivingEntityMixin livingEntityMixin = this;
                    if (livingEntityMixin instanceof class_1657) {
                        class_1657 gamer = (class_1657)livingEntityMixin;
                        this.method_18799(this.method_18798().method_1021(0.1));
                        this.method_18798().method_1031(0.0, -0.1, 0.0);
                        gamer.method_23670();
                    }
                    if (!this.method_37908().field_9236) {
                        class_1538 lightningEntity = new class_1538(class_1299.field_6112, this.method_37908());
                        lightningEntity.method_23327(this.method_23317(), this.method_23318(), this.method_23321());
                        this.method_37908().method_8649((class_1297)lightningEntity);
                    }
                }
            }
        } else if (this.getThunderedTime() > 0 && !this.isStruckDown()) {
            this.setThunderedTime(this.getThunderedTime() - 1);
        }
        if (this.method_24828() && this.isStruckDown()) {
            this.setstruckDown(false);
        }
        if (this.isHollowing()) {
            boolean flagz;
            class_243 vel = this.method_18798();
            vec3 = this.adjustMovementForCollisions(vel);
            boolean flagx = !class_3532.method_20390((double)vel.field_1352, (double)((class_243)vec3).field_1352);
            boolean bl = flagz = !class_3532.method_20390((double)vel.field_1350, (double)((class_243)vec3).field_1350);
            if (flagx) {
                this.method_24830(false);
                this.method_18800(-this.oldvel.field_1352, this.oldvel.field_1351, this.oldvel.field_1350);
            }
            if (flagz) {
                this.method_24830(false);
                this.method_18800(this.method_18798().field_1352, this.oldvel.field_1351, -this.oldvel.field_1350);
            }
            if (this.method_18798().method_1033() > 0.8) {
                List list = this.method_37908().method_8390(class_1309.class, this.method_5829().method_1014(0.1), class_1309::method_33190);
                for (class_1309 a : list) {
                    if (a.equals((Object)this) || a.field_6235 != 0) continue;
                    a.method_5643(this.method_48923().method_48828(), (float)this.method_18798().method_1033() * 2.0f + 2.0f);
                    a.method_60491(this.method_18798().method_1021(1.2));
                    class_1937 class_19372 = this.method_37908();
                    if (!(class_19372 instanceof class_3218)) continue;
                    class_3218 servo = (class_3218)class_19372;
                    servo.method_14199((class_2394)class_2398.field_11205, a.method_33571().field_1352, a.method_33571().field_1351, a.method_33571().field_1350, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            if (this.field_36331 && vel.method_1033() > 0.2) {
                this.method_24830(false);
                this.method_18799(new class_243(this.method_18798().field_1352, -this.oldvel.field_1351 * 1.2, this.method_18798().field_1350));
            }
            this.method_18799(this.method_18798().method_18805(1.03, 1.0, 1.03));
            if (vel.method_1033() < 0.2) {
                this.setHollowing(false);
            } else if (this.field_5976 || this.field_5992) {
                this.method_5643(this.method_48923().method_48828(), (float)this.method_18798().method_1033() * 5.0f);
            }
        }
        if ((vec3 = this) instanceof LivingEntityAccessor && (accessor = vec3).getExecuteTime() > 0) {
            accessor.setExecuteTime(accessor.getExecuteTime() - 1);
            if (accessor.getExecuteTime() == 0) {
                this.method_5643(this.field_6276, this.method_6032() * 2.0f);
                class_1937 class_19373 = this.method_37908();
                if (class_19373 instanceof class_3218) {
                    class_3218 servo = (class_3218)class_19373;
                    servo.method_14199((class_2394)EOParticlesInit.EXECUTE_PARTICLE, this.method_33571().field_1352, this.method_33571().field_1351, this.method_33571().field_1350, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    private class_243 adjustMovementForCollisions(class_243 movement) {
        boolean bl4;
        class_238 box = this.method_5829();
        List list = this.method_37908().method_20743((class_1297)this, box.method_18804(movement));
        class_243 vec3d = movement.method_1027() == 0.0 ? movement : LivingEntityMixin.method_20736((class_1297)this, (class_243)movement, (class_238)box, (class_1937)this.method_37908(), (List)list);
        boolean bl = movement.field_1352 != vec3d.field_1352;
        boolean bl2 = movement.field_1351 != vec3d.field_1351;
        boolean bl3 = movement.field_1350 != vec3d.field_1350;
        boolean bl5 = bl4 = bl2 && movement.field_1351 < 0.0;
        if (this.method_49476() > 0.0f && (bl4 || this.method_24828()) && (bl || bl3)) {
            float[] fs;
            class_238 box2 = bl4 ? box.method_989(0.0, vec3d.field_1351, 0.0) : box;
            class_238 box3 = box2.method_1012(movement.field_1352, (double)this.method_49476(), movement.field_1350);
            if (!bl4) {
                box3 = box3.method_1012(0.0, (double)-1.0E-5f, 0.0);
            }
            List<class_265> list2 = LivingEntityMixin.findCollisionsForMovement(this, this.method_37908(), list, box3);
            float f = (float)vec3d.field_1351;
            float[] var14 = fs = LivingEntityMixin.collectStepHeights(box2, list2, this.method_49476(), f);
            int var15 = fs.length;
            for (int var16 = 0; var16 < var15; ++var16) {
                float g = var14[var16];
                class_243 vec3d2 = LivingEntityMixin.adjustMovementForCollisions(new class_243(movement.field_1352, (double)g, movement.field_1350), box2, list2);
                if (!(vec3d2.method_37268() > vec3d.method_37268())) continue;
                double d = box.field_1322 - box2.field_1322;
                return vec3d2.method_1031(0.0, -d, 0.0);
            }
        }
        return vec3d;
    }

    private static List<class_265> findCollisionsForMovement(@Nullable class_1297 entity, class_1937 world, List<class_265> regularCollisions, class_238 movingEntityBoundingBox) {
        boolean bl;
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(regularCollisions.size() + 1));
        if (!regularCollisions.isEmpty()) {
            builder.addAll(regularCollisions);
        }
        class_2784 worldBorder = world.method_8621();
        boolean bl2 = bl = entity != null && worldBorder.method_39459(entity, movingEntityBoundingBox);
        if (bl) {
            builder.add((Object)worldBorder.method_17903());
        }
        builder.addAll(world.method_20812(entity, movingEntityBoundingBox));
        return builder.build();
    }

    private static class_243 adjustMovementForCollisions(class_243 movement, class_238 entityBoundingBox, List<class_265> collisions) {
        boolean bl;
        if (collisions.isEmpty()) {
            return movement;
        }
        double d = movement.field_1352;
        double e = movement.field_1351;
        double f = movement.field_1350;
        if (e != 0.0 && (e = class_259.method_1085((class_2350.class_2351)class_2350.class_2351.field_11052, (class_238)entityBoundingBox, collisions, (double)e)) != 0.0) {
            entityBoundingBox = entityBoundingBox.method_989(0.0, e, 0.0);
        }
        boolean bl2 = bl = Math.abs(d) < Math.abs(f);
        if (bl && f != 0.0 && (f = class_259.method_1085((class_2350.class_2351)class_2350.class_2351.field_11051, (class_238)entityBoundingBox, collisions, (double)f)) != 0.0) {
            entityBoundingBox = entityBoundingBox.method_989(0.0, 0.0, f);
        }
        if (d != 0.0) {
            d = class_259.method_1085((class_2350.class_2351)class_2350.class_2351.field_11048, (class_238)entityBoundingBox, collisions, (double)d);
            if (!bl && d != 0.0) {
                entityBoundingBox = entityBoundingBox.method_989(d, 0.0, 0.0);
            }
        }
        if (!bl && f != 0.0) {
            f = class_259.method_1085((class_2350.class_2351)class_2350.class_2351.field_11051, (class_238)entityBoundingBox, collisions, (double)f);
        }
        return new class_243(d, e, f);
    }

    private static float[] collectStepHeights(class_238 collisionBox, List<class_265> collisions, float f, float stepHeight) {
        FloatArraySet floatSet = new FloatArraySet(4);
        block0: for (class_265 voxelShape : collisions) {
            DoubleList doubleList = voxelShape.method_1109(class_2350.class_2351.field_11052);
            DoubleListIterator var8 = doubleList.iterator();
            while (var8.hasNext()) {
                double d = var8.next();
                float g = (float)(d - collisionBox.field_1322);
                if (g < 0.0f || g == stepHeight) continue;
                if (g > f) continue block0;
                floatSet.add(g);
            }
        }
        float[] fs = floatSet.toFloatArray();
        FloatArrays.unstableSort((float[])fs);
        return fs;
    }

    @Override
    public void setExecuteTime(int numb) {
        this.executetime = numb;
    }

    @Override
    public int getExecuteTime() {
        return this.executetime;
    }

    @Override
    public void setNoclipped(boolean noclipped) {
        this.noclipped = noclipped;
    }

    @Override
    public boolean isNoclipped() {
        return this.noclipped;
    }

    @Override
    public void setThunderedTime(int numb) {
        this.thunderedtime = numb;
    }

    @Override
    public int getThunderedTime() {
        return this.thunderedtime;
    }

    @Override
    public void setHollowing(boolean hollowing) {
        this.bouncy = hollowing;
    }

    @Override
    public boolean isHollowing() {
        return this.bouncy;
    }

    @Override
    public void setstruckDown(boolean hollowing) {
        this.doomed = hollowing;
    }

    @Override
    public boolean isStruckDown() {
        return this.doomed;
    }
}

